/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.lang;

import com.neeve.lang.XIntIterator;
import java.util.NoSuchElementException;

public class XIntArrayIterator
implements XIntIterator {
    private final int[] array;
    private final int offset;
    private final int length;
    private int current = 0;

    public XIntArrayIterator(int[] array) {
        this.array = array;
        this.offset = 0;
        this.length = array == null ? 0 : array.length;
    }

    public XIntArrayIterator(int[] array, int offset, int length) {
        this.array = array;
        this.offset = offset;
        this.length = length;
        if (length < 0 || array == null && length > 0 || length > array.length) {
            throw new IllegalArgumentException("length cannot be less than 0");
        }
        if (offset < 0 || array == null && offset > 0 || offset >= array.length) {
            throw new IndexOutOfBoundsException("length cannot be less than 0");
        }
    }

    public final int[] array() {
        return this.array;
    }

    public final int offset() {
        return this.offset;
    }

    public final int length() {
        return this.length;
    }

    @Override
    public final boolean hasNext() {
        return this.current < this.length;
    }

    @Override
    public final int next() {
        if (this.current < this.length) {
            return this.array[this.offset + this.current++];
        }
        throw new NoSuchElementException();
    }

    @Override
    public final void remove() {
        throw new UnsupportedOperationException("remove not supported");
    }

    @Override
    public final XIntIterator toFirst() {
        this.current = 0;
        return this;
    }
}

