/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.lang;

import com.neeve.lang.XCollection;
import com.neeve.lang.XIndexedList;
import java.io.ObjectStreamException;
import java.util.List;

final class XIndex
extends Number
implements Comparable<XIndex>,
XCollection.Record {
    private static final long serialVersionUID = 1L;
    public static final XIndex ZERO = new XIndex(0);
    private static XIndex[] _NegativeIndices = new XIndex[32];
    private static int _NegativeIndicesLength;
    private static XIndex[] _PositiveIndices;
    private static int _PositiveIndicesLength;
    private final int _value;
    private static final Runnable AUGMENT_POSITIVE;
    private static final Runnable AUGMENT_NEGATIVE;
    private static final int INCREASE_AMOUNT = 32;

    private XIndex(int i) {
        this._value = i;
    }

    public static void setMinimumRange(int first, int last) {
        if (first > last) {
            throw new IllegalArgumentException();
        }
        XIndex.valueOf(first);
        XIndex.valueOf(last);
    }

    public static XIndex valueOf(int i) {
        return i >= 0 ? (i < _PositiveIndicesLength ? _PositiveIndices[i] : XIndex.createPositive(i)) : XIndex.valueOfNegative(-i);
    }

    public static List<XIndex> rangeOf(int start, int end) {
        XIndexedList<XIndex> list = XIndexedList.newInstance();
        for (int i = start; i < end; ++i) {
            list.add(XIndex.valueOf(i));
        }
        return list;
    }

    public static List<XIndex> valuesOf(int ... indices) {
        XIndexedList<XIndex> list = XIndexedList.newInstance();
        for (int i : indices) {
            list.add(XIndex.valueOf(i));
        }
        return list;
    }

    private static XIndex valueOfNegative(int i) {
        return i < _NegativeIndicesLength ? _NegativeIndices[i] : XIndex.createNegative(i);
    }

    private static synchronized XIndex createPositive(int i) {
        if (i < _PositiveIndicesLength) {
            return _PositiveIndices[i];
        }
        while (i >= _PositiveIndicesLength) {
            AUGMENT_POSITIVE.run();
        }
        return _PositiveIndices[i];
    }

    private static synchronized XIndex createNegative(int i) {
        if (i < _NegativeIndicesLength) {
            return _NegativeIndices[i];
        }
        while (i >= _NegativeIndicesLength) {
            AUGMENT_NEGATIVE.run();
        }
        return _NegativeIndices[i];
    }

    @Override
    public int intValue() {
        return this._value;
    }

    @Override
    public long longValue() {
        return this.intValue();
    }

    @Override
    public float floatValue() {
        return this.intValue();
    }

    @Override
    public double doubleValue() {
        return this.intValue();
    }

    public final boolean equals(Object obj) {
        return this == obj;
    }

    public final int hashCode() {
        return this._value;
    }

    protected final Object readResolve() throws ObjectStreamException {
        return XIndex.valueOf(this._value);
    }

    @Override
    public final int compareTo(XIndex that) {
        return this._value - that._value;
    }

    @Override
    public final XCollection.Record getNext() {
        return XIndex.valueOf(this._value + 1);
    }

    @Override
    public final XCollection.Record getPrevious() {
        return XIndex.valueOf(this._value - 1);
    }

    public String toString() {
        return Integer.toString(this._value);
    }

    static /* synthetic */ XIndex[] access$202(XIndex[] x0) {
        _PositiveIndices = x0;
        return x0;
    }

    static /* synthetic */ XIndex[] access$402(XIndex[] x0) {
        _NegativeIndices = x0;
        return x0;
    }

    static {
        XIndex._NegativeIndices[0] = ZERO;
        XIndex._NegativeIndices[1] = new XIndex(-1);
        _NegativeIndicesLength = 2;
        _PositiveIndices = new XIndex[32];
        XIndex._PositiveIndices[0] = ZERO;
        for (int i = 1; i < _PositiveIndices.length; ++i) {
            XIndex._PositiveIndices[i] = new XIndex(i);
        }
        _PositiveIndicesLength = _PositiveIndices.length;
        AUGMENT_POSITIVE = new Runnable(){

            @Override
            public void run() {
                int n = _PositiveIndicesLength + 32;
                for (int i = _PositiveIndicesLength; i < n; ++i) {
                    XIndex index = new XIndex(i);
                    if (_PositiveIndices.length <= i) {
                        XIndex[] tmp = new XIndex[_PositiveIndices.length * 2];
                        System.arraycopy(_PositiveIndices, 0, tmp, 0, _PositiveIndices.length);
                        XIndex.access$202(tmp);
                    }
                    _PositiveIndices[i] = index;
                }
                _PositiveIndicesLength = _PositiveIndicesLength + 32;
            }
        };
        AUGMENT_NEGATIVE = new Runnable(){

            @Override
            public void run() {
                int n = _NegativeIndicesLength + 32;
                for (int i = _NegativeIndicesLength; i < n; ++i) {
                    XIndex index = new XIndex(-i);
                    if (_NegativeIndices.length <= i) {
                        XIndex[] tmp = new XIndex[_NegativeIndices.length * 2];
                        System.arraycopy(_NegativeIndices, 0, tmp, 0, _NegativeIndices.length);
                        XIndex.access$402(tmp);
                    }
                    _NegativeIndices[i] = index;
                }
                _NegativeIndicesLength = _NegativeIndicesLength + 32;
            }
        };
    }
}

