/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.tools;

import com.neeve.appbuilder.ApplicationBuilder;
import com.neeve.appbuilder.ServiceBuilder;
import com.neeve.tools.AbstractCommand;
import jargs.gnu.CmdLineParser;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

final class QuickstartCommand
extends AbstractCommand {
    private static final Set<String> topLevelCommands = Stream.of("app", "processor", "driver", "csvwriter").collect(Collectors.toCollection(HashSet::new));

    QuickstartCommand() {
    }

    private final void printTopLevelUsage() {
        System.out.println("");
        System.out.println("      Rumi 'quickstart' commands:");
        System.out.println("");
        System.out.println("         app        Generate the Rumi quickstart application");
        System.out.println("         processor  Generate the Rumi quickstart processor service");
        System.out.println("         driver     Generate the Rumi quickstart driver service");
        System.out.println("         csvwriter  Generate the Rumi quickstart CSV writer service");
        System.out.println("");
        System.out.println("      Run 'rumi help quickstart <command>' for help on a specific command");
        System.out.println("");
    }

    private static final AbstractCommand commandHandler(String command) {
        if (command.equals("app")) {
            return new GenerateQuickstartAppCommand();
        }
        if (command.equals("processor")) {
            return new GenerateQuickstartProcessorServiceCommand();
        }
        if (command.equals("driver")) {
            return new GenerateQuickstartDriverServiceCommand();
        }
        if (command.equals("csvwriter")) {
            return new GenerateQuickstartCSVWriterServiceCommand();
        }
        throw new IllegalArgumentException("unknown command '" + command + "'");
    }

    @Override
    final void help(String[] args) {
        if (args.length > 0) {
            String command = args[0].toLowerCase();
            if (topLevelCommands.contains(command)) {
                QuickstartCommand.commandHandler(command).help(args.length > 1 ? Arrays.copyOfRange(args, 1, args.length) : new String[]{});
            } else {
                this.printTopLevelUsage();
            }
        } else {
            this.printTopLevelUsage();
        }
    }

    @Override
    final void execute(String[] args) throws Exception {
        if (args.length > 0) {
            String command = args[0].toLowerCase();
            if (topLevelCommands.contains(command)) {
                QuickstartCommand.commandHandler(command).execute(args.length > 1 ? Arrays.copyOfRange(args, 1, args.length) : new String[]{});
            } else {
                this.printTopLevelUsage();
            }
        } else {
            this.printTopLevelUsage();
        }
    }

    private static final class GenerateQuickstartCSVWriterServiceCommand
    extends AbstractCommand {
        private GenerateQuickstartCSVWriterServiceCommand() {
        }

        private static final void printUsage() {
            System.out.println("");
            System.out.println("      'rumi quickstart csvwriter' where args are:");
            System.out.println("          [{-a, --app-root] root of the application to add the CSV Writer connector service (default=.)");
            System.out.println("");
        }

        @Override
        final void help(String[] args) {
            GenerateQuickstartCSVWriterServiceCommand.printUsage();
        }

        @Override
        final void execute(String[] args) throws Exception {
            CmdLineParser parser = new CmdLineParser();
            CmdLineParser.Option appRootOption = parser.addStringOption('r', "app-root");
            parser.parse(args);
            String appRoot = (String)parser.getOptionValue(appRootOption, (Object)"rumi-quickstart");
            new ServiceBuilder().createService(new ServiceBuilder.ServiceParams(appRoot, "CSVWriter", ServiceBuilder.ServiceType.CSVWRITER, null, false, 1));
        }
    }

    private static final class GenerateQuickstartDriverServiceCommand
    extends AbstractCommand {
        private GenerateQuickstartDriverServiceCommand() {
        }

        private static final void printUsage() {
            System.out.println("");
            System.out.println("      'rumi quickstart driver' where args are:");
            System.out.println("          [{-a, --app-root] root of the application to add the driver service (default=.)");
            System.out.println("");
        }

        @Override
        final void help(String[] args) {
            GenerateQuickstartDriverServiceCommand.printUsage();
        }

        @Override
        final void execute(String[] args) throws Exception {
            CmdLineParser parser = new CmdLineParser();
            CmdLineParser.Option appRootOption = parser.addStringOption('r', "app-root");
            parser.parse(args);
            String appRoot = (String)parser.getOptionValue(appRootOption, (Object)"rumi-quickstart");
            new ServiceBuilder().createService(new ServiceBuilder.ServiceParams(appRoot, "Driver", ServiceBuilder.ServiceType.DRIVER, null, false, 1));
        }
    }

    private static final class GenerateQuickstartProcessorServiceCommand
    extends AbstractCommand {
        private GenerateQuickstartProcessorServiceCommand() {
        }

        private static final void printUsage() {
            System.out.println("");
            System.out.println("      'rumi quickstart processor' where args are:");
            System.out.println("          [{-a, --app-root] root of the application to add the processor service (default=.)");
            System.out.println("          [{-s, --non-clustered] whether the processor is created non-clustered (default=false)");
            System.out.println("");
        }

        @Override
        final void help(String[] args) {
            GenerateQuickstartProcessorServiceCommand.printUsage();
        }

        @Override
        final void execute(String[] args) throws Exception {
            CmdLineParser parser = new CmdLineParser();
            CmdLineParser.Option appRootOption = parser.addStringOption('r', "app-root");
            CmdLineParser.Option standaloneOption = parser.addBooleanOption('s', "non-clustered");
            parser.parse(args);
            String appRoot = (String)parser.getOptionValue(appRootOption, (Object)"rumi-quickstart");
            boolean standalone = (Boolean)parser.getOptionValue(standaloneOption, (Object)false);
            new ServiceBuilder().createService(new ServiceBuilder.ServiceParams(appRoot, "Processor", ServiceBuilder.ServiceType.PROCESSOR, ServiceBuilder.ServiceHAModel.STATE_REPLICATION, !standalone, 1));
        }
    }

    private static final class GenerateQuickstartAppCommand
    extends AbstractCommand {
        private GenerateQuickstartAppCommand() {
        }

        private static final void printUsage() {
            System.out.println("");
            System.out.println("      'rumi quickstart app <args>' where args are:");
            System.out.println("          [{-e, --encoding-type] the app's encoding type (default=quark)");
            System.out.println("          [{-m, --messaging-provider] the app's messaging provider (default=activemq)");
            System.out.println("          [{-t, --target-dir] the target directory (default=.)");
            System.out.println("          [{-s, --only-scaffolding] whether to only create the app scaffolding or the full app (default=false)");
            System.out.println("");
        }

        @Override
        final void help(String[] args) {
            GenerateQuickstartAppCommand.printUsage();
        }

        @Override
        final void execute(String[] args) throws Exception {
            CmdLineParser parser = new CmdLineParser();
            CmdLineParser.Option encodingTypeOption = parser.addStringOption('e', "encoding-type");
            CmdLineParser.Option messagingProviderOption = parser.addStringOption('m', "messaging-provider");
            CmdLineParser.Option targetDirOption = parser.addStringOption('t', "target-dir");
            CmdLineParser.Option onlyScaffoldingOption = parser.addBooleanOption('s', "only-scaffolding");
            parser.parse(args);
            String encodingTypeStr = (String)parser.getOptionValue(encodingTypeOption, (Object)"quark");
            String messagingProviderStr = (String)parser.getOptionValue(messagingProviderOption, (Object)"activemq");
            String targetDirStr = (String)parser.getOptionValue(targetDirOption, (Object)".");
            boolean onlyScaffolding = (Boolean)parser.getOptionValue(onlyScaffoldingOption, (Object)false);
            ApplicationBuilder.AppParams appParams = new ApplicationBuilder.AppParams("Quickstart", targetDirStr, "org.rumi.quickstart", "org.rumi", "rumi", "4.0.584", "4.0.39", "2.0.29", ApplicationBuilder.EncodingType.fromString((String)encodingTypeStr), ApplicationBuilder.MessagingProvider.fromString((String)messagingProviderStr), ApplicationBuilder.BuildTool.MAVEN);
            String appRoot = appParams.getAppRoot();
            if (onlyScaffolding) {
                new ApplicationBuilder().createApplication(appParams);
            } else {
                new ApplicationBuilder().createApplication(appParams).newServiceBuilder().createService(new ServiceBuilder.ServiceParams(appRoot, "Processor", ServiceBuilder.ServiceType.PROCESSOR, ServiceBuilder.ServiceHAModel.STATE_REPLICATION, true, 1)).createService(new ServiceBuilder.ServiceParams(appRoot, "CSVWriter", ServiceBuilder.ServiceType.CSVWRITER, null, false, 1)).createService(new ServiceBuilder.ServiceParams(appRoot, "Driver", ServiceBuilder.ServiceType.DRIVER, null, false, 1));
            }
        }
    }
}

