/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.tools;

import com.neeve.ods.IStoreObject;
import com.neeve.ods.StoreObjectFactoryRegistry;
import com.neeve.query.QueryRepository;
import com.neeve.rog.IRogMessage;
import com.neeve.rog.log.RogLog;
import com.neeve.rog.log.RogLogFactory;
import com.neeve.rog.log.RogLogQuery;
import com.neeve.rog.log.RogLogQueryEngine;
import com.neeve.rog.log.RogLogQueryRepository;
import com.neeve.rog.log.RogLogQueryResultSet;
import com.neeve.server.mon.SrvMonHeartbeatFactory;
import com.neeve.server.mon.SrvMonHeartbeatMessage;
import com.neeve.server.mon.util.SrvMonHeartbeatTracer;
import com.neeve.tools.AbstractCommand;
import com.neeve.util.UtlDataTypes;
import jargs.gnu.CmdLineParser;
import java.io.File;
import java.io.FileOutputStream;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Properties;

final class HeartbeatsDumpCommand
extends AbstractCommand {
    HeartbeatsDumpCommand() {
    }

    private static final void printUsage() {
        System.out.println("      'rumi hbdump <args>' where args are:");
        System.err.println("          [{-l, --heartbeat-log <heartbeat log file>} the transaction log containing the heartbeat messages");
        System.err.println("          [{-o, --output-file <output text file>} the output file containing the textualized heartbeats]");
        System.err.println("          [{-a, --include-admin} whether to output heartbeats for Rumi internal administrative services as well]");
        System.err.println("          [{-s, --start-datetime <start date>} the start date-time of the heartbeats to process e.g. \"yyyy-MM-dd hh:mm:ss[.f...] [Z]\" or \"ten minutes ago\".]");
        System.err.println("          [{-e, --end-datetime <end date>} the end date-time of the heartbeats to process e.g. \"yyyy-MM-dd hh:mm:ss[.f...] [Z]\" or \"five minutes ago\".]");
        System.err.println("          [{-b, --no-sys-stats <no sys stats>} whether to exclude sys stats.]");
        System.err.println("          [{-c, --no-service-stats <no service stats>} whether to exclude service stats.]");
        System.err.println("          [{-d, --no-thread-stats <no thread stats>} whether to exclude thread stats.]");
        System.err.println("          [{-f, --no-user-stats <no user stats>} whether to exclude user stats.]");
        System.err.println("          [{-g, --no-pool-stats <no pool stats>} whether to exclude pool stats.]");
        System.err.println("          [{-i, --no-admin-client-stats <no admnin client stats>} whether to exclude admin client stats.]");
    }

    private final String buildWarmupTimeClauseForQuery(String startDateTime) throws Exception {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Calendar cal = Calendar.getInstance();
        cal.setTime(UtlDataTypes.parseAsDate((Object)startDateTime));
        cal.add(12, -1);
        return " WHERE timestamp BETWEEN '" + dateFormat.format(cal.getTime()) + "' AND '" + startDateTime + "'";
    }

    private final String buildTimeClauseForQuery(String startDateTime, String endDateTime) throws Exception {
        Object queryString = "";
        if (startDateTime != null && endDateTime != null) {
            queryString = " WHERE timestamp BETWEEN '" + startDateTime + "' AND '" + endDateTime + "'";
        } else {
            if (startDateTime != null) {
                queryString = (String)queryString + " WHERE timestamp > '" + startDateTime + "'";
            }
            if (endDateTime != null) {
                queryString = (String)queryString + " WHERE timestamp < '" + endDateTime + "'";
            }
        }
        return queryString;
    }

    private final void warmup(RogLogQueryEngine queryEngine, String queryString, SrvMonHeartbeatTracer heartbeatTracer) throws Exception {
        RogLogQuery query = queryEngine.createQuery(queryString);
        RogLogQueryResultSet results = queryEngine.execute(query);
        StringBuilder sb = new StringBuilder();
        while (results.next()) {
            sb.setLength(0);
            IStoreObject object = results.getLogEntry().getObject();
            if (!(object instanceof IRogMessage)) continue;
            SrvMonHeartbeatMessage srvMessage = (SrvMonHeartbeatMessage)object;
            heartbeatTracer.printStats(srvMessage, sb);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void dumpHeartbeats(RogLogQueryEngine queryEngine, String queryString, SrvMonHeartbeatTracer heartbeatTracer, File outFile) throws Exception {
        RogLogQuery query = queryEngine.createQuery(queryString);
        RogLogQueryResultSet results = queryEngine.execute(query);
        System.out.println("Writing " + results.getCount() + " heartbeats to " + outFile.getAbsoluteFile());
        try (FileOutputStream fout = new FileOutputStream(outFile);){
            StringBuilder sb = new StringBuilder();
            while (results.next()) {
                sb.setLength(0);
                IStoreObject object = results.getLogEntry().getObject();
                if (!(object instanceof IRogMessage)) continue;
                SrvMonHeartbeatMessage heartbeat = (SrvMonHeartbeatMessage)object;
                sb.append(String.format("\n[%s]<%s,%s> .....[STATS]\n", new Date(heartbeat.getCollectionStartWallTime()), heartbeat.getServerPid(), heartbeat.getServerHostName()));
                heartbeatTracer.printStats(heartbeat, sb);
                fout.write(sb.toString().getBytes());
            }
        }
        System.out.println("Done.");
    }

    @Override
    final void help(String[] args) {
        HeartbeatsDumpCommand.printUsage();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    final void execute(String[] args) throws Exception {
        CmdLineParser parser = new CmdLineParser();
        CmdLineParser.Option logNameOption = parser.addStringOption('l', "heartbeat-log");
        CmdLineParser.Option outputFileOption = parser.addStringOption('o', "output-file");
        CmdLineParser.Option includeAdminOption = parser.addBooleanOption('a', "include-admin");
        CmdLineParser.Option startOption = parser.addStringOption('s', "start-datetime");
        CmdLineParser.Option endOption = parser.addStringOption('e', "end-datetime");
        CmdLineParser.Option noSysStatsOption = parser.addBooleanOption('b', "no-sys-stats");
        CmdLineParser.Option noServiceStatsOption = parser.addBooleanOption('c', "no-service-stats");
        CmdLineParser.Option noThreadStatsOption = parser.addBooleanOption('c', "no-thread-stats");
        CmdLineParser.Option noUsserStatsOption = parser.addBooleanOption('c', "no-user-stats");
        CmdLineParser.Option noPoolStatsOption = parser.addBooleanOption('c', "no-pool-stats");
        CmdLineParser.Option noAdminClientStatsOption = parser.addBooleanOption('c', "no-admin-client-stats");
        parser.parse(args);
        String logName = (String)parser.getOptionValue(logNameOption, null);
        if (logName == null) {
            throw new IllegalArgumentException("heartbeat log needs to be specified");
        }
        File logFile = new File(logName);
        if (!logFile.exists()) {
            throw new IllegalArgumentException("heartbeat log '" + logFile + "' does not exist");
        }
        logFile = logFile.getAbsoluteFile();
        String outputFileName = (String)parser.getOptionValue(outputFileOption, (Object)"stats.txt");
        File outputFile = new File(outputFileName);
        if (outputFile.exists()) {
            throw new IllegalArgumentException("output file '" + outputFile.getAbsoluteFile() + "' already exists");
        }
        boolean includeAdmin = (Boolean)parser.getOptionValue(includeAdminOption, (Object)false);
        String startDateTime = (String)parser.getOptionValue(startOption, null);
        String endDateTime = (String)parser.getOptionValue(endOption, null);
        boolean noSysStats = (Boolean)parser.getOptionValue(noSysStatsOption, (Object)false);
        boolean noServiceStats = (Boolean)parser.getOptionValue(noServiceStatsOption, (Object)false);
        boolean noThreadStats = (Boolean)parser.getOptionValue(noThreadStatsOption, (Object)false);
        boolean noUserStats = (Boolean)parser.getOptionValue(noUsserStatsOption, (Object)false);
        boolean noPoolStats = (Boolean)parser.getOptionValue(noPoolStatsOption, (Object)false);
        boolean noAdminClientStats = (Boolean)parser.getOptionValue(noAdminClientStatsOption, (Object)false);
        SrvMonHeartbeatTracer heartbeatTracer = new SrvMonHeartbeatTracer();
        heartbeatTracer.setFilterAdminApps(!includeAdmin);
        heartbeatTracer.setTraceSysStats(!noSysStats);
        heartbeatTracer.setTraceAppStats(!noServiceStats);
        heartbeatTracer.setTraceThreadStats(!noThreadStats);
        heartbeatTracer.setTraceUserStats(!noUserStats);
        heartbeatTracer.setTracePoolStats(!noPoolStats);
        heartbeatTracer.setTraceAdminClientStats(!noAdminClientStats);
        StoreObjectFactoryRegistry.getInstance().registerObjectFactory(SrvMonHeartbeatFactory.class.getName());
        String name = logFile.getName().substring(0, logFile.getName().length() - 4);
        Properties props = new Properties();
        props.setProperty("storeRoot", logFile.getParent());
        props.setProperty("autoRepair", String.valueOf(false));
        props.setProperty("logMode", "r");
        log.open();
        try (RogLog log = RogLogFactory.createLog((String)name, (Properties)props);){
            queryEngine.setAutoIndexing(false);
            try (RogLogQueryEngine queryEngine = RogLogFactory.createQueryEngine();){
                queryRepository.open();
                try (RogLogQueryRepository queryRepository = log.asRepository();){
                    String warmupQuery;
                    queryEngine.addRepository((QueryRepository)queryRepository, name);
                    String queryCore = "SELECT * from logs";
                    String queryTimeClause = this.buildTimeClauseForQuery(startDateTime, endDateTime);
                    if (startDateTime != null && (warmupQuery = this.buildWarmupTimeClauseForQuery(startDateTime)) != null) {
                        this.warmup(queryEngine, "SELECT * from logs" + warmupQuery, heartbeatTracer);
                    }
                    this.dumpHeartbeats(queryEngine, "SELECT * from logs" + queryTimeClause, heartbeatTracer, outputFile);
                }
            }
        }
    }
}

