/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.tools;

import com.neeve.cloud.aws.AwsProvisioner;
import com.neeve.tools.AbstractCommand;
import jargs.gnu.CmdLineParser;
import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

final class AwsCommand
extends AbstractCommand {
    private static final Set<String> commands = Stream.of("create-network", "create-zone", "list-zones", "launch-jump", "start-jump", "stop-jump", "terminate-jump", "launch-admin", "run-admin-script", "start-admin", "stop-admin", "terminate-admin", "launch-monitor", "start-monitor", "stop-monitor", "terminate-monitor", "launch-solace", "start-solace", "stop-solace", "terminate-solace", "launch-kafka", "start-kafka", "stop-kafka", "terminate-kafka", "launch-amq", "start-amq", "stop-amq", "terminate-amq", "launch-platform", "start-platform", "stop-platform", "terminate-platform", "launch-instance", "attach-volume", "run-command", "start-instance", "stop-instance", "terminate-instance", "list-instances", "list-networks", "delete-network", "provision", "deploy", "configure", "start", "stop", "deprovision").collect(Collectors.toCollection(HashSet::new));

    AwsCommand() {
    }

    private final void printTopLevelUsage() {
        System.out.println("");
        System.out.println("      Rumi 'cloud aws' commands:");
        System.out.println("");
        System.out.println("         create-network         Create a new Rumi network");
        System.out.println("         create-zone            Create a new hosted zone associated with a Rumi network");
        System.out.println("         list-zones             List the hosted zone associated with a Rumi network");
        System.out.println("         launch-jump            Provision and start the Rumi Jump Server");
        System.out.println("         start-jump             Start the Rumi Jump Server");
        System.out.println("         stop-jump              Stop the Rumi Jump Server");
        System.out.println("         terminate-jump         Terminate the Rumi Jump Server");
        System.out.println("         launch-admin           Provision and start the Rumi Admin Server");
        System.out.println("         run-admin-script       Run an Rumi admin script");
        System.out.println("         start-admin            Start the Rumi Admin Server");
        System.out.println("         stop-admin             Stop the Rumi Admin Server");
        System.out.println("         terminate-admin        Terminate the Rumi Admin Server");
        System.out.println("         launch-monitor         Provision and start the Rumi Monitor Server");
        System.out.println("         start-monitor          Start the Rumi Monitor Server");
        System.out.println("         stop-monitor           Stop the Rumi Monitor Server");
        System.out.println("         terminate-monitor      Terminate the Rumi Monitor Server");
        System.out.println("         launch-solace          Provision and start the Rumi Solace Broker");
        System.out.println("         start-solace           Start the Rumi Solace Broker");
        System.out.println("         stop-solace            Stop the Rumi Solace Broker");
        System.out.println("         terminate-solace       Terminate the Rumi Solace Broker");
        System.out.println("         launch-kafka           Provision and start the Rumi Kafka Broker");
        System.out.println("         start-kafka            Start the Rumi Kafka Broker");
        System.out.println("         stop-kafka             Stop the Rumi Kafka Broker");
        System.out.println("         terminate-kafka        Terminate the Rumi ActiveMQ Broker");
        System.out.println("         launch-amq             Provision and start the Rumi ActiveMQ Broker");
        System.out.println("         start-amq              Start the Rumi ActiveMQ Broker");
        System.out.println("         stop-amq               Stop the Rumi ActiveMQ Broker");
        System.out.println("         terminate-amq          Terminate the Rumi ActiveMQ Broker");
        System.out.println("         launch-platform        Provision and start  the Rumi platform components (Jump, Admin, Monitor, Messaging)");
        System.out.println("         start-platform         Start the Rumi platform components (Jump, Admin, Monitor, Messaging)");
        System.out.println("         stop-platform          Stop the Rumi platform components (Jump, Admin, Monitor, Messaging)");
        System.out.println("         terminate-platform     Terminate the Rumi platform components (Jump, Admin, Monitor, Messaging)");
        System.out.println("         launch-instance        Provision and start a Rumi service instance");
        System.out.println("         attach-volume          Provision, attach and mount a new volume on a Rumi service instance");
        System.out.println("         run-command            Run a custom command on a Rumi service instance");
        System.out.println("         start-instance         Start the Rumi service instance");
        System.out.println("         stop-instance          Stop the Rumi service instance");
        System.out.println("         terminate-instance     Terminate the Rumi service instance");
        System.out.println("         list-instances         List instances provisioned by Rumi");
        System.out.println("         list-networks          List networks provisioned by Rumi");
        System.out.println("         delete-network         Delete an existing Rumi network");
        System.out.println("         provision              Provision a Rumi environment in AWS");
        System.out.println("         deploy                 Deploy a Rumi system to a Rumi environment provisioned in the Civo cloud");
        System.out.println("         configure              Update a configuration property of a Rumi environment provisioned in the Civo cloud");
        System.out.println("         start                  Start all provisioned instances in an AWS Rumi environment");
        System.out.println("         stop                   Stop all provisioned instances in an AWS Rumi environment");
        System.out.println("         deprovision            Deprovision an an existing Rumi environment in AWS");
        System.out.println("");
        System.out.println("      Run 'rumi help cloud aws <command>' for help on a specific command");
        System.out.println("");
    }

    private static final AbstractCommand commandHandler(String command) {
        if (command.equals("create-network")) {
            return new CreateNetworkCommand();
        }
        if (command.equals("create-zone")) {
            return new CreateZoneCommand();
        }
        if (command.equals("list-zones")) {
            return new ListZonesCommand();
        }
        if (command.equals("launch-jump")) {
            return new LaunchJumpServerCommand();
        }
        if (command.equals("start-jump")) {
            return new StartJumpServerCommand();
        }
        if (command.equals("stop-jump")) {
            return new StopJumpServerCommand();
        }
        if (command.equals("terminate-jump")) {
            return new TerminateJumpServerCommand();
        }
        if (command.equals("launch-admin")) {
            return new LaunchAdminServerCommand();
        }
        if (command.equals("run-admin-script")) {
            return new RunAdminScriptCommand();
        }
        if (command.equals("start-admin")) {
            return new StartAdminServerCommand();
        }
        if (command.equals("stop-admin")) {
            return new StopAdminServerCommand();
        }
        if (command.equals("terminate-admin")) {
            return new TerminateAdminServerCommand();
        }
        if (command.equals("launch-monitor")) {
            return new LaunchMonitorServerCommand();
        }
        if (command.equals("start-monitor")) {
            return new StartMonitorServerCommand();
        }
        if (command.equals("stop-monitor")) {
            return new StopMonitorServerCommand();
        }
        if (command.equals("terminate-monitor")) {
            return new TerminateMonitorServerCommand();
        }
        if (command.equals("launch-solace")) {
            return new LaunchSolaceBrokerCommand();
        }
        if (command.equals("start-solace")) {
            return new StartSolaceBrokerCommand();
        }
        if (command.equals("stop-solace")) {
            return new StopSolaceBrokerCommand();
        }
        if (command.equals("terminate-solace")) {
            return new TerminateSolaceBrokerCommand();
        }
        if (command.equals("launch-kafka")) {
            return new LaunchKafkaBrokerCommand();
        }
        if (command.equals("start-kafka")) {
            return new StartKafkaBrokerCommand();
        }
        if (command.equals("stop-kafka")) {
            return new StopKafkaBrokerCommand();
        }
        if (command.equals("terminate-kafka")) {
            return new TerminateKafkaBrokerCommand();
        }
        if (command.equals("launch-amq")) {
            return new LaunchActiveMQBrokerCommand();
        }
        if (command.equals("start-amq")) {
            return new StartActiveMQBrokerCommand();
        }
        if (command.equals("stop-amq")) {
            return new StopActiveMQBrokerCommand();
        }
        if (command.equals("terminate-amq")) {
            return new TerminateActiveMQBrokerCommand();
        }
        if (command.equals("launch-platform")) {
            return new LaunchPlatformCommand();
        }
        if (command.equals("start-platform")) {
            return new StartPlatformCommand();
        }
        if (command.equals("stop-platform")) {
            return new StopPlatformCommand();
        }
        if (command.equals("terminate-platform")) {
            return new TerminatePlatformCommand();
        }
        if (command.equals("launch-instance")) {
            return new LaunchServiceInstanceCommand();
        }
        if (command.equals("attach-volume")) {
            return new AttachNewVolumeToServiceInstanceCommand();
        }
        if (command.equals("run-command")) {
            return new RunCommandOnServiceInstanceCommand();
        }
        if (command.equals("start-instance")) {
            return new StartServiceInstanceCommand();
        }
        if (command.equals("stop-instance")) {
            return new StopServiceInstanceCommand();
        }
        if (command.equals("terminate-instance")) {
            return new TerminateServiceInstanceCommand();
        }
        if (command.equals("list-instances")) {
            return new ListInstancesCommand();
        }
        if (command.equals("list-networks")) {
            return new ListNetworksCommand();
        }
        if (command.equals("delete-network")) {
            return new DeleteNetworkCommand();
        }
        if (command.equals("provision")) {
            return new ProvisionEnvironmentCommand();
        }
        if (command.equals("deploy")) {
            return new DeploySystemCommand();
        }
        if (command.equals("configure")) {
            return new UpdateEnvironmentConfigCommand();
        }
        if (command.equals("start")) {
            return new StartEnvironmentCommand();
        }
        if (command.equals("stop")) {
            return new StopEnvironmentCommand();
        }
        if (command.equals("deprovision")) {
            return new DeprovisionEnvironmentCommand();
        }
        throw new IllegalArgumentException("unknown command '" + command + "'");
    }

    @Override
    final void help(String[] args) {
        if (args.length > 0) {
            String command = args[0].toLowerCase();
            if (commands.contains(command)) {
                AwsCommand.commandHandler(command).help(null);
            } else {
                this.printTopLevelUsage();
            }
        } else {
            this.printTopLevelUsage();
        }
    }

    @Override
    final void execute(String[] args) throws Exception {
        if (args.length > 0) {
            String command = args[0].toLowerCase();
            if (commands.contains(command)) {
                AwsCommand.commandHandler(command).execute(args.length > 1 ? Arrays.copyOfRange(args, 1, args.length) : new String[]{});
            } else {
                this.printTopLevelUsage();
            }
        } else {
            this.printTopLevelUsage();
        }
    }

    private static final class DeprovisionEnvironmentCommand
    extends AbstractCommand {
        private DeprovisionEnvironmentCommand() {
        }

        private static final void printUsage() {
            System.out.println("");
            System.out.println("      'rumi cloud aws deprovision <args>' where args are:");
            System.out.println("          [{-p, --profile the AWS profile to use] (required)");
            System.out.println("          [{-r, --region the AWS region to use] (default=us-east-1)");
            System.out.println("          [{-n, --name the name of the provisioned Rumi environment to deleted] (required)");
            System.out.println("          [{-y, --key-pair the network key pair] (required)");
            System.out.println("");
        }

        @Override
        final void help(String[] args) {
            DeprovisionEnvironmentCommand.printUsage();
        }

        @Override
        final void execute(String[] args) throws Exception {
            CmdLineParser parser = new CmdLineParser();
            CmdLineParser.Option profileOption = parser.addStringOption('p', "profile");
            CmdLineParser.Option regionOption = parser.addStringOption('r', "region");
            CmdLineParser.Option nameOption = parser.addStringOption('n', "name");
            CmdLineParser.Option keyPairOption = parser.addStringOption('k', "key-pair");
            parser.parse(args);
            String profile = (String)parser.getOptionValue(profileOption, null);
            String region = (String)parser.getOptionValue(regionOption, (Object)"us-east-1");
            String name = (String)parser.getOptionValue(nameOption, null);
            String keyPair = (String)parser.getOptionValue(keyPairOption, null);
            if (profile != null && name != null && keyPair != null) {
                AwsProvisioner.create((String)profile, (String)region).deprovisionEnvironment(name, keyPair);
            } else {
                DeprovisionEnvironmentCommand.printUsage();
            }
        }
    }

    private static final class StopEnvironmentCommand
    extends AbstractCommand {
        private StopEnvironmentCommand() {
        }

        private static final void printUsage() {
            System.out.println("");
            System.out.println("      'rumi cloud aws stop <args>' where args are:");
            System.out.println("          [{-p, --profile the AWS profile to use] (required)");
            System.out.println("          [{-r, --region the AWS region to use] (default=us-east-1)");
            System.out.println("          [{-n, --name the name of the environment to stop] (required)");
            System.out.println("          [{-o, --no-wait whether to not wait for the instance to fully start] (default=false)");
            System.out.println("");
        }

        @Override
        final void help(String[] args) {
            StopEnvironmentCommand.printUsage();
        }

        @Override
        final void execute(String[] args) throws Exception {
            CmdLineParser parser = new CmdLineParser();
            CmdLineParser.Option profileOption = parser.addStringOption('p', "profile");
            CmdLineParser.Option regionOption = parser.addStringOption('r', "region");
            CmdLineParser.Option nameOption = parser.addStringOption('n', "name");
            CmdLineParser.Option nowaitOption = parser.addBooleanOption('o', "no-wait");
            parser.parse(args);
            String profile = (String)parser.getOptionValue(profileOption, null);
            String region = (String)parser.getOptionValue(regionOption, (Object)"us-east-1");
            String name = (String)parser.getOptionValue(nameOption, null);
            boolean nowait = (Boolean)parser.getOptionValue(nowaitOption, (Object)false);
            if (profile != null && name != null) {
                AwsProvisioner.create((String)profile, (String)region).stopEnvironment(name, !nowait);
            } else {
                StopEnvironmentCommand.printUsage();
            }
        }
    }

    private static final class StartEnvironmentCommand
    extends AbstractCommand {
        private StartEnvironmentCommand() {
        }

        private static final void printUsage() {
            System.out.println("");
            System.out.println("      'rumi cloud aws start <args>' where args are:");
            System.out.println("          [{-p, --profile the AWS profile to use] (required)");
            System.out.println("          [{-r, --region the AWS region to use] (default=us-east-1)");
            System.out.println("          [{-n, --name the name of the environment to start] (required)");
            System.out.println("          [{-o, --no-wait whether to not wait for the instance to fully start] (default=false)");
            System.out.println("");
        }

        @Override
        final void help(String[] args) {
            StartEnvironmentCommand.printUsage();
        }

        @Override
        final void execute(String[] args) throws Exception {
            CmdLineParser parser = new CmdLineParser();
            CmdLineParser.Option profileOption = parser.addStringOption('p', "profile");
            CmdLineParser.Option regionOption = parser.addStringOption('r', "region");
            CmdLineParser.Option nameOption = parser.addStringOption('n', "name");
            CmdLineParser.Option nowaitOption = parser.addBooleanOption('o', "no-wait");
            parser.parse(args);
            String profile = (String)parser.getOptionValue(profileOption, null);
            String region = (String)parser.getOptionValue(regionOption, (Object)"us-east-1");
            String name = (String)parser.getOptionValue(nameOption, null);
            boolean nowait = (Boolean)parser.getOptionValue(nowaitOption, (Object)false);
            if (profile != null && name != null) {
                AwsProvisioner.create((String)profile, (String)region).startEnvironment(name, !nowait);
            } else {
                StartEnvironmentCommand.printUsage();
            }
        }
    }

    private static final class UpdateEnvironmentConfigCommand
    extends AbstractCommand {
        private UpdateEnvironmentConfigCommand() {
        }

        private static final void printUsage() {
            System.out.println("");
            System.out.println("      'rumi cloud aws configure <args>' where args are:");
            System.out.println("          [{-p, --profile the AWS profile to use] (required)");
            System.out.println("          [{-r, --region the AWS region to use] (default=us-east-1)");
            System.out.println("          [{-n, --name the name of the environment whose config is to be updated] (required)");
            System.out.println("          [{-y, --key-pair the network key pair] (required)");
            System.out.println("          [{-s, --section the configuration property section] (required)");
            System.out.println("          [{-e, --key the configuration property key] (required)");
            System.out.println("          [{-v, --value the configuration property value] (required)");
            System.out.println("");
        }

        @Override
        final void help(String[] args) {
            UpdateEnvironmentConfigCommand.printUsage();
        }

        @Override
        final void execute(String[] args) throws Exception {
            CmdLineParser parser = new CmdLineParser();
            CmdLineParser.Option profileOption = parser.addStringOption('p', "profile");
            CmdLineParser.Option regionOption = parser.addStringOption('r', "region");
            CmdLineParser.Option nameOption = parser.addStringOption('n', "name");
            CmdLineParser.Option keyPairOption = parser.addStringOption('k', "key-pair");
            CmdLineParser.Option sectionOption = parser.addStringOption('s', "section");
            CmdLineParser.Option keyOption = parser.addStringOption('e', "key");
            CmdLineParser.Option valueOption = parser.addStringOption('v', "value");
            parser.parse(args);
            String profile = (String)parser.getOptionValue(profileOption, null);
            String region = (String)parser.getOptionValue(regionOption, (Object)"us-east-1");
            String name = (String)parser.getOptionValue(nameOption, null);
            String keyPair = (String)parser.getOptionValue(keyPairOption, null);
            String section = (String)parser.getOptionValue(sectionOption, null);
            String key = (String)parser.getOptionValue(keyOption, null);
            String value = (String)parser.getOptionValue(valueOption, null);
            if (profile != null && keyPair != null && name != null && section != null & key != null && value != null) {
                AwsProvisioner.create((String)profile, (String)region).updateConfig(name, keyPair, section, key, value.equalsIgnoreCase("null") ? null : value);
            } else {
                UpdateEnvironmentConfigCommand.printUsage();
            }
        }
    }

    private static final class DeploySystemCommand
    extends AbstractCommand {
        private DeploySystemCommand() {
        }

        private static final void printUsage() {
            System.out.println("");
            System.out.println("      'rumi cloud aws deploy <args>' where args are:");
            System.out.println("          [{-p, --profile the AWS profile to use] (required)");
            System.out.println("          [{-r, --region the AWS region to use] (default=us-east-1)");
            System.out.println("          [{-n, --name the name of the environment to deploy the system to] (required)");
            System.out.println("          [{-y, --key-pair the network key pair] (required)");
            System.out.println("          [{-x, --xar the xar file] (required)");
            System.out.println("");
        }

        @Override
        final void help(String[] args) {
            DeploySystemCommand.printUsage();
        }

        @Override
        final void execute(String[] args) throws Exception {
            CmdLineParser parser = new CmdLineParser();
            CmdLineParser.Option profileOption = parser.addStringOption('p', "profile");
            CmdLineParser.Option regionOption = parser.addStringOption('r', "region");
            CmdLineParser.Option nameOption = parser.addStringOption('n', "name");
            CmdLineParser.Option keyPairOption = parser.addStringOption('k', "key-pair");
            CmdLineParser.Option xarOption = parser.addStringOption('x', "xar");
            parser.parse(args);
            String profile = (String)parser.getOptionValue(profileOption, null);
            String region = (String)parser.getOptionValue(regionOption, (Object)"us-east-1");
            String name = (String)parser.getOptionValue(nameOption, null);
            String keyPair = (String)parser.getOptionValue(keyPairOption, null);
            String xar = (String)parser.getOptionValue(xarOption, null);
            if (profile != null && keyPair != null && name != null && xar != null) {
                AwsProvisioner.create((String)profile, (String)region).deploySystem(name, keyPair, new File(xar));
            } else {
                DeploySystemCommand.printUsage();
            }
        }
    }

    private static final class ProvisionEnvironmentCommand
    extends AbstractCommand {
        private ProvisionEnvironmentCommand() {
        }

        private static final void printUsage() {
            System.out.println("");
            System.out.println("      'rumi cloud aws provision <args>' where args are:");
            System.out.println("          [{-p, --profile the AWS profile to use] (required)");
            System.out.println("          [{-r, --region the AWS region to use] (default=us-east-1)");
            System.out.println("          [{-n, --name the name of the environment] (required)");
            System.out.println("          [{-a, --addr the address of the environment's network in the form of x.y] (default=10.0)");
            System.out.println("          [{-y, --key-pair the network key pair] (required)");
            System.out.println("          [{-b, --message-broker the messaging broker to provision too] (default=<no broker>)");
            System.out.println("          [{-o, --firewall-ports the comma separated set of ports to open in this network's firewall] (default=null)");
            System.out.println("          [{-a, --admin-proxy-server the admin proxy server] (default=null)");
            System.out.println("          [{-b, --admin-proxy-port the admin proxy port] (default=0)");
            System.out.println("          [{-c, --discovery-proxy-server the discovery proxy server] (default=null)");
            System.out.println("          [{-d, --discovery-proxy-port the discovery proxy port] (default=0)");
            System.out.println("          [{-e, --monitor-proxy-server the monitor proxy server] (default=null)");
            System.out.println("          [{-f, --monitor-proxy-port the monitor proxy port] (default=0)");
            System.out.println("          [{-g, --broker-proxy-server the broker proxy server] (default=null)");
            System.out.println("          [{-i, --broker-proxy-port the broker proxy port] (default=0)");
            System.out.println("");
        }

        @Override
        final void help(String[] args) {
            ProvisionEnvironmentCommand.printUsage();
        }

        @Override
        final void execute(String[] args) throws Exception {
            CmdLineParser parser = new CmdLineParser();
            CmdLineParser.Option profileOption = parser.addStringOption('p', "profile");
            CmdLineParser.Option regionOption = parser.addStringOption('r', "region");
            CmdLineParser.Option nameOption = parser.addStringOption('n', "name");
            CmdLineParser.Option addrOption = parser.addStringOption('a', "addr");
            CmdLineParser.Option keyPairOption = parser.addStringOption('k', "key-pair");
            CmdLineParser.Option messageBrokerOption = parser.addStringOption('b', "message-broker");
            CmdLineParser.Option firewallPortsOption = parser.addStringOption('o', "firewall-ports");
            CmdLineParser.Option adminProxyServerOption = parser.addStringOption('a', "admin-proxy-server");
            CmdLineParser.Option adminProxyPortOption = parser.addIntegerOption('b', "admin-proxy-port");
            CmdLineParser.Option discoveryProxyServerOption = parser.addStringOption('c', "discovery-proxy-server");
            CmdLineParser.Option discoveryProxyPortOption = parser.addIntegerOption('d', "discovery-proxy-port");
            CmdLineParser.Option monitorProxyServerOption = parser.addStringOption('e', "monitor-proxy-server");
            CmdLineParser.Option monitorProxyPortOption = parser.addIntegerOption('f', "monitor-proxy-port");
            CmdLineParser.Option brokerProxyServerOption = parser.addStringOption('h', "broker-proxy-server");
            CmdLineParser.Option brokerProxyPortOption = parser.addIntegerOption('i', "broker-proxy-port");
            parser.parse(args);
            String profile = (String)parser.getOptionValue(profileOption, null);
            String region = (String)parser.getOptionValue(regionOption, (Object)"us-east-1");
            String name = (String)parser.getOptionValue(nameOption, null);
            String addr = (String)parser.getOptionValue(addrOption, (Object)"10.0");
            String keyPair = (String)parser.getOptionValue(keyPairOption, null);
            String messageBrokerStr = (String)parser.getOptionValue(messageBrokerOption, null);
            AwsProvisioner.MessageBroker messageBroker = messageBrokerStr != null ? AwsProvisioner.MessageBroker.valueOf((String)messageBrokerStr) : null;
            String commaSeparatedFirewallPorts = (String)parser.getOptionValue(firewallPortsOption, null);
            String adminProxyServer = (String)parser.getOptionValue(adminProxyServerOption, null);
            int adminProxyPort = (Integer)parser.getOptionValue(adminProxyPortOption, (Object)0);
            String discoveryProxyServer = (String)parser.getOptionValue(discoveryProxyServerOption, null);
            int discoveryProxyPort = (Integer)parser.getOptionValue(discoveryProxyPortOption, (Object)0);
            String monitorProxyServer = (String)parser.getOptionValue(monitorProxyServerOption, null);
            int monitorProxyPort = (Integer)parser.getOptionValue(monitorProxyPortOption, (Object)0);
            String brokerProxyServer = (String)parser.getOptionValue(brokerProxyServerOption, null);
            int brokerProxyPort = (Integer)parser.getOptionValue(brokerProxyPortOption, (Object)0);
            if (profile != null && name != null && keyPair != null) {
                List firewallPorts = commaSeparatedFirewallPorts != null && !commaSeparatedFirewallPorts.trim().isEmpty() ? Arrays.stream(commaSeparatedFirewallPorts.split(",")).map(String::trim).map(Integer::parseInt).collect(Collectors.toList()) : null;
                HashMap<AwsProvisioner.ProxiedService, AwsProvisioner.PlatformServiceProxyInfo> platformProxyInfo = new HashMap<AwsProvisioner.ProxiedService, AwsProvisioner.PlatformServiceProxyInfo>();
                if (adminProxyServer != null || adminProxyPort > 0) {
                    platformProxyInfo.put(AwsProvisioner.ProxiedService.admin, new AwsProvisioner.PlatformServiceProxyInfo(adminProxyServer, adminProxyPort));
                }
                if (discoveryProxyServer != null || discoveryProxyPort > 0) {
                    platformProxyInfo.put(AwsProvisioner.ProxiedService.discovery, new AwsProvisioner.PlatformServiceProxyInfo(discoveryProxyServer, discoveryProxyPort));
                }
                if (monitorProxyServer != null || monitorProxyPort > 0) {
                    platformProxyInfo.put(AwsProvisioner.ProxiedService.monitor, new AwsProvisioner.PlatformServiceProxyInfo(monitorProxyServer, monitorProxyPort));
                }
                AwsProvisioner.create((String)profile, (String)region).provisionEnvironmentWithMessageBroker(name, addr, keyPair, messageBroker, firewallPorts, platformProxyInfo, messageBroker != null && (brokerProxyServer != null || brokerProxyPort > 0) ? new AwsProvisioner.PlatformServiceProxyInfo(brokerProxyServer, brokerProxyPort) : null);
            } else {
                ProvisionEnvironmentCommand.printUsage();
            }
        }
    }

    private static final class DeleteNetworkCommand
    extends AbstractCommand {
        private DeleteNetworkCommand() {
        }

        private static final void printUsage() {
            System.out.println("");
            System.out.println("      'rumi cloud aws delete-network <args>' where args are:");
            System.out.println("          [{-p, --profile the AWS profile to use] (required)");
            System.out.println("          [{-r, --region the AWS region to use] (default=us-east-1)");
            System.out.println("          [{-n, --name the name of the network (VPC)] (required)");
            System.out.println("          [{-y, --key-pair the network key pair] (required)");
            System.out.println("");
        }

        @Override
        final void help(String[] args) {
            DeleteNetworkCommand.printUsage();
        }

        @Override
        final void execute(String[] args) throws Exception {
            CmdLineParser parser = new CmdLineParser();
            CmdLineParser.Option profileOption = parser.addStringOption('p', "profile");
            CmdLineParser.Option regionOption = parser.addStringOption('r', "region");
            CmdLineParser.Option nameOption = parser.addStringOption('n', "name");
            CmdLineParser.Option keyPairOption = parser.addStringOption('k', "key-pair");
            parser.parse(args);
            String profile = (String)parser.getOptionValue(profileOption, null);
            String region = (String)parser.getOptionValue(regionOption, (Object)"us-east-1");
            String name = (String)parser.getOptionValue(nameOption, null);
            String keyPair = (String)parser.getOptionValue(keyPairOption, null);
            if (profile != null && name != null && keyPair != null) {
                AwsProvisioner.create((String)profile, (String)region).deleteNetwork(name, keyPair);
            } else {
                DeleteNetworkCommand.printUsage();
            }
        }
    }

    private static final class ListNetworksCommand
    extends AbstractCommand {
        private ListNetworksCommand() {
        }

        private static final void printUsage() {
            System.out.println("");
            System.out.println("      'rumi cloud aws list-networks <args>' where args are:");
            System.out.println("          [{-p, --profile the AWS profile to use] (required)");
            System.out.println("          [{-r, --region the AWS region to use] (default=us-east-1)");
            System.out.println("");
        }

        @Override
        final void help(String[] args) {
            ListNetworksCommand.printUsage();
        }

        @Override
        final void execute(String[] args) throws Exception {
            CmdLineParser parser = new CmdLineParser();
            CmdLineParser.Option profileOption = parser.addStringOption('p', "profile");
            CmdLineParser.Option regionOption = parser.addStringOption('r', "region");
            parser.parse(args);
            String profile = (String)parser.getOptionValue(profileOption, null);
            String region = (String)parser.getOptionValue(regionOption, (Object)"us-east-1");
            if (profile != null) {
                List networks = AwsProvisioner.create((String)profile, (String)region).getNetworks();
                System.out.println("");
                System.out.println("Provisioned Networks");
                System.out.println("--------------------");
                if (networks.size() > 0) {
                    Iterator iterator = networks.iterator();
                    while (iterator.hasNext()) {
                        System.out.println("  " + (String)iterator.next());
                    }
                } else {
                    System.out.println("  <none>");
                }
                System.out.println("");
            } else {
                ListNetworksCommand.printUsage();
            }
        }
    }

    private static final class ListInstancesCommand
    extends AbstractCommand {
        private ListInstancesCommand() {
        }

        private static final void printUsage() {
            System.out.println("");
            System.out.println("      'rumi cloud aws list-instances <args>' where args are:");
            System.out.println("          [{-p, --profile the AWS profile to use] (required)");
            System.out.println("          [{-r, --region the AWS region to use] (default=us-east-1)");
            System.out.println("          [{-n, --network the name of the network to list instances in] (required)");
            System.out.println("");
        }

        @Override
        final void help(String[] args) {
            ListInstancesCommand.printUsage();
        }

        @Override
        final void execute(String[] args) throws Exception {
            CmdLineParser parser = new CmdLineParser();
            CmdLineParser.Option profileOption = parser.addStringOption('p', "profile");
            CmdLineParser.Option regionOption = parser.addStringOption('r', "region");
            CmdLineParser.Option networkOption = parser.addStringOption('n', "network");
            parser.parse(args);
            String profile = (String)parser.getOptionValue(profileOption, null);
            String region = (String)parser.getOptionValue(regionOption, (Object)"us-east-1");
            String network = (String)parser.getOptionValue(networkOption, null);
            if (profile != null) {
                Iterator iterator;
                AwsProvisioner provisioner = AwsProvisioner.create((String)profile, (String)region);
                List instances = provisioner.getPlatformInstances(network);
                System.out.println("");
                System.out.println("Platform Instances");
                System.out.println("------------------");
                if (instances.size() > 0) {
                    iterator = instances.iterator();
                    while (iterator.hasNext()) {
                        System.out.println("  " + (String)iterator.next());
                    }
                } else {
                    System.out.println("  <none>");
                }
                instances = provisioner.getMessageBrokerInstances(network);
                System.out.println("");
                System.out.println("Message Broker Instances");
                System.out.println("------------------------");
                if (instances.size() > 0) {
                    iterator = instances.iterator();
                    while (iterator.hasNext()) {
                        System.out.println("  " + (String)iterator.next());
                    }
                } else {
                    System.out.println("  <none>");
                }
                instances = provisioner.getServiceInstances(network);
                System.out.println("");
                System.out.println("Service Instances");
                System.out.println("-----------------");
                if (instances.size() > 0) {
                    iterator = instances.iterator();
                    while (iterator.hasNext()) {
                        System.out.println("  " + (String)iterator.next());
                    }
                } else {
                    System.out.println("  <none>");
                }
                System.out.println("");
            } else {
                ListInstancesCommand.printUsage();
            }
        }
    }

    private static final class TerminateServiceInstanceCommand
    extends AbstractCommand {
        private TerminateServiceInstanceCommand() {
        }

        private static final void printUsage() {
            System.out.println("");
            System.out.println("      'rumi cloud aws terminate-instance <args>' where args are:");
            System.out.println("          [{-p, --profile the AWS profile to use] (required)");
            System.out.println("          [{-r, --region the AWS region to use] (default=us-east-1)");
            System.out.println("          [{-n, --network the name of the network to terminate it into] (required)");
            System.out.println("          [{-y, --key-pair the network key pair] (required)");
            System.out.println("          [{-i, --name the name of the service instance to terminate] (required)");
            System.out.println("          [{-o, --no-wait whether to not wait for the instance to fully start] (default=false)");
            System.out.println("");
        }

        @Override
        final void help(String[] args) {
            TerminateServiceInstanceCommand.printUsage();
        }

        @Override
        final void execute(String[] args) throws Exception {
            CmdLineParser parser = new CmdLineParser();
            CmdLineParser.Option profileOption = parser.addStringOption('p', "profile");
            CmdLineParser.Option regionOption = parser.addStringOption('r', "region");
            CmdLineParser.Option networkOption = parser.addStringOption('n', "network");
            CmdLineParser.Option keyPairOption = parser.addStringOption('k', "key-pair");
            CmdLineParser.Option nameOption = parser.addStringOption('i', "name");
            CmdLineParser.Option nowaitOption = parser.addBooleanOption('o', "no-wait");
            parser.parse(args);
            String profile = (String)parser.getOptionValue(profileOption, null);
            String region = (String)parser.getOptionValue(regionOption, (Object)"us-east-1");
            String network = (String)parser.getOptionValue(networkOption, null);
            String keyPair = (String)parser.getOptionValue(keyPairOption, null);
            String name = (String)parser.getOptionValue(nameOption, null);
            boolean nowait = (Boolean)parser.getOptionValue(nowaitOption, (Object)false);
            if (profile != null && network != null && keyPair != null && name != null) {
                AwsProvisioner.create((String)profile, (String)region).terminateServiceInstance(network, keyPair, name, !nowait);
            } else {
                TerminateServiceInstanceCommand.printUsage();
            }
        }
    }

    private static final class StopServiceInstanceCommand
    extends AbstractCommand {
        private StopServiceInstanceCommand() {
        }

        private static final void printUsage() {
            System.out.println("");
            System.out.println("      'rumi cloud aws stop-instance <args>' where args are:");
            System.out.println("          [{-p, --profile the AWS profile to use] (required)");
            System.out.println("          [{-r, --region the AWS region to use] (default=us-east-1)");
            System.out.println("          [{-n, --network the name of the network to stop it into] (required)");
            System.out.println("          [{-a, --name the name of the service instance to stop] (required)");
            System.out.println("          [{-o, --no-wait whether to not wait for the instance to fully stop] (default=false)");
            System.out.println("");
        }

        @Override
        final void help(String[] args) {
            StopServiceInstanceCommand.printUsage();
        }

        @Override
        final void execute(String[] args) throws Exception {
            CmdLineParser parser = new CmdLineParser();
            CmdLineParser.Option profileOption = parser.addStringOption('p', "profile");
            CmdLineParser.Option regionOption = parser.addStringOption('r', "region");
            CmdLineParser.Option networkOption = parser.addStringOption('n', "network");
            CmdLineParser.Option nameOption = parser.addStringOption('a', "name");
            CmdLineParser.Option nowaitOption = parser.addBooleanOption('o', "no-wait");
            parser.parse(args);
            String profile = (String)parser.getOptionValue(profileOption, null);
            String region = (String)parser.getOptionValue(regionOption, (Object)"us-east-1");
            String network = (String)parser.getOptionValue(networkOption, null);
            String name = (String)parser.getOptionValue(nameOption, null);
            boolean nowait = (Boolean)parser.getOptionValue(nowaitOption, (Object)false);
            if (profile != null && network != null && name != null) {
                AwsProvisioner.create((String)profile, (String)region).stopServiceInstance(network, name, !nowait);
            } else {
                StopServiceInstanceCommand.printUsage();
            }
        }
    }

    private static final class StartServiceInstanceCommand
    extends AbstractCommand {
        private StartServiceInstanceCommand() {
        }

        private static final void printUsage() {
            System.out.println("");
            System.out.println("      'rumi cloud aws start-instance <args>' where args are:");
            System.out.println("          [{-p, --profile the AWS profile to use] (required)");
            System.out.println("          [{-r, --region the AWS region to use] (default=us-east-1)");
            System.out.println("          [{-n, --network the name of the network to start it into] (required)");
            System.out.println("          [{-a, --name the name of the service instance to start] (required)");
            System.out.println("          [{-o, --no-wait whether to not wait for the instance to fully start] (default=false)");
            System.out.println("");
        }

        @Override
        final void help(String[] args) {
            StartServiceInstanceCommand.printUsage();
        }

        @Override
        final void execute(String[] args) throws Exception {
            CmdLineParser parser = new CmdLineParser();
            CmdLineParser.Option profileOption = parser.addStringOption('p', "profile");
            CmdLineParser.Option regionOption = parser.addStringOption('r', "region");
            CmdLineParser.Option networkOption = parser.addStringOption('n', "network");
            CmdLineParser.Option nameOption = parser.addStringOption('a', "name");
            CmdLineParser.Option nowaitOption = parser.addBooleanOption('o', "no-wait");
            parser.parse(args);
            String profile = (String)parser.getOptionValue(profileOption, null);
            String region = (String)parser.getOptionValue(regionOption, (Object)"us-east-1");
            String network = (String)parser.getOptionValue(networkOption, null);
            String name = (String)parser.getOptionValue(nameOption, null);
            boolean nowait = (Boolean)parser.getOptionValue(nowaitOption, (Object)false);
            if (profile != null && network != null && name != null) {
                AwsProvisioner.create((String)profile, (String)region).startServiceInstance(network, name, !nowait);
            } else {
                StartServiceInstanceCommand.printUsage();
            }
        }
    }

    private static final class RunCommandOnServiceInstanceCommand
    extends AbstractCommand {
        private RunCommandOnServiceInstanceCommand() {
        }

        private static final void printUsage() {
            System.out.println("");
            System.out.println("      'rumi cloud aws run-commmand <args>' where args are:");
            System.out.println("          [{-p, --profile the AWS profile to use] (required)");
            System.out.println("          [{-r, --region the AWS region to use] (default=us-east-1)");
            System.out.println("          [{-n, --network the name of the network containing the instance of which to run the command] (required)");
            System.out.println("          [{-y, --key-pair the network key pair] (required)");
            System.out.println("          [{-z, --zone the name of the hosted zone the instance belongs to] (default=rumi.local)");
            System.out.println("          [{-o, --instanceNameInZone the zone name of the instance] (required)");
            System.out.println("          [{-m, --command the command to run] (required)");
            System.out.println("");
        }

        @Override
        final void help(String[] args) {
            RunCommandOnServiceInstanceCommand.printUsage();
        }

        @Override
        final void execute(String[] args) throws Exception {
            CmdLineParser parser = new CmdLineParser();
            CmdLineParser.Option profileOption = parser.addStringOption('p', "profile");
            CmdLineParser.Option regionOption = parser.addStringOption('r', "region");
            CmdLineParser.Option networkOption = parser.addStringOption('n', "network");
            CmdLineParser.Option keyPairOption = parser.addStringOption('k', "key-pair");
            CmdLineParser.Option zoneOption = parser.addStringOption('z', "zone");
            CmdLineParser.Option instanceNameInZoneOption = parser.addStringOption('i', "instanceNameInZone");
            CmdLineParser.Option commandOption = parser.addStringOption('c', "command");
            parser.parse(args);
            String profile = (String)parser.getOptionValue(profileOption, null);
            String region = (String)parser.getOptionValue(regionOption, (Object)"us-east-1");
            String network = (String)parser.getOptionValue(networkOption, null);
            String keyPair = (String)parser.getOptionValue(keyPairOption, null);
            String zone = (String)parser.getOptionValue(zoneOption, (Object)"rumi.local");
            String instanceNameInZone = (String)parser.getOptionValue(instanceNameInZoneOption, null);
            String command = (String)parser.getOptionValue(commandOption, null);
            if (profile != null && network != null && keyPair != null && instanceNameInZone != null && command != null) {
                AwsProvisioner.create((String)profile, (String)region).runCommandOnServiceInstance(network, keyPair, zone, instanceNameInZone, command);
            } else {
                RunCommandOnServiceInstanceCommand.printUsage();
            }
        }
    }

    private static final class AttachNewVolumeToServiceInstanceCommand
    extends AbstractCommand {
        private AttachNewVolumeToServiceInstanceCommand() {
        }

        private static final void printUsage() {
            System.out.println("");
            System.out.println("      'rumi cloud aws attach-volume <args>' where args are:");
            System.out.println("          [{-p, --profile the AWS profile to use] (required)");
            System.out.println("          [{-r, --region the AWS region to use] (default=us-east-1)");
            System.out.println("          [{-n, --network the name of the network to launch it into] (required)");
            System.out.println("          [{-y, --key-pair the network key pair] (required)");
            System.out.println("          [{-z, --zone the name of the hosted zone the service belongs to] (default=rumi.local)");
            System.out.println("          [{-i, --instanceName the name of the service instance to attach the volume to] (required)");
            System.out.println("          [{-o, --instanceNameInZone the zone name of the service instance] (default=null in which case the instance name is used as the name in the zone)");
            System.out.println("          [{-n  --volumeName the name to assign to the volume] (default=null in which case <noname> name is assigned to the volume)");
            System.out.println("          [{-t  --volumeType the volume type (GP3, SC1, ST1)] (default=GP3)");
            System.out.println("          [{-v, --volumeSize the size, in GiB, of the new volume] (default=1)");
            System.out.println("          [{-s, --snapshot the id of the snapshot to create the volume from] (default=null in which case a volume is created fresh)");
            System.out.println("          [{-m, --mountPoint the mount point] (default=null in which case the volume is not mounted)");
            System.out.println("");
        }

        @Override
        final void help(String[] args) {
            AttachNewVolumeToServiceInstanceCommand.printUsage();
        }

        @Override
        final void execute(String[] args) throws Exception {
            CmdLineParser parser = new CmdLineParser();
            CmdLineParser.Option profileOption = parser.addStringOption('p', "profile");
            CmdLineParser.Option regionOption = parser.addStringOption('r', "region");
            CmdLineParser.Option networkOption = parser.addStringOption('n', "network");
            CmdLineParser.Option keyPairOption = parser.addStringOption('k', "key-pair");
            CmdLineParser.Option zoneOption = parser.addStringOption('z', "zone");
            CmdLineParser.Option instanceNameOption = parser.addStringOption('i', "instanceName");
            CmdLineParser.Option instanceNameInZoneOption = parser.addStringOption('j', "instanceNameInZone");
            CmdLineParser.Option volumeNameOption = parser.addStringOption('n', "volumeName");
            CmdLineParser.Option volumeTypeOption = parser.addStringOption('t', "volumeType");
            CmdLineParser.Option volumeSizeOption = parser.addIntegerOption('i', "volumeSize");
            CmdLineParser.Option snapshotOption = parser.addStringOption('s', "snapshot");
            CmdLineParser.Option mountPointOption = parser.addStringOption('m', "mountPoint");
            parser.parse(args);
            String profile = (String)parser.getOptionValue(profileOption, null);
            String region = (String)parser.getOptionValue(regionOption, (Object)"us-east-1");
            String network = (String)parser.getOptionValue(networkOption, null);
            String keyPair = (String)parser.getOptionValue(keyPairOption, null);
            String zone = (String)parser.getOptionValue(zoneOption, (Object)"rumi.local");
            String instanceName = (String)parser.getOptionValue(instanceNameOption, null);
            String instanceNameInZone = (String)parser.getOptionValue(instanceNameInZoneOption, null);
            String volumeName = (String)parser.getOptionValue(volumeNameOption, null);
            String volumeType = (String)parser.getOptionValue(volumeTypeOption, (Object)"GP3");
            int volumeSize = (Integer)parser.getOptionValue(volumeSizeOption, (Object)1);
            String snapshotId = (String)parser.getOptionValue(snapshotOption, null);
            String mountPoint = (String)parser.getOptionValue(mountPointOption, null);
            if (profile != null && network != null && keyPair != null && instanceName != null) {
                AwsProvisioner.create((String)profile, (String)region).attachNewVolumeToServiceInstance(network, keyPair, zone, instanceName, instanceNameInZone, volumeName, volumeType, volumeSize, snapshotId, mountPoint);
            } else {
                AttachNewVolumeToServiceInstanceCommand.printUsage();
            }
        }
    }

    private static final class LaunchServiceInstanceCommand
    extends AbstractCommand {
        private LaunchServiceInstanceCommand() {
        }

        private static final void printUsage() {
            System.out.println("");
            System.out.println("      'rumi cloud aws launch-instance <args>' where args are:");
            System.out.println("          [{-p, --profile the AWS profile to use] (required)");
            System.out.println("          [{-r, --region the AWS region to use] (default=us-east-1)");
            System.out.println("          [{-n, --network the name of the network in which to launch the instance] (required)");
            System.out.println("          [{-y, --key-pair the network key pair] (required)");
            System.out.println("          [{-t  --type the type of the service instance to launch] (required)");
            System.out.println("          [{-i, --publicIP whether to assign a public IP to the instance] (default=false)");
            System.out.println("          [{-z, --zone the hosted zone to add this instance's DNS entry to] (default=rumi.local)");
            System.out.println("          [{-a, --name the name of the service instance to launch] (required)");
            System.out.println("          [{-o, --nameInZone the zone name of the service instance] (default=instance name in dotted case ('-' replaced with '.'))");
            System.out.println("          [{-l, --additionalNamesInZone the additional names to add the zone for this service instance] (default=null in which case no additional names are added to the zone for this instance)");
            System.out.println("          [{-v, --vsize the size, in GiB, of the additional (non-boot) volume on the instance] (default=32)");
            System.out.println("");
        }

        @Override
        final void help(String[] args) {
            LaunchServiceInstanceCommand.printUsage();
        }

        @Override
        final void execute(String[] args) throws Exception {
            CmdLineParser parser = new CmdLineParser();
            CmdLineParser.Option profileOption = parser.addStringOption('p', "profile");
            CmdLineParser.Option regionOption = parser.addStringOption('r', "region");
            CmdLineParser.Option networkOption = parser.addStringOption('n', "network");
            CmdLineParser.Option keyPairOption = parser.addStringOption('k', "key-pair");
            CmdLineParser.Option typeOption = parser.addStringOption('t', "type");
            CmdLineParser.Option publicIPOption = parser.addBooleanOption('i', "publicIP");
            CmdLineParser.Option zoneOption = parser.addStringOption('z', "zone");
            CmdLineParser.Option nameOption = parser.addStringOption('a', "name");
            CmdLineParser.Option nameInZoneOption = parser.addStringOption('b', "nameInZone");
            CmdLineParser.Option additionalNamesInZoneOption = parser.addStringOption('l', "additionalNamesInZone");
            CmdLineParser.Option vsizeOption = parser.addIntegerOption('v', "vsize");
            parser.parse(args);
            String profile = (String)parser.getOptionValue(profileOption, null);
            String region = (String)parser.getOptionValue(regionOption, (Object)"us-east-1");
            String network = (String)parser.getOptionValue(networkOption, null);
            String keyPair = (String)parser.getOptionValue(keyPairOption, null);
            String type = (String)parser.getOptionValue(typeOption, null);
            boolean publicIP = (Boolean)parser.getOptionValue(publicIPOption, (Object)false);
            String zone = (String)parser.getOptionValue(zoneOption, (Object)"rumi.local");
            String name = (String)parser.getOptionValue(nameOption, null);
            String additionalNamesInZone = (String)parser.getOptionValue(additionalNamesInZoneOption, null);
            int vsize = (Integer)parser.getOptionValue(vsizeOption, (Object)32);
            if (profile != null && network != null && keyPair != null && name != null && type != null) {
                String nameInZone = (String)parser.getOptionValue(nameInZoneOption, (Object)name.replace("-", "."));
                AwsProvisioner.create((String)profile, (String)region).launchServiceInstance(network, keyPair, type, publicIP, zone, name, nameInZone, additionalNamesInZone != null ? additionalNamesInZone.split(",") : null, vsize);
            } else {
                LaunchServiceInstanceCommand.printUsage();
            }
        }
    }

    private static final class TerminatePlatformCommand
    extends AbstractCommand {
        private TerminatePlatformCommand() {
        }

        private static final void printUsage() {
            System.out.println("");
            System.out.println("      'rumi cloud aws terminate-platform <args>' where args are:");
            System.out.println("          [{-p, --profile the AWS profile to use] (required)");
            System.out.println("          [{-r, --region the AWS region to use] (default=us-east-1)");
            System.out.println("          [{-n, --network the name of the network to terminate it into] (required)");
            System.out.println("          [{-y, --key-pair the network key pair] (required)");
            System.out.println("          [{-o, --no-wait whether to not wait for the instance to fully start] (default=false)");
            System.out.println("");
        }

        @Override
        final void help(String[] args) {
            TerminatePlatformCommand.printUsage();
        }

        @Override
        final void execute(String[] args) throws Exception {
            CmdLineParser parser = new CmdLineParser();
            CmdLineParser.Option profileOption = parser.addStringOption('p', "profile");
            CmdLineParser.Option regionOption = parser.addStringOption('r', "region");
            CmdLineParser.Option networkOption = parser.addStringOption('n', "network");
            CmdLineParser.Option keyPairOption = parser.addStringOption('k', "key-pair");
            CmdLineParser.Option nowaitOption = parser.addBooleanOption('o', "no-wait");
            parser.parse(args);
            String profile = (String)parser.getOptionValue(profileOption, null);
            String region = (String)parser.getOptionValue(regionOption, (Object)"us-east-1");
            String network = (String)parser.getOptionValue(networkOption, null);
            String keyPair = (String)parser.getOptionValue(keyPairOption, null);
            boolean nowait = (Boolean)parser.getOptionValue(nowaitOption, (Object)false);
            if (profile != null && network != null && keyPair != null) {
                AwsProvisioner.create((String)profile, (String)region).terminatePlatform(network, keyPair, !nowait);
            } else {
                TerminatePlatformCommand.printUsage();
            }
        }
    }

    private static final class StopPlatformCommand
    extends AbstractCommand {
        private StopPlatformCommand() {
        }

        private static final void printUsage() {
            System.out.println("");
            System.out.println("      'rumi cloud aws stop-platform <args>' where args are:");
            System.out.println("          [{-p, --profile the AWS profile to use] (required)");
            System.out.println("          [{-r, --region the AWS region to use] (default=us-east-1)");
            System.out.println("          [{-n, --network the name of the network to stop it into] (required)");
            System.out.println("          [{-o, --no-wait whether to not wait for the instance to fully start] (default=false)");
            System.out.println("");
        }

        @Override
        final void help(String[] args) {
            StopPlatformCommand.printUsage();
        }

        @Override
        final void execute(String[] args) throws Exception {
            CmdLineParser parser = new CmdLineParser();
            CmdLineParser.Option profileOption = parser.addStringOption('p', "profile");
            CmdLineParser.Option regionOption = parser.addStringOption('r', "region");
            CmdLineParser.Option networkOption = parser.addStringOption('n', "network");
            CmdLineParser.Option nowaitOption = parser.addBooleanOption('o', "no-wait");
            parser.parse(args);
            String profile = (String)parser.getOptionValue(profileOption, null);
            String region = (String)parser.getOptionValue(regionOption, (Object)"us-east-1");
            String network = (String)parser.getOptionValue(networkOption, null);
            boolean nowait = (Boolean)parser.getOptionValue(nowaitOption, (Object)false);
            if (profile != null && network != null) {
                AwsProvisioner.create((String)profile, (String)region).stopPlatform(network, !nowait);
            } else {
                StopPlatformCommand.printUsage();
            }
        }
    }

    private static final class StartPlatformCommand
    extends AbstractCommand {
        private StartPlatformCommand() {
        }

        private static final void printUsage() {
            System.out.println("");
            System.out.println("      'rumi cloud aws start-platform <args>' where args are:");
            System.out.println("          [{-p, --profile the AWS profile to use] (required)");
            System.out.println("          [{-r, --region the AWS region to use] (default=us-east-1)");
            System.out.println("          [{-n, --network the name of the network to start it into] (required)");
            System.out.println("          [{-o, --no-wait whether to not wait for the instance to fully start] (default=false)");
            System.out.println("");
        }

        @Override
        final void help(String[] args) {
            StartPlatformCommand.printUsage();
        }

        @Override
        final void execute(String[] args) throws Exception {
            CmdLineParser parser = new CmdLineParser();
            CmdLineParser.Option profileOption = parser.addStringOption('p', "profile");
            CmdLineParser.Option regionOption = parser.addStringOption('r', "region");
            CmdLineParser.Option networkOption = parser.addStringOption('n', "network");
            CmdLineParser.Option nowaitOption = parser.addBooleanOption('o', "no-wait");
            parser.parse(args);
            String profile = (String)parser.getOptionValue(profileOption, null);
            String region = (String)parser.getOptionValue(regionOption, (Object)"us-east-1");
            String network = (String)parser.getOptionValue(networkOption, null);
            boolean nowait = (Boolean)parser.getOptionValue(nowaitOption, (Object)false);
            if (profile != null && network != null) {
                AwsProvisioner.create((String)profile, (String)region).startPlatform(network, !nowait);
            } else {
                StartPlatformCommand.printUsage();
            }
        }
    }

    private static final class LaunchPlatformCommand
    extends AbstractCommand {
        private LaunchPlatformCommand() {
        }

        private static final void printUsage() {
            System.out.println("");
            System.out.println("      'rumi cloud aws launch-platform <args>' where args are:");
            System.out.println("          [{-p, --profile the AWS profile to use] (required)");
            System.out.println("          [{-r, --region the AWS region to use] (default=us-east-1)");
            System.out.println("          [{-n, --network the name of the network to launch it into] (required)");
            System.out.println("          [{-y, --key-pair the network key pair] (required)");
            System.out.println("          [{-a, --admin-proxy-server the admin proxy server] (default=null)");
            System.out.println("          [{-b, --admin-proxy-port the admin proxy port] (default=0)");
            System.out.println("          [{-c, --discovery-proxy-server the discovery proxy server] (default=null)");
            System.out.println("          [{-d, --discovery-proxy-port the discovery proxy port] (default=0)");
            System.out.println("          [{-e, --monitor-proxy-server the monitor proxy server] (default=null)");
            System.out.println("          [{-f, --monitor-proxy-port the monitor proxy port] (default=0)");
            System.out.println("");
        }

        @Override
        final void help(String[] args) {
            LaunchPlatformCommand.printUsage();
        }

        @Override
        final void execute(String[] args) throws Exception {
            CmdLineParser parser = new CmdLineParser();
            CmdLineParser.Option profileOption = parser.addStringOption('p', "profile");
            CmdLineParser.Option regionOption = parser.addStringOption('r', "region");
            CmdLineParser.Option networkOption = parser.addStringOption('n', "network");
            CmdLineParser.Option keyPairOption = parser.addStringOption('k', "key-pair");
            CmdLineParser.Option adminProxyServerOption = parser.addStringOption('a', "admin-proxy-server");
            CmdLineParser.Option adminProxyPortOption = parser.addIntegerOption('b', "admin-proxy-port");
            CmdLineParser.Option discoveryProxyServerOption = parser.addStringOption('c', "discovery-proxy-server");
            CmdLineParser.Option discoveryProxyPortOption = parser.addIntegerOption('d', "discovery-proxy-port");
            CmdLineParser.Option monitorProxyServerOption = parser.addStringOption('e', "monitor-proxy-server");
            CmdLineParser.Option monitorProxyPortOption = parser.addIntegerOption('f', "monitor-proxy-port");
            parser.parse(args);
            String profile = (String)parser.getOptionValue(profileOption, null);
            String region = (String)parser.getOptionValue(regionOption, (Object)"us-east-1");
            String network = (String)parser.getOptionValue(networkOption, null);
            String keyPair = (String)parser.getOptionValue(keyPairOption, null);
            String adminProxyServer = (String)parser.getOptionValue(adminProxyServerOption, null);
            int adminProxyPort = (Integer)parser.getOptionValue(adminProxyPortOption, (Object)0);
            String discoveryProxyServer = (String)parser.getOptionValue(discoveryProxyServerOption, null);
            int discoveryProxyPort = (Integer)parser.getOptionValue(discoveryProxyPortOption, (Object)0);
            String monitorProxyServer = (String)parser.getOptionValue(monitorProxyServerOption, null);
            int monitorProxyPort = (Integer)parser.getOptionValue(monitorProxyPortOption, (Object)0);
            if (profile != null && network != null && keyPair != null) {
                HashMap<AwsProvisioner.ProxiedService, AwsProvisioner.PlatformServiceProxyInfo> proxyInfo = new HashMap<AwsProvisioner.ProxiedService, AwsProvisioner.PlatformServiceProxyInfo>();
                if (adminProxyServer != null || adminProxyPort > 0) {
                    proxyInfo.put(AwsProvisioner.ProxiedService.admin, new AwsProvisioner.PlatformServiceProxyInfo(adminProxyServer, adminProxyPort));
                }
                if (discoveryProxyServer != null || discoveryProxyPort > 0) {
                    proxyInfo.put(AwsProvisioner.ProxiedService.discovery, new AwsProvisioner.PlatformServiceProxyInfo(discoveryProxyServer, discoveryProxyPort));
                }
                if (monitorProxyServer != null || monitorProxyPort > 0) {
                    proxyInfo.put(AwsProvisioner.ProxiedService.monitor, new AwsProvisioner.PlatformServiceProxyInfo(monitorProxyServer, monitorProxyPort));
                }
                AwsProvisioner.create((String)profile, (String)region).launchPlatform(network, keyPair, proxyInfo.size() > 0 ? proxyInfo : null);
            } else {
                LaunchPlatformCommand.printUsage();
            }
        }
    }

    private static final class TerminateActiveMQBrokerCommand
    extends AbstractCommand {
        private TerminateActiveMQBrokerCommand() {
        }

        private static final void printUsage() {
            System.out.println("");
            System.out.println("      'rumi cloud aws terminate-amq <args>' where args are:");
            System.out.println("          [{-p, --profile the AWS profile to use] (required)");
            System.out.println("          [{-r, --region the AWS region to use] (default=us-east-1)");
            System.out.println("          [{-n, --network the name of the network to terminate it into] (required)");
            System.out.println("          [{-y, --key-pair the network key pair] (required)");
            System.out.println("          [{-o, --no-wait whether to not wait for the instance to fully start] (default=false)");
            System.out.println("");
        }

        @Override
        final void help(String[] args) {
            TerminateActiveMQBrokerCommand.printUsage();
        }

        @Override
        final void execute(String[] args) throws Exception {
            CmdLineParser parser = new CmdLineParser();
            CmdLineParser.Option profileOption = parser.addStringOption('p', "profile");
            CmdLineParser.Option regionOption = parser.addStringOption('r', "region");
            CmdLineParser.Option networkOption = parser.addStringOption('n', "network");
            CmdLineParser.Option keyPairOption = parser.addStringOption('k', "key-pair");
            CmdLineParser.Option nowaitOption = parser.addBooleanOption('o', "no-wait");
            parser.parse(args);
            String profile = (String)parser.getOptionValue(profileOption, null);
            String region = (String)parser.getOptionValue(regionOption, (Object)"us-east-1");
            String network = (String)parser.getOptionValue(networkOption, null);
            String keyPair = (String)parser.getOptionValue(keyPairOption, null);
            boolean nowait = (Boolean)parser.getOptionValue(nowaitOption, (Object)false);
            if (profile != null && network != null && keyPair != null) {
                AwsProvisioner.create((String)profile, (String)region).terminateActiveMQBroker(network, keyPair, !nowait);
            } else {
                TerminateActiveMQBrokerCommand.printUsage();
            }
        }
    }

    private static final class StopActiveMQBrokerCommand
    extends AbstractCommand {
        private StopActiveMQBrokerCommand() {
        }

        private static final void printUsage() {
            System.out.println("");
            System.out.println("      'rumi cloud aws stop-amq <args>' where args are:");
            System.out.println("          [{-p, --profile the AWS profile to use] (required)");
            System.out.println("          [{-r, --region the AWS region to use] (default=us-east-1)");
            System.out.println("          [{-n, --network the name of the network to stop it into] (required)");
            System.out.println("          [{-o, --no-wait whether to not wait for the instance to fully start] (default=false)");
            System.out.println("");
        }

        @Override
        final void help(String[] args) {
            StopActiveMQBrokerCommand.printUsage();
        }

        @Override
        final void execute(String[] args) throws Exception {
            CmdLineParser parser = new CmdLineParser();
            CmdLineParser.Option profileOption = parser.addStringOption('p', "profile");
            CmdLineParser.Option regionOption = parser.addStringOption('r', "region");
            CmdLineParser.Option networkOption = parser.addStringOption('n', "network");
            CmdLineParser.Option nowaitOption = parser.addBooleanOption('o', "no-wait");
            parser.parse(args);
            String profile = (String)parser.getOptionValue(profileOption, null);
            String region = (String)parser.getOptionValue(regionOption, (Object)"us-east-1");
            String network = (String)parser.getOptionValue(networkOption, null);
            boolean nowait = (Boolean)parser.getOptionValue(nowaitOption, (Object)false);
            if (profile != null && network != null) {
                AwsProvisioner.create((String)profile, (String)region).stopActiveMQBroker(network, !nowait);
            } else {
                StopActiveMQBrokerCommand.printUsage();
            }
        }
    }

    private static final class StartActiveMQBrokerCommand
    extends AbstractCommand {
        private StartActiveMQBrokerCommand() {
        }

        private static final void printUsage() {
            System.out.println("");
            System.out.println("      'rumi cloud aws start-amq <args>' where args are:");
            System.out.println("          [{-p, --profile the AWS profile to use] (required)");
            System.out.println("          [{-r, --region the AWS region to use] (default=us-east-1)");
            System.out.println("          [{-n, --network the name of the network to start it into] (required)");
            System.out.println("          [{-o, --no-wait whether to not wait for the instance to fully start] (default=false)");
            System.out.println("");
        }

        @Override
        final void help(String[] args) {
            StartActiveMQBrokerCommand.printUsage();
        }

        @Override
        final void execute(String[] args) throws Exception {
            CmdLineParser parser = new CmdLineParser();
            CmdLineParser.Option profileOption = parser.addStringOption('p', "profile");
            CmdLineParser.Option regionOption = parser.addStringOption('r', "region");
            CmdLineParser.Option networkOption = parser.addStringOption('n', "network");
            CmdLineParser.Option nowaitOption = parser.addBooleanOption('o', "no-wait");
            parser.parse(args);
            String profile = (String)parser.getOptionValue(profileOption, null);
            String region = (String)parser.getOptionValue(regionOption, (Object)"us-east-1");
            String network = (String)parser.getOptionValue(networkOption, null);
            boolean nowait = (Boolean)parser.getOptionValue(nowaitOption, (Object)false);
            if (profile != null && network != null) {
                AwsProvisioner.create((String)profile, (String)region).startActiveMQBroker(network, !nowait);
            } else {
                StartActiveMQBrokerCommand.printUsage();
            }
        }
    }

    private static final class LaunchActiveMQBrokerCommand
    extends AbstractCommand {
        private LaunchActiveMQBrokerCommand() {
        }

        private static final void printUsage() {
            System.out.println("");
            System.out.println("      'rumi cloud aws launch-amq <args>' where args are:");
            System.out.println("          [{-p, --profile the AWS profile to use] (required)");
            System.out.println("          [{-r, --region the AWS region to use] (default=us-east-1)");
            System.out.println("          [{-n, --network the name of the network to launch it into] (required)");
            System.out.println("          [{-y, --key-pair the network key pair] (required)");
            System.out.println("          [{-a, --proxy-server the broker proxy server] (default=null)");
            System.out.println("          [{-b, --proxy-port the broker proxy port] (default=0)");
            System.out.println("");
        }

        @Override
        final void help(String[] args) {
            LaunchActiveMQBrokerCommand.printUsage();
        }

        @Override
        final void execute(String[] args) throws Exception {
            CmdLineParser parser = new CmdLineParser();
            CmdLineParser.Option profileOption = parser.addStringOption('p', "profile");
            CmdLineParser.Option regionOption = parser.addStringOption('r', "region");
            CmdLineParser.Option networkOption = parser.addStringOption('n', "network");
            CmdLineParser.Option keyPairOption = parser.addStringOption('k', "key-pair");
            CmdLineParser.Option proxyServerOption = parser.addStringOption('a', "proxy-server");
            CmdLineParser.Option proxyPortOption = parser.addIntegerOption('b', "proxy-port");
            parser.parse(args);
            String profile = (String)parser.getOptionValue(profileOption, null);
            String region = (String)parser.getOptionValue(regionOption, (Object)"us-east-1");
            String network = (String)parser.getOptionValue(networkOption, null);
            String keyPair = (String)parser.getOptionValue(keyPairOption, null);
            String proxyServer = (String)parser.getOptionValue(proxyServerOption, null);
            int proxyPort = (Integer)parser.getOptionValue(proxyPortOption, (Object)0);
            if (profile != null && network != null && keyPair != null) {
                AwsProvisioner.create((String)profile, (String)region).launchActiveMQBroker(network, keyPair, (AwsProvisioner.PlatformServiceProxyInfo)(proxyServer != null || proxyPort > 0 ? new AwsProvisioner.PlatformServiceProxyInfo(proxyServer, proxyPort) : null));
            } else {
                LaunchActiveMQBrokerCommand.printUsage();
            }
        }
    }

    private static final class TerminateKafkaBrokerCommand
    extends AbstractCommand {
        private TerminateKafkaBrokerCommand() {
        }

        private static final void printUsage() {
            System.out.println("");
            System.out.println("      'rumi cloud aws terminate-kafka <args>' where args are:");
            System.out.println("          [{-p, --profile the AWS profile to use] (required)");
            System.out.println("          [{-r, --region the AWS region to use] (default=us-east-1)");
            System.out.println("          [{-n, --network the name of the network to terminate it into] (required)");
            System.out.println("          [{-y, --key-pair the network key pair] (required)");
            System.out.println("          [{-o, --no-wait whether to not wait for the instance to fully start] (default=false)");
            System.out.println("");
        }

        @Override
        final void help(String[] args) {
            TerminateKafkaBrokerCommand.printUsage();
        }

        @Override
        final void execute(String[] args) throws Exception {
            CmdLineParser parser = new CmdLineParser();
            CmdLineParser.Option profileOption = parser.addStringOption('p', "profile");
            CmdLineParser.Option regionOption = parser.addStringOption('r', "region");
            CmdLineParser.Option networkOption = parser.addStringOption('n', "network");
            CmdLineParser.Option keyPairOption = parser.addStringOption('k', "key-pair");
            CmdLineParser.Option nowaitOption = parser.addBooleanOption('o', "no-wait");
            parser.parse(args);
            String profile = (String)parser.getOptionValue(profileOption, null);
            String region = (String)parser.getOptionValue(regionOption, (Object)"us-east-1");
            String network = (String)parser.getOptionValue(networkOption, null);
            String keyPair = (String)parser.getOptionValue(keyPairOption, null);
            boolean nowait = (Boolean)parser.getOptionValue(nowaitOption, (Object)false);
            if (profile != null && network != null && keyPair != null) {
                AwsProvisioner.create((String)profile, (String)region).terminateKafkaBroker(network, keyPair, !nowait);
            } else {
                TerminateKafkaBrokerCommand.printUsage();
            }
        }
    }

    private static final class StopKafkaBrokerCommand
    extends AbstractCommand {
        private StopKafkaBrokerCommand() {
        }

        private static final void printUsage() {
            System.out.println("");
            System.out.println("      'rumi cloud aws stop-kafka <args>' where args are:");
            System.out.println("          [{-p, --profile the AWS profile to use] (required)");
            System.out.println("          [{-r, --region the AWS region to use] (default=us-east-1)");
            System.out.println("          [{-n, --network the name of the network to stop it into] (required)");
            System.out.println("          [{-o, --no-wait whether to not wait for the instance to fully start] (default=false)");
            System.out.println("");
        }

        @Override
        final void help(String[] args) {
            StopKafkaBrokerCommand.printUsage();
        }

        @Override
        final void execute(String[] args) throws Exception {
            CmdLineParser parser = new CmdLineParser();
            CmdLineParser.Option profileOption = parser.addStringOption('p', "profile");
            CmdLineParser.Option regionOption = parser.addStringOption('r', "region");
            CmdLineParser.Option networkOption = parser.addStringOption('n', "network");
            CmdLineParser.Option nowaitOption = parser.addBooleanOption('o', "no-wait");
            parser.parse(args);
            String profile = (String)parser.getOptionValue(profileOption, null);
            String region = (String)parser.getOptionValue(regionOption, (Object)"us-east-1");
            String network = (String)parser.getOptionValue(networkOption, null);
            boolean nowait = (Boolean)parser.getOptionValue(nowaitOption, (Object)false);
            if (profile != null && network != null) {
                AwsProvisioner.create((String)profile, (String)region).stopKafkaBroker(network, !nowait);
            } else {
                StopKafkaBrokerCommand.printUsage();
            }
        }
    }

    private static final class StartKafkaBrokerCommand
    extends AbstractCommand {
        private StartKafkaBrokerCommand() {
        }

        private static final void printUsage() {
            System.out.println("");
            System.out.println("      'rumi cloud aws start-kafka <args>' where args are:");
            System.out.println("          [{-p, --profile the AWS profile to use] (required)");
            System.out.println("          [{-r, --region the AWS region to use] (default=us-east-1)");
            System.out.println("          [{-n, --network the name of the network to start it into] (required)");
            System.out.println("          [{-o, --no-wait whether to not wait for the instance to fully start] (default=false)");
            System.out.println("");
        }

        @Override
        final void help(String[] args) {
            StartKafkaBrokerCommand.printUsage();
        }

        @Override
        final void execute(String[] args) throws Exception {
            CmdLineParser parser = new CmdLineParser();
            CmdLineParser.Option profileOption = parser.addStringOption('p', "profile");
            CmdLineParser.Option regionOption = parser.addStringOption('r', "region");
            CmdLineParser.Option networkOption = parser.addStringOption('n', "network");
            CmdLineParser.Option nowaitOption = parser.addBooleanOption('o', "no-wait");
            parser.parse(args);
            String profile = (String)parser.getOptionValue(profileOption, null);
            String region = (String)parser.getOptionValue(regionOption, (Object)"us-east-1");
            String network = (String)parser.getOptionValue(networkOption, null);
            boolean nowait = (Boolean)parser.getOptionValue(nowaitOption, (Object)false);
            if (profile != null && network != null) {
                AwsProvisioner.create((String)profile, (String)region).startKafkaBroker(network, !nowait);
            } else {
                StartKafkaBrokerCommand.printUsage();
            }
        }
    }

    private static final class LaunchKafkaBrokerCommand
    extends AbstractCommand {
        private LaunchKafkaBrokerCommand() {
        }

        private static final void printUsage() {
            System.out.println("");
            System.out.println("      'rumi cloud aws launch-kafka <args>' where args are:");
            System.out.println("          [{-p, --profile the AWS profile to use] (required)");
            System.out.println("          [{-r, --region the AWS region to use] (default=us-east-1)");
            System.out.println("          [{-n, --network the name of the network to launch it into] (required)");
            System.out.println("          [{-y, --key-pair the network key pair] (required)");
            System.out.println("          [{-a, --proxy-server the broker proxy server] (default=null)");
            System.out.println("          [{-b, --proxy-port the broker proxy port] (default=0)");
            System.out.println("");
        }

        @Override
        final void help(String[] args) {
            LaunchKafkaBrokerCommand.printUsage();
        }

        @Override
        final void execute(String[] args) throws Exception {
            CmdLineParser parser = new CmdLineParser();
            CmdLineParser.Option profileOption = parser.addStringOption('p', "profile");
            CmdLineParser.Option regionOption = parser.addStringOption('r', "region");
            CmdLineParser.Option networkOption = parser.addStringOption('n', "network");
            CmdLineParser.Option keyPairOption = parser.addStringOption('k', "key-pair");
            CmdLineParser.Option proxyServerOption = parser.addStringOption('a', "proxy-server");
            CmdLineParser.Option proxyPortOption = parser.addIntegerOption('b', "proxy-port");
            parser.parse(args);
            String profile = (String)parser.getOptionValue(profileOption, null);
            String region = (String)parser.getOptionValue(regionOption, (Object)"us-east-1");
            String network = (String)parser.getOptionValue(networkOption, null);
            String keyPair = (String)parser.getOptionValue(keyPairOption, null);
            String proxyServer = (String)parser.getOptionValue(proxyServerOption, null);
            int proxyPort = (Integer)parser.getOptionValue(proxyPortOption, (Object)0);
            if (profile != null && network != null && keyPair != null) {
                AwsProvisioner.create((String)profile, (String)region).launchKafkaBroker(network, keyPair, (AwsProvisioner.PlatformServiceProxyInfo)(proxyServer != null || proxyPort > 0 ? new AwsProvisioner.PlatformServiceProxyInfo(proxyServer, proxyPort) : null));
            } else {
                LaunchKafkaBrokerCommand.printUsage();
            }
        }
    }

    private static final class TerminateSolaceBrokerCommand
    extends AbstractCommand {
        private TerminateSolaceBrokerCommand() {
        }

        private static final void printUsage() {
            System.out.println("");
            System.out.println("      'rumi cloud aws terminate-solace <args>' where args are:");
            System.out.println("          [{-p, --profile the AWS profile to use] (required)");
            System.out.println("          [{-r, --region the AWS region to use] (default=us-east-1)");
            System.out.println("          [{-n, --network the name of the network to terminate it into] (required)");
            System.out.println("          [{-y, --key-pair the network key pair] (required)");
            System.out.println("          [{-o, --no-wait whether to not wait for the instance to fully start] (default=false)");
            System.out.println("");
        }

        @Override
        final void help(String[] args) {
            TerminateSolaceBrokerCommand.printUsage();
        }

        @Override
        final void execute(String[] args) throws Exception {
            CmdLineParser parser = new CmdLineParser();
            CmdLineParser.Option profileOption = parser.addStringOption('p', "profile");
            CmdLineParser.Option regionOption = parser.addStringOption('r', "region");
            CmdLineParser.Option networkOption = parser.addStringOption('n', "network");
            CmdLineParser.Option keyPairOption = parser.addStringOption('k', "key-pair");
            CmdLineParser.Option nowaitOption = parser.addBooleanOption('o', "no-wait");
            parser.parse(args);
            String profile = (String)parser.getOptionValue(profileOption, null);
            String region = (String)parser.getOptionValue(regionOption, (Object)"us-east-1");
            String network = (String)parser.getOptionValue(networkOption, null);
            String keyPair = (String)parser.getOptionValue(keyPairOption, null);
            boolean nowait = (Boolean)parser.getOptionValue(nowaitOption, (Object)false);
            if (profile != null && network != null && keyPair != null) {
                AwsProvisioner.create((String)profile, (String)region).terminateSolaceBroker(network, keyPair, !nowait);
            } else {
                TerminateSolaceBrokerCommand.printUsage();
            }
        }
    }

    private static final class StopSolaceBrokerCommand
    extends AbstractCommand {
        private StopSolaceBrokerCommand() {
        }

        private static final void printUsage() {
            System.out.println("");
            System.out.println("      'rumi cloud aws stop-solace <args>' where args are:");
            System.out.println("          [{-p, --profile the AWS profile to use] (required)");
            System.out.println("          [{-r, --region the AWS region to use] (default=us-east-1)");
            System.out.println("          [{-n, --network the name of the network to stop it into] (required)");
            System.out.println("          [{-o, --no-wait whether to not wait for the instance to fully start] (default=false)");
            System.out.println("");
        }

        @Override
        final void help(String[] args) {
            StopSolaceBrokerCommand.printUsage();
        }

        @Override
        final void execute(String[] args) throws Exception {
            CmdLineParser parser = new CmdLineParser();
            CmdLineParser.Option profileOption = parser.addStringOption('p', "profile");
            CmdLineParser.Option regionOption = parser.addStringOption('r', "region");
            CmdLineParser.Option networkOption = parser.addStringOption('n', "network");
            CmdLineParser.Option nowaitOption = parser.addBooleanOption('o', "no-wait");
            parser.parse(args);
            String profile = (String)parser.getOptionValue(profileOption, null);
            String region = (String)parser.getOptionValue(regionOption, (Object)"us-east-1");
            String network = (String)parser.getOptionValue(networkOption, null);
            boolean nowait = (Boolean)parser.getOptionValue(nowaitOption, (Object)false);
            if (profile != null && network != null) {
                AwsProvisioner.create((String)profile, (String)region).stopSolaceBroker(network, !nowait);
            } else {
                StopSolaceBrokerCommand.printUsage();
            }
        }
    }

    private static final class StartSolaceBrokerCommand
    extends AbstractCommand {
        private StartSolaceBrokerCommand() {
        }

        private static final void printUsage() {
            System.out.println("");
            System.out.println("      'rumi cloud aws start-solace <args>' where args are:");
            System.out.println("          [{-p, --profile the AWS profile to use] (required)");
            System.out.println("          [{-r, --region the AWS region to use] (default=us-east-1)");
            System.out.println("          [{-n, --network the name of the network to start it into] (required)");
            System.out.println("          [{-o, --no-wait whether to not wait for the instance to fully start] (default=false)");
            System.out.println("");
        }

        @Override
        final void help(String[] args) {
            StartSolaceBrokerCommand.printUsage();
        }

        @Override
        final void execute(String[] args) throws Exception {
            CmdLineParser parser = new CmdLineParser();
            CmdLineParser.Option profileOption = parser.addStringOption('p', "profile");
            CmdLineParser.Option regionOption = parser.addStringOption('r', "region");
            CmdLineParser.Option networkOption = parser.addStringOption('n', "network");
            CmdLineParser.Option nowaitOption = parser.addBooleanOption('o', "no-wait");
            parser.parse(args);
            String profile = (String)parser.getOptionValue(profileOption, null);
            String region = (String)parser.getOptionValue(regionOption, (Object)"us-east-1");
            String network = (String)parser.getOptionValue(networkOption, null);
            boolean nowait = (Boolean)parser.getOptionValue(nowaitOption, (Object)false);
            if (profile != null && network != null) {
                AwsProvisioner.create((String)profile, (String)region).startSolaceBroker(network, !nowait);
            } else {
                StartSolaceBrokerCommand.printUsage();
            }
        }
    }

    private static final class LaunchSolaceBrokerCommand
    extends AbstractCommand {
        private LaunchSolaceBrokerCommand() {
        }

        private static final void printUsage() {
            System.out.println("");
            System.out.println("      'rumi cloud aws launch-solace <args>' where args are:");
            System.out.println("          [{-p, --profile the AWS profile to use] (required)");
            System.out.println("          [{-r, --region the AWS region to use] (default=us-east-1)");
            System.out.println("          [{-n, --network the name of the network to launch it into] (required)");
            System.out.println("          [{-y, --key-pair the network key pair] (required)");
            System.out.println("          [{-a, --proxy-server the broker proxy server] (default=null)");
            System.out.println("          [{-b, --proxy-port the broker proxy port] (default=0)");
            System.out.println("");
        }

        @Override
        final void help(String[] args) {
            LaunchSolaceBrokerCommand.printUsage();
        }

        @Override
        final void execute(String[] args) throws Exception {
            CmdLineParser parser = new CmdLineParser();
            CmdLineParser.Option profileOption = parser.addStringOption('p', "profile");
            CmdLineParser.Option regionOption = parser.addStringOption('r', "region");
            CmdLineParser.Option networkOption = parser.addStringOption('n', "network");
            CmdLineParser.Option keyPairOption = parser.addStringOption('k', "key-pair");
            CmdLineParser.Option proxyServerOption = parser.addStringOption('a', "proxy-server");
            CmdLineParser.Option proxyPortOption = parser.addIntegerOption('b', "proxy-port");
            parser.parse(args);
            String profile = (String)parser.getOptionValue(profileOption, null);
            String region = (String)parser.getOptionValue(regionOption, (Object)"us-east-1");
            String network = (String)parser.getOptionValue(networkOption, null);
            String keyPair = (String)parser.getOptionValue(keyPairOption, null);
            String proxyServer = (String)parser.getOptionValue(proxyServerOption, null);
            int proxyPort = (Integer)parser.getOptionValue(proxyPortOption, (Object)0);
            if (profile != null && network != null && keyPair != null) {
                AwsProvisioner.create((String)profile, (String)region).launchSolaceBroker(network, keyPair, (AwsProvisioner.PlatformServiceProxyInfo)(proxyServer != null || proxyPort > 0 ? new AwsProvisioner.PlatformServiceProxyInfo(proxyServer, proxyPort) : null));
            } else {
                LaunchSolaceBrokerCommand.printUsage();
            }
        }
    }

    private static final class TerminateMonitorServerCommand
    extends AbstractCommand {
        private TerminateMonitorServerCommand() {
        }

        private static final void printUsage() {
            System.out.println("");
            System.out.println("      'rumi cloud aws terminate-monitor <args>' where args are:");
            System.out.println("          [{-p, --profile the AWS profile to use] (required)");
            System.out.println("          [{-r, --region the AWS region to use] (default=us-east-1)");
            System.out.println("          [{-n, --network the name of the network to terminate it into] (required)");
            System.out.println("          [{-y, --key-pair the network key pair] (required)");
            System.out.println("          [{-w, --wait wait for the instance to fully terminate] (default=false)");
            System.out.println("");
        }

        @Override
        final void help(String[] args) {
            TerminateMonitorServerCommand.printUsage();
        }

        @Override
        final void execute(String[] args) throws Exception {
            CmdLineParser parser = new CmdLineParser();
            CmdLineParser.Option profileOption = parser.addStringOption('p', "profile");
            CmdLineParser.Option regionOption = parser.addStringOption('r', "region");
            CmdLineParser.Option networkOption = parser.addStringOption('n', "network");
            CmdLineParser.Option keyPairOption = parser.addStringOption('k', "key-pair");
            CmdLineParser.Option nowaitOption = parser.addBooleanOption('o', "no-wait");
            parser.parse(args);
            String profile = (String)parser.getOptionValue(profileOption, null);
            String region = (String)parser.getOptionValue(regionOption, (Object)"us-east-1");
            String network = (String)parser.getOptionValue(networkOption, null);
            String keyPair = (String)parser.getOptionValue(keyPairOption, null);
            boolean nowait = (Boolean)parser.getOptionValue(nowaitOption, (Object)false);
            if (profile != null && network != null && keyPair != null) {
                AwsProvisioner.create((String)profile, (String)region).terminateMonitorServer(network, keyPair, !nowait);
            } else {
                TerminateMonitorServerCommand.printUsage();
            }
        }
    }

    private static final class StopMonitorServerCommand
    extends AbstractCommand {
        private StopMonitorServerCommand() {
        }

        private static final void printUsage() {
            System.out.println("");
            System.out.println("      'rumi cloud aws stop-monitor <args>' where args are:");
            System.out.println("          [{-p, --profile the AWS profile to use] (required)");
            System.out.println("          [{-r, --region the AWS region to use] (default=us-east-1)");
            System.out.println("          [{-n, --network the name of the network to stop it into] (required)");
            System.out.println("          [{-o, --no-wait whether to not wait for the instance to fully start] (default=false)");
            System.out.println("");
        }

        @Override
        final void help(String[] args) {
            StopMonitorServerCommand.printUsage();
        }

        @Override
        final void execute(String[] args) throws Exception {
            CmdLineParser parser = new CmdLineParser();
            CmdLineParser.Option profileOption = parser.addStringOption('p', "profile");
            CmdLineParser.Option regionOption = parser.addStringOption('r', "region");
            CmdLineParser.Option networkOption = parser.addStringOption('n', "network");
            CmdLineParser.Option nowaitOption = parser.addBooleanOption('o', "no-wait");
            parser.parse(args);
            String profile = (String)parser.getOptionValue(profileOption, null);
            String region = (String)parser.getOptionValue(regionOption, (Object)"us-east-1");
            String network = (String)parser.getOptionValue(networkOption, null);
            boolean nowait = (Boolean)parser.getOptionValue(nowaitOption, (Object)false);
            if (profile != null && network != null) {
                AwsProvisioner.create((String)profile, (String)region).stopMonitorServer(network, !nowait);
            } else {
                StopMonitorServerCommand.printUsage();
            }
        }
    }

    private static final class StartMonitorServerCommand
    extends AbstractCommand {
        private StartMonitorServerCommand() {
        }

        private static final void printUsage() {
            System.out.println("");
            System.out.println("      'rumi cloud aws start-monitor <args>' where args are:");
            System.out.println("          [{-p, --profile the AWS profile to use] (required)");
            System.out.println("          [{-r, --region the AWS region to use] (default=us-east-1)");
            System.out.println("          [{-n, --network the name of the network to start it into] (required)");
            System.out.println("          [{-o, --no-wait whether to not wait for the instance to fully start] (default=false)");
            System.out.println("");
        }

        @Override
        final void help(String[] args) {
            StartMonitorServerCommand.printUsage();
        }

        @Override
        final void execute(String[] args) throws Exception {
            CmdLineParser parser = new CmdLineParser();
            CmdLineParser.Option profileOption = parser.addStringOption('p', "profile");
            CmdLineParser.Option regionOption = parser.addStringOption('r', "region");
            CmdLineParser.Option networkOption = parser.addStringOption('n', "network");
            CmdLineParser.Option nowaitOption = parser.addBooleanOption('o', "no-wait");
            parser.parse(args);
            String profile = (String)parser.getOptionValue(profileOption, null);
            String region = (String)parser.getOptionValue(regionOption, (Object)"us-east-1");
            String network = (String)parser.getOptionValue(networkOption, null);
            boolean nowait = (Boolean)parser.getOptionValue(nowaitOption, (Object)false);
            if (profile != null && network != null) {
                AwsProvisioner.create((String)profile, (String)region).startMonitorServer(network, !nowait);
            } else {
                StartMonitorServerCommand.printUsage();
            }
        }
    }

    private static final class LaunchMonitorServerCommand
    extends AbstractCommand {
        private LaunchMonitorServerCommand() {
        }

        private static final void printUsage() {
            System.out.println("");
            System.out.println("      'rumi cloud aws launch-monitor <args>' where args are:");
            System.out.println("          [{-p, --profile the AWS profile to use] (required)");
            System.out.println("          [{-r, --region the AWS region to use] (default=us-east-1)");
            System.out.println("          [{-n, --network the name of the network to launch it into] (required)");
            System.out.println("          [{-y, --key-pair the network key pair] (required)");
            System.out.println("          [{-a, --proxy-server the monitor proxy server] (default=null)");
            System.out.println("          [{-b, --proxy-port the monitor proxy port] (default=0)");
            System.out.println("");
        }

        @Override
        final void help(String[] args) {
            LaunchMonitorServerCommand.printUsage();
        }

        @Override
        final void execute(String[] args) throws Exception {
            CmdLineParser parser = new CmdLineParser();
            CmdLineParser.Option profileOption = parser.addStringOption('p', "profile");
            CmdLineParser.Option regionOption = parser.addStringOption('r', "region");
            CmdLineParser.Option networkOption = parser.addStringOption('n', "network");
            CmdLineParser.Option keyPairOption = parser.addStringOption('k', "key-pair");
            CmdLineParser.Option proxyServerOption = parser.addStringOption('a', "proxy-server");
            CmdLineParser.Option proxyPortOption = parser.addIntegerOption('b', "proxy-port");
            parser.parse(args);
            String profile = (String)parser.getOptionValue(profileOption, null);
            String region = (String)parser.getOptionValue(regionOption, (Object)"us-east-1");
            String network = (String)parser.getOptionValue(networkOption, null);
            String keyPair = (String)parser.getOptionValue(keyPairOption, null);
            String proxyServer = (String)parser.getOptionValue(proxyServerOption, null);
            int proxyPort = (Integer)parser.getOptionValue(proxyPortOption, (Object)0);
            if (profile != null && network != null && keyPair != null) {
                AwsProvisioner.create((String)profile, (String)region).launchMonitorServer(network, keyPair, (AwsProvisioner.PlatformServiceProxyInfo)(proxyServer != null || proxyPort > 0 ? new AwsProvisioner.PlatformServiceProxyInfo(proxyServer, proxyPort) : null));
            } else {
                LaunchMonitorServerCommand.printUsage();
            }
        }
    }

    private static final class TerminateAdminServerCommand
    extends AbstractCommand {
        private TerminateAdminServerCommand() {
        }

        private static final void printUsage() {
            System.out.println("");
            System.out.println("      'rumi cloud aws terminate-admin <args>' where args are:");
            System.out.println("          [{-p, --profile the AWS profile to use] (required)");
            System.out.println("          [{-r, --region the AWS region to use] (default=us-east-1)");
            System.out.println("          [{-n, --network the name of the network to terminate it into] (required)");
            System.out.println("          [{-y, --key-pair the network key pair] (required)");
            System.out.println("          [{-o, --no-wait whether to not wait for the instance to fully start] (default=false)");
            System.out.println("");
        }

        @Override
        final void help(String[] args) {
            TerminateAdminServerCommand.printUsage();
        }

        @Override
        final void execute(String[] args) throws Exception {
            CmdLineParser parser = new CmdLineParser();
            CmdLineParser.Option profileOption = parser.addStringOption('p', "profile");
            CmdLineParser.Option regionOption = parser.addStringOption('r', "region");
            CmdLineParser.Option networkOption = parser.addStringOption('n', "network");
            CmdLineParser.Option keyPairOption = parser.addStringOption('k', "key-pair");
            CmdLineParser.Option nowaitOption = parser.addBooleanOption('o', "no-wait");
            parser.parse(args);
            String profile = (String)parser.getOptionValue(profileOption, null);
            String region = (String)parser.getOptionValue(regionOption, (Object)"us-east-1");
            String network = (String)parser.getOptionValue(networkOption, null);
            String keyPair = (String)parser.getOptionValue(keyPairOption, null);
            boolean nowait = (Boolean)parser.getOptionValue(nowaitOption, (Object)false);
            if (profile != null && network != null && keyPair != null) {
                AwsProvisioner.create((String)profile, (String)region).terminateAdminServer(network, keyPair, !nowait);
            } else {
                TerminateAdminServerCommand.printUsage();
            }
        }
    }

    private static final class StopAdminServerCommand
    extends AbstractCommand {
        private StopAdminServerCommand() {
        }

        private static final void printUsage() {
            System.out.println("");
            System.out.println("      'rumi cloud aws stop-admin <args>' where args are:");
            System.out.println("          [{-p, --profile the AWS profile to use] (required)");
            System.out.println("          [{-r, --region the AWS region to use] (default=us-east-1)");
            System.out.println("          [{-n, --network the name of the network to stop it into] (required)");
            System.out.println("          [{-o, --no-wait whether to not wait for the instance to fully start] (default=false)");
            System.out.println("");
        }

        @Override
        final void help(String[] args) {
            StopAdminServerCommand.printUsage();
        }

        @Override
        final void execute(String[] args) throws Exception {
            CmdLineParser parser = new CmdLineParser();
            CmdLineParser.Option profileOption = parser.addStringOption('p', "profile");
            CmdLineParser.Option regionOption = parser.addStringOption('r', "region");
            CmdLineParser.Option networkOption = parser.addStringOption('n', "network");
            CmdLineParser.Option nowaitOption = parser.addBooleanOption('o', "no-wait");
            parser.parse(args);
            String profile = (String)parser.getOptionValue(profileOption, null);
            String region = (String)parser.getOptionValue(regionOption, (Object)"us-east-1");
            String network = (String)parser.getOptionValue(networkOption, null);
            boolean nowait = (Boolean)parser.getOptionValue(nowaitOption, (Object)false);
            if (profile != null && network != null) {
                AwsProvisioner.create((String)profile, (String)region).stopAdminServer(network, !nowait);
            } else {
                StopAdminServerCommand.printUsage();
            }
        }
    }

    private static final class StartAdminServerCommand
    extends AbstractCommand {
        private StartAdminServerCommand() {
        }

        private static final void printUsage() {
            System.out.println("");
            System.out.println("      'rumi cloud aws start-admin <args>' where args are:");
            System.out.println("          [{-p, --profile the AWS profile to use] (required)");
            System.out.println("          [{-r, --region the AWS region to use] (default=us-east-1)");
            System.out.println("          [{-n, --network the name of the network to start it into] (required)");
            System.out.println("          [{-o, --no-wait whether to not wait for the instance to fully start] (default=false)");
            System.out.println("");
        }

        @Override
        final void help(String[] args) {
            StartAdminServerCommand.printUsage();
        }

        @Override
        final void execute(String[] args) throws Exception {
            CmdLineParser parser = new CmdLineParser();
            CmdLineParser.Option profileOption = parser.addStringOption('p', "profile");
            CmdLineParser.Option regionOption = parser.addStringOption('r', "region");
            CmdLineParser.Option networkOption = parser.addStringOption('n', "network");
            CmdLineParser.Option nowaitOption = parser.addBooleanOption('o', "no-wait");
            parser.parse(args);
            String profile = (String)parser.getOptionValue(profileOption, null);
            String region = (String)parser.getOptionValue(regionOption, (Object)"us-east-1");
            String network = (String)parser.getOptionValue(networkOption, null);
            boolean nowait = (Boolean)parser.getOptionValue(nowaitOption, (Object)false);
            if (profile != null && network != null) {
                AwsProvisioner.create((String)profile, (String)region).startAdminServer(network, !nowait);
            } else {
                StartAdminServerCommand.printUsage();
            }
        }
    }

    private static final class RunAdminScriptCommand
    extends AbstractCommand {
        private RunAdminScriptCommand() {
        }

        private static final void printUsage() {
            System.out.println("");
            System.out.println("      'rumi cloud aws run-admin-script <args>' where args are:");
            System.out.println("          [{-p, --profile the AWS profile to use] (required)");
            System.out.println("          [{-r, --region the AWS region to use] (default=us-east-1)");
            System.out.println("          [{-n, --network the name of the network containing the instance of which to run the command] (required)");
            System.out.println("          [{-y, --key-pair the network key pair] (required)");
            System.out.println("          [{-s, --system the name of the system whose script to run] (required)");
            System.out.println("          [{-i, --script the script to run] (required)");
            System.out.println("          [{-a, --params the script params in key1=val1,key2=val2,...,keyN=valN formay] (default=null)");
            System.out.println("");
        }

        @Override
        final void help(String[] args) {
            RunAdminScriptCommand.printUsage();
        }

        @Override
        final void execute(String[] args) throws Exception {
            CmdLineParser parser = new CmdLineParser();
            CmdLineParser.Option profileOption = parser.addStringOption('p', "profile");
            CmdLineParser.Option regionOption = parser.addStringOption('r', "region");
            CmdLineParser.Option networkOption = parser.addStringOption('n', "network");
            CmdLineParser.Option keyPairOption = parser.addStringOption('k', "key-pair");
            CmdLineParser.Option systemOption = parser.addStringOption('s', "system");
            CmdLineParser.Option scriptOption = parser.addStringOption('i', "script");
            CmdLineParser.Option paramsOption = parser.addStringOption('a', "params");
            parser.parse(args);
            String profile = (String)parser.getOptionValue(profileOption, null);
            String region = (String)parser.getOptionValue(regionOption, (Object)"us-east-1");
            String network = (String)parser.getOptionValue(networkOption, null);
            String keyPair = (String)parser.getOptionValue(keyPairOption, null);
            String system = (String)parser.getOptionValue(systemOption, null);
            String script = (String)parser.getOptionValue(scriptOption, null);
            String params = (String)parser.getOptionValue(paramsOption, null);
            if (profile != null && network != null && keyPair != null && system != null && script != null) {
                AwsProvisioner.create((String)profile, (String)region).runAdminScript(network, keyPair, system, script, params);
            } else {
                RunAdminScriptCommand.printUsage();
            }
        }
    }

    private static final class LaunchAdminServerCommand
    extends AbstractCommand {
        private LaunchAdminServerCommand() {
        }

        private static final void printUsage() {
            System.out.println("");
            System.out.println("      'rumi cloud aws launch-admin <args>' where args are:");
            System.out.println("          [{-p, --profile the AWS profile to use] (required)");
            System.out.println("          [{-r, --region the AWS region to use] (default=us-east-1)");
            System.out.println("          [{-n, --network the name of the network to launch it into] (required)");
            System.out.println("          [{-y, --key-pair the network key pair] (required)");
            System.out.println("          [{-a, --admin-proxy-server the admin proxy server] (default=null)");
            System.out.println("          [{-b, --admin-proxy-port the admin proxy port] (default=0)");
            System.out.println("          [{-c, --discovery-proxy-server the discovery proxy server] (default=null)");
            System.out.println("          [{-d, --discovery-proxy-port the discovery proxy port] (default=0)");
            System.out.println("");
        }

        @Override
        final void help(String[] args) {
            LaunchAdminServerCommand.printUsage();
        }

        @Override
        final void execute(String[] args) throws Exception {
            CmdLineParser parser = new CmdLineParser();
            CmdLineParser.Option profileOption = parser.addStringOption('p', "profile");
            CmdLineParser.Option regionOption = parser.addStringOption('r', "region");
            CmdLineParser.Option networkOption = parser.addStringOption('n', "network");
            CmdLineParser.Option keyPairOption = parser.addStringOption('k', "key-pair");
            CmdLineParser.Option adminProxyServerOption = parser.addStringOption('a', "admin-proxy-server");
            CmdLineParser.Option adminProxyPortOption = parser.addIntegerOption('b', "admin-proxy-port");
            CmdLineParser.Option discoveryProxyServerOption = parser.addStringOption('c', "discovery-proxy-server");
            CmdLineParser.Option discoveryProxyPortOption = parser.addIntegerOption('d', "discovery-proxy-port");
            parser.parse(args);
            String profile = (String)parser.getOptionValue(profileOption, null);
            String region = (String)parser.getOptionValue(regionOption, (Object)"us-east-1");
            String network = (String)parser.getOptionValue(networkOption, null);
            String keyPair = (String)parser.getOptionValue(keyPairOption, null);
            String adminProxyServer = (String)parser.getOptionValue(adminProxyServerOption, null);
            int adminProxyPort = (Integer)parser.getOptionValue(adminProxyPortOption, (Object)0);
            String discoveryProxyServer = (String)parser.getOptionValue(discoveryProxyServerOption, null);
            int discoveryProxyPort = (Integer)parser.getOptionValue(discoveryProxyPortOption, (Object)0);
            if (profile != null && network != null && keyPair != null) {
                AwsProvisioner.create((String)profile, (String)region).launchAdminServer(network, keyPair, (AwsProvisioner.PlatformServiceProxyInfo)(adminProxyServer != null || adminProxyPort > 0 ? new AwsProvisioner.PlatformServiceProxyInfo(adminProxyServer, adminProxyPort) : null), (AwsProvisioner.PlatformServiceProxyInfo)(discoveryProxyServer != null || discoveryProxyPort > 0 ? new AwsProvisioner.PlatformServiceProxyInfo(discoveryProxyServer, discoveryProxyPort) : null));
            } else {
                LaunchAdminServerCommand.printUsage();
            }
        }
    }

    private static final class TerminateJumpServerCommand
    extends AbstractCommand {
        private TerminateJumpServerCommand() {
        }

        private static final void printUsage() {
            System.out.println("");
            System.out.println("      'rumi cloud aws terminate-jump <args>' where args are:");
            System.out.println("          [{-p, --profile the AWS profile to use] (required)");
            System.out.println("          [{-r, --region the AWS region to use] (default=us-east-1)");
            System.out.println("          [{-n, --network the name of the network to terminate it into] (required)");
            System.out.println("          [{-y, --key-pair the network key pair] (required)");
            System.out.println("          [{-o, --no-wait whether to not wait for the instance to fully start] (default=false)");
            System.out.println("");
        }

        @Override
        final void help(String[] args) {
            TerminateJumpServerCommand.printUsage();
        }

        @Override
        final void execute(String[] args) throws Exception {
            CmdLineParser parser = new CmdLineParser();
            CmdLineParser.Option profileOption = parser.addStringOption('p', "profile");
            CmdLineParser.Option regionOption = parser.addStringOption('r', "region");
            CmdLineParser.Option networkOption = parser.addStringOption('n', "network");
            CmdLineParser.Option keyPairOption = parser.addStringOption('k', "key-pair");
            CmdLineParser.Option nowaitOption = parser.addBooleanOption('o', "no-wait");
            parser.parse(args);
            String profile = (String)parser.getOptionValue(profileOption, null);
            String region = (String)parser.getOptionValue(regionOption, (Object)"us-east-1");
            String network = (String)parser.getOptionValue(networkOption, null);
            String keyPair = (String)parser.getOptionValue(keyPairOption, null);
            boolean nowait = (Boolean)parser.getOptionValue(nowaitOption, (Object)false);
            if (profile != null && network != null && keyPair != null) {
                AwsProvisioner.create((String)profile, (String)region).terminateJumpServer(network, keyPair, !nowait);
            } else {
                TerminateJumpServerCommand.printUsage();
            }
        }
    }

    private static final class StopJumpServerCommand
    extends AbstractCommand {
        private StopJumpServerCommand() {
        }

        private static final void printUsage() {
            System.out.println("");
            System.out.println("      'rumi cloud aws stop-jump <args>' where args are:");
            System.out.println("          [{-p, --profile the AWS profile to use] (required)");
            System.out.println("          [{-r, --region the AWS region to use] (default=us-east-1)");
            System.out.println("          [{-n, --network the name of the network to stop it into] (required)");
            System.out.println("          [{-o, --no-wait whether to not wait for the instance to fully start] (default=false)");
            System.out.println("");
        }

        @Override
        final void help(String[] args) {
            StopJumpServerCommand.printUsage();
        }

        @Override
        final void execute(String[] args) throws Exception {
            CmdLineParser parser = new CmdLineParser();
            CmdLineParser.Option profileOption = parser.addStringOption('p', "profile");
            CmdLineParser.Option regionOption = parser.addStringOption('r', "region");
            CmdLineParser.Option networkOption = parser.addStringOption('n', "network");
            CmdLineParser.Option nowaitOption = parser.addBooleanOption('o', "no-wait");
            parser.parse(args);
            String profile = (String)parser.getOptionValue(profileOption, null);
            String region = (String)parser.getOptionValue(regionOption, (Object)"us-east-1");
            String network = (String)parser.getOptionValue(networkOption, null);
            boolean nowait = (Boolean)parser.getOptionValue(nowaitOption, (Object)false);
            if (profile != null && network != null) {
                AwsProvisioner.create((String)profile, (String)region).stopJumpServer(network, !nowait);
            } else {
                StopJumpServerCommand.printUsage();
            }
        }
    }

    private static final class StartJumpServerCommand
    extends AbstractCommand {
        private StartJumpServerCommand() {
        }

        private static final void printUsage() {
            System.out.println("");
            System.out.println("      'rumi cloud aws start-jump <args>' where args are:");
            System.out.println("          [{-p, --profile the AWS profile to use] (required)");
            System.out.println("          [{-r, --region the AWS region to use] (default=us-east-1)");
            System.out.println("          [{-n, --network the name of the network to start it into] (required)");
            System.out.println("          [{-o, --no-wait whether to not wait for the instance to fully start] (default=false)");
            System.out.println("");
        }

        @Override
        final void help(String[] args) {
            StartJumpServerCommand.printUsage();
        }

        @Override
        final void execute(String[] args) throws Exception {
            CmdLineParser parser = new CmdLineParser();
            CmdLineParser.Option profileOption = parser.addStringOption('p', "profile");
            CmdLineParser.Option regionOption = parser.addStringOption('r', "region");
            CmdLineParser.Option networkOption = parser.addStringOption('n', "network");
            CmdLineParser.Option nowaitOption = parser.addBooleanOption('o', "no-wait");
            parser.parse(args);
            String profile = (String)parser.getOptionValue(profileOption, null);
            String region = (String)parser.getOptionValue(regionOption, (Object)"us-east-1");
            String network = (String)parser.getOptionValue(networkOption, null);
            boolean nowait = (Boolean)parser.getOptionValue(nowaitOption, (Object)false);
            if (profile != null && network != null) {
                AwsProvisioner.create((String)profile, (String)region).startJumpServer(network, !nowait);
            } else {
                StartJumpServerCommand.printUsage();
            }
        }
    }

    private static final class LaunchJumpServerCommand
    extends AbstractCommand {
        private LaunchJumpServerCommand() {
        }

        private static final void printUsage() {
            System.out.println("");
            System.out.println("      'rumi cloud aws launch-jump <args>' where args are:");
            System.out.println("          [{-p, --profile the AWS profile to use] (required)");
            System.out.println("          [{-r, --region the AWS region to use] (default=us-east-1)");
            System.out.println("          [{-n, --network the name of the network to launch it into] (required)");
            System.out.println("          [{-y, --key-pair the network key pair] (required)");
            System.out.println("");
        }

        @Override
        final void help(String[] args) {
            LaunchJumpServerCommand.printUsage();
        }

        @Override
        final void execute(String[] args) throws Exception {
            CmdLineParser parser = new CmdLineParser();
            CmdLineParser.Option profileOption = parser.addStringOption('p', "profile");
            CmdLineParser.Option regionOption = parser.addStringOption('r', "region");
            CmdLineParser.Option networkOption = parser.addStringOption('n', "network");
            CmdLineParser.Option keyPairOption = parser.addStringOption('k', "key-pair");
            parser.parse(args);
            String profile = (String)parser.getOptionValue(profileOption, null);
            String region = (String)parser.getOptionValue(regionOption, (Object)"us-east-1");
            String network = (String)parser.getOptionValue(networkOption, null);
            String keyPair = (String)parser.getOptionValue(keyPairOption, null);
            if (profile != null && network != null && keyPair != null) {
                AwsProvisioner.create((String)profile, (String)region).launchJumpServer(network, keyPair);
            } else {
                LaunchJumpServerCommand.printUsage();
            }
        }
    }

    private static final class ListZonesCommand
    extends AbstractCommand {
        private ListZonesCommand() {
        }

        private static final void printUsage() {
            System.out.println("");
            System.out.println("      'rumi cloud aws create-zone <args>' where args are:");
            System.out.println("          [{-p, --profile the AWS profile to use] (required)");
            System.out.println("          [{-r, --region the AWS region to use] (default=us-east-1)");
            System.out.println("          [{-n, --network the name of the network (VPC)] (required)");
            System.out.println("");
        }

        @Override
        final void help(String[] args) {
            ListZonesCommand.printUsage();
        }

        @Override
        final void execute(String[] args) throws Exception {
            CmdLineParser parser = new CmdLineParser();
            CmdLineParser.Option profileOption = parser.addStringOption('p', "profile");
            CmdLineParser.Option regionOption = parser.addStringOption('r', "region");
            CmdLineParser.Option networkOption = parser.addStringOption('n', "network");
            parser.parse(args);
            String profile = (String)parser.getOptionValue(profileOption, null);
            String region = (String)parser.getOptionValue(regionOption, (Object)"us-east-1");
            String network = (String)parser.getOptionValue(networkOption, null);
            if (profile != null && network != null) {
                List zones = AwsProvisioner.create((String)profile, (String)region).getHostedZones(network);
                System.out.println("");
                System.out.println("Provisioned Zones");
                System.out.println("-----------------");
                if (zones.size() > 0) {
                    Iterator iterator = zones.iterator();
                    while (iterator.hasNext()) {
                        System.out.println("  " + (String)iterator.next());
                    }
                } else {
                    System.out.println("  <none>");
                }
                System.out.println("");
            } else {
                ListZonesCommand.printUsage();
            }
        }
    }

    private static final class CreateZoneCommand
    extends AbstractCommand {
        private CreateZoneCommand() {
        }

        private static final void printUsage() {
            System.out.println("");
            System.out.println("      'rumi cloud aws create-zone <args>' where args are:");
            System.out.println("          [{-p, --profile the AWS profile to use] (required)");
            System.out.println("          [{-r, --region the AWS region to use] (default=us-east-1)");
            System.out.println("          [{-n, --network the name of the network (VPC)] (required)");
            System.out.println("          [{-z, --zone the zone to create and associate with the network (required)");
            System.out.println("");
        }

        @Override
        final void help(String[] args) {
            CreateZoneCommand.printUsage();
        }

        @Override
        final void execute(String[] args) throws Exception {
            CmdLineParser parser = new CmdLineParser();
            CmdLineParser.Option profileOption = parser.addStringOption('p', "profile");
            CmdLineParser.Option regionOption = parser.addStringOption('r', "region");
            CmdLineParser.Option networkOption = parser.addStringOption('n', "network");
            CmdLineParser.Option zoneOption = parser.addStringOption('z', "zone");
            parser.parse(args);
            String profile = (String)parser.getOptionValue(profileOption, null);
            String region = (String)parser.getOptionValue(regionOption, (Object)"us-east-1");
            String network = (String)parser.getOptionValue(networkOption, null);
            String zone = (String)parser.getOptionValue(zoneOption, null);
            if (profile != null && network != null && zone != null) {
                AwsProvisioner.create((String)profile, (String)region).createHostedZone(network, zone);
            } else {
                CreateZoneCommand.printUsage();
            }
        }
    }

    private static final class CreateNetworkCommand
    extends AbstractCommand {
        private CreateNetworkCommand() {
        }

        private static final void printUsage() {
            System.out.println("");
            System.out.println("      'rumi cloud aws create-network <args>' where args are:");
            System.out.println("          [{-p, --profile the AWS profile to use] (required)");
            System.out.println("          [{-r, --region the AWS region to use] (default=us-east-1)");
            System.out.println("          [{-n, --name the name of the network (VPC)] (required)");
            System.out.println("          [{-a, --addr the network address in the form of x.y] (default=10.0)");
            System.out.println("          [{-o, --firewall-ports the comma separated set of ports to open in this network's firewall] (default=null)");
            System.out.println("");
        }

        @Override
        final void help(String[] args) {
            CreateNetworkCommand.printUsage();
        }

        @Override
        final void execute(String[] args) throws Exception {
            CmdLineParser parser = new CmdLineParser();
            CmdLineParser.Option profileOption = parser.addStringOption('p', "profile");
            CmdLineParser.Option regionOption = parser.addStringOption('r', "region");
            CmdLineParser.Option nameOption = parser.addStringOption('n', "name");
            CmdLineParser.Option addrOption = parser.addStringOption('a', "addr");
            CmdLineParser.Option firewallPortsOption = parser.addStringOption('o', "firewall-ports");
            parser.parse(args);
            String profile = (String)parser.getOptionValue(profileOption, null);
            String region = (String)parser.getOptionValue(regionOption, (Object)"us-east-1");
            String name = (String)parser.getOptionValue(nameOption, null);
            String addr = (String)parser.getOptionValue(addrOption, (Object)"10.0");
            String commaSeparatedFirewallPorts = (String)parser.getOptionValue(firewallPortsOption, null);
            if (profile != null && name != null) {
                if (commaSeparatedFirewallPorts != null && !commaSeparatedFirewallPorts.trim().isEmpty()) {
                    AwsProvisioner.create((String)profile, (String)region).createNetwork(name, addr, Arrays.stream(commaSeparatedFirewallPorts.split(",")).map(String::trim).map(Integer::parseInt).collect(Collectors.toList()));
                } else {
                    AwsProvisioner.create((String)profile, (String)region).createNetwork(name, addr);
                }
            } else {
                CreateNetworkCommand.printUsage();
            }
        }
    }
}

