/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.rog.log;

import com.eaio.uuid.UUID;
import com.neeve.lang.XIterator;
import com.neeve.lang.XLinkedHashMap;
import com.neeve.lang.XLinkedList;
import com.neeve.rog.IRogChangeDataCaptureHandler;
import com.neeve.rog.IRogNode;
import com.neeve.rog.RogObject;
import com.neeve.rog.log.RogLog;
import com.neeve.rog.log.RogLogCheckpointReaderParams;
import com.neeve.rog.log.RogLogCompactionReader;
import com.neeve.rog.log.RogLogMetadata;
import com.neeve.trace.Tracer;
import com.neeve.util.UtlProps;
import com.neeve.util.UtlThrowable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public final class RogLogCdcProcessor
extends RogObject {
    private final RogLog log;
    private final RogLogCompactionReader reader;
    private final IRogChangeDataCaptureHandler handler;
    private static final Tracer tracer = Tracer.get((String)"nv.rog.cdc");
    private volatile boolean closed = false;
    public static final String PROP_ENTRY_RETENTION_THRESHOLD = "cdc.entryRetentionThreshold";
    public static final String PROP_CONFLATE_CHECKPOINTS = "cdc.conflateCheckpoints";
    public static final String PROP_SKIP_CDC_CHECKPOINTED = "cdc.skipCdcCheckpointed";
    public static final String PROP_OFF_HEAP_BUFFERING = "cdc.offheapBuffering";
    public static final String PROP_OFF_HEAP_BUFFERING_LOAD_STRATEGY = "cdc.offheapBufferingLoadStrategy";
    public static final String PROP_MEM_MAPPED_READ_BUFFER_LOAD = "cdc.memMappedReadBufferLoad";
    public static final String PROP_MEM_MAPPED_READ_BUFFER_MAX_SIZE = "cdc.memMappedReadBufferMaxSize";

    RogLogCdcProcessor(RogLog log, IRogChangeDataCaptureHandler handler, Params props) throws Exception {
        if (log == null) {
            throw new IllegalArgumentException("log cannot be null");
        }
        if (handler == null) {
            throw new IllegalArgumentException("handler cannot be null");
        }
        if (!log.isOpen()) {
            throw new IllegalStateException("log is not open");
        }
        this.log = log;
        this.handler = handler;
        this.reader = RogLogCompactionReader.create(log, new CompactionReadHandler(), tracer, props);
    }

    private final IRogChangeDataCaptureHandler.LogCompletionReason compactionReaderToCdcProcessorCompletionReason(RogLogCompactionReader.RunCompletionReason readerCompletionReason) {
        switch (readerCompletionReason) {
            case LogNotCheckpointed: {
                return IRogChangeDataCaptureHandler.LogCompletionReason.LogNotCheckpointed;
            }
            case EndOfFile: {
                return IRogChangeDataCaptureHandler.LogCompletionReason.MovedOntoNextLog;
            }
            case Closed: {
                return IRogChangeDataCaptureHandler.LogCompletionReason.Closed;
            }
        }
        throw new IllegalArgumentException("unknown reader completion reason [" + (Object)((Object)readerCompletionReason) + "]");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void run() throws Exception {
        block19: {
            tracer.log("[CDC Processor] Starting run...", Tracer.Level.INFO);
            try {
                RogLogMetadata metadata = this.log.getMetadata();
                if (metadata.isCdcEnabled()) {
                    boolean done = false;
                    while (!this.closed && !done) {
                        if (!metadata.getIsBackup()) {
                            int logNumber = this.log.skipCdcOverMissing();
                            tracer.log("[CDC Processor] Processing log #" + logNumber + "...", Tracer.Level.INFO);
                            try {
                                this.handler.onLogStart(logNumber);
                                RogLogCompactionReader.RunCompletionReason completionReason = this.reader.run(logNumber, Long.MAX_VALUE);
                                switch (completionReason) {
                                    case LogNotCheckpointed: {
                                        tracer.log("[CDC Processor] Log is not checkpointed.", Tracer.Level.INFO);
                                        done = true;
                                        break;
                                    }
                                    case EndOfFile: {
                                        this.reader.releaseReaderFiles();
                                        metadata.setCdcLogNumber(logNumber + 1);
                                        this.log.skipCdcOverMissing();
                                        break;
                                    }
                                    case MaxFilePointerReached: {
                                        throw new InternalError("** Reached max file position during compaction run for CDC!! **");
                                    }
                                    case Closed: {
                                        break;
                                    }
                                    default: {
                                        throw new IllegalStateException("Received unknown error from compaction reader [" + (Object)((Object)completionReason) + "]");
                                    }
                                }
                                this.handler.onLogComplete(logNumber, this.compactionReaderToCdcProcessorCompletionReason(completionReason), null);
                                tracer.log("[CDC Processor] Log #" + logNumber + " complete.", Tracer.Level.INFO);
                            }
                            catch (Throwable e) {
                                StringBuilder sb = new StringBuilder();
                                if (e instanceof InterruptedException) {
                                    sb.append("CDC processing of log #").append(logNumber).append(" was interrupted").append("\n");
                                } else {
                                    sb.append("CDC processing encountered an error while processing log #").append(logNumber).append(" [").append(e.toString()).append("].").append("\n");
                                    sb.append("Stack Trace:").append("\n");
                                    sb.append(UtlThrowable.prepareStackTrace((Throwable)e));
                                }
                                tracer.log(sb.toString(), Tracer.Level.SEVERE);
                                try {
                                    this.handler.onLogComplete(logNumber, IRogChangeDataCaptureHandler.LogCompletionReason.Error, e);
                                }
                                catch (Throwable throwable) {
                                    // empty catch block
                                }
                                done = true;
                            }
                            continue;
                        }
                        if (RogLogCdcProcessor.tracer.debug) {
                            tracer.log("[CDC Processor] Role is backup. Sleeping...", Tracer.Level.DEBUG);
                        }
                        Thread.sleep(100L);
                    }
                    break block19;
                }
                tracer.log("[CDC Processor] Log is not enabled for CDC.", Tracer.Level.INFO);
            }
            finally {
                tracer.log("[CDC Processor] Exiting run...", Tracer.Level.INFO);
            }
        }
    }

    public final void close() {
        this.closed = true;
        this.reader.close();
    }

    public static final class Params
    extends RogLogCheckpointReaderParams {
        private Params(Properties props) {
            super(props);
        }

        public static final Params create(Properties props) {
            String prefix = "cdc.";
            Properties cdcProps = new Properties();
            cdcProps.putAll((Map<?, ?>)RogLogCheckpointReaderParams.defaultProps);
            for (Map.Entry<Object, Object> prop : props.entrySet()) {
                String key = String.valueOf(prop.getKey());
                if (!key.startsWith("cdc.")) continue;
                cdcProps.put(key.substring("cdc.".length()), prop.getValue());
            }
            if (UtlProps.getValue((Properties)cdcProps, (String)"conflateCheckpoints", (boolean)false)) {
                tracer.log("[CDC Processor] configured value of true for 'conflateCheckpoints is not currently supported, setting to false", Tracer.Level.WARNING);
                cdcProps.put("conflateCheckpoints", "false");
            }
            return new Params(cdcProps);
        }

        void dump(String prefix, StringBuilder sb) {
            sb.append(prefix).append("cdc {\n");
            sb.append(prefix).append("...reader{\n");
            super.dump(sb, prefix + "......");
            sb.append(prefix).append("...}\n");
            sb.append(prefix).append("}\n");
        }
    }

    private final class CompactionReadHandler
    implements RogLogCompactionReader.ReadHandler {
        private final XLinkedList<IRogNode> objects = new XLinkedList();
        private boolean processCheckpoint;

        private CompactionReadHandler() {
        }

        private final XLinkedList<IRogNode> entriesToObjects(List<RogLogCompactionReader.CompactionReaderEntry> entries) {
            this.objects.clear();
            for (RogLogCompactionReader.CompactionReaderEntry entry : entries) {
                IRogNode object = (IRogNode)entry.getObject();
                this.objects.add((Object)object);
            }
            return this.objects;
        }

        private final void disposeObjects(XLinkedList<IRogNode> objects) {
            XIterator iterator = objects.reusableIterator();
            while (iterator.hasNext()) {
                IRogNode object = (IRogNode)iterator.next();
                if (object == null) continue;
                object.dispose();
            }
        }

        private final void disposeEntries(List<RogLogCompactionReader.CompactionReaderEntry> objects) {
            Iterator<RogLogCompactionReader.CompactionReaderEntry> iterator = objects.iterator();
            while (iterator.hasNext()) {
                iterator.next().dispose();
            }
        }

        private final IRogChangeDataCaptureHandler.ChangeType toCDCChangeType(RogLogCompactionReader.ReadHandler.ChangeType changeType) {
            switch (changeType) {
                case Put: {
                    return IRogChangeDataCaptureHandler.ChangeType.Put;
                }
                case Update: {
                    return IRogChangeDataCaptureHandler.ChangeType.Update;
                }
                case Remove: {
                    return IRogChangeDataCaptureHandler.ChangeType.Remove;
                }
                case Send: {
                    return IRogChangeDataCaptureHandler.ChangeType.Send;
                }
                case Noop: {
                    return IRogChangeDataCaptureHandler.ChangeType.Noop;
                }
            }
            throw new IllegalArgumentException("unknown change type '" + (Object)((Object)changeType) + "'");
        }

        @Override
        public final boolean onCheckpointStart(long checkpointVersion) {
            RogLogMetadata metadata;
            if (tracer.debug) {
                tracer.log("[CDC Processor] Checkpoint #" + checkpointVersion + " is stable...", Tracer.Level.DEBUG);
            }
            if (this.processCheckpoint = (metadata = RogLogCdcProcessor.this.log.getMetadata()).getCdcCheckpointVersion() == 0L || checkpointVersion >= metadata.getCdcCheckpointVersion()) {
                if (tracer.debug) {
                    tracer.log("[CDC Processor] Stable checkpoint is CDC checkpoint.", Tracer.Level.DEBUG);
                }
                RogLogCdcProcessor.this.handler.onCheckpointStart(checkpointVersion);
                return false;
            }
            if (tracer.debug) {
                tracer.log("[CDC Processor] Stable checkpoint is NOT CDC checkpoint (stable=" + checkpointVersion + ", CDC=" + metadata.getCdcCheckpointVersion() + ").", Tracer.Level.DEBUG);
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        @Override
        public final void handleChange(RogLogCompactionReader.ReadHandler.ChangeType changeType, List<RogLogCompactionReader.CompactionReaderEntry> entries) {
            if (RogLogCdcProcessor.access$000().debug) {
                RogLogCdcProcessor.access$000().log("[CDC Processor] Received change (type='" + (Object)changeType + "', entries=" + entries.size() + ")...", Tracer.Level.DEBUG);
            }
            if (this.processCheckpoint) {
                firstEntry = entries.get(0);
                metadata = RogLogCdcProcessor.access$100(RogLogCdcProcessor.this).getMetadata();
                if (metadata.getCdcCursor() < firstEntry.getFilePosition()) {
                    objects = this.entriesToObjects(entries);
                    try {
                        if (RogLogCdcProcessor.access$200(RogLogCdcProcessor.this).handleChange(firstEntry.getId(), this.toCDCChangeType(changeType), (List<IRogNode>)objects)) {
                            metadata.setCdcCursor(firstEntry.getFilePosition());
                            if (!RogLogCdcProcessor.access$000().debug) ** GOTO lbl25
                            RogLogCdcProcessor.access$000().log("[CDC Processor] Entry was handled successfully. advancing CDC cursor to " + firstEntry.getFilePosition() + ".", Tracer.Level.DEBUG);
                        }
                        if (!RogLogCdcProcessor.access$000().debug) ** GOTO lbl25
                        RogLogCdcProcessor.access$000().log("[CDC Processor] Entry was not handled. not advancing CDC cursor", Tracer.Level.DEBUG);
                    }
                    finally {
                        this.disposeObjects(objects);
                    }
                } else if (RogLogCdcProcessor.access$000().debug) {
                    RogLogCdcProcessor.access$000().log("[CDC Processor] Entry is before CDC cursor (cdcCursor=" + metadata.getCdcCursor() + ", entryPos=" + firstEntry.getFilePosition() + ").", Tracer.Level.DEBUG);
                }
            } else if (RogLogCdcProcessor.access$000().debug) {
                RogLogCdcProcessor.access$000().log("[CDC Processor] Checkpoint not being processed.", Tracer.Level.DEBUG);
            }
lbl25:
            // 8 sources

            this.disposeEntries(entries);
        }

        @Override
        public final void onCheckpointComplete(long checkpointVersion, int numEntriesConflated, int numCheckpointsConflated) {
            if (tracer.debug) {
                tracer.log("[CDC Processor] Checkpoint #" + checkpointVersion + " end...", Tracer.Level.DEBUG);
            }
            if (this.processCheckpoint) {
                if (RogLogCdcProcessor.this.handler.onCheckpointComplete(checkpointVersion)) {
                    RogLogMetadata metadata = RogLogCdcProcessor.this.log.getMetadata();
                    metadata.setCdcCheckpointVersion(checkpointVersion + 1L);
                    if (tracer.debug) {
                        tracer.log("[CDC Processor] Checkpoint completely handled by handler. Updated CDC checkpoint version to " + metadata.getCdcCheckpointVersion(), Tracer.Level.DEBUG);
                    }
                } else if (tracer.debug) {
                    tracer.log("[CDC Processor] Checkpoint was not completely handled by handler.", Tracer.Level.DEBUG);
                }
            } else if (tracer.debug) {
                tracer.log("[CDC Processor] Checkpoint not being processed.", Tracer.Level.DEBUG);
            }
        }

        @Override
        public final void onWait() {
            if (tracer.debug) {
                tracer.log("[CDC Processor] Waiting for more entries...", Tracer.Level.DEBUG);
            }
            RogLogCdcProcessor.this.handler.onWait();
        }

        @Override
        public void handleConflatedChanges(XLinkedHashMap<UUID, RogLogCompactionReader.CompactionReaderEntry> entries) {
            throw new IllegalStateException("CDC Handler cannot accept conflated changes");
        }
    }
}

