/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.rog.impl;

import com.eaio.uuid.UUID;
import com.eaio.uuid.UUIDGen;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.neeve.config.Config;
import com.neeve.io.IOElasticBuffer;
import com.neeve.lang.XString;
import com.neeve.ods.IStoreBinding;
import com.neeve.ods.IStoreObject;
import com.neeve.ods.IStoreObjectMetadata;
import com.neeve.rog.IRogContainerNode;
import com.neeve.rog.IRogMessage;
import com.neeve.rog.IRogMetadata;
import com.neeve.rog.IRogNode;
import com.neeve.rog.impl.RogDirectMetadata;
import com.neeve.rog.impl.RogGraphVisitor;
import com.neeve.rog.impl.RogTransactionalField;
import com.neeve.sma.MessageChannel;
import com.neeve.sma.MessageChannelKeyResolver;
import com.neeve.sma.MessageEncodingTypeRegistry;
import com.neeve.sma.MessageLatencyManager;
import com.neeve.sma.MessageReflector;
import com.neeve.sma.MessageTransportHeaders;
import com.neeve.sma.MessageView;
import com.neeve.sma.MessageViewImpl;
import com.neeve.sma.SmaException;
import com.neeve.sma.event.MessageEvent;
import com.neeve.util.UtlTime;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import java.util.TimeZone;

public abstract class RogNode
extends MessageViewImpl
implements IRogNode {
    private static final JsonFactory jsonFactory = new JsonFactory();
    private static final int fid_type = 1;
    private static final RogTransactionalField<RogNode, Short> _idxTypeField = new RogTransactionalField<RogNode, Short>(1L, "type", RogNode.class, "type", Short.class, null){
        private static final long serialVersionUID = 1L;

        @Override
        public final void setValue(RogNode node, Short value) {
            throw new IllegalAccessError("A node's type is read only");
        }

        @Override
        public final boolean hasValue(RogNode node) {
            return true;
        }

        @Override
        public final Short getValue(RogNode node) {
            return node.getNodeType();
        }

        @Override
        public final boolean appendValueTo(RogNode node, XString target) {
            target.append((long)node.getNodeType());
            return true;
        }
    };
    private static final int fid_graphid = 2;
    private static final RogTransactionalField<RogNode, Integer> _idxGraphIdField = new RogTransactionalField<RogNode, Integer>(2L, "graphId", RogNode.class, "graphId", Integer.class, null){
        private static final long serialVersionUID = 1L;

        @Override
        public final void setValue(RogNode node, Integer value) {
            node.setGraphId(value);
        }

        @Override
        public final boolean hasValue(RogNode node) {
            return true;
        }

        @Override
        public final Integer getValue(RogNode node) {
            return node.getGraphId();
        }

        @Override
        public final boolean appendValueTo(RogNode node, XString target) {
            target.append((long)node.getGraphId());
            return true;
        }
    };
    private static final int fid_parent = 3;
    private static final RogTransactionalField<RogNode, IRogContainerNode> _idxParentField = new RogTransactionalField<RogNode, IRogContainerNode>(3L, "parent", RogNode.class, "parent", IRogContainerNode.class, null){
        private static final long serialVersionUID = 1L;

        @Override
        public final void setValue(RogNode node, IRogContainerNode value) {
            node.setParent(value);
        }

        @Override
        public final boolean hasValue(RogNode node) {
            return node.getParent() != null;
        }

        @Override
        public final IRogContainerNode getValue(RogNode node) {
            return node.getParent();
        }

        @Override
        public final boolean appendValueTo(RogNode node, XString target) {
            if (node.getParent() != null) {
                target.append((CharSequence)node.getParent().toString());
                return true;
            }
            return false;
        }
    };
    protected static final int LAST_ROG_FID = 3;
    private static final ArrayList<RogTransactionalField<? extends RogNode, ?>> fields = new ArrayList(3);
    private final UUID id;
    private boolean idSet;
    private UUID parentId;
    private IRogContainerNode parent;
    private short ofid;
    private long createTs;
    private final RogDirectMetadata metadata;
    private final NonPersistentMessagingTimestamps nonPersistentMessagingTimestamps;
    protected boolean readOnly;
    private boolean priority;
    protected final boolean transactional;
    private MessageReflector messageReflector;
    private long transactionId = 0L;
    private long stableTransactionId = 0L;
    private long checkpointVersion = 0L;
    protected volatile IStoreBinding binding;
    private int committedDataSize = 0;
    private Object attachment;
    public static final String DATE_FORMAT = "yyyyMMdd-HH:mm:ss.SSS";

    protected RogNode(short ofid, short vfid, short type, UUID id, boolean transactional) {
        super(vfid, type);
        this.ofid = ofid;
        this.id = new UUID(0L, 0L);
        if (id != null) {
            this.initIdFrom(id);
        }
        boolean isMessage = this instanceof IRogMessage;
        this.metadata = RogDirectMetadata.create(isMessage, Config.conserveMemory() || !isMessage);
        this.nonPersistentMessagingTimestamps = isMessage ? new NonPersistentMessagingTimestamps() : null;
        this.transactional = transactional;
    }

    private final void initIdFrom(UUID id) {
        if (this.idSet) {
            throw new IllegalStateException("Can't overwrite existing id");
        }
        this.id.clockSeqAndNode = id.clockSeqAndNode;
        this.id.time = id.time;
        this.idSet = true;
    }

    protected final void recordFieldUpdate(long fid, Object val) {
        if (this.transactional && this.binding != null && this.binding.getState() == IStoreBinding.State.Open && this.binding.getRole() == IStoreBinding.Role.Primary) {
            this.binding.getTransactionLog().recordFieldUpdate(this, fid, null, val);
        }
    }

    protected final <T> void recordFieldUpdate(RogTransactionalField<? extends RogNode, T> field, T old, T val) {
        if (this.transactional && this.binding != null && this.binding.getState() == IStoreBinding.State.Open && this.binding.getRole() == IStoreBinding.Role.Primary) {
            this.binding.recordFieldUpdate(this, field, old, val);
        }
    }

    protected final void recordAsDirty() {
        if (this.binding != null && this.binding.getState() == IStoreBinding.State.Open && this.binding.getRole() == IStoreBinding.Role.Primary) {
            this.binding.getTransactionLog().recordObjectAsDirty(this);
        }
    }

    protected int getLastFid() {
        return 3;
    }

    protected String toDumpString() {
        String parentClassName = this.getParent() != null ? this.getParent().getClass().getSimpleName() : null;
        return "id=" + this.getOid() + ", inStore=" + (this.getBinding() != null) + ", parent=<" + this.getParentId() + ", " + parentClassName + ">, graph=" + this.getGraphId() + ", " + this.toString();
    }

    public static final short getTypeFromJson(String json) {
        try {
            JsonParser jp = jsonFactory.createParser(json);
            if (jp.nextToken() == JsonToken.START_OBJECT) {
                jp.nextToken();
                String fieldName = jp.getCurrentName();
                if (fieldName.equals("xRogType")) {
                    jp.nextToken();
                    return jp.getShortValue();
                }
                throw new IllegalArgumentException("invalid json object (xRogType is not the first field)");
            }
            throw new IllegalArgumentException("invalid json object (not formatted as an Object)");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public final MessageView setMessageBus(String name) {
        this.metadata.setMessageBus(name);
        return this;
    }

    @Override
    public final String getMessageBus() {
        return this.metadata.getMessageBus();
    }

    @JsonIgnore
    public final MessageView setMessageBusAsRaw(XString key) {
        this.metadata.setMessageBusAsRaw(key);
        return this;
    }

    @JsonIgnore
    public final XString getMessageBusAsRaw() {
        return this.metadata.getMessageBusAsRaw();
    }

    public final MessageView setMessageChannel(String name) {
        this.metadata.setMessageChannel(name);
        return this;
    }

    @Override
    public final String getMessageChannel() {
        return this.metadata.getMessageChannel();
    }

    public final MessageView setMessageChannelAsRaw(XString key) {
        this.metadata.setMessageChannelAsRaw(key);
        return this;
    }

    @JsonIgnore
    public final XString getMessageChannelAsRaw() {
        return this.metadata.getMessageChannelAsRaw();
    }

    public final MessageView setMessageKey(String key) {
        this.metadata.setMessageKey(key);
        return this;
    }

    @Override
    public final String getMessageKey() {
        return this.metadata.getMessageKey();
    }

    public final void resolveMessageKeyWith(MessageChannelKeyResolver channelKeyResolver, MessageChannel.RawKeyResolutionTable rawKeyResolutionTable) throws SmaException {
        XString keyBuffer = this.metadata.messageKeyBuffer((short)64);
        if (rawKeyResolutionTable != null || channelKeyResolver.getKeyResolutionTable() == null) {
            keyBuffer.clear(false);
            channelKeyResolver.resolveMessageKey(keyBuffer, (MessageView)this, rawKeyResolutionTable);
        } else {
            String strKey = channelKeyResolver.resolveMessageKey((MessageView)this, null);
            if (strKey != null) {
                keyBuffer.setValue(strKey);
            }
        }
        this.metadata.setMessageKeyAsRaw(keyBuffer);
    }

    public final void resolveMessageKeyWith(MessageChannelKeyResolver channelKeyResolver, Properties keyResolutionTable) throws SmaException {
        XString keyBuffer = this.metadata.messageKeyBuffer((short)64);
        if (keyResolutionTable == null && channelKeyResolver.getKeyResolutionTable() == null) {
            channelKeyResolver.resolveMessageKey(keyBuffer, (MessageView)this, null);
        } else {
            String strKey = channelKeyResolver.resolveMessageKey((MessageView)this, keyResolutionTable);
            if (strKey != null) {
                keyBuffer.setValue(strKey);
            }
        }
        this.metadata.setMessageKeyAsRaw(keyBuffer);
    }

    @JsonIgnore
    public final MessageView setMessageKeyAsRaw(XString key) {
        this.metadata.setMessageKeyAsRaw(key);
        return this;
    }

    @JsonIgnore
    public final XString getMessageKeyAsRaw() {
        return this.metadata.getMessageKeyAsRaw();
    }

    public final MessageView setMessageSender(int sender) {
        this.metadata.setMessageSender(sender);
        return this;
    }

    @Override
    public final int getMessageSender() {
        return this.metadata.getMessageSender();
    }

    public final MessageView setMessageFlow(int flow) {
        this.metadata.setMessageFlow(flow);
        return this;
    }

    @Override
    public final int getMessageFlow() {
        return this.metadata.getMessageFlow();
    }

    public final MessageView setMessageSequenceNumber(long sno) {
        this.metadata.setMessageSequenceNumber(sno);
        return this;
    }

    public final MessageView setRequestorId(String val) {
        this.metadata.setRequestorId(val);
        return this;
    }

    @Override
    public final String getRequestorId() {
        return this.metadata.getRequestorId();
    }

    public final MessageView setRequestorIdAsRaw(XString val) {
        this.metadata.setRequestorIdAsRaw(val);
        return this;
    }

    public final XString getRequestorIdAsRaw() {
        return this.metadata.getRequestorIdAsRaw();
    }

    public final MessageView setRequestId(long id) {
        this.metadata.setRequestId(id);
        return this;
    }

    @Override
    public final long getRequestId() {
        return this.metadata.getRequestId();
    }

    @Override
    public final long getMessageSequenceNumber() {
        return this.metadata.getMessageSequenceNumber();
    }

    public final MessageView setPossibleDuplicate() {
        this.metadata.setPossibleDuplicate(true);
        return this;
    }

    @Override
    public final boolean isPossibleDuplicate() {
        return this.metadata.isPossibleDuplicate();
    }

    @Override
    public final MessageTransportHeaders activateMessageTransportHeaders() {
        return this.metadata.activateMessageTransportHeaders();
    }

    @Override
    public final MessageTransportHeaders getMessageTransportHeaders() {
        return this.metadata.getMessageTransportHeaders();
    }

    public final RogNode setMessageTransportHeaders(MessageTransportHeaders headers) {
        this.metadata.setMessageTransportHeaders(headers);
        return this;
    }

    public final IRogNode setOriginTs(long ts) {
        this.nonPersistentMessagingTimestamps.originTs = ts;
        return this;
    }

    public final long getOriginTs() {
        if (this.nonPersistentMessagingTimestamps == null) {
            return 0L;
        }
        return this.nonPersistentMessagingTimestamps.originTs;
    }

    public final IRogNode setCreateTs(long ts) {
        this.createTs = ts;
        return this;
    }

    public final long getCreateTs() {
        return this.createTs;
    }

    public final IRogNode setAppSendBeginTs(long ts) {
        this.nonPersistentMessagingTimestamps.appSendBeginTs = ts;
        return this;
    }

    public final long getAppSendBeginTs() {
        if (this.nonPersistentMessagingTimestamps == null) {
            return 0L;
        }
        return this.nonPersistentMessagingTimestamps.appSendBeginTs;
    }

    public final IRogNode setAppSendDoneTs(long ts) {
        this.nonPersistentMessagingTimestamps.appSendDoneTs = ts;
        return this;
    }

    public final long getAppSendDoneTs() {
        if (this.nonPersistentMessagingTimestamps == null) {
            return 0L;
        }
        return this.nonPersistentMessagingTimestamps.appSendDoneTs;
    }

    public final IRogNode setSendTs(long ts) {
        this.nonPersistentMessagingTimestamps.sendTs = ts;
        return this;
    }

    public final long getSendTs() {
        if (this.nonPersistentMessagingTimestamps == null) {
            return 0L;
        }
        return this.nonPersistentMessagingTimestamps.sendTs;
    }

    public final IRogNode setSendStartTs(long ts) {
        this.nonPersistentMessagingTimestamps.sendStartTs = ts;
        return this;
    }

    public final long getSendStartTs() {
        if (this.nonPersistentMessagingTimestamps == null) {
            return 0L;
        }
        return this.nonPersistentMessagingTimestamps.sendStartTs;
    }

    @Deprecated
    public final IRogNode setOutTs(long ts) {
        this.metadata.setOutTs(ts);
        return this;
    }

    @Override
    public final long getOutTs() {
        return this.metadata.getOutTs();
    }

    public final IRogNode setOutTsMicros(long ts) {
        this.metadata.setOutTsMicros(ts);
        return this;
    }

    @Override
    public final long getOutTsMicros() {
        return this.metadata.getOutTsMicros();
    }

    public final IRogNode setPreSerializeTs(long ts) {
        this.nonPersistentMessagingTimestamps.preSerializeTs = ts;
        return this;
    }

    public final long getPreSerializeTs() {
        if (this.nonPersistentMessagingTimestamps == null) {
            return 0L;
        }
        return this.nonPersistentMessagingTimestamps.preSerializeTs;
    }

    public final IRogNode setPostSerializeTs(long ts) {
        this.nonPersistentMessagingTimestamps.postSerializeTs = ts;
        return this;
    }

    public final long getPostSerializeTs() {
        if (this.nonPersistentMessagingTimestamps == null) {
            return 0L;
        }
        return this.nonPersistentMessagingTimestamps.postSerializeTs;
    }

    public final IRogNode setPreWireTs(long ts) {
        this.nonPersistentMessagingTimestamps.preWireTs = ts;
        return this;
    }

    public final long getPreWireTs() {
        if (this.nonPersistentMessagingTimestamps == null) {
            return 0L;
        }
        return this.nonPersistentMessagingTimestamps.preWireTs;
    }

    public final IRogNode setPostWireSendTs(long ts) {
        this.nonPersistentMessagingTimestamps.postWireSendTs = ts;
        return this;
    }

    public final long getPostWireSendTs() {
        if (this.nonPersistentMessagingTimestamps == null) {
            return 0L;
        }
        return this.nonPersistentMessagingTimestamps.postWireSendTs;
    }

    public final IRogNode setPostWireTs(long ts) {
        this.nonPersistentMessagingTimestamps.postWireTs = ts;
        return this;
    }

    public final long getPostWireTs() {
        if (this.nonPersistentMessagingTimestamps == null) {
            return 0L;
        }
        return this.nonPersistentMessagingTimestamps.postWireTs;
    }

    public final IRogNode setPreDeserializeTs(long ts) {
        this.nonPersistentMessagingTimestamps.preDeserializeTs = ts;
        return this;
    }

    public final long getPreDeserializeTs() {
        if (this.nonPersistentMessagingTimestamps == null) {
            return 0L;
        }
        return this.nonPersistentMessagingTimestamps.preDeserializeTs;
    }

    public final IRogNode setPostDeserializeTs(long ts) {
        this.nonPersistentMessagingTimestamps.postDeserializeTs = ts;
        return this;
    }

    public final long getPostDeserializeTs() {
        if (this.nonPersistentMessagingTimestamps == null) {
            return 0L;
        }
        return this.nonPersistentMessagingTimestamps.postDeserializeTs;
    }

    @Override
    public final long getEnqueueTs() {
        return this.metadata.getEnqueueTs();
    }

    public final IRogNode setEnqueueTsMicros(long ts) {
        this.metadata.setEnqueueTsMicros(ts);
        return this;
    }

    @Override
    public final long getEnqueueTsMicros() {
        return this.metadata.getEnqueueTsMicros();
    }

    public final IRogNode setReceiveTs(long ts) {
        this.nonPersistentMessagingTimestamps.receiveTs = ts;
        return this;
    }

    public final long getReceiveTs() {
        if (this.nonPersistentMessagingTimestamps == null) {
            return 0L;
        }
        return this.nonPersistentMessagingTimestamps.receiveTs;
    }

    @Deprecated
    public final IRogNode setPreProcessingTs(long ts) {
        this.metadata.setPreProcessingTs(ts);
        return this;
    }

    @Override
    public final long getPreProcessingTs() {
        return this.metadata.getPreProcessingTs();
    }

    public final IRogNode setPreProcessingTsMicros(long ts) {
        this.metadata.setPreProcessingTsMicros(ts);
        return this;
    }

    @Override
    public final long getPreProcessingTsMicros() {
        return this.metadata.getPreProcessingTsMicros();
    }

    @Deprecated
    public final IRogNode setPostProcessingTs(long ts) {
        this.nonPersistentMessagingTimestamps.postProcessingTs = ts * 1000L;
        return this;
    }

    @Deprecated
    public final long getPostProcessingTs() {
        if (this.nonPersistentMessagingTimestamps == null) {
            return 0L;
        }
        return this.nonPersistentMessagingTimestamps.postProcessingTs / 1000L;
    }

    public final IRogNode setPostProcessingTsMicros(long ts) {
        this.nonPersistentMessagingTimestamps.postProcessingTs = ts;
        return this;
    }

    public final long getPostProcessingTsMicros() {
        if (this.nonPersistentMessagingTimestamps == null) {
            return 0L;
        }
        return this.nonPersistentMessagingTimestamps.postProcessingTs;
    }

    protected final IRogNode setMessageReflector(MessageReflector messageReflector) {
        this.messageReflector = messageReflector;
        return this;
    }

    public final MessageReflector getMessageReflector() {
        if (this.messageReflector == null) {
            this.messageReflector = MessageEncodingTypeRegistry.getInstance().getMessageReflector(this.messageEncodingType);
        }
        return this.messageReflector;
    }

    public boolean appendFieldValueTo(Object node, String fieldPath, XString target) {
        String value;
        MessageReflector reflector = this.getMessageReflector();
        if (reflector != null && (value = reflector.getFieldValueAsString((Object)reflector, fieldPath)) != null) {
            target.append((CharSequence)value);
            return true;
        }
        return false;
    }

    public boolean appendFieldValueTo(Object node, String[] pathComponents, XString target) {
        String value;
        MessageReflector reflector = this.getMessageReflector();
        if (reflector != null && (value = reflector.getFieldValueAsString((Object)reflector, pathComponents)) != null) {
            target.append((CharSequence)value);
            return true;
        }
        return false;
    }

    @Override
    public final UUID ensureOId() {
        if (this.idSet) {
            return this.id;
        }
        this.id.time = UUIDGen.newTime();
        this.id.clockSeqAndNode = UUIDGen.getClockSeqAndNode();
        this.idSet = true;
        return this.id;
    }

    @Override
    public final UUID getOid() {
        if (this.idSet) {
            return this.id;
        }
        return null;
    }

    @Override
    public final short getOfid() {
        return this.ofid;
    }

    @Override
    public final short getObjectType() {
        return this.type;
    }

    @Override
    public final IStoreObject setBinding(IStoreBinding binding) {
        this.binding = binding;
        return this;
    }

    @Override
    public final IStoreBinding getBinding() {
        return this.binding;
    }

    @Override
    public final int getSerializedMetadataLength() {
        return this.metadata.serializedLength();
    }

    @Override
    public final int serializeMetadata(IOElasticBuffer buffer, int offset) {
        return this.metadata.serialize(buffer, offset);
    }

    @Override
    public final IStoreObjectMetadata getStoreMetadata() {
        return this;
    }

    @Override
    public final IRogMetadata getMetadata() {
        return this.metadata;
    }

    @Override
    public final IStoreObject deserializeMetadata(IOElasticBuffer metadata, int metadataOffset, boolean copyDeserialize) {
        try {
            this.metadata.deserialize(metadata, metadataOffset, copyDeserialize);
            this.parentId = null;
            return this;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public final IStoreObject deserializeMetadata(IOElasticBuffer metadata, int metadataOffset) {
        return this.deserializeMetadata(metadata, metadataOffset, false);
    }

    @Override
    public IStoreObject setFieldValue(long fid, Object val) {
        if (fid == 2L) {
            this.setGraphIdCore((Integer)val);
        } else if (fid == 3L) {
            this.setParentCore((IRogContainerNode)val);
        }
        return this;
    }

    @Override
    public final void setCommittedDataSize(int dataSize) {
        this.committedDataSize = dataSize;
    }

    @Override
    public final int getCommittedDataSize() {
        return this.committedDataSize;
    }

    @Override
    public void saveMemory() {
    }

    private final void setGraphIdCore(int graphId) {
        this.metadata.setGraphId(graphId);
    }

    public final void setGraphId(int graphId) {
        if (this.transactional) {
            if (graphId != this.getGraphId()) {
                this.recordFieldUpdate(2L, this.getGraphId());
                this.setGraphIdCore(graphId);
            }
        } else {
            this.setGraphIdCore(graphId);
        }
    }

    @Override
    public final int getGraphId() {
        return this.metadata.getGraphId();
    }

    private final void setParentIdCore(UUID parentId) {
        this.metadata.setParentId(parentId);
    }

    @Override
    public final void setParentId(UUID parentId) {
        if (this.parent != null) {
            throw new IllegalStateException("cannot set parent id with parent already set");
        }
        this.setParentIdCore(parentId);
    }

    @Override
    public final UUID getParentId() {
        if (this.parentId == null) {
            this.parentId = this.metadata.getParentId();
        }
        return this.parentId;
    }

    private final void setParentCore(IRogContainerNode parent) {
        this.parent = parent;
        this.setParentIdCore(parent == null ? null : parent.getOid());
    }

    final void setParent(IRogContainerNode parent) {
        if (this.transactional) {
            if (parent != this.getParent()) {
                this.recordFieldUpdate(3L, this.getParent());
                this.setParentCore(parent);
            }
        } else {
            this.setParentCore(parent);
        }
    }

    @Override
    public final short getNodeType() {
        return this.type;
    }

    @Override
    public final IRogContainerNode getParent() {
        return this.parent;
    }

    @Override
    public final RogNode setTransactionId(long id) {
        this.transactionId = id;
        return this;
    }

    @Override
    public final long getTransactionId() {
        return this.transactionId;
    }

    @Override
    public final RogNode setStableTransactionId(long id) {
        this.stableTransactionId = id;
        return this;
    }

    @Override
    public final long getStableTransactionId() {
        return this.stableTransactionId;
    }

    @Override
    public final void setInMsgsInTransaction(boolean val) {
        this.metadata.setInMsgsInTransaction(val);
    }

    @Override
    public final boolean getInMsgsInTransaction() {
        return this.metadata.getInMsgsInTransaction();
    }

    @Override
    public final void setOutMsgsInTransaction(boolean val) {
        this.metadata.setOutMsgsInTransaction(val);
    }

    @Override
    public final boolean getOutMsgsInTransaction() {
        return this.metadata.getOutMsgsInTransaction();
    }

    @Override
    public final RogNode setTransactionInSequenceNumber(int val) {
        this.metadata.setTransactionInSequenceNumber(val);
        return this;
    }

    @Override
    public final int getTransactionInSequenceNumber() {
        return this.metadata.getTransactionInSequenceNumber();
    }

    @Override
    public final RogNode setTransactionOutSequenceNumber(int val) {
        this.metadata.setTransactionOutSequenceNumber(val);
        return this;
    }

    @Override
    public final int getTransactionOutSequenceNumber() {
        return this.metadata.getTransactionOutSequenceNumber();
    }

    @Override
    public final void setAsMessage(boolean val) {
        this.metadata.setIsMessage(val);
    }

    @Override
    public final boolean getIsMessage() {
        return this.metadata.getIsMessage();
    }

    @Override
    public final void setAsInboundMessage(boolean val) {
        this.metadata.setIsInboundMessage(val);
    }

    @Override
    public final boolean getIsInboundMessage() {
        return this.metadata.getIsInboundMessage();
    }

    @Override
    public final void setAsOutboundMessage(boolean val) {
        this.metadata.setIsOutboundMessage(val);
    }

    @Override
    public final boolean getIsOutboundMessage() {
        return this.metadata.getIsOutboundMessage();
    }

    @Override
    public final void setAsReplayedMessage(boolean val) {
        this.metadata.setIsReplayedMessage(val);
    }

    @Override
    public final boolean getIsReplayedMessage() {
        return this.metadata.getIsReplayedMessage();
    }

    @Override
    public final boolean getIsLiveInboundMessage() {
        MessageEvent event = (MessageEvent)this.getTag(0);
        return event != null && event.getMessageChannel() != null;
    }

    @Override
    public final void setAsLastTransaction(boolean val) {
        this.metadata.setIsLastTransaction(val);
    }

    @Override
    public final boolean getIsLastTransaction() {
        return this.metadata.getIsLastTransaction();
    }

    @Override
    public final void setAsInternal(boolean val) {
        this.metadata.setIsInternal(val);
    }

    @Override
    public final boolean getIsInternal() {
        return this.metadata.getIsInternal();
    }

    @Override
    public final void setCheckpointVersion(long version) {
        this.checkpointVersion = version;
    }

    @Override
    public final long getCheckpointVersion() {
        return this.checkpointVersion;
    }

    @Override
    public void dump(StringBuilder sb, String leader, String leaderConcat) {
        sb.append("\n");
        sb.append(leader).append("[").append(this.toDumpString()).append("]");
    }

    private final String tsToDateString(long ts, SimpleDateFormat dateFormat) {
        return ts == 0L ? "0" : dateFormat.format(new Date(ts));
    }

    @Override
    public final String metadataToString() {
        SimpleDateFormat dateFormat = new SimpleDateFormat(DATE_FORMAT);
        dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName()).append("<").append(this.type).append("> {").append("\n");
        sb.append("   type.............").append(this.getNodeType()).append("\n");
        sb.append("   ref..............").append(this.getOwnershipCount()).append("\n");
        sb.append("   int..............").append(this.getIsInternal()).append("\n");
        sb.append("   .................").append("\n");
        sb.append("   msg..............").append(this.getIsMessage()).append("\n");
        sb.append("   dir..............").append(this.getIsMessage() ? (this.getIsOutboundMessage() ? "out" : (this.getIsInboundMessage() ? "in" : "?")) : "---").append("\n");
        sb.append("   .................").append("\n");
        sb.append("   vfid.............").append(this.getVfid()).append("\n");
        sb.append("   encoding.........").append(this.getMessageEncodingType()).append("\n");
        sb.append("   bus..............").append(this.getMessageBus()).append("\n");
        sb.append("   channel..........").append(this.getMessageChannel()).append("\n");
        sb.append("   key..............").append(this.getMessageKey()).append("\n");
        sb.append("   sender...........").append(this.getMessageSender()).append("\n");
        sb.append("   flow.............").append(this.getMessageFlow()).append("\n");
        sb.append("   sno..............").append(this.getMessageSequenceNumber()).append("\n");
        sb.append("   .................").append("\n");
        sb.append("   ofid.............").append(this.getOfid()).append("\n");
        sb.append("   oid..............").append(this.getOid()).append("\n");
        sb.append("   graphid..........").append(this.getGraphId()).append("\n");
        sb.append("   parentid.........").append(this.getParentId()).append("\n");
        sb.append("   .................").append("\n");
        sb.append("   txnid............").append(this.getTransactionId()).append("\n");
        sb.append("   stbltxnid........").append(this.getStableTransactionId()).append("\n");
        sb.append("   chkpoint.........").append(this.getCheckpointVersion()).append("\n");
        sb.append("   inmsgs...........").append(this.getInMsgsInTransaction()).append("\n");
        sb.append("   outmsgs..........").append(this.getOutMsgsInTransaction()).append("\n");
        sb.append("   insno............").append(this.getTransactionInSequenceNumber()).append("\n");
        sb.append("   outsno...........").append(this.getTransactionOutSequenceNumber()).append("\n");
        sb.append("   posdup...........").append(this.isPossibleDuplicate()).append("\n");
        sb.append("   lasttxn..........").append(this.getIsLastTransaction()).append("\n");
        sb.append("   .................").append("\n");
        sb.append("   outTs............").append(this.tsToDateString(this.getOutTs(), dateFormat)).append("\n");
        sb.append("   outTsMicros......").append(this.getOutTsMicros()).append("\n");
        sb.append("   enqueueTs........").append(this.tsToDateString(this.getEnqueueTs(), dateFormat)).append("\n");
        sb.append("   enqueueTsMicros..").append(this.getEnqueueTsMicros()).append("\n");
        sb.append("   preprocTs........").append(this.tsToDateString(this.getPreProcessingTs(), dateFormat)).append("\n");
        sb.append("   preprocTsMicros..").append(this.getPreProcessingTsMicros()).append("\n");
        sb.append("}");
        return sb.toString();
    }

    @Override
    public final String metadataToJsonString() {
        return this.metadataToJsonString(Config.getValue((String)"nv.indent.json", (boolean)false));
    }

    @Override
    public final String metadataToJsonString(boolean indentOutput) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(DATE_FORMAT);
        dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        StringBuilder sb = new StringBuilder("{");
        if (indentOutput) {
            sb.append("\n  ");
        }
        sb.append("\"class\":\"" + this.getClass().getSimpleName() + "\"");
        sb.append(",");
        if (indentOutput) {
            sb.append("\n  ");
        }
        sb.append("\"type\":" + this.getNodeType());
        sb.append(",");
        if (indentOutput) {
            sb.append("\n  ");
        }
        sb.append("\"ref\":" + this.getOwnershipCount());
        sb.append(",");
        if (indentOutput) {
            sb.append("\n  ");
        }
        sb.append("\"int\":" + this.getIsInternal());
        sb.append(",");
        if (indentOutput) {
            sb.append("\n  ");
        }
        sb.append("\"msg\":" + this.getIsMessage());
        sb.append(",");
        if (indentOutput) {
            sb.append("\n  ");
        }
        sb.append("\"dir\":\"" + (this.getIsMessage() ? (this.getIsOutboundMessage() ? "out" : (this.getIsInboundMessage() ? "in" : "?")) : "---") + "\"");
        sb.append(",");
        if (indentOutput) {
            sb.append("\n  ");
        }
        sb.append("\"vfid\":" + this.getVfid());
        sb.append(",");
        if (indentOutput) {
            sb.append("\n  ");
        }
        sb.append("\"encoding\":" + this.getMessageEncodingType());
        sb.append(",");
        if (indentOutput) {
            sb.append("\n  ");
        }
        sb.append("\"bus\":" + (this.getMessageBus() == null ? "null" : "\"" + this.getMessageBus() + "\""));
        sb.append(",");
        if (indentOutput) {
            sb.append("\n  ");
        }
        sb.append("\"channel\":" + (this.getMessageChannel() == null ? "null" : "\"" + this.getMessageChannel() + "\""));
        sb.append(",");
        if (indentOutput) {
            sb.append("\n  ");
        }
        sb.append("\"key\":" + (this.getMessageKey() == null ? "null" : "\"" + this.getMessageKey() + "\""));
        sb.append(",");
        if (indentOutput) {
            sb.append("\n  ");
        }
        sb.append("\"sender\":" + this.getMessageSender());
        sb.append(",");
        if (indentOutput) {
            sb.append("\n  ");
        }
        sb.append("\"flow\":" + this.getMessageFlow());
        sb.append(",");
        if (indentOutput) {
            sb.append("\n  ");
        }
        sb.append("\"sno\":" + this.getMessageSequenceNumber());
        sb.append(",");
        if (indentOutput) {
            sb.append("\n  ");
        }
        sb.append("\"ofid\":" + this.getOfid());
        sb.append(",");
        if (indentOutput) {
            sb.append("\n  ");
        }
        sb.append("\"id\":" + (this.getOid() == null ? "null" : "\"" + this.getOid().toString() + "\""));
        sb.append(",");
        if (indentOutput) {
            sb.append("\n  ");
        }
        sb.append("\"graphid\":" + this.getGraphId());
        sb.append(",");
        if (indentOutput) {
            sb.append("\n  ");
        }
        sb.append("\"parentid\":" + (this.getParentId() == null ? "null" : "\"" + this.getParentId().toString() + "\""));
        sb.append(",");
        if (indentOutput) {
            sb.append("\n  ");
        }
        sb.append("\"txnid\":" + this.getTransactionId());
        sb.append(",");
        if (indentOutput) {
            sb.append("\n  ");
        }
        sb.append("\"stbltxnid\":" + this.getStableTransactionId());
        sb.append(",");
        if (indentOutput) {
            sb.append("\n  ");
        }
        sb.append("\"chkpnt\":" + this.getCheckpointVersion());
        sb.append(",");
        if (indentOutput) {
            sb.append("\n  ");
        }
        sb.append("\"inmsgs\":" + this.getInMsgsInTransaction());
        sb.append(",");
        if (indentOutput) {
            sb.append("\n  ");
        }
        sb.append("\"outmsgs\":" + this.getOutMsgsInTransaction());
        sb.append(",");
        if (indentOutput) {
            sb.append("\n  ");
        }
        sb.append("\"insno\":" + this.getTransactionInSequenceNumber());
        sb.append(",");
        if (indentOutput) {
            sb.append("\n  ");
        }
        sb.append("\"outsno\":" + this.getTransactionOutSequenceNumber());
        sb.append(",");
        if (indentOutput) {
            sb.append("\n  ");
        }
        sb.append("\"posdup\":" + this.isPossibleDuplicate());
        sb.append(",");
        if (indentOutput) {
            sb.append("\n  ");
        }
        sb.append("\"lasttxn\":" + this.getIsLastTransaction());
        sb.append(",");
        if (indentOutput) {
            sb.append("\n  ");
        }
        sb.append("\"outTs\":\"" + this.tsToDateString(this.getOutTs(), dateFormat) + "\"");
        sb.append(",");
        if (indentOutput) {
            sb.append("\n  ");
        }
        sb.append("\"outTsMicros\":\"" + this.getOutTsMicros() + "\"");
        sb.append(",");
        if (indentOutput) {
            sb.append("\n  ");
        }
        sb.append("\"enqueueTs\":\"" + this.tsToDateString(this.getEnqueueTs(), dateFormat) + "\"");
        sb.append(",");
        if (indentOutput) {
            sb.append("\n  ");
        }
        sb.append("\"enqueueTsMicros\":\"" + this.getEnqueueTsMicros() + "\"");
        sb.append(",");
        if (indentOutput) {
            sb.append("\n  ");
        }
        sb.append("\"preprocTs\":\"" + this.tsToDateString(this.getPreProcessingTs(), dateFormat) + "\"");
        sb.append(",");
        if (indentOutput) {
            sb.append("\n");
        }
        sb.append("\"preprocTsMicros\":\"" + this.getPreProcessingTsMicros() + "\"");
        if (indentOutput) {
            sb.append("\n");
        }
        sb.append("}");
        return sb.toString();
    }

    @Override
    public final void setAttachment(Object val) {
        this.attachment = val;
    }

    @Override
    public final Object getAttachment() {
        return this.attachment;
    }

    @Override
    public void setAsReadOnly() {
        this.readOnly = true;
    }

    @Override
    public final boolean getIsReadOnly() {
        return this.readOnly;
    }

    @Override
    public void setAsPriority() {
        this.priority = true;
    }

    @Override
    public final boolean getIsPriority() {
        return this.priority;
    }

    @Override
    public int dispose() {
        int count = super.dispose();
        if (count == 0) {
            if (this.binding != null) {
                throw new IllegalStateException("node being disposed is still in an ODS store");
            }
            this.metadata.reset();
            if (this.nonPersistentMessagingTimestamps != null) {
                this.nonPersistentMessagingTimestamps.clear();
            }
            this.createTs = 0L;
            this.id.time = 0L;
            this.id.clockSeqAndNode = 0L;
            this.idSet = false;
            this.parentId = null;
            this.parent = null;
            this.transactionId = 0L;
            this.stableTransactionId = 0L;
            this.checkpointVersion = 0L;
            this.readOnly = false;
        }
        return count;
    }

    public void undispose(UUID id) {
        super.undispose();
        if (id != null) {
            this.initIdFrom(id);
        }
        if (MessageLatencyManager.recordMsgLegWaypoints) {
            this.setCreateTs(UtlTime.now());
        }
    }

    public final void accept(RogGraphVisitor visitor) {
        if (visitor.visitField(null, "", this)) {
            visitor.beginFieldVisit(this);
            this.visitFields(visitor);
            visitor.endFieldVisit(this);
        }
    }

    protected void visitFields(RogGraphVisitor visitor) {
    }

    protected final void visitField(RogGraphVisitor visitor, String fieldName, RogNode field) {
        if (visitor.visitField(this, fieldName, field)) {
            visitor.beginFieldVisit(field);
            field.visitFields(visitor);
            visitor.endFieldVisit(field);
        }
    }

    protected final void visitField(RogGraphVisitor visitor, String fieldName, Object field) {
        visitor.visitField(this, fieldName, field);
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public void getValidationErrors(List<XString> results, String errorPrefix) {
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    public static List<RogTransactionalField<? extends RogNode, ?>> getFields() {
        return fields;
    }

    static {
        fields.add(_idxTypeField);
        fields.add(_idxGraphIdField);
        fields.add(_idxParentField);
    }

    private static final class NonPersistentMessagingTimestamps {
        long originTs;
        long appSendBeginTs;
        long appSendDoneTs;
        long sendTs;
        long sendStartTs;
        long preSerializeTs;
        long postSerializeTs;
        long preWireTs;
        long postWireSendTs;
        long postWireTs;
        long preDeserializeTs;
        long postDeserializeTs;
        long receiveTs;
        long postProcessingTs;

        private NonPersistentMessagingTimestamps() {
        }

        final void clear() {
            this.originTs = 0L;
            this.appSendBeginTs = 0L;
            this.appSendDoneTs = 0L;
            this.sendTs = 0L;
            this.sendStartTs = 0L;
            this.preSerializeTs = 0L;
            this.postSerializeTs = 0L;
            this.preWireTs = 0L;
            this.postWireSendTs = 0L;
            this.postWireTs = 0L;
            this.preDeserializeTs = 0L;
            this.postDeserializeTs = 0L;
            this.receiveTs = 0L;
            this.postProcessingTs = 0L;
        }
    }
}

