/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.ods.impl;

import com.eaio.uuid.UUID;
import com.neeve.config.Config;
import com.neeve.ods.IStoreField;
import com.neeve.ods.IStoreObject;
import com.neeve.ods.IStoreTransactionLog;
import com.neeve.ods.OdsObject;
import com.neeve.trace.Tracer;
import com.neeve.util.UtlLinkedHashMap;
import com.neeve.util.UtlList;
import com.neeve.util.UtlListElement;
import com.neeve.util.UtlPool;
import java.util.Map;

final class StoreTransactionLog
extends OdsObject
implements IStoreTransactionLog {
    private static final boolean enableObjectIDMutationProtection = Config.getValue((String)"nv.ods.enableObjectIDMutationProtection", (boolean)false);
    private final UtlLinkedHashMap<UUID, ObjectEntriesList> log;
    private final UtlList olog;
    private final UtlPool<PutEntry> putEntryPool;
    private final UtlPool<FieldUpdateEntry> updateEntryPool;
    private final UtlPool<RemoveEntry> removeEntryPool;
    private final UtlPool<SendEntry> sendEntryPool;
    private final UtlPool<OrderedEntry> orderedEntryPool;
    private final UtlPool<ObjectEntriesList> objectEntryListPool;
    private final UUID uuidTemp = new UUID();
    private int currentSavepoint = 0;

    StoreTransactionLog(String name) {
        super(null);
        this.log = new UtlLinkedHashMap();
        this.olog = UtlList.create();
        this.putEntryPool = UtlPool.create((String)"txnlog.pentry", (String)name, (UtlPool.Factory)new PutEntry.Factory(), (UtlPool.Params)UtlPool.Params.create().setThreaded(false));
        this.updateEntryPool = UtlPool.create((String)"txnlog.fuentry", (String)name, (UtlPool.Factory)new FieldUpdateEntry.Factory(), (UtlPool.Params)UtlPool.Params.create().setThreaded(false));
        this.removeEntryPool = UtlPool.create((String)"txnlog.rentry", (String)name, (UtlPool.Factory)new RemoveEntry.Factory(), (UtlPool.Params)UtlPool.Params.create().setThreaded(false));
        this.sendEntryPool = UtlPool.create((String)"txnlog.sentry", (String)name, (UtlPool.Factory)new SendEntry.Factory(), (UtlPool.Params)UtlPool.Params.create().setThreaded(false));
        this.orderedEntryPool = UtlPool.create((String)"txnlog.oentry", (String)name, (UtlPool.Factory)new OrderedEntry.Factory(), (UtlPool.Params)UtlPool.Params.create().setThreaded(false));
        this.objectEntryListPool = UtlPool.create((String)"txnlog.oentrylist", (String)name, (UtlPool.Factory)new ObjectEntriesList.Factory(), (UtlPool.Params)UtlPool.Params.create().setThreaded(false));
    }

    private final ObjectEntriesList getLog(IStoreObject object, boolean forRemove) {
        UUID oid = object.getOid();
        this.uuidTemp.time = oid.time;
        this.uuidTemp.clockSeqAndNode = oid.clockSeqAndNode;
        ObjectEntriesList list = (ObjectEntriesList)((Object)this.log.get((Object)oid));
        if (list == null) {
            list = (ObjectEntriesList)this.objectEntryListPool.get(null);
            this.log.put((Object)oid, (Object)list);
            list.oid = oid;
        } else if (forRemove) {
            if (enableObjectIDMutationProtection) {
                this.log.remove((Object)this.uuidTemp);
                this.log.put((Object)this.uuidTemp, (Object)list);
            } else {
                list = (ObjectEntriesList)((Object)this.log.remove((Object)object.getOid()));
                this.log.put((Object)object.getOid(), (Object)list);
                if (list == null) {
                    this.tracer.log("Entry transaction log with id of '" + this.uuidTemp + "' removed during lookup for object with id '" + object.getOid() + "' (ocount=" + object.getOwnershipCount() + ", txnId=" + object.getTransactionId() + ")!", Tracer.Level.SEVERE);
                    try {
                        this.tracer.log(" Offending Object: " + object.toString(), Tracer.Level.SEVERE);
                    }
                    catch (Throwable thrown) {
                        thrown.printStackTrace();
                    }
                }
            }
        }
        return list;
    }

    final StringBuilder dumpLog(StringBuilder sb) {
        sb.append("Transaction Log {\n");
        UtlLinkedHashMap.FastIterator iterator = this.log.fastIterator().toFirst();
        while (iterator.hasNext()) {
            Map.Entry mapEntry = iterator.next();
            ObjectEntriesList list = (ObjectEntriesList)((Object)mapEntry.getValue());
            sb.append("...[").append(((UUID)mapEntry.getKey()).toString()).append("] {");
            for (Entry entry = (Entry)list.first(); entry != null; entry = (Entry)entry.next()) {
                sb.append((Object)entry.type).append(" ");
            }
            sb.append("}\n");
        }
        sb.append("}");
        return sb;
    }

    final UtlLinkedHashMap<UUID, ObjectEntriesList> getLog() {
        return this.log;
    }

    final UtlList getOrderedLog() {
        return this.olog;
    }

    final void recordObjectPut(IStoreObject object) {
        PutEntry entry = (PutEntry)this.putEntryPool.get(null);
        this.getLog(object, false).append(entry);
        this.olog.append((UtlListElement)((OrderedEntry)this.orderedEntryPool.get(null)).setEntry(entry, this.currentSavepoint));
    }

    final void recordObjectRemove(IStoreObject object) {
        RemoveEntry entry = ((RemoveEntry)this.removeEntryPool.get(null)).initialize(object);
        this.getLog(object, true).append(entry);
        this.olog.append((UtlListElement)((OrderedEntry)this.orderedEntryPool.get(null)).setEntry(entry, this.currentSavepoint));
    }

    final void recordObjectSend(IStoreObject object) {
        SendEntry entry = ((SendEntry)this.sendEntryPool.get(null)).initialize(object);
        ObjectEntriesList list = this.getLog(object, false);
        if (list.count() > 0) {
            throw new IllegalStateException("an object send cannot be mixed with an object remove/updates in the same store transaction");
        }
        list.append(entry);
        this.olog.append((UtlListElement)((OrderedEntry)this.orderedEntryPool.get(null)).setEntry(entry, this.currentSavepoint));
    }

    final int createSavepoint() {
        ++this.currentSavepoint;
        return this.currentSavepoint;
    }

    final int getCurrentSavepoint() {
        return this.currentSavepoint;
    }

    final void resetSavepoint(int savepoint) {
        this.currentSavepoint = savepoint;
    }

    final void clear() {
        UtlLinkedHashMap.FastIterator oeListIterator = this.log.fastIterator().toFirst();
        while (oeListIterator.hasNext()) {
            ((ObjectEntriesList)((Object)((Map.Entry)oeListIterator.next()).getValue())).dispose();
        }
        this.log.clear();
        for (OrderedEntry oe = (OrderedEntry)this.olog.first(); oe != null; oe = (OrderedEntry)oe.next()) {
            oe.dispose();
        }
        this.olog.clear();
        this.currentSavepoint = 0;
    }

    @Override
    public final void recordObjectAsDirty(IStoreObject object) {
        if (object == null) {
            throw new IllegalArgumentException("object cannot be null");
        }
        if (object.getBinding() == null) {
            throw new IllegalStateException("object not in a store");
        }
        this.getLog(object, false);
    }

    @Override
    public final <T> void recordFieldUpdate(IStoreObject object, long fieldId, IStoreField<T> field, T fieldVal) {
        if (object == null) {
            throw new IllegalArgumentException("object cannot be null");
        }
        if (object.getBinding() == null) {
            throw new IllegalStateException("object not in a store");
        }
        ObjectEntriesList log = this.getLog(object, false);
        if (log.count() > 0 && ((Entry)log.last()).type == Entry.Type.Remove) {
            throw new IllegalStateException("it is illegal to add a field update operation to the trsnaction log after a remove");
        }
        FieldUpdateEntry entry = (FieldUpdateEntry)this.updateEntryPool.get(null);
        entry.initialize(fieldId, field, fieldVal);
        log.append(entry);
        this.olog.append((UtlListElement)((OrderedEntry)this.orderedEntryPool.get(null)).setEntry(entry, this.currentSavepoint));
    }

    @Override
    public final boolean hasUncommitted() {
        return this.log.size() > 0;
    }

    final void close() {
        this.clear();
        this.putEntryPool.close();
        this.updateEntryPool.close();
        this.removeEntryPool.close();
        this.sendEntryPool.close();
        this.orderedEntryPool.close();
        this.objectEntryListPool.close();
    }

    static {
        if (enableObjectIDMutationProtection) {
            System.err.println("ODS OBJECT ID MUTATION PROTECTION IS ENABLED");
        }
    }

    static final class OrderedEntry
    extends UtlListElement
    implements UtlPool.Item<OrderedEntry> {
        Entry<?> entry;
        UtlPool<OrderedEntry> pool;
        int savepoint = 0;

        OrderedEntry() {
        }

        public final OrderedEntry init() {
            this.entry = null;
            this.savepoint = 0;
            return this;
        }

        public final OrderedEntry setPool(UtlPool<OrderedEntry> pool) {
            this.pool = pool;
            return this;
        }

        public final UtlPool<OrderedEntry> getPool() {
            return this.pool;
        }

        public final OrderedEntry setEntry(Entry<?> entry, int savepointVersion) {
            this.entry = entry;
            this.savepoint = savepointVersion;
            return this;
        }

        public final void dispose() {
            this.entry.dispose();
            this.savepoint = 0;
            this.pool.put((UtlPool.Item)this);
        }

        public static final class Factory
        implements UtlPool.Factory<OrderedEntry> {
            public final OrderedEntry createItem(Object object) {
                return new OrderedEntry();
            }

            public final OrderedEntry[] createItemArray(int size) {
                return new OrderedEntry[size];
            }
        }
    }

    static final class SendEntry
    extends Entry<SendEntry> {
        IStoreObject object;

        SendEntry() {
            super(Entry.Type.Send);
        }

        public final SendEntry init() {
            this.object = null;
            return this;
        }

        public final SendEntry initialize(IStoreObject object) {
            this.object = object;
            return this;
        }

        @Override
        protected final SendEntry asType() {
            return this;
        }

        public static final class Factory
        implements UtlPool.Factory<SendEntry> {
            public final SendEntry createItem(Object object) {
                return new SendEntry();
            }

            public final SendEntry[] createItemArray(int size) {
                return new SendEntry[size];
            }
        }
    }

    static final class FieldUpdateEntry
    extends Entry<FieldUpdateEntry> {
        long fieldId;
        Object fieldVal;
        IStoreField<?> field;

        FieldUpdateEntry() {
            super(Entry.Type.FieldUpdate);
        }

        public final FieldUpdateEntry init() {
            this.fieldId = -1L;
            this.fieldVal = null;
            this.field = null;
            return this;
        }

        public final void initialize(long fieldId, IStoreField<?> field, Object fieldVal) {
            this.fieldId = fieldId;
            this.field = field;
            this.fieldVal = fieldVal;
        }

        @Override
        protected final FieldUpdateEntry asType() {
            return this;
        }

        public final String toString() {
            return "{id=" + this.fieldId + ", val=" + this.fieldVal + "}";
        }

        public static final class Factory
        implements UtlPool.Factory<FieldUpdateEntry> {
            public final FieldUpdateEntry createItem(Object object) {
                return new FieldUpdateEntry();
            }

            public final FieldUpdateEntry[] createItemArray(int size) {
                return new FieldUpdateEntry[size];
            }
        }
    }

    static final class RemoveEntry
    extends Entry<RemoveEntry> {
        IStoreObject object;

        RemoveEntry() {
            super(Entry.Type.Remove);
        }

        public final RemoveEntry initialize(IStoreObject object) {
            this.object = object;
            return this;
        }

        public final RemoveEntry init() {
            this.object = null;
            return this;
        }

        @Override
        protected final RemoveEntry asType() {
            return this;
        }

        public static final class Factory
        implements UtlPool.Factory<RemoveEntry> {
            public final RemoveEntry createItem(Object object) {
                return new RemoveEntry();
            }

            public final RemoveEntry[] createItemArray(int size) {
                return new RemoveEntry[size];
            }
        }
    }

    static final class PutEntry
    extends Entry<PutEntry> {
        PutEntry() {
            super(Entry.Type.Put);
        }

        public final PutEntry init() {
            return this;
        }

        @Override
        protected final PutEntry asType() {
            return this;
        }

        public static final class Factory
        implements UtlPool.Factory<PutEntry> {
            public final PutEntry createItem(Object object) {
                return new PutEntry();
            }

            public final PutEntry[] createItemArray(int size) {
                return new PutEntry[size];
            }
        }
    }

    static abstract class Entry<T extends Entry<T>>
    extends UtlListElement
    implements UtlPool.Item<T> {
        final Type type;
        private UtlPool<T> pool;
        int savepointVersion;

        protected Entry(Type type) {
            this.type = type;
        }

        public final T setPool(UtlPool<T> pool) {
            this.pool = pool;
            return this.asType();
        }

        public final UtlPool<T> getPool() {
            return this.pool;
        }

        protected abstract T asType();

        public final void dispose() {
            this.savepointVersion = 0;
            this.pool.put(this.asType());
        }

        public int getSavepointVersion() {
            return this.savepointVersion;
        }

        static enum Type {
            Put,
            FieldUpdate,
            Remove,
            Send;

        }
    }

    static class ObjectEntriesList
    extends UtlList
    implements UtlPool.Item<ObjectEntriesList> {
        UUID oid;
        UtlPool<ObjectEntriesList> pool;

        ObjectEntriesList(UUID oid) {
            this.oid = oid;
        }

        public final ObjectEntriesList init() {
            this.oid = null;
            this.clear();
            return this;
        }

        public final ObjectEntriesList setPool(UtlPool<ObjectEntriesList> pool) {
            this.pool = pool;
            return this;
        }

        public final UtlPool<ObjectEntriesList> getPool() {
            return this.pool;
        }

        public final void dispose() {
            this.pool.put((UtlPool.Item)this);
        }

        public static final class Factory
        implements UtlPool.Factory<ObjectEntriesList> {
            public final ObjectEntriesList createItem(Object object) {
                return new ObjectEntriesList((UUID)object);
            }

            public final ObjectEntriesList[] createItemArray(int size) {
                return new ObjectEntriesList[size];
            }
        }
    }
}

