/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.event;

import cern.colt.bitvector.BitVector;
import cern.colt.map.OpenIntObjectHashMap;
import com.neeve.config.Config;
import com.neeve.config.IConfigRepository;
import com.neeve.config.IConfigSimpleEntity;
import com.neeve.config.IConfigSimpleEntityContainer;
import com.neeve.event.EEventClassInstantiateException;
import com.neeve.event.EEventClassLoadException;
import com.neeve.event.EEventException;
import com.neeve.event.EEventTypeInvalidException;
import com.neeve.event.Event;
import com.neeve.root.RootObject;
import com.neeve.trace.Tracer;
import com.neeve.util.UtlPool;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;

public final class EventFactory
extends RootObject {
    private final EventTypeTable evTypeTable = new EventTypeTable();
    private static final EventFactory instance;
    private static final boolean shouldPool;

    private EventFactory() {
        super(null);
        Config.setTraceLevel((Tracer)this.tracer, (String)"nv.event.factory.trace");
        this.tracer.bind("nv.event.factory");
        this.initEventTypeInfo();
    }

    public static EventFactory getInstance() {
        return instance;
    }

    private final void registerEventType(EventType evType, boolean byLoader) {
        if (byLoader) {
            this.tracer.log("...Loading (system) event type '" + evType.name + "'...", Tracer.Level.FINE);
        } else {
            this.tracer.log("...Registering (user) event type '" + evType.name + "'...", Tracer.Level.FINE);
        }
        this.tracer.log("......Id=" + evType.id, Tracer.Level.FINE);
        this.tracer.log("......Class='" + evType.className + "'", Tracer.Level.FINE);
        this.tracer.log("......ShouldPool=" + evType.shouldPool, Tracer.Level.FINE);
        this.evTypeTable.put(evType);
    }

    private final void initEventTypeInfo() {
        IConfigRepository repo = Config.getRepository();
        IConfigSimpleEntityContainer container = repo.getSimpleEntityContainer("/events");
        if (container != null) {
            Iterator iterator = container.iterator();
            int numEventTypesLoaded = 0;
            while (iterator.hasNext()) {
                IConfigSimpleEntity entity = (IConfigSimpleEntity)iterator.next();
                short evTypeId = Short.parseShort(entity.getProperty("Id", String.valueOf(0)));
                String className = entity.getProperty("Class", null);
                if (className != null && evTypeId != 0) {
                    boolean shouldPool = Boolean.parseBoolean(entity.getProperty("ShouldPool", "true"));
                    Properties props = (Properties)entity.getProperties().clone();
                    props.remove("Class");
                    props.remove("Id");
                    props.remove("ShouldPool");
                    String evTypeName = entity.getName();
                    this.registerEventType(new EventType(evTypeId, evTypeName, className, shouldPool, props), true);
                    ++numEventTypesLoaded;
                    continue;
                }
                this.tracer.log("Event type '" + entity.getName() + "' configuration error [event type and class name both need to be specified]. The event type '" + entity.getName() + "' will not be loaded.", Tracer.Level.WARNING);
            }
            this.tracer.log("Loaded " + numEventTypesLoaded + " event types.", Tracer.Level.VERBOSE);
        } else {
            this.tracer.log("No event types configured.", Tracer.Level.VERBOSE);
        }
    }

    private final Event createEvent(EventType evType) throws EEventClassLoadException, EEventClassInstantiateException, EEventException {
        if (evType.createMethod == null) {
            Class<?> evClass = null;
            try {
                evClass = Class.forName(evType.className);
            }
            catch (ClassNotFoundException e) {
                throw new EEventClassLoadException("Event  class [" + evType.className + "] could not be found");
            }
            catch (UnsupportedClassVersionError e) {
                throw new EEventClassLoadException("Event  class [" + evType.className + "] is not supported by this VM <version=" + System.getProperty("java.vm.version") + ">");
            }
            try {
                Class[] parameterTypes = new Class[]{Class.forName("java.util.Properties")};
                Method createMethod = evClass.getDeclaredMethod("create", parameterTypes);
                if (!createMethod.isAccessible()) {
                    createMethod.setAccessible(true);
                }
                evType.createMethod = createMethod;
            }
            catch (ClassNotFoundException e) {
                throw new InternalError("Failed to load java.util.Properties during instantiation of event class [" + evType.className + "]");
            }
            catch (SecurityException e) {
                throw new EEventClassInstantiateException("Access to instantiation method in event class [" + evType.className + "] is denied");
            }
            catch (NoSuchMethodException e) {
                throw new EEventClassInstantiateException("Instantiation method in event class [" + evType.className + "] could not be found");
            }
        }
        Event ret = null;
        try {
            try {
                Object[] parameters = new Object[]{evType.props};
                ret = (Event)evType.createMethod.invoke(null, parameters);
                if (ret == null) {
                    throw new EEventClassInstantiateException("Instantiation method in event class [" + evType.className + "] returned a null object");
                }
            }
            catch (ClassCastException e) {
                throw new EEventClassInstantiateException("Instantiation method in event class [" + evType.className + "] returned object of incorrect type");
            }
        }
        catch (IllegalAccessException e) {
            throw new EEventClassInstantiateException("Access to instantiation method in event class [" + evType.className + "] is denied");
        }
        catch (InvocationTargetException e) {
            throw new EEventClassInstantiateException(e.getCause());
        }
        return ret;
    }

    public final void registerEventType(EventType evType) {
        if (evType == null) {
            throw new IllegalArgumentException("event type cannot be null");
        }
        this.registerEventType(evType, false);
    }

    public final EventType getEventType(short id) {
        return this.evTypeTable.get(id);
    }

    public final EventType getEventType(String name) {
        return this.evTypeTable.get(name);
    }

    public final BitVector getRegisteredEventTypes() {
        return this.evTypeTable.getRegistered();
    }

    public final String getEventTypeNameFromId(short id) {
        EventType evType = this.evTypeTable.get(id);
        if (evType != null) {
            return evType.name;
        }
        return "<unknown>";
    }

    public final Event createEvent(short id) throws EEventTypeInvalidException, EEventClassLoadException, EEventClassInstantiateException, EEventException {
        EventType evType = this.evTypeTable.get(id);
        if (evType != null) {
            return evType.createEvent();
        }
        throw new EEventTypeInvalidException(id);
    }

    public final Event createEvent(String name) throws EEventTypeInvalidException, EEventClassLoadException, EEventClassInstantiateException, EEventException {
        EventType evType = this.evTypeTable.get(name);
        if (evType != null) {
            return evType.createEvent();
        }
        throw new EEventTypeInvalidException(name);
    }

    static {
        shouldPool = Config.getValue((String)"nv.event.shouldpool", (boolean)true);
        instance = new EventFactory();
    }

    private final class EventTypeTable {
        private final Map<String, EventType> tableByName = new HashMap<String, EventType>();
        private final OpenIntObjectHashMap tableById = new OpenIntObjectHashMap(65534, 0.0, 0.5);
        private final EventType[] array = new EventType[32768];
        private final BitVector registered = new BitVector(32768);

        EventTypeTable() {
        }

        void put(EventType evType) {
            EventType evTypeCurr = null;
            if (evType.id > 0) {
                evTypeCurr = this.array[evType.id];
                this.array[evType.id] = evType;
            } else {
                evTypeCurr = (EventType)this.tableById.get((int)evType.id);
                this.tableById.put((int)evType.id, (Object)evType);
            }
            if (evTypeCurr != null && !evTypeCurr.name.equals(evType.name)) {
                String str = "Duplicate event type definitions for event type #" + evType.id + ". Event type '" + evType.name + "' is attempting to replace '" + evTypeCurr.name + "'.";
                EventFactory.this.tracer.log(str, Tracer.Level.SEVERE);
                throw new Error(str);
            }
            evTypeCurr = this.tableByName.put(evType.name, evType);
            if (evTypeCurr != null && evTypeCurr.id != evType.id) {
                String str = "Duplicate event type definitions for event '" + evType.name + "'. Event type #" + evType.id + " is attempting to replace #" + evTypeCurr.id + "'.";
                EventFactory.this.tracer.log(str, Tracer.Level.SEVERE);
                throw new Error(str);
            }
            this.registered.set((int)evType.id);
        }

        final EventType get(short evTypeId) {
            EventType evType = null;
            evType = evTypeId > 0 ? this.array[evTypeId] : (EventType)this.tableById.get((int)evTypeId);
            return evType;
        }

        final EventType get(String evTypeName) {
            return this.tableByName.get(evTypeName);
        }

        final BitVector getRegistered() {
            return this.registered;
        }
    }

    public static final class EventType {
        private final Factory factory;
        private final UtlPool<Event> pool;
        final short id;
        final String name;
        final String className;
        final boolean shouldPool;
        final Properties props;
        Method createMethod;

        private EventType(short id, String name, String className, boolean shouldPool, Properties props) {
            this.id = id;
            this.name = name;
            this.className = className;
            this.props = props != null && props.size() > 0 ? props : null;
            this.createMethod = null;
            shouldPool = shouldPool && Config.getValue((String)("nv.event." + name + ".shouldpool"), (boolean)true) && shouldPool;
            boolean threadedPool = Config.getValue((String)("nv.event." + name + ".threadedpool"), (boolean)true);
            this.factory = new Factory();
            this.pool = shouldPool ? UtlPool.create((String)"event", (String)name, (UtlPool.Factory)this.factory, (UtlPool.Params)UtlPool.Params.create().setThreaded(threadedPool)) : null;
            this.shouldPool = shouldPool;
        }

        public static final EventType create(short id, String name, String className, boolean shouldPool, Properties props) {
            if (id == 0) {
                throw new IllegalArgumentException("id cannot be 0");
            }
            if (name == null) {
                throw new IllegalArgumentException("name cannot be null");
            }
            if (className == null) {
                throw new IllegalArgumentException("event class name cannot be null");
            }
            return new EventType(id, name, className, shouldPool, props);
        }

        final Event createEvent() {
            return this.pool != null ? (Event)this.pool.get(null) : this.factory.createItem(null);
        }

        public final String getName() {
            return this.name;
        }

        public final boolean isPooled() {
            return this.pool != null;
        }

        public final UtlPool<Event> getPool() {
            return this.pool;
        }

        private final class Factory
        implements UtlPool.Factory<Event> {
            EventFactory evFactory;

            private Factory() {
            }

            public final Event createItem(Object object) {
                if (this.evFactory == null) {
                    this.evFactory = EventFactory.getInstance();
                }
                return this.evFactory.createEvent(EventType.this);
            }

            public final Event[] createItemArray(int size) {
                return new Event[size];
            }
        }
    }
}

