/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.util;

public class UtlReadWriteLock {
    private int lockCount;
    private int waitingWriters;
    private Thread writeLockOwner;
    private Object mutex = new Object();

    private UtlReadWriteLock(String name) {
    }

    public static UtlReadWriteLock create(String name) {
        return new UtlReadWriteLock(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void getReadLock() throws InterruptedException {
        Object object = this.mutex;
        synchronized (object) {
            while (this.lockCount < 0 || this.waitingWriters != 0) {
                this.mutex.wait();
            }
            ++this.lockCount;
        }
    }

    public final void getReadLockUninterrupted() {
        while (true) {
            try {
                this.getReadLock();
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void getWriteLock() throws InterruptedException {
        Object object = this.mutex;
        synchronized (object) {
            if (this.writeLockOwner != null && this.writeLockOwner == Thread.currentThread()) {
                --this.lockCount;
                return;
            }
            ++this.waitingWriters;
            while (this.lockCount != 0) {
                try {
                    this.mutex.wait();
                }
                catch (InterruptedException ie) {
                    --this.waitingWriters;
                    this.mutex.notifyAll();
                    throw ie;
                }
            }
            this.writeLockOwner = Thread.currentThread();
            --this.waitingWriters;
            this.lockCount = -1;
        }
    }

    public final void getWriteLockUninterrupted() {
        while (true) {
            try {
                this.getWriteLock();
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void releaseLock() {
        Object object = this.mutex;
        synchronized (object) {
            if (this.lockCount == 0) {
                return;
            }
            if (this.lockCount < 0) {
                ++this.lockCount;
                if (this.lockCount != 0) return;
                this.writeLockOwner = null;
            } else {
                --this.lockCount;
            }
            this.mutex.notifyAll();
            return;
        }
    }
}

