/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.trace;

import java.util.Properties;
import java.util.StringTokenizer;

final class TracerDescriptor {
    final String type;
    final String config;
    final Properties props;
    static final String SEPARATOR_STR = "://";

    private TracerDescriptor(String descriptor, Properties props) throws IllegalArgumentException {
        if (descriptor == null) {
            throw new IllegalArgumentException("descriptor cannot be null");
        }
        int index = -1;
        int s = 0;
        for (int i = 0; i < descriptor.length(); ++i) {
            s = descriptor.charAt(i) == SEPARATOR_STR.charAt(s) ? ++s : 0;
            if (s != SEPARATOR_STR.length()) continue;
            index = i - SEPARATOR_STR.length() + 1;
            break;
        }
        if (index <= 0) {
            throw new IllegalArgumentException("Descriptor must of of format [type]://[config], but was '" + descriptor + "'");
        }
        this.type = descriptor.subSequence(0, index).toString().trim();
        this.config = descriptor.subSequence(index + SEPARATOR_STR.length(), descriptor.length()).toString().trim();
        this.props = props == null ? new Properties() : (Properties)props.clone();
        String str = this.config;
        StringTokenizer tokenizer = new StringTokenizer(str, "&", false);
        while (tokenizer.hasMoreTokens()) {
            String propVal = tokenizer.nextToken();
            StringTokenizer propValTokenizer = new StringTokenizer(propVal, "=", false);
            if (propValTokenizer.countTokens() == 2) {
                String prop = propValTokenizer.nextToken();
                String val = propValTokenizer.nextToken();
                this.props.put(prop, val);
                continue;
            }
            throw new IllegalArgumentException(descriptor);
        }
    }

    static TracerDescriptor parse(String descriptor, Properties props) throws IllegalArgumentException {
        return new TracerDescriptor(descriptor, props);
    }
}

