/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.config.impl.pft;

import com.neeve.config.Config;
import com.neeve.config.EConfigException;
import com.neeve.config.IConfigComplexEntityContainer;
import com.neeve.config.IConfigEntity;
import com.neeve.config.IConfigEntityContainer;
import com.neeve.config.IConfigSimpleEntityContainer;
import com.neeve.config.impl.ConfigRepositoryBase;
import com.neeve.config.impl.pft.PftConfigComplexEntity;
import com.neeve.config.impl.pft.PftConfigComplexEntityContainer;
import com.neeve.config.impl.pft.PftConfigSimpleEntity;
import com.neeve.config.impl.pft.PftConfigSimpleEntityContainer;
import com.neeve.trace.Tracer;
import com.neeve.util.UtlAddressDescriptor;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;

public final class PftConfigRepository
extends ConfigRepositoryBase {
    private final File root;

    PftConfigRepository(UtlAddressDescriptor descriptor, CreateMode createMode) throws EConfigException {
        super(descriptor);
        this.root = new File(descriptor.address.compareToIgnoreCase(".") == 0 ? Config.getConfigDirectory() : descriptor.address);
        if (this.tracer.debug) {
            this.tracer.log("Repository root=" + this.root, Tracer.Level.DEBUG);
        }
        File rootMarker = new File(this.root + "/.nvx.repository.root");
        switch (createMode) {
            case Create: {
                if (this.root.exists() && rootMarker.exists()) {
                    throw new EConfigException("'" + this.root + "' is already a repository");
                }
                if (!this.root.exists()) {
                    this.root.mkdirs();
                }
                try {
                    rootMarker.createNewFile();
                }
                catch (IOException e) {
                    throw new EConfigException(e);
                }
                this.parseDirectoryForEntityContainer(this.root, "");
                if (!this.tracer.debug) break;
                this.tracer.log("Created repository:\n" + this, Tracer.Level.DEBUG);
                break;
            }
            case Open: {
                if (!this.root.exists() || !rootMarker.exists()) {
                    throw new EConfigException("'" + this.root + "' is not a valid repository");
                }
                this.parseDirectoryForEntityContainer(this.root, "");
                if (!this.tracer.debug) break;
                this.tracer.log("Loaded repository:\n" + this, Tracer.Level.DEBUG);
            }
        }
    }

    private final boolean isEntityContainer(File dir, Properties props) throws EConfigException {
        File file = new File(dir + "/.nvx.repository.entitycontainer");
        if (file.exists()) {
            FileReader reader = null;
            try {
                reader = new FileReader(file);
                props.load(reader);
                boolean bl = true;
                return bl;
            }
            catch (Exception e) {
                throw new EConfigException("Failed to load entity container properties <file='" + file + "'> [" + e.toString() + "]");
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
        return false;
    }

    private final boolean isComplexEntity(File dir) {
        File file = new File(dir + "/.nvx.repository.complexentity");
        return file.exists();
    }

    private final boolean isSimpleContainer(Properties props) {
        String type = props.getProperty("Type");
        return type != null && type.compareToIgnoreCase("simple") == 0;
    }

    private final boolean isComplexContainer(Properties props) {
        String type = props.getProperty("Type");
        return type != null && type.compareToIgnoreCase("complex") == 0;
    }

    private final void setEntityPropertiesFromFile(PftConfigSimpleEntity entity, File file) throws EConfigException {
        InputStreamReader reader = null;
        try {
            Properties props = new Properties();
            reader = new FileReader(file);
            props.load(reader);
            if (this.tracer.debug) {
                this.tracer.log("...Setting properties " + props + " in simple entity's property set...", Tracer.Level.DEBUG);
            }
            entity.setProperties(props);
        }
        catch (Exception e) {
            throw new EConfigException("Failure in loading entity " + entity + " properties from file '" + file + "' [" + e.toString() + "]");
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private final void setEntityPropertiesFromFile(PftConfigComplexEntity entity, String setname, File file) throws EConfigException {
        InputStreamReader reader = null;
        try {
            Properties props = new Properties();
            reader = new FileReader(file);
            props.load(reader);
            if (this.tracer.debug) {
                this.tracer.log("...Setting properties " + props + " in entity's " + (setname == null ? "default" : "'" + setname + "'") + " property set...", Tracer.Level.DEBUG);
            }
            entity.setProperties(setname, props);
        }
        catch (Exception e) {
            throw new EConfigException("Failure in loading entity " + entity + " properties from file '" + file + "' [" + e.toString() + "]");
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void parseSimpleEntityContainerDirectory(File dir, String address) throws EConfigException {
        PftConfigSimpleEntityContainer container;
        try {
            container = (PftConfigSimpleEntityContainer)this.createSimpleEntityContainerObject(address, false);
        }
        catch (EConfigException e) {
            throw new EConfigException("Repository corrupt. Could not create simple entity container object for directory '" + dir + "' [" + e.toString() + "]");
        }
        try {
            if (this.tracer.debug) {
                this.tracer.log("Creating simple entities from files...", Tracer.Level.DEBUG);
            }
            File[] files = dir.listFiles();
            for (int i = 0; i < files.length; ++i) {
                if (!files[i].isDirectory()) {
                    if (files[i].getName().compareToIgnoreCase(".nvx.repository.entitycontainer") == 0) continue;
                    PftConfigSimpleEntity entity = (PftConfigSimpleEntity)container.createEntity(files[i].getName());
                    if (this.tracer.debug) {
                        this.tracer.log("Created simple entity " + entity + ".", Tracer.Level.DEBUG);
                    }
                    try {
                        this.setEntityPropertiesFromFile(entity, files[i]);
                        continue;
                    }
                    finally {
                        entity.setDirty(false);
                    }
                }
                if (this.tracer.debug) {
                    this.tracer.log("'" + files[i].getName() + "' is a subdirectory. Recursing into it parsing for entity container...", Tracer.Level.DEBUG);
                }
                this.parseDirectoryForEntityContainer(files[i], address + "/" + files[i].getName());
            }
        }
        finally {
            container.setDirty(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void parseComplexEntityContainerDirectory(File dir, String address) throws EConfigException {
        PftConfigComplexEntityContainer container;
        try {
            container = (PftConfigComplexEntityContainer)this.createComplexEntityContainerObject(address, false);
        }
        catch (EConfigException e) {
            throw new EConfigException("Repository corrupt. Could not create complex entity container object for directory '" + dir + "' [" + e.toString() + "]");
        }
        try {
            if (this.tracer.debug) {
                this.tracer.log("Creating complex entities from subdirectories...", Tracer.Level.DEBUG);
            }
            File[] files = dir.listFiles();
            for (int i = 0; i < files.length; ++i) {
                if (files[i].isDirectory()) {
                    if (this.isComplexEntity(files[i])) {
                        PftConfigComplexEntity entity = (PftConfigComplexEntity)container.createEntity(files[i].getName());
                        if (this.tracer.debug) {
                            this.tracer.log("Subdirectory is a complex entity. Created complex entity " + entity + ".", Tracer.Level.DEBUG);
                        }
                        try {
                            File[] propfiles = files[i].listFiles();
                            for (int j = 0; j < propfiles.length; ++j) {
                                if (propfiles[j].isDirectory()) {
                                    if (this.tracer.debug) {
                                        this.tracer.log("'" + propfiles[j].getName() + "' is a subdirectory. Recursing into it parsing for sub-entity container...", Tracer.Level.DEBUG);
                                    }
                                    this.parseDirectoryForEntityContainer(propfiles[j], container.getAddress() + "/" + files[i].getName() + "/" + propfiles[j].getName());
                                    continue;
                                }
                                if (propfiles[j].getName().compareToIgnoreCase(".nvx.repository.complexentity") == 0) continue;
                                if (this.tracer.debug) {
                                    this.tracer.log("'" + propfiles[j].getName() + "' is a file. Treating as property file and loading into entity...", Tracer.Level.DEBUG);
                                }
                                this.setEntityPropertiesFromFile(entity, propfiles[j].getName(), propfiles[j]);
                            }
                            continue;
                        }
                        finally {
                            entity.setDirty(false);
                        }
                    }
                    if (this.tracer.debug) {
                        this.tracer.log("Subdirectory is not a complex entity. Recursing into it parsing for entity container...", Tracer.Level.DEBUG);
                    }
                    this.parseDirectoryForEntityContainer(files[i], address + "/" + files[i].getName());
                    continue;
                }
                if (!this.tracer.debug) continue;
                this.tracer.log("'" + files[i].getName() + "' is a file. Ignoring it...", Tracer.Level.DEBUG);
            }
        }
        finally {
            container.setDirty(false);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void parseDirectoryForEntityContainer(File dir, String address) throws EConfigException {
        Properties props;
        if (this.tracer.debug) {
            this.tracer.log("Parsing directory '" + dir + "' for entity container <address='" + address + "'>...", Tracer.Level.DEBUG);
        }
        if (this.isEntityContainer(dir, props = new Properties())) {
            if (this.isSimpleContainer(props)) {
                if (this.tracer.debug) {
                    this.tracer.log("Directory is a simple entity container.", Tracer.Level.DEBUG);
                }
                this.parseSimpleEntityContainerDirectory(dir, address);
                return;
            } else {
                if (!this.isComplexContainer(props)) throw new EConfigException("Repository corrupt. Invalid type for entity container '" + address + "'");
                if (this.tracer.debug) {
                    this.tracer.log("Directory is a complex entity container.", Tracer.Level.DEBUG);
                }
                this.parseComplexEntityContainerDirectory(dir, address);
            }
            return;
        } else {
            if (this.tracer.debug) {
                this.tracer.log("Directory is not entity container. Parsing sub-directories for entity containers...", Tracer.Level.DEBUG);
            }
            File[] files = dir.listFiles();
            for (int i = 0; i < files.length; ++i) {
                if (files[i].getName().compareToIgnoreCase(".nvx.repository.root") == 0) continue;
                if (files[i].isDirectory()) {
                    if (this.tracer.debug) {
                        this.tracer.log("'" + files[i].getName() + "' is a subdirectory. Recursing into it parsing for entity container...", Tracer.Level.DEBUG);
                    }
                    this.parseDirectoryForEntityContainer(files[i], address + "/" + files[i].getName());
                    continue;
                }
                if (!this.tracer.debug) continue;
                this.tracer.log("'" + files[i].getName() + "' is a file. Ignoring.", Tracer.Level.DEBUG);
            }
        }
    }

    private final boolean createEntityContainerDirectory(File dir, boolean simple) throws EConfigException {
        File file1 = new File(dir + "/.nvx.repository.entitycontainer");
        File file2 = new File(dir + "/.nvx.repository.complexentity");
        if (!file1.exists() || file2.exists()) {
            if (dir.exists() || dir.mkdirs()) {
                Properties props = new Properties();
                props.setProperty("Type", simple ? "simple" : "complex");
                try {
                    FileWriter writer = new FileWriter(file1);
                    try {
                        props.store(writer, "");
                    }
                    catch (IOException e) {
                        throw new EConfigException("I/O failure while writing container metafile '" + file1 + "' [" + e.toString() + "']");
                    }
                    finally {
                        try {
                            writer.close();
                        }
                        catch (Exception exception) {}
                    }
                    return true;
                }
                catch (IOException e) {
                    throw new EConfigException("I/O failure while writing container metafile '" + file1 + "' [" + e.toString() + "']");
                }
            }
            throw new EConfigException("Unable to create container directory '" + dir + "'");
        }
        return false;
    }

    private final void createSimpleEntityContainerDirectory(PftConfigSimpleEntityContainer container) throws EConfigException {
        File dir = new File(this.root + container.getAddress());
        if (this.tracer.debug) {
            this.tracer.log("Creating a simple entity container <address='" + container.getAddress() + "'> in directory '" + dir + "'...", Tracer.Level.DEBUG);
        }
        if (!this.createEntityContainerDirectory(dir, true)) {
            throw new InternalError("Request to create a simple entity container <address='" + container.getAddress() + "'> in a directory '" + dir + "' that is already a container or entity.");
        }
    }

    private final void createComplexEntityContainerDirectory(PftConfigComplexEntityContainer container) throws EConfigException {
        File dir = new File(this.root + container.getAddress());
        if (this.tracer.debug) {
            this.tracer.log("Creating a complex entity container <address='" + container.getAddress() + "'> in directory '" + dir + "'...", Tracer.Level.DEBUG);
        }
        if (!this.createEntityContainerDirectory(dir, false)) {
            throw new InternalError("Request to create a complex entity container <address='" + container.getAddress() + "'> in a directory '" + dir + "' that is already a container or entity.");
        }
    }

    private final void clearSimpleEntityContainerDirectory(PftConfigSimpleEntityContainer container) throws EConfigException {
        File dir = new File(this.root + container.getAddress());
        Properties props = new Properties();
        if (this.tracer.debug) {
            this.tracer.log("Validating directory '" + dir + "' is simple entity container <address='" + container.getAddress() + "'>...", Tracer.Level.DEBUG);
        }
        if (this.isEntityContainer(dir, props) && this.isSimpleContainer(props)) {
            if (this.tracer.debug) {
                this.tracer.log("Deleting simple entities files...", Tracer.Level.DEBUG);
            }
            File[] files = dir.listFiles();
            for (int i = 0; i < files.length; ++i) {
                if (!files[i].isDirectory()) {
                    if (files[i].getName().compareToIgnoreCase(".nvx.repository.entitycontainer") == 0) continue;
                    if (this.tracer.debug) {
                        this.tracer.log("'" + files[i].getName() + "' is a file. Deleting...", Tracer.Level.DEBUG);
                    }
                    files[i].delete();
                    continue;
                }
                if (!this.tracer.debug) continue;
                this.tracer.log("'" + files[i].getName() + "' is a subdirectory. Ignoring...", Tracer.Level.DEBUG);
            }
        } else {
            throw new InternalError("Request to clear a simple entity container <address='" + container.getAddress() + "'> from a directory '" + dir + "' that is not a simple container.");
        }
    }

    private final void clearComplexEntityContainerDirectory(PftConfigComplexEntityContainer container) throws EConfigException {
        File dir = new File(this.root + container.getAddress());
        Properties props = new Properties();
        if (this.tracer.debug) {
            this.tracer.log("Validating directory '" + dir + "' is complex entity container <address='" + container.getAddress() + "'>...", Tracer.Level.DEBUG);
        }
        if (this.isEntityContainer(dir, props) && this.isComplexContainer(props)) {
            if (this.tracer.debug) {
                this.tracer.log("Deleting files in complex entity directories...", Tracer.Level.DEBUG);
            }
            File[] files = dir.listFiles();
            for (int i = 0; i < files.length; ++i) {
                if (files[i].isDirectory()) {
                    if (this.tracer.debug) {
                        this.tracer.log("Deleting files in " + files[i] + "...", Tracer.Level.DEBUG);
                    }
                    File[] propfiles = files[i].listFiles();
                    for (int j = 0; j < propfiles.length; ++j) {
                        if (propfiles[j].isDirectory()) {
                            if (!this.tracer.debug) continue;
                            this.tracer.log("'" + propfiles[j].getName() + "' is a subdirectory. Ignoring (empty dirs will be cleared later)...", Tracer.Level.DEBUG);
                            continue;
                        }
                        if (this.tracer.debug) {
                            this.tracer.log("'" + propfiles[j].getName() + "' is a file. Deleting...", Tracer.Level.DEBUG);
                        }
                        propfiles[j].delete();
                    }
                    continue;
                }
                if (!this.tracer.debug) continue;
                this.tracer.log("'" + files[i].getName() + "' is a file. Ignoring it...", Tracer.Level.DEBUG);
            }
        } else {
            throw new InternalError("Request to clear a complex entity container <address='" + container.getAddress() + "'> from a directory '" + dir + "' that is not a complex container.");
        }
    }

    private final void saveEntityPropertiesToFile(IConfigEntity entity, Properties props, File file) throws EConfigException {
        try {
            FileWriter writer = new FileWriter(file);
            try {
                props.store(writer, "Configuration descriptor for '" + entity.getAddress() + "'");
            }
            catch (IOException e) {
                throw new EConfigException("I/O failure while writing simple entity's <'" + entity.getAddress() + "'> configuration file '" + file + "' [" + e.toString() + "']");
            }
            finally {
                try {
                    writer.close();
                }
                catch (Exception exception) {}
            }
        }
        catch (IOException e) {
            throw new EConfigException("I/O failure while creating simple entity's <'" + entity.getAddress() + "'> configuration file '" + file + "' [" + e.toString() + "']");
        }
    }

    private final void saveSimpleEntity(PftConfigSimpleEntity entity) throws EConfigException {
        File file = new File(this.root + entity.getAddress());
        if (this.tracer.debug) {
            this.tracer.log("Saving simple entity's <'" + entity.getAddress() + "'> property set <file='" + file + "'>...", Tracer.Level.DEBUG);
        }
        this.saveEntityPropertiesToFile(entity, entity.getProperties(), file);
    }

    private final void checkAndCreateComplexEntity(File dir) throws EConfigException {
        block13: {
            File file = new File(dir + "/.nvx.repository.complexentity");
            if (!file.exists()) {
                if (dir.exists() || dir.mkdirs()) {
                    Properties props = new Properties();
                    try {
                        FileWriter writer = new FileWriter(file);
                        try {
                            props.store(writer, "");
                            break block13;
                        }
                        catch (IOException e) {
                            throw new EConfigException("I/O failure while writing complex entity metafile '" + file + "' [" + e.toString() + "']");
                        }
                        finally {
                            try {
                                writer.close();
                            }
                            catch (Exception exception) {}
                        }
                    }
                    catch (IOException e) {
                        throw new EConfigException("I/O failure while writing complex entity metafile '" + file + "' [" + e.toString() + "']");
                    }
                }
                throw new EConfigException("Unable to create complex entity directory '" + dir + "'");
            }
        }
    }

    private final void saveComplexEntity(PftConfigComplexEntity entity) throws EConfigException {
        File dir = new File(this.root + entity.getAddress());
        this.checkAndCreateComplexEntity(dir);
        if (this.tracer.debug) {
            this.tracer.log("Saving complex entity's <'" + entity.getAddress() + "'> property sets...", Tracer.Level.DEBUG);
        }
        Iterator<String> iterator = entity.names();
        while (iterator.hasNext()) {
            String name = iterator.next();
            File file = new File(dir + "/" + name);
            if (this.tracer.debug) {
                this.tracer.log("Saving complex entity's <'" + entity.getAddress() + "'> property set <'" + name + "'> <file='" + file + "'>...", Tracer.Level.DEBUG);
            }
            this.saveEntityPropertiesToFile(entity, entity.getProperties(name), file);
        }
    }

    static final boolean exists(UtlAddressDescriptor descriptor) {
        File root = new File(descriptor.address.compareToIgnoreCase(".") == 0 ? Config.getConfigDirectory() : descriptor.address);
        File rootMarker = new File(root + "/.nvx.repository.root");
        return root.exists() && rootMarker.exists();
    }

    @Override
    protected final IConfigSimpleEntityContainer doCreateSimpleEntityContainer(String address) throws EConfigException {
        return new PftConfigSimpleEntityContainer(this, address);
    }

    @Override
    protected final IConfigComplexEntityContainer doCreateComplexEntityContainer(String address) throws EConfigException {
        return new PftConfigComplexEntityContainer(this, address);
    }

    @Override
    protected final void doCommitStart() throws EConfigException {
    }

    @Override
    protected final void doCreateContainers(Set<IConfigEntityContainer<? extends IConfigEntity>> containers) throws EConfigException {
        for (IConfigEntityContainer<? extends IConfigEntity> container : containers) {
            if (container instanceof PftConfigSimpleEntityContainer) {
                this.createSimpleEntityContainerDirectory((PftConfigSimpleEntityContainer)container);
                continue;
            }
            if (container instanceof PftConfigComplexEntityContainer) {
                this.createComplexEntityContainerDirectory((PftConfigComplexEntityContainer)container);
                continue;
            }
            throw new EConfigException("Unknown entity container type");
        }
    }

    @Override
    protected final void doClearContainers(Set<IConfigEntityContainer<? extends IConfigEntity>> containers) throws EConfigException {
        for (IConfigEntityContainer<? extends IConfigEntity> container : containers) {
            if (container instanceof PftConfigSimpleEntityContainer) {
                this.clearSimpleEntityContainerDirectory((PftConfigSimpleEntityContainer)container);
                continue;
            }
            if (container instanceof PftConfigComplexEntityContainer) {
                this.clearComplexEntityContainerDirectory((PftConfigComplexEntityContainer)container);
                continue;
            }
            throw new EConfigException("Unknown entity container type");
        }
    }

    @Override
    protected final void doDeleteContainers(Set<IConfigEntityContainer<? extends IConfigEntity>> containers) throws EConfigException {
        this.doClearContainers(containers);
        for (IConfigEntityContainer<? extends IConfigEntity> container : containers) {
            File dir = new File(this.root + container.getAddress());
            if (this.tracer.debug) {
                this.tracer.log("Deleting entity container <address='" + container.getAddress() + "'> from directory '" + dir + "'...", Tracer.Level.DEBUG);
            }
            File file = new File(dir + "/.nvx.repository.entitycontainer");
            if (this.tracer.debug) {
                this.tracer.log("...Deleting container metafile '" + file + "'...", Tracer.Level.DEBUG);
            }
            file.delete();
        }
    }

    @Override
    protected final void doSaveEntities(Set<IConfigEntity> entities) throws EConfigException {
        for (IConfigEntity entity : entities) {
            if (entity instanceof PftConfigSimpleEntity) {
                this.saveSimpleEntity((PftConfigSimpleEntity)entity);
                continue;
            }
            if (entity instanceof PftConfigComplexEntity) {
                this.saveComplexEntity((PftConfigComplexEntity)entity);
                continue;
            }
            throw new EConfigException("Unknown entity type");
        }
    }

    @Override
    protected final void doCommitEnd() throws EConfigException {
    }

    @Override
    protected final void doClose() throws EConfigException {
    }

    static enum CreateMode {
        Create,
        Open;

    }
}

