/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.config;

import com.neeve.config.ConfigRepositoryFactory;
import com.neeve.config.EConfigException;
import com.neeve.config.IConfigRepository;
import com.neeve.config.IConfigSimpleEntity;
import com.neeve.env.Env;
import com.neeve.trace.Tracer;
import com.neeve.trace.TracerRegistry;
import com.neeve.util.UtlLinkedHashMap;
import com.neeve.util.UtlPlatform;
import com.neeve.util.UtlProps;
import com.neeve.util.UtlThrowable;
import java.io.File;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public final class Config {
    private static final String CONFIG_ENVCONTAINER_NAME = "/env";
    private static final String CONFIG_ENVENTITY_NAME = "default";
    private static final Properties bootstrapEnv = new Properties();
    private static final Set<String> bootstrapEnvAccessed = new HashSet<String>();
    private static final Map<String, String> bootstrapEnvAccessedStackTraces = new HashMap<String, String>();
    private static final Properties env = new Properties();
    private static boolean allowDuplicateEnvironmentInitialization;
    private static String lastInitializerThreadContext;
    private static State state;
    private static boolean debugEarlyAccess;
    private static boolean checked;
    private static PerformanceTuning performanceTuning;
    private static boolean conserveMemory;
    private static boolean conserveCPU;
    private static boolean disableDisruptorWaitStrategyOptimizations;
    public static final String CONFIG_ENVENTITY_FULLNAME = "/env/default";

    private static final void state(State val) {
        state = val;
    }

    private static final Properties toProps(Map<String, Object> map) {
        Properties props = new Properties();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (!(value instanceof String)) continue;
            props.setProperty(key, (String)value);
        }
        return props;
    }

    private static final Map<String, Object> toMap(Properties props) {
        UtlLinkedHashMap<String, Object> map = new UtlLinkedHashMap<String, Object>();
        Enumeration<?> e = props.propertyNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            map.put(key, props.getProperty(key));
        }
        return map;
    }

    private static final Set<String> keysAsSet(Properties props) {
        HashSet<String> set = new HashSet<String>();
        Enumeration<?> e = props.propertyNames();
        while (e.hasMoreElements()) {
            set.add((String)e.nextElement());
        }
        return set;
    }

    private static final synchronized void updateCachedProps() {
        boolean defaultCheckedValue;
        boolean bl = debugEarlyAccess = Config.hasValue("nv.config.debugearlyaccess") ? Config.getValue("nv.config.debugearlyaccess", false) : false;
        String performanceTuningStr = Config.hasValue("nv.tuning.performance") ? Config.getValue("nv.tuning.performance") : (Config.hasValue("nv.optimizefor") ? Config.getValue("nv.optimizefor") : null);
        try {
            performanceTuning = performanceTuningStr != null ? PerformanceTuning.valueOf(performanceTuningStr) : null;
        }
        catch (Exception e) {
            System.err.println("Invalid global performance tuning setting '" + performanceTuningStr + "'. Defaulting to none");
        }
        boolean bl2 = Config.hasValue("nv.tuning.memory.conserve") ? Config.getValue("nv.tuning.memory.conserve", false) : (conserveMemory = Config.hasValue("nv.optimizeMemoryUsage") ? Config.getValue("nv.optimizeMemoryUsage", false) : false);
        boolean bl3 = Config.hasValue("nv.tuning.disabledisruptorwaitstrategyoptimizations") ? Config.getValue("nv.tuning.disabledisruptorwaitstrategyoptimizations", false) : (disableDisruptorWaitStrategyOptimizations = Config.hasValue("nv.disabledisruptorwaitstrategyoptimizations") ? Config.getValue("nv.disabledisruptorwaitstrategyoptimizations", false) : false);
        conserveCPU = Config.hasValue("nv.tuning.cpu.conserve") ? Config.getValue("nv.tuning.cpu.conserve", false) : (Config.hasValue("nv.conservecpu") ? Config.getValue("nv.conservecpu", false) : false);
        boolean bl4 = defaultCheckedValue = !Config.optimizeForLatency() && !Config.optimizeForThroughput() && !Config.conserveMemory();
        checked = Config.hasValue("nv.tuning.checked") ? Config.getValue("nv.tuning.checked", defaultCheckedValue) : (Config.hasValue("nv.checked") ? Config.getValue("nv.checked", defaultCheckedValue) : defaultCheckedValue);
    }

    private static final Properties env() {
        switch (state) {
            case PREBOOTSTRAP: {
                bootstrapEnv.putAll((Map<?, ?>)Config.toProps(Env.getBootstrapEnvironment()));
                Config.state(State.BOOTSTRAP);
                Config.updateCachedProps();
                return bootstrapEnv;
            }
            case BOOTSTRAP: {
                return bootstrapEnv;
            }
            case INITIALIZED: {
                return env;
            }
        }
        throw new InternalError("unknown state '" + (Object)((Object)state) + "'");
    }

    private static final void getChangedPropertiesBetweenBootstrapAndInitializedEnv(Set<String> changedProps) {
        for (String propName : bootstrapEnvAccessed) {
            if (bootstrapEnv.containsKey(propName) == env.containsKey(propName) && (!bootstrapEnv.containsKey(propName) || bootstrapEnv.getProperty(propName).equals(env.getProperty(propName))) && (!env.containsKey(propName) || env.getProperty(propName).equals(bootstrapEnv.getProperty(propName)))) continue;
            changedProps.add(propName);
        }
    }

    public static final synchronized void allowDuplicateEnvironmentInitialization(boolean val) {
        if (state == State.INITIALIZED) {
            throw new IllegalStateException("config environment has already been initialized");
        }
        allowDuplicateEnvironmentInitialization = val;
    }

    public static final synchronized Set<String> initializeEnvironment(Properties props) {
        if (!allowDuplicateEnvironmentInitialization && state == State.INITIALIZED) {
            String thisInitializerThreadContext = UtlThrowable.prepareStackTrace(new Exception("Initializing Thread: " + Thread.currentThread().getName()));
            String err = "*****\nFATAL ERROR: Duplicate initialization of configuration environment: [\nLast inititializer:\n" + lastInitializerThreadContext + "'\nThis initializer:\n" + thisInitializerThreadContext + "\n]\n*****";
            System.err.println(err);
            throw new IllegalStateException(err);
        }
        lastInitializerThreadContext = UtlThrowable.prepareStackTrace(new Exception("Initializing Thread: " + Thread.currentThread().getName()));
        env.putAll((Map<?, ?>)Config.toProps(Env.getBootstrapEnvironment()));
        env.putAll((Map<?, ?>)Config.getRepository().getSimpleEntity(CONFIG_ENVENTITY_FULLNAME).getProperties());
        if (props != null) {
            env.putAll((Map<?, ?>)props);
        }
        Env.setEnvironment(Config.toMap(env));
        HashSet<String> changedProps = new HashSet<String>();
        if (bootstrapEnv != null) {
            boolean dumpIfPropsChanged = UtlProps.getValue(env, "nv.config.erronearlyaccess", false);
            Config.getChangedPropertiesBetweenBootstrapAndInitializedEnv(changedProps);
            if (changedProps.size() > 0) {
                StringBuilder sb = new StringBuilder();
                sb.append("*****\n").append(dumpIfPropsChanged ? "FATAL ERROR" : "WARNING").append(": The following properties were accessed during the bootstrap state but changed after initialization of the configuration environment:").append("\n");
                for (String propName : changedProps) {
                    sb.append("...").append(propName).append(" (").append(bootstrapEnv.getProperty(propName)).append("->").append(env.getProperty(propName)).append(")\n");
                    if (!debugEarlyAccess) continue;
                    sb.append("......").append(" was last accessed during bootstrap at ").append(bootstrapEnvAccessedStackTraces.get(propName)).append("\n");
                }
                sb.append("*****");
                System.err.println(sb.toString());
                if (dumpIfPropsChanged) {
                    throw new IllegalStateException("some properties were accessed during the bootstrap state but changed after initialization of the configuration environment");
                }
            }
        }
        Config.state(State.INITIALIZED);
        TracerRegistry.getInstance().clear();
        Config.updateCachedProps();
        return changedProps;
    }

    public static final void initializeEnvironment() {
        Config.initializeEnvironment(null);
    }

    public static final State getState() {
        return state;
    }

    public static final Tracer.Level getTraceLevel(String prop, Tracer.Level defaultLevel) {
        Tracer.Level level = defaultLevel;
        String levelStr = Config.getValue(prop);
        if (levelStr != null) {
            try {
                level = Tracer.getLevel(levelStr);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return level;
    }

    public static final Tracer.Level getTraceLevel(String prop) {
        return Config.getTraceLevel(prop, Tracer.defaultLevel);
    }

    public static final void setTraceLevel(Tracer tracer, String prop, Tracer.Level defaultLevel) {
        tracer.setLevel(Config.getTraceLevel(prop, defaultLevel));
    }

    public static final void setTraceLevel(Tracer tracer, String prop) {
        Config.setTraceLevel(tracer, prop, tracer.getLevel());
    }

    public static final Set<String> getPropertyNames() {
        return Config.keysAsSet(Config.env());
    }

    public static final Properties getPropertiesTo(Properties props) {
        if (props == null) {
            throw new IllegalArgumentException("supplied properties table cannot be null");
        }
        props.putAll((Map<?, ?>)Config.env());
        return props;
    }

    public static final Properties getPropertiesCopy() {
        return Config.getPropertiesTo(new Properties());
    }

    public static final boolean hasValue(String name) {
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        return Config.env().containsKey(name);
    }

    public static final byte getValue(String name, byte defValue) {
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        if (state != State.INITIALIZED) {
            bootstrapEnvAccessed.add(name);
            if (debugEarlyAccess) {
                bootstrapEnvAccessedStackTraces.put(name, UtlThrowable.prepareStackTrace(new Exception()));
            }
        }
        return UtlProps.getValue(Config.env(), name, defValue);
    }

    public static final short getValue(String name, short defValue) {
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        if (state != State.INITIALIZED) {
            bootstrapEnvAccessed.add(name);
            if (debugEarlyAccess) {
                bootstrapEnvAccessedStackTraces.put(name, UtlThrowable.prepareStackTrace(new Exception()));
            }
        }
        return UtlProps.getValue(Config.env(), name, defValue);
    }

    public static final int getValue(String name, int defValue) {
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        if (state != State.INITIALIZED) {
            bootstrapEnvAccessed.add(name);
            if (debugEarlyAccess) {
                bootstrapEnvAccessedStackTraces.put(name, UtlThrowable.prepareStackTrace(new Exception()));
            }
        }
        return UtlProps.getValue(Config.env(), name, defValue);
    }

    public static final long getValue(String name, long defValue) {
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        if (state != State.INITIALIZED) {
            bootstrapEnvAccessed.add(name);
            if (debugEarlyAccess) {
                bootstrapEnvAccessedStackTraces.put(name, UtlThrowable.prepareStackTrace(new Exception()));
            }
        }
        return UtlProps.getValue(Config.env(), name, defValue);
    }

    public static final float getValue(String name, float defValue) {
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        if (state != State.INITIALIZED) {
            bootstrapEnvAccessed.add(name);
            if (debugEarlyAccess) {
                bootstrapEnvAccessedStackTraces.put(name, UtlThrowable.prepareStackTrace(new Exception()));
            }
        }
        return UtlProps.getValue(Config.env(), name, defValue);
    }

    public static final double getValue(String name, double defValue) {
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        if (state != State.INITIALIZED) {
            bootstrapEnvAccessed.add(name);
            if (debugEarlyAccess) {
                bootstrapEnvAccessedStackTraces.put(name, UtlThrowable.prepareStackTrace(new Exception()));
            }
        }
        return UtlProps.getValue(Config.env(), name, defValue);
    }

    public static final boolean getValue(String name, boolean defValue) {
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        if (state != State.INITIALIZED) {
            bootstrapEnvAccessed.add(name);
            if (debugEarlyAccess) {
                bootstrapEnvAccessedStackTraces.put(name, UtlThrowable.prepareStackTrace(new Exception()));
            }
        }
        return UtlProps.getValue(Config.env(), name, defValue);
    }

    public static final String getValue(String name) {
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        if (state != State.INITIALIZED) {
            bootstrapEnvAccessed.add(name);
            if (debugEarlyAccess) {
                bootstrapEnvAccessedStackTraces.put(name, UtlThrowable.prepareStackTrace(new Exception()));
            }
        }
        return UtlProps.getValue(Config.env(), name, (String)null);
    }

    public static final String getValue(String name, String defValue) {
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        if (state != State.INITIALIZED) {
            bootstrapEnvAccessed.add(name);
            if (debugEarlyAccess) {
                bootstrapEnvAccessedStackTraces.put(name, UtlThrowable.prepareStackTrace(new Exception()));
            }
        }
        return UtlProps.getValue(Config.env(), name, defValue);
    }

    public static final String getPlatform() {
        return Config.getValue("NVPLATFORM", null);
    }

    public static final boolean isWindowsPlatform() {
        return UtlPlatform.isWindowsPlatform(Config.getPlatform());
    }

    public static final String getRootDirectory() {
        return Config.getValue("NVROOT", ".");
    }

    public static final String getBinDirectory() {
        return Config.getRootDirectory() + "/bin";
    }

    public static final String getConfigDirectory() {
        return Config.getRootDirectory() + "/conf";
    }

    public static final String getJavaLibDirectory() {
        return Config.getRootDirectory() + "/bin/java/lib";
    }

    public static final String getUnmanagedJavaLibDirectory() {
        return Config.getJavaLibDirectory() + "/unmanaged";
    }

    public static final synchronized String getDataDirectory(boolean createIfAbsent) {
        File dir;
        String dirname = Config.getValue("nv.data.directory", null);
        if (dirname == null) {
            dirname = Config.getRootDirectory() + "/rdat";
            dir = new File(dirname);
        } else if (new File(dirname).isAbsolute()) {
            dir = new File(dirname);
        } else {
            dir = new File(Config.getRootDirectory(), dirname);
            dirname = dir.getAbsolutePath();
        }
        if (!dir.exists()) {
            if (createIfAbsent) {
                dir.mkdirs();
            }
            return dirname;
        }
        if (!dir.isDirectory()) {
            System.err.println("configured data directory is actually a file!");
            System.exit(1);
        }
        return dirname;
    }

    public static final String getDataDirectory() {
        return Config.getDataDirectory(true);
    }

    public static final String getLogsDirectory(boolean createIfAbsent) {
        File dir;
        String dirname = Config.getValue("nv.log.directory", null);
        if (dirname == null) {
            dirname = Config.getDataDirectory() + "/logs";
            dir = new File(dirname);
        } else if (new File(dirname).isAbsolute()) {
            dir = new File(dirname);
        } else {
            dir = new File(Config.getDataDirectory(), dirname);
            dirname = dir.getAbsolutePath();
        }
        if (!dir.exists()) {
            if (createIfAbsent) {
                dir.mkdirs();
            }
            return dirname;
        }
        if (!dir.isDirectory()) {
            System.err.println("configured log directory is actually a file!");
            System.exit(1);
        }
        return dirname;
    }

    public static final String getLogsDirectory() {
        return Config.getLogsDirectory(true);
    }

    public static final boolean checked() {
        return checked;
    }

    public static final boolean tuneForLatency() {
        return performanceTuning == PerformanceTuning.latency;
    }

    public static final boolean optimizeForLatency() {
        return Config.tuneForLatency();
    }

    public static final boolean tuneForThroughput() {
        return performanceTuning == PerformanceTuning.throughput;
    }

    public static final boolean optimizeForThroughput() {
        return Config.tuneForThroughput();
    }

    @Deprecated
    public static final boolean optimizeMemoryUsage() {
        return conserveMemory;
    }

    public static final boolean conserveMemory() {
        return conserveMemory;
    }

    public static final boolean conserveCPU() {
        return conserveCPU;
    }

    public static final boolean disableDisruptorWaitStrategyOptimizations() {
        return disableDisruptorWaitStrategyOptimizations;
    }

    public static final IConfigRepository getRepository() {
        IConfigRepository repo = ConfigRepositoryFactory.getInstance().getDefaultRepository();
        IConfigSimpleEntity repoEnv = repo.getSimpleEntity(CONFIG_ENVENTITY_FULLNAME);
        if (repoEnv == null) {
            try {
                repo.createSimpleEntityContainer(CONFIG_ENVCONTAINER_NAME).createEntity(CONFIG_ENVENTITY_NAME);
            }
            catch (EConfigException e) {
                throw new RuntimeException("Failed to create environment container in configuration repository", e);
            }
        }
        return repo;
    }

    public static final synchronized void resetEnvironment() {
        env.clear();
        bootstrapEnv.clear();
        bootstrapEnvAccessed.clear();
        bootstrapEnvAccessedStackTraces.clear();
        Config.state(State.PREBOOTSTRAP);
    }

    public static final synchronized void resetRepository() {
        ConfigRepositoryFactory.getInstance().resetDefaultRepository();
    }

    public static final synchronized void reset(Properties systemProperties) {
        if (systemProperties != null) {
            System.setProperties(systemProperties);
        }
        Config.resetRepository();
        Config.resetEnvironment();
    }

    static {
        state = State.PREBOOTSTRAP;
    }

    public static enum PerformanceTuning {
        none,
        latency,
        throughput;

    }

    public static enum State {
        PREBOOTSTRAP,
        BOOTSTRAP,
        INITIALIZED;

    }
}

