/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.sma;

import com.neeve.io.IOBufferPacket;
import com.neeve.io.IONativePacket;
import com.neeve.pkt.PktPacket;
import com.neeve.sma.MessageView;
import com.neeve.sma.MessageViewFactory;
import com.neeve.sma.PacketMessage;
import com.neeve.sma.SmaObject;
import java.nio.ByteBuffer;
import java.util.Properties;

public final class PacketMessageFactory
extends SmaObject
implements MessageViewFactory {
    private PacketMessageFactory(Properties props) {
        super(null);
    }

    public static final PacketMessageFactory create(Properties props) {
        return new PacketMessageFactory(props);
    }

    @Override
    public final short getVfid() {
        return 1;
    }

    @Override
    public final MessageView create(short vid) {
        if (vid == 0) {
            return PacketMessage.create();
        }
        throw new IllegalArgumentException("unknown view id '" + vid + "'");
    }

    @Override
    public final MessageView wrap(short type, int encodingType, Object message) {
        if (encodingType != 1) {
            throw new IllegalArgumentException("packet messages only support custom encoding formats");
        }
        PacketMessage view = PacketMessage.create();
        if (message instanceof IONativePacket) {
            IONativePacket ioNativePacket = (IONativePacket)message;
            return view.deserializeFrom(ioNativePacket.addr, ioNativePacket.offset, ioNativePacket.length);
        }
        if (message instanceof IOBufferPacket) {
            IOBufferPacket iobufPacket = (IOBufferPacket)message;
            return view.deserializeFrom(iobufPacket.buf, iobufPacket.offset, iobufPacket.length);
        }
        if (message instanceof byte[]) {
            return view.deserializeFromByteArray((byte[])message);
        }
        if (message instanceof ByteBuffer) {
            return view.deserializeFromByteBuffer((ByteBuffer)message);
        }
        if (message instanceof PktPacket) {
            return view.deserializeFromPacket((PktPacket)message);
        }
        throw new IllegalArgumentException("unknown serialized form '" + message.getClass().getName() + "'");
    }
}

