/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.cloud.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;

public class PemKeyGenerator {
    private static final KeyPair generateRSAKeyPair() throws NoSuchAlgorithmException {
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA");
        keyPairGenerator.initialize(2048);
        return keyPairGenerator.generateKeyPair();
    }

    private static final String convertToPemFormat(byte[] keyBytes, String type) {
        String encodedKey = Base64.getMimeEncoder(64, new byte[]{10}).encodeToString(keyBytes);
        return "-----BEGIN " + type + "-----\n" + encodedKey + "\n-----END " + type + "-----\n";
    }

    private static final void writeToFile(File file, String content) throws IOException {
        file.getParentFile().mkdirs();
        try (FileWriter writer = new FileWriter(file);){
            writer.write(content);
        }
    }

    private static final String readFromFile(File file) throws IOException {
        if (!file.exists()) {
            return null;
        }
        StringBuilder content = new StringBuilder();
        try (BufferedReader reader = new BufferedReader(new FileReader(file));){
            String line;
            while ((line = reader.readLine()) != null) {
                content.append(line).append("\n");
            }
        }
        return content.toString();
    }

    public static final String generate(String keyName, String directoryPath) throws Exception {
        File privateKeyFile = new File(directoryPath, keyName + ".pem");
        File publicKeyFile = new File(directoryPath, keyName + ".pub");
        if (privateKeyFile.exists()) {
            return PemKeyGenerator.readFromFile(publicKeyFile);
        }
        KeyPair keyPair = PemKeyGenerator.generateRSAKeyPair();
        String privateKeyPem = PemKeyGenerator.convertToPemFormat(keyPair.getPrivate().getEncoded(), "PRIVATE KEY");
        String publicKeyPem = PemKeyGenerator.convertToPemFormat(keyPair.getPublic().getEncoded(), "PUBLIC KEY");
        PemKeyGenerator.writeToFile(privateKeyFile, privateKeyPem);
        PemKeyGenerator.writeToFile(publicKeyFile, publicKeyPem);
        return publicKeyPem;
    }
}

