/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.cloud.civo;

import com.neeve.cloud.civo.CivoRequestType;
import com.neeve.cloud.civo.messages.DeleteFirewallRequestMessage;
import com.neeve.cloud.civo.messages.DeleteFirewallRuleRequestMessage;
import com.neeve.cloud.civo.messages.DeleteInstanceRequestMessage;
import com.neeve.cloud.civo.messages.DeleteNetworkRequestMessage;
import com.neeve.cloud.civo.messages.GetFirewallRulesRequestMessage;
import com.neeve.cloud.civo.messages.GetFirewallsRequestMessage;
import com.neeve.cloud.civo.messages.GetInstanceRequestMessage;
import com.neeve.cloud.civo.messages.GetInstancesRequestMessage;
import com.neeve.cloud.civo.messages.GetNetworksRequestMessage;
import com.neeve.cloud.civo.messages.StartInstanceRequestMessage;
import com.neeve.cloud.civo.messages.StopInstanceRequestMessage;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;

final class CivoRequestParameterFactory {
    CivoRequestParameterFactory() {
    }

    private static final Map<String, String> createMap(Consumer<Map<String, String>> populateFunction) {
        HashMap<String, String> map = new HashMap<String, String>();
        populateFunction.accept(map);
        return map;
    }

    private static final Map<String, String> createGetNetworksQueryParams(String region) {
        return CivoRequestParameterFactory.createMap(map -> map.put("region", region));
    }

    private static final Map<String, String> createDeleteNetworkQueryParams(String region) {
        return CivoRequestParameterFactory.createMap(map -> map.put("region", region));
    }

    private static final Map<String, String> createGetFirewallRulesQueryParams(String region) {
        return CivoRequestParameterFactory.createMap(map -> map.put("region", region));
    }

    private static final Map<String, String> createDeleteFirewallRuleQueryParams(String region) {
        return CivoRequestParameterFactory.createMap(map -> map.put("region", region));
    }

    private static final Map<String, String> createGetFirewallsQueryParams(String region) {
        return CivoRequestParameterFactory.createMap(map -> map.put("region", region));
    }

    private static final Map<String, String> createDeleteFirewallQueryParams(String region) {
        return CivoRequestParameterFactory.createMap(map -> map.put("region", region));
    }

    private static final Map<String, String> createGetInstanceQueryParams(String region) {
        return CivoRequestParameterFactory.createMap(map -> map.put("region", region));
    }

    private static final Map<String, String> createGetInstancesQueryParams(String region, int page, int numPerPage, String tags) {
        return CivoRequestParameterFactory.createMap(map -> {
            map.put("region", region);
            map.put("page", String.valueOf(page));
            map.put("numPerPage", String.valueOf(numPerPage));
            map.put("tags", tags);
        });
    }

    private static final Map<String, String> createStartInstanceQueryParams(String region) {
        return CivoRequestParameterFactory.createMap(map -> map.put("region", region));
    }

    private static final Map<String, String> createStopInstanceQueryParams(String region) {
        return CivoRequestParameterFactory.createMap(map -> map.put("region", region));
    }

    private static final Map<String, String> createDeleteInstanceQueryParams(String region) {
        return CivoRequestParameterFactory.createMap(map -> map.put("region", region));
    }

    static final Map<String, String> createHeaders(CivoRequestType requestType, Object o) {
        switch (requestType) {
            case GetSSHKeys: 
            case CreateNetwork: 
            case GetNetworks: 
            case DeleteNetwork: 
            case CreateFirewall: 
            case CreateFirewallRule: 
            case GetFirewallRules: 
            case DeleteFirewallRule: 
            case GetFirewalls: 
            case DeleteFirewall: 
            case GetDiskImages: 
            case GetInstanceSizes: 
            case CreateInstance: 
            case StartInstance: 
            case StopInstance: 
            case GetInstance: 
            case GetInstances: 
            case DeleteInstance: {
                return new HashMap<String, String>();
            }
        }
        throw new IllegalArgumentException("Unsupported request type: " + (Object)((Object)requestType));
    }

    static final Map<String, String> createQueryParams(CivoRequestType requestType, Object o) {
        switch (requestType) {
            case GetSSHKeys: 
            case CreateNetwork: 
            case CreateFirewall: 
            case CreateFirewallRule: 
            case GetDiskImages: 
            case GetInstanceSizes: 
            case CreateInstance: {
                return new HashMap<String, String>();
            }
            case GetNetworks: {
                return CivoRequestParameterFactory.createGetNetworksQueryParams(((GetNetworksRequestMessage)o).getRegion());
            }
            case DeleteNetwork: {
                return CivoRequestParameterFactory.createDeleteNetworkQueryParams(((DeleteNetworkRequestMessage)o).getRegion());
            }
            case GetFirewallRules: {
                return CivoRequestParameterFactory.createGetFirewallRulesQueryParams(((GetFirewallRulesRequestMessage)o).getRegion());
            }
            case DeleteFirewallRule: {
                return CivoRequestParameterFactory.createDeleteFirewallRuleQueryParams(((DeleteFirewallRuleRequestMessage)o).getRegion());
            }
            case GetFirewalls: {
                return CivoRequestParameterFactory.createGetFirewallsQueryParams(((GetFirewallsRequestMessage)o).getRegion());
            }
            case DeleteFirewall: {
                return CivoRequestParameterFactory.createDeleteFirewallQueryParams(((DeleteFirewallRequestMessage)o).getRegion());
            }
            case StartInstance: {
                return CivoRequestParameterFactory.createStartInstanceQueryParams(((StartInstanceRequestMessage)o).getRegion());
            }
            case StopInstance: {
                return CivoRequestParameterFactory.createStopInstanceQueryParams(((StopInstanceRequestMessage)o).getRegion());
            }
            case GetInstance: {
                return CivoRequestParameterFactory.createGetInstanceQueryParams(((GetInstanceRequestMessage)o).getRegion());
            }
            case GetInstances: {
                return CivoRequestParameterFactory.createGetInstancesQueryParams(((GetInstancesRequestMessage)o).getRegion(), ((GetInstancesRequestMessage)o).getPage(), ((GetInstancesRequestMessage)o).getNumPerPage(), ((GetInstancesRequestMessage)o).getTags());
            }
            case DeleteInstance: {
                return CivoRequestParameterFactory.createDeleteInstanceQueryParams(((DeleteInstanceRequestMessage)o).getRegion());
            }
        }
        throw new IllegalArgumentException("Unsupported request type: " + (Object)((Object)requestType));
    }
}

