/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.adm;

import com.neeve.adm.AdmCollection;
import com.neeve.adm.AdmDocumentedType;
import com.neeve.adm.AdmEntity;
import com.neeve.adm.AdmFactoryType;
import com.neeve.adm.AdmGenerator;
import com.neeve.adm.AdmMessage;
import com.neeve.adm.AdmModel;
import com.neeve.adm.AdmScopedType;
import com.neeve.adm.AdmSourceCodeBuilder;
import com.neeve.adm.EAdmException;
import com.neeve.build.codegen.CgSourceCodeErrorAggregator;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;

public final class AdmFactory
extends AdmDocumentedType {
    private final AdmModel model;
    private final String namespace;
    private final String name;
    private final int id;
    private final HashMap<String, AdmFactoryType> types;
    private boolean containsMessage;
    private boolean containsType;
    static final int MAX_TYPES_PER_FACTORY = Short.MAX_VALUE;
    static final int MAX_FACTORY_ID = 65538;
    static final int FIRST_DYNAMIC_PLATFORM_FACTORY_ID = 32;
    static final int FIRST_VALID_MODEL_PLATFORM_FACTORY_ID = 0;
    static final int LAST_VALID_MODEL_PLATFORM_FACTORY_ID = -65506;
    static final int FIRST_VALID_MODEL_USER_FACTORY_ID = 1;
    static final int LAST_VALID_MODEL_USER_FACTORY_ID = 65538;

    public AdmFactory(AdmModel model, String namespace, String name, int id) {
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        if (namespace == null) {
            throw new IllegalArgumentException("namespace cannot be null");
        }
        this.name = name;
        this.model = model;
        this.namespace = namespace;
        this.id = id;
        this.types = new HashMap();
    }

    private final String protobufName(AdmScopedType type) {
        return type.getModel().getProtobufOuterClassName() + "." + type.getName();
    }

    private final AdmFactoryType getTypeById(int id) {
        for (AdmFactoryType type : this.types.values()) {
            if (type.getId() != id) continue;
            return type;
        }
        return null;
    }

    private final boolean isPlatformFactory() {
        return this.getId() <= 0;
    }

    private final int calcPacketId(int id) throws EAdmException {
        if (id < 0 || id > Short.MAX_VALUE) {
            throw new EAdmException("a type's id must be between 0 and 32767 both inclusive", this.getCodeSource());
        }
        if (this.isPlatformFactory()) {
            return this.calcFactoryId() * Short.MAX_VALUE + id + 4096;
        }
        return this.calcFactoryId() * Short.MAX_VALUE - id;
    }

    private final void writeClassDeclaration(AdmSourceCodeBuilder codeBuilder, String encodingType) {
        AdmGenerator.writeJavadocTypeComment("", this, codeBuilder);
        AdmGenerator.writeAdmGeneratedAnnotations(((Object)((Object)this)).getClass(), encodingType, this.model, codeBuilder);
        codeBuilder.last().appendln("final public class " + this.getName() + " implements %{com.neeve.ods.IStoreObjectFactory}, %{com.neeve.sma.MessageViewFactory} {");
    }

    private final void writeIds(AdmSourceCodeBuilder codeBuilder, boolean packetTypePerObjectType) throws EAdmException {
        AdmFactoryType type;
        codeBuilder.last().appendln("    /*");
        codeBuilder.last().appendln("     * IDs of the various factories implemented by this class");
        codeBuilder.last().appendln("     */");
        codeBuilder.last().appendln("    /**");
        codeBuilder.last().appendln("     * This factory's {@link %{com.neeve.ods.IStoreObjectFactory}} id.");
        codeBuilder.last().appendln("     * <p>");
        codeBuilder.last().appendln("     * The store factory ID is used to register the object in the {@link com.neeve.ods.StoreObjectFactoryRegistry}}");
        codeBuilder.last().appendln("     * used by ODS stores for deserializing objects.");
        codeBuilder.last().appendln("     */");
        codeBuilder.last().appendln("    final public static short OFID = " + this.calcFactoryId() + ";");
        if (this.containsMessage) {
            codeBuilder.last().appendln("    /**");
            codeBuilder.last().appendln("     * This factory's {@link %{com.neeve.sma.MessageViewFactory}} id.");
            codeBuilder.last().appendln("     * <p>");
            codeBuilder.last().appendln("     * The message factory ID is used to register the object in the {@link com.neeve.sma.MessageViewFactoryRegistry}}");
            codeBuilder.last().appendln("     * used by SMA binding for deserializing received messages.");
            codeBuilder.last().appendln("     */");
            codeBuilder.last().appendln("    final public static short VFID = " + this.calcFactoryId() + ";");
        } else {
            codeBuilder.last().appendln("    /**");
            codeBuilder.last().appendln("     * Not used for this factory as it contains no message types.");
            codeBuilder.last().appendln("     */");
            codeBuilder.last().appendln("    final public static short VFID = 0;");
        }
        if (this.containsType) {
            codeBuilder.last().appendln("    /**");
            codeBuilder.last().appendln("     * This factory's type factory id.");
            codeBuilder.last().appendln("     * <p>");
            codeBuilder.last().appendln("     * This id is reserved for platform internal use.");
            codeBuilder.last().appendln("     */");
            codeBuilder.last().appendln("    final public static short TFID = " + this.calcFactoryId() + ";");
        } else {
            codeBuilder.last().appendln("    /**");
            codeBuilder.last().appendln("     * This factory's type factory id.");
            codeBuilder.last().appendln("     * <p>");
            codeBuilder.last().appendln("     * This id is reserved for platform internal use.");
            codeBuilder.last().appendln("     */");
            codeBuilder.last().appendln("    final public static short TFID = 0;");
        }
        codeBuilder.last().appendln("");
        codeBuilder.last().appendln("    /*");
        codeBuilder.last().appendln("     * Object ids (unique within the factory) ");
        codeBuilder.last().appendln("     */");
        Iterator<AdmFactoryType> iterator = this.typeIterator();
        while (iterator.hasNext()) {
            type = iterator.next();
            codeBuilder.last().appendln("    /**");
            codeBuilder.last().appendln("     * Defines the {@link " + type.getName() + "} type id.");
            codeBuilder.last().appendln("     */");
            codeBuilder.last().appendln("    final public static short ID_" + type.getName() + " = (short)" + type.getId() + ";");
        }
        if (packetTypePerObjectType) {
            codeBuilder.last().appendln("");
            codeBuilder.last().appendln("    /*");
            codeBuilder.last().appendln("     * Object packet ids (unique within the system) ");
            codeBuilder.last().appendln("     */");
            iterator = this.typeIterator();
            while (iterator.hasNext()) {
                type = iterator.next();
                if (type instanceof AdmCollection) continue;
                codeBuilder.last().appendln("    /**");
                codeBuilder.last().appendln("     * Defines the {@link " + type.getName() + "} backing packet id type.");
                codeBuilder.last().appendln("     * <p>");
                codeBuilder.last().appendln("     * {@link " + type.getName() + "} are backet by a packet which is used for");
                codeBuilder.last().appendln("     * efficient transport, serialization and pooling. This constants defines");
                codeBuilder.last().appendln("     * the unique packet type id.");
                codeBuilder.last().appendln("     */");
                codeBuilder.last().appendln("    final public static int PKTID_" + type.getName() + " = " + this.calcPacketId(type.getId()) + ";");
            }
        }
    }

    private final void writeConstructors(AdmSourceCodeBuilder codeBuilder, String encodingType, boolean packetTypePerObjectType) {
        codeBuilder.last().appendln("    /*");
        codeBuilder.last().appendln("     * Static constructor.");
        codeBuilder.last().appendln("     */");
        codeBuilder.last().appendln("    final static %{com.fasterxml.jackson.databind.ObjectMapper} mapper;");
        codeBuilder.last().appendln("    static {");
        codeBuilder.last().appendln("        mapper = new %{com.fasterxml.jackson.databind.ObjectMapper}();");
        codeBuilder.last().appendln("        mapper.configure(%{com.fasterxml.jackson.databind.MapperFeature}.USE_ANNOTATIONS, true).");
        codeBuilder.last().appendln("               configure(%{com.fasterxml.jackson.databind.MapperFeature}.AUTO_DETECT_GETTERS, false).");
        codeBuilder.last().appendln("               configure(%{com.fasterxml.jackson.databind.MapperFeature}.AUTO_DETECT_IS_GETTERS, false).");
        codeBuilder.last().appendln("               configure(%{com.fasterxml.jackson.databind.MapperFeature}.AUTO_DETECT_FIELDS, false).");
        codeBuilder.last().appendln("               configure(%{com.fasterxml.jackson.databind.MapperFeature}.AUTO_DETECT_SETTERS, false).");
        codeBuilder.last().appendln("               configure(%{com.fasterxml.jackson.databind.MapperFeature}.AUTO_DETECT_CREATORS, false).");
        codeBuilder.last().appendln("               configure(%{com.fasterxml.jackson.databind.MapperFeature}.USE_GETTERS_AS_SETTERS, true).");
        codeBuilder.last().appendln("               configure(%{com.fasterxml.jackson.databind.DeserializationFeature}.FAIL_ON_UNKNOWN_PROPERTIES, false).");
        codeBuilder.last().appendln("               configure(%{com.fasterxml.jackson.databind.DeserializationFeature}.READ_UNKNOWN_ENUM_VALUES_AS_NULL, true).");
        codeBuilder.last().appendln("               configure(%{com.fasterxml.jackson.databind.SerializationFeature}.FAIL_ON_EMPTY_BEANS, false).");
        codeBuilder.last().appendln("               configure(%{com.fasterxml.jackson.databind.SerializationFeature}.INDENT_OUTPUT, %{com.neeve.config.Config}.getValue(\"nv.indent.json\", false));");
        if (packetTypePerObjectType) {
            codeBuilder.last().appendln("");
            codeBuilder.last().appendln("        /*");
            codeBuilder.last().appendln("         * Register packet types");
            codeBuilder.last().appendln("         */");
            Iterator<AdmFactoryType> iterator = this.typeIterator();
            while (iterator.hasNext()) {
                AdmFactoryType type = iterator.next();
                if (type instanceof AdmCollection) continue;
                codeBuilder.last().appendln("         %{com.neeve.pkt.PktFactory}.getInstance().registerPacketType(%{com.neeve.pkt.PktFactory}.PktType.create(PKTID_" + type.getName() + ",");
                codeBuilder.last().appendln("                                                                               \"" + type.getName() + encodingType + "Packet." + this.getId() + "." + type.getId() + "\",");
                codeBuilder.last().appendln("                                                                               \"" + type.getFullName() + "$PacketBody\",");
                codeBuilder.last().appendln("                                                                               %{com.neeve.config.Config}.getValue(\"nv.tuning.memory.pool.\" + " + type.getName() + ".class.getName() + \".shouldpool\", true),");
                codeBuilder.last().appendln("                                                                               %{com.neeve.adm.runtime.AdmRuntime}.configurePoolParams(" + type.getName() + ".class, %{com.neeve.util.UtlPool}.Params.create()),");
                codeBuilder.last().appendln("                                                                               null));");
            }
        }
        codeBuilder.last().appendln("    }");
        codeBuilder.last().appendln("");
        codeBuilder.last().appendln("    /**");
        codeBuilder.last().appendln("     * Constructor for when loading factory from configuration repository.");
        codeBuilder.last().appendln("     */");
        codeBuilder.last().appendln("    final public static " + this.getName() + " create(final %{java.util.Properties} props) {");
        codeBuilder.last().appendln("        return new " + this.getName() + "();");
        codeBuilder.last().appendln("    }");
    }

    final int getDeprecatedTypeCount(boolean onlyMessages) {
        int deprecatedTypes = 0;
        Iterator<AdmFactoryType> iterator = this.typeIterator();
        while (iterator.hasNext()) {
            AdmFactoryType type = iterator.next();
            if (!type.isDeprecated() || onlyMessages && !(type instanceof AdmMessage)) continue;
            ++deprecatedTypes;
        }
        return deprecatedTypes;
    }

    public static final short decodeObjectFactoryIdFromPacketId(int packetId) {
        if (packetId > 0) {
            return (short)((packetId - 4096) / Short.MAX_VALUE);
        }
        return (short)(-packetId / Short.MAX_VALUE * -1);
    }

    public static final short decodeObjectTypeFormPacketId(int packetId) {
        if (packetId > 0) {
            return (short)(packetId - AdmFactory.decodeObjectFactoryIdFromPacketId(packetId) * Short.MAX_VALUE - 4096);
        }
        return (short)(-packetId - AdmFactory.decodeObjectFactoryIdFromPacketId(packetId) * Short.MAX_VALUE * -1);
    }

    @Override
    public final String getName() {
        return this.name;
    }

    public final String getFullName() {
        return AdmScopedType.constructFullName(this.getNamespace(), this.getName());
    }

    public final String getNamespace() {
        return this.namespace;
    }

    public final int getId() {
        return this.id;
    }

    public final short calcFactoryId() {
        if (this.isPlatformFactory()) {
            return (short)(this.getId() * -1 + 32);
        }
        return (short)(this.getId() * -1);
    }

    public final AdmFactory addType(AdmFactoryType type) throws EAdmException {
        AdmFactoryType dupType;
        String message;
        if (type == null) {
            throw new IllegalArgumentException("type cannot be null");
        }
        if (type.getFactory() != this) {
            message = "attempt to add a type to a factory different from the type's factory " + type.getName();
            if (this.model.getModelBuildErrorAggregator() != null) {
                this.model.getModelBuildErrorAggregator().add(message, CgSourceCodeErrorAggregator.Severity.ERROR, this.getCodeSource(), null);
            } else {
                throw new EAdmException(message, this.getCodeSource());
            }
        }
        if (!type.getNamespace().equals(this.getNamespace())) {
            message = "a factory type's namespace (" + type.getNamespace() + ") must be the same as it's factory's namespace (" + this.getNamespace() + ")";
            if (this.model.getModelBuildErrorAggregator() != null) {
                this.model.getModelBuildErrorAggregator().add(message, CgSourceCodeErrorAggregator.Severity.ERROR, this.getCodeSource(), null);
            } else {
                throw new EAdmException(message, this.getCodeSource());
            }
        }
        if ((dupType = this.getTypeById(type.getId())) != null && dupType != type) {
            String message2 = type.getJavaTypeName() + " and " + dupType.getJavaTypeName() + " have the same type id [id=" + type.getId() + ", factory='" + this.getName() + "']";
            if (this.model.getModelBuildErrorAggregator() != null) {
                if (type.getCodeSource() != null && dupType.getCodeSource() != null) {
                    this.model.getModelBuildErrorAggregator().add(message2, CgSourceCodeErrorAggregator.Severity.ERROR, dupType.getCodeSource(), null);
                    this.model.getModelBuildErrorAggregator().add(message2, CgSourceCodeErrorAggregator.Severity.ERROR, type.getCodeSource(), null);
                } else {
                    this.model.getModelBuildErrorAggregator().add(message2, CgSourceCodeErrorAggregator.Severity.ERROR, this.getCodeSource(), null);
                }
            } else {
                throw new EAdmException(message2, this.getCodeSource());
            }
        }
        this.types.put(type.getName(), type);
        this.containsMessage |= type instanceof AdmMessage;
        this.containsType |= type instanceof AdmEntity && ((AdmEntity)type).isEmbedded();
        return this;
    }

    public final boolean handlesType(AdmFactoryType type) {
        if (type == null) {
            throw new IllegalArgumentException("type cannot be null");
        }
        return this.types.get(type.getName()) != null;
    }

    public final Iterator<AdmFactoryType> typeIterator() {
        return this.types.values().iterator();
    }

    public final int getMessageCount() {
        int numMessages = 0;
        Iterator<AdmFactoryType> iterator = this.typeIterator();
        while (iterator.hasNext()) {
            AdmFactoryType type = iterator.next();
            if (!(type instanceof AdmMessage)) continue;
            ++numMessages;
        }
        return numMessages;
    }

    public final void startClassGeneration(AdmSourceCodeBuilder codeBuilder, String encodingType, boolean packetTypePerObjectType) throws EAdmException {
        boolean error = false;
        String message = null;
        if (this.id <= 0 && this.id < -65506) {
            error = true;
            message = "platform factory ids must be between 0 and -65506 both inclusive";
        }
        if (this.id >= 1 && this.id > 65538) {
            error = true;
            message = "user factory ids must be between 1 and 65538 both inclusive";
        }
        if (this.types.size() == Short.MAX_VALUE) {
            error = true;
            message = "number of types in factory has exceeded the maximum (32767)";
        }
        if (error) {
            if (this.model.getModelBuildErrorAggregator() != null) {
                this.model.getModelBuildErrorAggregator().add(message, CgSourceCodeErrorAggregator.Severity.ERROR, this.getCodeSource(), null);
            } else {
                throw new EAdmException(message, this.getCodeSource());
            }
        }
        codeBuilder.header().appendln("/**");
        codeBuilder.header().appendln(" * ************************************************************");
        codeBuilder.header().appendln(" * *** THIS FILE IS GENERATED BY RUMI CODE GENERATION TOOLS ***");
        codeBuilder.header().appendln(" * ************************************************************");
        codeBuilder.header().append(" */");
        codeBuilder.packageName(this.getNamespace());
        codeBuilder.last().appendln("");
        this.writeClassDeclaration(codeBuilder, encodingType);
        this.writeIds(codeBuilder, packetTypePerObjectType);
        codeBuilder.last().appendln("");
        this.writeConstructors(codeBuilder, encodingType, packetTypePerObjectType);
    }

    public final AdmSourceCodeBuilder startClassGeneration(String encodingType, boolean packetTypePerObjectType) throws Exception {
        AdmSourceCodeBuilder codeBuilder = new AdmSourceCodeBuilder(this.model);
        this.startClassGeneration(codeBuilder, encodingType, packetTypePerObjectType);
        return codeBuilder;
    }

    public final void completeClassGeneration(AdmSourceCodeBuilder codeBuilder, File baseOutDir, boolean absolute) throws Exception {
        codeBuilder.last().appendln("}");
        try {
            File file = AdmModel.resolveAbsoluteClassFile(baseOutDir, absolute ? null : this.getNamespace(), this.getName(), true);
            try {
                codeBuilder.write(file);
            }
            catch (IOException e2) {
                throw new EAdmException("Failed to write factory class file '" + file.getPath() + "' [" + e2.toString() + "]", (Throwable)e2, this.getCodeSource());
            }
        }
        catch (IOException e1) {
            throw new EAdmException("Failed to create factory class file (outdir '" + baseOutDir.getPath() + "') [" + e1.toString() + "]", (Throwable)e1, this.getCodeSource());
        }
    }
}

