/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.adm;

import com.neeve.adm.AdmModelElement;
import com.neeve.build.codegen.CgCodeSource;

public class AdmDirective
extends AdmModelElement {
    private final String key;
    private final Object value;
    private final boolean override;

    public AdmDirective(String key, Object value, boolean override) {
        if (key == null) {
            throw new IllegalArgumentException("'key' cannot be null");
        }
        this.key = key;
        this.value = value;
        this.override = override;
    }

    public AdmDirective(String key, Object value, boolean override, CgCodeSource codeSource) {
        if (key == null) {
            throw new IllegalArgumentException("'key' cannot be null");
        }
        this.key = key;
        this.value = value;
        this.override = override;
        this.setCodeSource(codeSource);
    }

    public final String getKey() {
        return this.key;
    }

    public final String getValueAsString(String defaultValue) {
        String retVal = null;
        if (this.value != null) {
            retVal = this.value instanceof String ? (String)this.value : this.value.toString();
        }
        return retVal;
    }

    public final Boolean getValueAsBoolean(Boolean defaultValue) {
        Boolean retVal = null;
        try {
            if (this.value != null) {
                retVal = Boolean.parseBoolean(this.value.toString());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return retVal;
    }

    public final Object getValue() {
        return this.value;
    }

    public final boolean isOverride() {
        return this.override;
    }
}

