/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.tools.interactive.commands;

import com.neeve.stats.IStats;
import com.neeve.stats.StatsRegistry;
import com.neeve.tools.interactive.commands.Command;

public final class StartStats
extends Command {
    private void processStartStats(String name, int interval) {
        IStats stats = StatsRegistry.getInstance().get(name);
        if (stats != null) {
            if (interval > 0) {
                try {
                    System.out.println("Starting statistics dump for statistics object ['" + name + "'] with interval=" + interval + "...");
                    stats.startPeriodicOutput(interval);
                }
                catch (Exception e) {
                    System.out.println("Failure [" + e.toString() + "]");
                }
            } else {
                System.out.println("Invalid interval ['" + interval + "'].");
            }
        } else {
            System.out.println("Invalid statistics object ['" + name + "'].");
        }
    }

    public final void run(String[] args) {
        if (args.length != 2) {
            System.out.println("Syntax error: startstats <name> <interval>");
        } else {
            this.processStartStats(args[0], Integer.parseInt(args[1]));
        }
    }

    public final void help() {
        System.out.println("startstats <name> <interval>");
        System.out.println("  Start statistics dump for a statistics object.");
    }

    public final String[] keywords() {
        return new String[]{"startstats"};
    }
}

