/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.sto;

import com.neeve.sto.StoField;
import java.nio.ByteBuffer;
import java.util.Date;

public final class StoDateField
extends StoField {
    private Date val;

    private StoDateField(String name) {
        super(StoField.Type.DATE, name);
    }

    private StoDateField(ByteBuffer buffer, int bufferOffset) {
        super(buffer, bufferOffset);
    }

    @Override
    protected final void doSyncToBuffer(ByteBuffer buffer, int bufferOffset) {
        StoDateField.put(buffer, bufferOffset, this.val);
    }

    @Override
    protected final void onBackingBufferAttach() {
        StoDateField.put(this.buffer, this.bodyOffset, this.val);
    }

    @Override
    protected final void onBackingBufferDetach() {
        if (this.val == null) {
            this.val = StoDateField.get(this.buffer, this.bodyOffset);
        }
    }

    @Override
    protected final void onBackingBufferChange() {
        this.val = null;
    }

    @Override
    protected final int getSerializedLength() {
        return 8;
    }

    @Override
    protected final String getValueString() {
        Date val = this.getValue();
        return this.getValue() == null ? null : val.toString();
    }

    @Override
    protected final boolean bodyContentsEquals(StoField other) {
        Date val1 = this.getValue();
        Date val2 = ((StoDateField)other).getValue();
        return val1 == null ? val2 == null : val1.equals(val2);
    }

    @Override
    protected final void cloneBody(StoField clonee) {
        ((StoDateField)clonee).setValue(this.getValue());
    }

    public static StoDateField create(String name) {
        return new StoDateField(name);
    }

    public static StoDateField create(ByteBuffer buffer, int bufferOffset) {
        return new StoDateField(buffer, bufferOffset);
    }

    public static int getSerializedLength(ByteBuffer buffer, int offset) {
        return 8;
    }

    public static void put(ByteBuffer buffer, int offset, Date val) {
        buffer.putLong(offset, val == null ? 0L : val.getTime());
    }

    public static Date get(ByteBuffer buffer, int offset) {
        long val = buffer.getLong(offset);
        return val == 0L ? null : new Date(val);
    }

    @Override
    public final boolean isVariableLength() {
        return false;
    }

    @Override
    public final void reset() {
        this.setValue(null);
    }

    public final void setValue(Date val) {
        this.val = val;
        if (this.buffer != null) {
            StoDateField.put(this.buffer, this.bodyOffset, val);
        }
    }

    public final Date getValue() {
        if (this.val == null && this.buffer != null) {
            this.val = StoDateField.get(this.buffer, this.bodyOffset);
        }
        return this.val;
    }
}

