/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.sto;

import com.neeve.sto.StoField;
import com.neeve.sto.StoShortField;
import com.neeve.sto.StoVariableLengthField;
import java.nio.ByteBuffer;
import java.util.Arrays;

public final class StoBooleanArrayField
extends StoVariableLengthField<boolean[]> {
    private StoBooleanArrayField(String name) {
        super(StoField.Type.BOOLEAN_ARRAY, name);
    }

    private StoBooleanArrayField(ByteBuffer buffer, int bufferOffset) {
        super(buffer, bufferOffset);
    }

    @Override
    protected final int serializedLength(ByteBuffer buffer, int offset) {
        return StoBooleanArrayField.getSerializedLength(buffer, offset);
    }

    @Override
    protected final int serializedLength(boolean[] val) {
        return StoBooleanArrayField.getSerializedLength(val);
    }

    @Override
    protected final void serialize(ByteBuffer buffer, int offset, boolean[] val) {
        StoBooleanArrayField.put(buffer, offset, val);
    }

    @Override
    protected final boolean[] deserialize(ByteBuffer buffer, int offset) {
        return StoBooleanArrayField.get(buffer, offset);
    }

    @Override
    protected final boolean compare(boolean[] val1, boolean[] val2) {
        return Arrays.equals(val1, val2);
    }

    @Override
    protected final boolean[] clone(boolean[] val) {
        return Arrays.copyOf(val, val.length);
    }

    @Override
    protected final String toString(boolean[] val) {
        return Arrays.toString(val);
    }

    public static StoBooleanArrayField create(String name) {
        return new StoBooleanArrayField(name);
    }

    public static StoBooleanArrayField create(ByteBuffer buffer, int bufferOffset) {
        return new StoBooleanArrayField(buffer, bufferOffset);
    }

    public static final int getSerializedLength(ByteBuffer buffer, int offset) {
        short len = StoShortField.get(buffer, offset);
        return 2 + (len < 0 ? (short)0 : len) * 1;
    }

    public static final int getSerializedLength(boolean[] val) {
        return 2 + (val != null ? val.length * 1 : 0);
    }

    public static void put(ByteBuffer buffer, int offset, boolean[] val) {
        StoShortField.put(buffer, offset, (short)(val == null ? 0 : (val.length == 0 ? -1 : val.length)));
        if (val != null) {
            for (int i = 0; i < val.length; ++i) {
                buffer.put(offset + 2 + i, (byte)(val[i] ? 1 : 0));
            }
        }
    }

    public static boolean[] get(ByteBuffer buffer, int offset) {
        short len = StoShortField.get(buffer, offset);
        if (len > 0) {
            boolean[] val = new boolean[len];
            for (int i = 0; i < val.length; ++i) {
                val[i] = buffer.get(offset + 2 + i) > 0;
            }
            return val;
        }
        if (len < 0) {
            return new boolean[0];
        }
        return null;
    }
}

