/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.pkt;

import com.neeve.trace.Tracer;
import com.neeve.util.UtlBuffer;
import com.neeve.util.UtlThrowable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.nio.ByteBuffer;

public final class PktUtils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void dumpCorruptedSerializedPacket(String message, ByteBuffer buffer, int pos, int limit, Throwable e, Tracer tracer) {
        block8: {
            try {
                File dumpFile = File.createTempFile("PktCorruption", ".dump");
                try (PrintStream out = new PrintStream(new FileOutputStream(dumpFile));){
                    out.println("Corrupted Packet Buffer Dump [" + message + "]");
                    out.println("Cause:");
                    out.println(UtlThrowable.prepareStackTrace((Throwable)e));
                    out.println("Corrupted packet buffer offset " + pos);
                    int len = limit - pos;
                    out.println(UtlBuffer.dump((String)("Read buffer contents (at pos=" + pos + " of len=" + len + ")"), (ByteBuffer)buffer, (int)pos, (int)len));
                    if (pos > 0) {
                        int numBeforePos = Math.min(pos, 100);
                        out.println(UtlBuffer.dump((String)("Read buffer contents from " + numBeforePos + " bytes before packet pos (at pos=" + (pos - numBeforePos) + " of len=" + numBeforePos + ")"), (ByteBuffer)buffer, (int)(pos - numBeforePos), (int)numBeforePos));
                    } else {
                        out.println("Packet pos already at beginning of buffer. Nothing to dump before packet pos");
                    }
                    out.flush();
                }
                tracer.log("Corrupted packet dump written to " + dumpFile.getCanonicalPath(), Tracer.Level.WARNING);
            }
            catch (Throwable thrown) {
                if (!tracer.debug) break block8;
                tracer.log("Failed to dump corrupted packet buffer: " + UtlThrowable.prepareStackTrace((Throwable)thrown), Tracer.Level.WARNING);
            }
        }
    }
}

