/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.pkt;

import cern.colt.map.OpenIntObjectHashMap;
import com.neeve.config.Config;
import com.neeve.config.IConfigRepository;
import com.neeve.config.IConfigSimpleEntity;
import com.neeve.config.IConfigSimpleEntityContainer;
import com.neeve.io.IOBuffer;
import com.neeve.pkt.EPktBodyClassInstantiateException;
import com.neeve.pkt.EPktBodyClassLoadException;
import com.neeve.pkt.EPktException;
import com.neeve.pkt.EPktIncompleteException;
import com.neeve.pkt.EPktTypeInvalidException;
import com.neeve.pkt.PktBody;
import com.neeve.pkt.PktHeader;
import com.neeve.pkt.PktPacket;
import com.neeve.root.RootObject;
import com.neeve.trace.Tracer;
import com.neeve.util.UtlPool;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;

public final class PktFactory
extends RootObject {
    private final PktTypeTable pktTypeTable = new PktTypeTable();
    private static final PktFactory instance;
    private static final boolean shouldPool;
    private static final Map<String, Object> defaultPktPoolParams;

    private PktFactory() {
        super(null);
        this.tracer.bind("nv.pkt.factory");
        Config.setTraceLevel((Tracer)this.tracer, (String)"nv.pkt.factory.trace");
        this.initPktTypeInfo();
    }

    public static PktFactory getInstance() {
        return instance;
    }

    private final void registerPacketType(PktType pktType, boolean byLoader) {
        if (byLoader) {
            this.tracer.log("...Loading (system) packet type '" + pktType.name + "'...", Tracer.Level.FINE);
        } else {
            this.tracer.log("...Registering (user) packet type '" + pktType.name + "'...", Tracer.Level.FINE);
        }
        this.tracer.log("......Id=" + pktType.id, Tracer.Level.FINE);
        this.tracer.log("......Class='" + pktType.bodyClassName + "'", Tracer.Level.FINE);
        this.tracer.log("......ShouldPool=" + pktType.shouldPool, Tracer.Level.FINE);
        this.pktTypeTable.put(pktType);
    }

    private final void initPktTypeInfo() {
        IConfigRepository repo = Config.getRepository();
        IConfigSimpleEntityContainer container = repo.getSimpleEntityContainer("/packets");
        if (container != null) {
            Iterator iterator = container.iterator();
            int numPktTypesLoaded = 0;
            while (iterator.hasNext()) {
                IConfigSimpleEntity entity = (IConfigSimpleEntity)iterator.next();
                short pktTypeId = Short.parseShort(entity.getProperty("Id", String.valueOf(0)));
                String bodyClassName = entity.getProperty("BodyClass", null);
                if (bodyClassName != null && pktTypeId != 0) {
                    boolean shouldPool = Boolean.parseBoolean(entity.getProperty("ShouldPool", "true"));
                    Properties props = (Properties)entity.getProperties().clone();
                    props.remove("BodyClass");
                    props.remove("Id");
                    props.remove("ShouldPool");
                    String pktTypeName = entity.getName();
                    this.registerPacketType(new PktType(pktTypeId, pktTypeName, bodyClassName, shouldPool, null, props), true);
                    ++numPktTypesLoaded;
                    continue;
                }
                this.tracer.log("Packet type '" + entity.getName() + "' configuration error [packet type and body class name both need to be specified]. The packet type '" + entity.getName() + "' will not be loaded.", Tracer.Level.WARNING);
            }
            this.tracer.log("Loaded " + numPktTypesLoaded + " packet types.", Tracer.Level.VERBOSE);
        } else {
            this.tracer.log("No packet types configured.", Tracer.Level.VERBOSE);
        }
    }

    private final PktBody createPacketBody(PktType pktType) throws EPktBodyClassLoadException, EPktBodyClassInstantiateException, EPktException {
        if (pktType.bodyCreateMethod == null) {
            Class<?> pktBodyClass = null;
            try {
                pktBodyClass = Class.forName(pktType.bodyClassName);
            }
            catch (ClassNotFoundException e) {
                throw new EPktBodyClassLoadException("Packet body class [" + pktType.bodyClassName + "] could not be found");
            }
            catch (UnsupportedClassVersionError e) {
                throw new EPktBodyClassLoadException("Packet body class [" + pktType.bodyClassName + "] is not supported by this VM <version=" + System.getProperty("java.vm.version") + ">");
            }
            try {
                Class[] parameterTypes = new Class[]{Class.forName("java.util.Properties")};
                pktType.bodyCreateMethod = pktBodyClass.getMethod("create", parameterTypes);
            }
            catch (ClassNotFoundException e) {
                throw new InternalError("Failed to load java.lang.Short or java.util.Properties during instantiation of packet body class [" + pktType.bodyClassName + "]");
            }
            catch (SecurityException e) {
                throw new EPktBodyClassInstantiateException("Access to instantiation method in packet body class [" + pktType.bodyClassName + "] is denied");
            }
            catch (NoSuchMethodException e) {
                throw new EPktBodyClassInstantiateException("Instantiation method in packet body class [" + pktType.bodyClassName + "] could not be found");
            }
        }
        PktBody ret = null;
        try {
            try {
                Object[] parameters = new Object[]{pktType.props};
                ret = (PktBody)((Object)pktType.bodyCreateMethod.invoke(null, parameters));
                if (ret == null) {
                    throw new EPktBodyClassInstantiateException("Instantiation method in packet body class [" + pktType.bodyClassName + "] returned a null object");
                }
            }
            catch (ClassCastException e) {
                throw new EPktBodyClassInstantiateException("Instantiation method in packet body class [" + pktType.bodyClassName + "] returned object of incorrect type");
            }
        }
        catch (IllegalAccessException e) {
            throw new EPktBodyClassInstantiateException("Access to instantiation method in packet body class [" + pktType.bodyClassName + "] is denied");
        }
        catch (InvocationTargetException e) {
            throw new EPktBodyClassInstantiateException(e.getCause());
        }
        return ret;
    }

    private PktPacket createPacket(PktHeader pktHeader, PktBody pktBody, PktType pktType, int flags) {
        return PktPacket.create(pktHeader, pktBody, null, flags);
    }

    private PktPacket createPacket(PktType pktType, int flags) throws EPktBodyClassLoadException, EPktBodyClassInstantiateException, EPktException {
        PktBody pktBody = this.createPacketBody(pktType);
        PktHeader pktHeader = PktHeader.create(pktBody, pktType.props);
        return this.createPacket(pktHeader, pktBody, pktType, flags);
    }

    public final void registerPacketType(PktType pktType) {
        if (pktType == null) {
            throw new IllegalArgumentException("packet type cannot be null");
        }
        this.registerPacketType(pktType, false);
    }

    public final PktType getPacketType(int pktTypeId) {
        return this.pktTypeTable.get(pktTypeId);
    }

    public final PktType getPacketType(String pktTypeName) {
        return this.pktTypeTable.get(pktTypeName);
    }

    public final String getPacketTypeNameFromId(int pktTypeId) {
        PktType pktType = this.pktTypeTable.get(pktTypeId);
        if (pktType != null) {
            return pktType.name;
        }
        return "<unknown>";
    }

    public final PktBody createPacketBody(int pktTypeId) throws EPktTypeInvalidException, EPktBodyClassLoadException, EPktBodyClassInstantiateException, EPktException {
        PktType pktType = this.pktTypeTable.get(pktTypeId);
        if (pktType != null) {
            return this.createPacketBody(pktType);
        }
        throw new EPktTypeInvalidException(pktTypeId);
    }

    public final PktBody createPacketBody(String pktTypeName) throws EPktTypeInvalidException, EPktBodyClassLoadException, EPktBodyClassInstantiateException, EPktException {
        PktType pktType = this.pktTypeTable.get(pktTypeName);
        if (pktType != null) {
            return this.createPacketBody(pktType);
        }
        throw new EPktTypeInvalidException(pktTypeName);
    }

    public final PktPacket createPacket(int pktTypeId) throws EPktTypeInvalidException, EPktBodyClassLoadException, EPktBodyClassInstantiateException, EPktException {
        PktType pktType = this.pktTypeTable.get(pktTypeId);
        if (pktType != null) {
            return pktType.createPacket(false);
        }
        throw new EPktTypeInvalidException(pktTypeId);
    }

    public final PktPacket createPacketNonPooled(int pktTypeId) throws EPktTypeInvalidException, EPktBodyClassLoadException, EPktBodyClassInstantiateException, EPktException {
        PktType pktType = this.pktTypeTable.get(pktTypeId);
        if (pktType != null) {
            return pktType.createPacket(true);
        }
        throw new EPktTypeInvalidException(pktTypeId);
    }

    public final PktPacket createPacket(String pktTypeName) throws EPktTypeInvalidException, EPktBodyClassLoadException, EPktBodyClassInstantiateException, EPktException {
        PktType pktType = this.pktTypeTable.get(pktTypeName);
        if (pktType != null) {
            return pktType.createPacket(false);
        }
        throw new EPktTypeInvalidException(pktTypeName);
    }

    public final PktPacket createPacket(ByteBuffer buffer, int offset, int length) {
        int packetSerializedLength = PktHeader.getSerializedPacketLength(buffer, offset, length);
        if (packetSerializedLength <= 0 || packetSerializedLength > length) {
            throw new EPktIncompleteException(length, packetSerializedLength);
        }
        PktPacket packet = PktFactory.getInstance().createPacket(PktHeader.getBodyType(buffer, offset));
        packet.deserialize(buffer, offset);
        return packet;
    }

    public final PktPacket createPacket(ByteBuffer buffer) {
        return this.createPacket(buffer, buffer.position(), buffer.remaining());
    }

    public final PktPacket createPacket(IOBuffer buffer, int offset, int length, boolean wrap) {
        int packetSerializedLength = PktHeader.getSerializedPacketLength(buffer, offset, length);
        if (packetSerializedLength <= 0 || packetSerializedLength > length) {
            throw new EPktIncompleteException(length, packetSerializedLength);
        }
        PktPacket packet = PktFactory.getInstance().createPacket(PktHeader.getBodyType(buffer, offset));
        packet.deserialize(buffer, offset, wrap);
        return packet;
    }

    public final PktPacket createPacket(long addr, int offset, int length) {
        int packetSerializedLength = PktHeader.getSerializedPacketLength(addr, offset, length);
        if (packetSerializedLength <= 0 || packetSerializedLength > length) {
            throw new EPktIncompleteException(length, packetSerializedLength);
        }
        PktPacket packet = this.createPacket(PktHeader.getBodyType(addr, offset));
        packet.deserialize(addr, offset);
        return packet;
    }

    static {
        defaultPktPoolParams = new HashMap<String, Object>();
        shouldPool = Config.getValue((String)"nv.pkt.shouldpool", (boolean)true);
        defaultPktPoolParams.put("default.detachedWash", "true");
        defaultPktPoolParams.put("default.threaded", "true");
        instance = new PktFactory();
    }

    private final class PktTypeTable {
        private final Map<String, PktType> tableByName = new HashMap<String, PktType>();
        private final OpenIntObjectHashMap tableById = new OpenIntObjectHashMap(64510, 0.0, 0.5);
        private final PktType[] array = new PktType[1024];

        PktTypeTable() {
        }

        void put(PktType pktType) {
            PktType pktTypeCurr = null;
            if (pktType.id > 0 && pktType.id < 1024) {
                pktTypeCurr = this.array[pktType.id];
                this.array[pktType.id] = pktType;
            } else {
                pktTypeCurr = (PktType)this.tableById.get(pktType.id);
                this.tableById.put(pktType.id, (Object)pktType);
            }
            if (pktTypeCurr != null && !pktTypeCurr.name.equals(pktType.name)) {
                String str = "Duplicate packet type definitions for packet type #" + pktType.id + ". Packet type '" + pktType.name + "' is attempting to replace '" + pktTypeCurr.name + "'.";
                PktFactory.this.tracer.log(str, Tracer.Level.SEVERE);
                throw new Error(str);
            }
            pktTypeCurr = this.tableByName.put(pktType.name, pktType);
            if (pktTypeCurr != null && pktTypeCurr.id != pktType.id) {
                String str = "Duplicate packet type definitions for packet '" + pktType.name + "'. Packet type #" + pktType.id + " is attempting to replace #" + pktTypeCurr.id + "'.";
                PktFactory.this.tracer.log(str, Tracer.Level.SEVERE);
                throw new Error(str);
            }
        }

        final PktType get(int pktTypeId) {
            PktType pktType = null;
            pktType = pktTypeId > 0 && pktTypeId < 1024 ? this.array[pktTypeId] : (PktType)this.tableById.get(pktTypeId);
            return pktType;
        }

        final PktType get(String pktTypeName) {
            return this.tableByName.get(pktTypeName);
        }
    }

    public static final class PktType {
        private final Factory factory;
        private final UtlPool<PktPacket> pool;
        private final PoolGetObject poolGetObject;
        private volatile EventHandler eventHandler;
        final int id;
        final String name;
        final String bodyClassName;
        final boolean shouldPool;
        final Properties props;
        Method bodyCreateMethod;

        private PktType(int id, String name, String bodyClassName, boolean shouldPool, UtlPool.Params poolParams, Properties props) {
            this.id = id;
            this.name = name;
            this.bodyClassName = bodyClassName;
            this.props = props != null && props.size() > 0 ? props : null;
            this.bodyCreateMethod = null;
            shouldPool = shouldPool && Config.getValue((String)("nv.pkt." + name + ".shouldpool"), (boolean)true) && shouldPool;
            this.factory = new Factory();
            this.poolGetObject = new PoolGetObject();
            if (shouldPool) {
                if (poolParams == null) {
                    poolParams = UtlPool.Params.create();
                }
                poolParams.load("default", defaultPktPoolParams, false);
                this.pool = UtlPool.create((String)"packet", (String)name, (UtlPool.Factory)this.factory, (UtlPool.Params)poolParams);
            } else {
                this.pool = null;
            }
            this.shouldPool = shouldPool;
        }

        public static final PktType create(int id, String name, String bodyClassName, boolean shouldPool, Properties props) {
            return PktType.create(id, name, bodyClassName, shouldPool, null, props);
        }

        public static final PktType create(int id, String name, String bodyClassName, boolean shouldPool, UtlPool.Params poolParams, Properties props) {
            if (id == 0) {
                throw new IllegalArgumentException("id cannot be 0");
            }
            if (name == null) {
                throw new IllegalArgumentException("name cannot be null");
            }
            if (bodyClassName == null) {
                throw new IllegalArgumentException("packet body class name cannot be null");
            }
            return new PktType(id, name, bodyClassName, shouldPool, poolParams, props);
        }

        final PktPacket createPacket(boolean forceNonPooled) {
            this.poolGetObject.reset();
            PktPacket packet = (this.pool != null && !forceNonPooled ? (PktPacket)this.pool.get((Object)this.poolGetObject) : this.factory.createItem(this.poolGetObject)).undispose();
            EventHandler eventHandler = this.eventHandler;
            if (eventHandler != null) {
                eventHandler.onPacketCreate(packet, !this.poolGetObject.factoryWasInvoked);
            }
            return packet;
        }

        public final boolean pooled() {
            return this.shouldPool;
        }

        public final EventHandler setEventHandler(EventHandler eventHandler) {
            EventHandler existing = this.eventHandler;
            this.eventHandler = eventHandler;
            return existing;
        }

        public final EventHandler getEventHandler() {
            return this.eventHandler;
        }

        public String toString() {
            return this.name;
        }

        public static interface EventHandler {
            public void onPacketCreate(PktPacket var1, boolean var2);
        }

        private final class Factory
        implements UtlPool.Factory<PktPacket> {
            PktFactory pktFactory;

            private Factory() {
            }

            public final PktPacket createItem(Object object) {
                if (object != null) {
                    ((PoolGetObject)object).factoryWasInvoked = true;
                }
                if (this.pktFactory == null) {
                    this.pktFactory = PktFactory.getInstance();
                }
                return this.pktFactory.createPacket(PktType.this, 0);
            }

            public final PktPacket[] createItemArray(int size) {
                return new PktPacket[size];
            }
        }

        private final class PoolGetObject {
            boolean factoryWasInvoked;

            private PoolGetObject() {
            }

            final void reset() {
                this.factoryWasInvoked = false;
            }
        }
    }
}

