/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.link.network;

import com.neeve.emx.EEmxException;
import com.neeve.emx.EmxFactory;
import com.neeve.emx.EmxNwLnkOpWaitCond;
import com.neeve.emx.IEmxDispatcher;
import com.neeve.emx.IEmxEvent;
import com.neeve.emx.IEmxEventHandler;
import com.neeve.emx.IEmxNwLnkPeerEndpoint;
import com.neeve.emx.IEmxNwLnkServerEndpoint;
import com.neeve.link.ELnkException;
import com.neeve.link.ELnkOpFailedException;
import com.neeve.link.ILnkEventHandlerCore;
import com.neeve.link.ILnkServerEndpoint;
import com.neeve.link.ILnkServerEndpointCore;
import com.neeve.link.LnkEvents;
import com.neeve.link.LnkServerEndpoint;
import com.neeve.link.network.LnkNwConfig;
import com.neeve.link.network.LnkNwObject;
import com.neeve.link.network.LnkNwPeerEndpoint;
import com.neeve.trace.Tracer;
import com.neeve.util.UtlAddressDescriptor;
import com.neeve.util.UtlProps;
import java.util.Map;

public final class LnkNwServerEndpoint
extends LnkNwObject
implements ILnkServerEndpointCore {
    private final UtlAddressDescriptor descriptor;
    private final IEmxNwLnkServerEndpoint sep;
    AcceptContext context;

    private LnkNwServerEndpoint(UtlAddressDescriptor descriptor) throws ELnkException {
        this.descriptor = descriptor;
        String traceLevelStr = UtlProps.getValue((Map)descriptor.props, (String)"trace", null);
        if (traceLevelStr != null) {
            this.tracer.setLevel(Tracer.getLevel((String)traceLevelStr));
        }
        try {
            this.sep = EmxFactory.getInstance().createNwLnkServerEndpoint(EmxFactory.EmxImpl.DEFAULT, descriptor);
        }
        catch (Exception e) {
            throw new ELnkException(e);
        }
    }

    public static ILnkServerEndpoint create(UtlAddressDescriptor descriptor) throws ELnkException {
        if (descriptor == null) {
            throw new IllegalArgumentException("network link server endpoint descriptor parameter cannot be null");
        }
        LnkNwServerEndpoint sep = new LnkNwServerEndpoint(descriptor);
        return LnkServerEndpoint.create(LnkNwConfig.getConfig(), sep);
    }

    private final void dispatchCompletion(IEmxNwLnkPeerEndpoint pep) throws Exception {
        Exception failure = null;
        if (this.context.dispatcher.getOwner() != Thread.currentThread()) {
            throw new InternalError("A completion event is being dispatched in the context of the wrong thread!");
        }
        try {
            LnkEvents.ConnectAcceptCompleteEventData completionEvent = new LnkEvents.ConnectAcceptCompleteEventData(LnkNwPeerEndpoint.create(pep, this.descriptor));
            try {
                this.context.handler.onEvent(this.context.dispatcher, 2, completionEvent);
            }
            catch (Exception e) {
                this.tracer.log("Exception thrown by handler of the event indicating successful acceptance of a network link [" + e.toString() + "].", Tracer.Level.WARNING);
                failure = e;
            }
        }
        catch (Exception e) {
            this.tracer.log("Error in creating a network link peer endpoint upon successful acceptance of a network link [" + e.toString() + "].", Tracer.Level.WARNING);
            failure = e;
            e.printStackTrace();
        }
        if (failure != null) {
            try {
                pep.close();
            }
            catch (Exception e) {
                this.tracer.log("Failure to close an accepted link upon encountering a failure post successful accept [" + e.toString() + "]. Ignoring.", Tracer.Level.WARNING);
            }
            throw failure;
        }
    }

    private final void dispatchCompletion(ELnkOpFailedException e) {
        block3: {
            if (this.context.dispatcher.getOwner() != Thread.currentThread()) {
                throw new InternalError("A completion event is being dispatched in the context of the wrong thread!");
            }
            try {
                this.context.handler.onEvent(this.context.dispatcher, 2, new LnkEvents.ConnectAcceptCompleteEventData(e));
            }
            catch (Exception e1) {
                if (!this.tracer.debug) break block3;
                this.tracer.log("Exception thrown by handler of the event indicating failed acceptance of network link [" + e.toString() + "]. Ignoring.", Tracer.Level.DEBUG);
            }
        }
    }

    private final boolean accept() throws Exception {
        IEmxNwLnkPeerEndpoint pep = this.sep.accept(this.context.waitCond.reset());
        if (pep != null) {
            this.dispatchCompletion(pep);
            return true;
        }
        if (this.context.waitCond.list().size() <= 0 || this.context.waitCond.list().size() > 1) {
            throw new InternalError("Unsupported events in wait condition list returned by acceptPost() [" + this.context.waitCond.list().size() + "]");
        }
        if (((IEmxEvent)this.context.waitCond.list().get(0)).getType() != IEmxEvent.EventType.NW_ACCEPT_READY) {
            throw new InternalError("Unsupported event in wait condition list returned by acceptPost() " + this.context.waitCond.list().get(0));
        }
        return false;
    }

    private final boolean onAcceptReady() {
        try {
            if (this.accept()) {
                if (this.tracer.debug) {
                    this.tracer.log("Accept successful.", Tracer.Level.DEBUG);
                }
                return false;
            }
            if (this.tracer.debug) {
                this.tracer.log("Accept still pending. Rescheduling event with dispatcher...", Tracer.Level.DEBUG);
            }
            return true;
        }
        catch (Exception e) {
            if (this.tracer.debug) {
                this.tracer.log("Accept failed [" + e.toString() + "].", Tracer.Level.DEBUG);
            }
            this.dispatchCompletion(new ELnkOpFailedException(e));
            return false;
        }
    }

    @Override
    public final void acceptPost(IEmxDispatcher dispatcher, ILnkEventHandlerCore handler, int flags) throws ELnkOpFailedException {
        try {
            this.context = new AcceptContext(dispatcher, handler, new EmxNwLnkOpWaitCond());
            if (!this.accept()) {
                if ((flags & 2) == 0) {
                    if (this.tracer.debug) {
                        this.tracer.log("Accept pending. Scheduling event " + this.context.waitCond.list().get(0) + " with dispatcher...", Tracer.Level.DEBUG);
                    }
                    dispatcher.schedEv(((IEmxEvent)this.context.waitCond.list().get(0)).setHandler(new AcceptReadyEventHandler()));
                } else if (this.tracer.debug) {
                    this.tracer.log("Accept pending but NO_ASYNC flag is set. Returning...", Tracer.Level.DEBUG);
                }
            }
        }
        catch (Exception e) {
            throw new ELnkOpFailedException(e);
        }
    }

    @Override
    public final void acceptCancel(int flags) {
        if (this.context != null) {
            if (this.tracer.debug) {
                this.tracer.log("Unscheduling event " + this.context.waitCond.list().get(0) + " from dispatcher...", Tracer.Level.DEBUG);
            }
            this.context.dispatcher.unschedEv((IEmxEvent)this.context.waitCond.list().get(0));
        }
    }

    @Override
    public final void close() throws ELnkOpFailedException {
        try {
            if (this.tracer.debug) {
                this.tracer.log("Closing underlying EMX network link server endpoint...", Tracer.Level.DEBUG);
            }
            this.sep.close();
        }
        catch (EEmxException e) {
            throw new ELnkOpFailedException((Throwable)((Object)e));
        }
    }

    private final class AcceptReadyEventHandler
    implements IEmxEventHandler {
        private AcceptReadyEventHandler() {
        }

        @Override
        public final boolean onEvent(IEmxDispatcher dispatcher, IEmxEvent event) {
            return LnkNwServerEndpoint.this.onAcceptReady();
        }
    }

    private final class AcceptContext {
        final IEmxDispatcher dispatcher;
        final ILnkEventHandlerCore handler;
        final EmxNwLnkOpWaitCond waitCond;

        AcceptContext(IEmxDispatcher dispatcher, ILnkEventHandlerCore handler, EmxNwLnkOpWaitCond waitCond) {
            this.dispatcher = dispatcher;
            this.handler = handler;
            this.waitCond = waitCond;
        }
    }
}

