/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.link;

import com.neeve.emx.IEmxDispatcher;
import com.neeve.link.ELnkInvalidStateException;
import com.neeve.link.ELnkOpFailedException;
import com.neeve.link.ILnkEventHandler;
import com.neeve.link.ILnkPeerEndpoint;
import com.neeve.link.ILnkServerEndpoint;
import com.neeve.link.LnkEvents;
import com.neeve.link.LnkObject;
import com.neeve.link.LnkSynchronizer;

public final class LnkSynchronousAcceptor
extends LnkObject {
    private LnkSynchronousAcceptor() {
        super(null);
    }

    public static LnkSynchronousAcceptor create() {
        return new LnkSynchronousAcceptor();
    }

    public final ILnkPeerEndpoint run(ILnkServerEndpoint sep, int timeout) throws ELnkInvalidStateException, ELnkOpFailedException {
        if (sep == null) {
            throw new IllegalArgumentException("server endpoint cannot be null");
        }
        if (timeout <= 0) {
            throw new IllegalArgumentException("timeout must be positive");
        }
        LnkEvents.ConnectAcceptCompleteEventData completionData = (LnkEvents.ConnectAcceptCompleteEventData)new LnkSynchronizer().run(new Operation(sep, timeout), -1, this.tracer);
        if (completionData.status) {
            return completionData.pep;
        }
        throw completionData.e;
    }

    private static final class Operation
    extends LnkSynchronizer.Operation {
        final ILnkServerEndpoint sep;
        final int timeout;

        Operation(ILnkServerEndpoint sep, int timeout) {
            this.sep = sep;
            this.timeout = timeout;
        }

        @Override
        final void execute(IEmxDispatcher dispatcher, ILnkEventHandler handler) throws ELnkOpFailedException {
            this.sep.acceptPost(dispatcher, handler, this.timeout, 1);
        }
    }
}

