/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.link;

import com.neeve.emx.IEmxDispatcher;
import com.neeve.link.ELnkException;
import com.neeve.link.ELnkHandshakeException;
import com.neeve.link.ELnkNotPresentException;
import com.neeve.link.ELnkOpCancelledException;
import com.neeve.link.ELnkOpFailedException;
import com.neeve.link.ILnkClientEndpointCore;
import com.neeve.link.ILnkEventHandlerCore;
import com.neeve.link.ILnkPeerEndpoint;
import com.neeve.link.LnkContainer;
import com.neeve.link.LnkEvents;
import com.neeve.link.LnkHandshaker;
import com.neeve.link.LnkLTPAuthority;
import com.neeve.link.LnkObject;
import com.neeve.link.LnkRegistry;
import com.neeve.pkt.PktHeader;
import com.neeve.pkt.PktPacket;
import com.neeve.root.RootConfig;
import com.neeve.trace.Tracer;
import com.neeve.util.UtlAddressDescriptor;
import com.neeve.util.UtlProps;
import java.util.Map;

public abstract class LnkLayeredClientEndpoint
extends LnkObject
implements ILnkClientEndpointCore {
    private final RootConfig.ObjectConfig config;
    private State state;
    private ConnectContext context;
    protected final UtlAddressDescriptor descriptor;
    protected final ILnkPeerEndpoint pep;
    protected final short ltp;

    protected LnkLayeredClientEndpoint(RootConfig.ObjectConfig config, UtlAddressDescriptor descriptor) throws ELnkException {
        super(config);
        this.config = config;
        this.descriptor = descriptor;
        this.pep = this.getPep();
        this.ltp = LnkLTPAuthority.getInstance().alloc();
        if (this.tracer.debug) {
            this.tracer.log("Using LTP=" + this.ltp, Tracer.Level.DEBUG);
        }
        this.state = State.INIT;
    }

    private final ILnkPeerEndpoint getPep() throws ELnkException {
        String containerName = UtlProps.getValue((Map)this.descriptor.props, (String)"container", null);
        if (containerName != null) {
            String baseEndpointName = UtlProps.getValue((Map)this.descriptor.props, (String)"base", null);
            if (baseEndpointName != null) {
                LnkContainer container = LnkRegistry.getInstance().getContainer(containerName);
                if (container != null) {
                    ILnkPeerEndpoint pep = container.getLink(baseEndpointName);
                    if (pep != null) {
                        return pep;
                    }
                    throw new ELnkNotPresentException("Base link '" + baseEndpointName + "' not present in container '" + containerName + "'");
                }
                throw new ELnkNotPresentException("Container '" + containerName + "' not found");
            }
            throw new ELnkException("Base link not specified (Use 'base' property in descriptor)");
        }
        throw new ELnkException("Container not specified (Use 'container' property in descriptor)");
    }

    private final void dispatchCompletion(ILnkPeerEndpoint pep) throws Exception {
        if (this.context.dispatcher.getOwner() != Thread.currentThread()) {
            throw new InternalError("A completion event is being dispatched in the context of the wrong thread!");
        }
        LnkEvents.ConnectAcceptCompleteEventData completionEvent = new LnkEvents.ConnectAcceptCompleteEventData(pep);
        try {
            this.context.handler.onEvent(this.context.dispatcher, 1, completionEvent);
        }
        catch (Exception e) {
            this.tracer.log("Exception thrown by handler of the event indicating successful establishment of a layered link [" + e.toString() + "].", Tracer.Level.DIAGNOSE);
            throw e;
        }
    }

    private final void dispatchCompletion(ELnkOpFailedException e) {
        if (this.context.dispatcher.getOwner() != Thread.currentThread()) {
            throw new InternalError("A completion event is being dispatched in the context of the wrong thread!");
        }
        try {
            this.context.handler.onEvent(this.context.dispatcher, 1, new LnkEvents.ConnectAcceptCompleteEventData(e));
        }
        catch (Exception e1) {
            this.tracer.log("Exception thrown by handler of the event indicating failed establishment of layered link [" + e1.toString() + "]. Ignoring.", Tracer.Level.DIAGNOSE);
        }
    }

    private final void onEvent(Event event, Object eventData) {
        if (this.tracer.debug) {
            this.tracer.log("Layered client endpoint state machine ENTRY [state=" + (Object)((Object)this.state) + " event=" + (Object)((Object)event) + "]", Tracer.Level.DEBUG);
        }
        block3 : switch (this.state) {
            case INIT: {
                switch (event) {
                    case ON_START: {
                        this.context = (ConnectContext)eventData;
                        this.state = State.HANDSHAKING;
                        this.context.handshaker.start(this.context.dispatcher);
                        break block3;
                    }
                    case ON_CLOSE: {
                        this.closeFinal();
                        break block3;
                    }
                }
                throw new InternalError("Invalid event [" + event.toString() + " for state [" + this.state.toString() + "]");
            }
            case HANDSHAKING: {
                switch (event) {
                    case ON_HANDSHAKE_SUCCESS: {
                        this.state = State.CONNECTED;
                        try {
                            ILnkPeerEndpoint pep = this.createPeerEndpoint((LnkHandshaker.CompletionData)eventData);
                            try {
                                this.dispatchCompletion(pep);
                            }
                            catch (Exception e) {
                                this.state = State.FAILED;
                                try {
                                    pep.close((short)-1);
                                }
                                catch (Exception e1) {
                                    this.tracer.log("Error in closing layered link peer endpoint upon exception from completion handler [" + e1.toString() + "].", Tracer.Level.DIAGNOSE);
                                }
                            }
                        }
                        catch (Exception e) {
                            this.state = State.FAILED;
                            ELnkOpFailedException e1 = e instanceof ELnkOpFailedException ? (ELnkOpFailedException)((Object)e) : new ELnkOpFailedException(e);
                            this.dispatchCompletion(e1);
                        }
                        break block3;
                    }
                    case ON_HANDSHAKE_FAIL: {
                        this.state = State.FAILED;
                        ELnkOpFailedException e = eventData instanceof ELnkOpFailedException ? (ELnkOpFailedException)((Object)eventData) : new ELnkOpFailedException((Throwable)eventData);
                        this.dispatchCompletion(e);
                        break block3;
                    }
                    case ON_CANCEL: {
                        this.state = State.CANCELLING;
                        this.context.handshaker.stop();
                        break block3;
                    }
                }
                throw new InternalError("Invalid event [" + event.toString() + " for state [" + this.state.toString() + "]");
            }
            case CONNECTED: {
                switch (event) {
                    default: 
                }
                throw new InternalError("Invalid event [" + event.toString() + " for state [" + this.state.toString() + "]");
            }
            case FAILED: {
                switch (event) {
                    case ON_CLOSE: {
                        this.closeFinal();
                        break block3;
                    }
                }
                throw new InternalError("Invalid event [" + event.toString() + " for state [" + this.state.toString() + "]");
            }
            case CANCELLING: {
                switch (event) {
                    case ON_CANCEL_COMPLETE: {
                        this.state = State.CANCELLED;
                        break block3;
                    }
                    case ON_CLOSE: {
                        this.state = State.CLOSING;
                        break block3;
                    }
                }
                throw new InternalError("Invalid event [" + event.toString() + " for state [" + this.state.toString() + "]");
            }
            case CANCELLED: {
                switch (event) {
                    case ON_CLOSE: {
                        this.closeFinal();
                        break block3;
                    }
                }
                throw new InternalError("Invalid event [" + event.toString() + " for state [" + this.state.toString() + "]");
            }
            case CLOSING: {
                switch (event) {
                    case ON_CANCEL_COMPLETE: {
                        this.closeFinal();
                        break block3;
                    }
                }
                throw new InternalError("Invalid event [" + event.toString() + " for state [" + this.state.toString() + "]");
            }
            case CLOSED: {
                switch (event) {
                    default: 
                }
                throw new InternalError("Invalid event [" + event.toString() + " for state [" + this.state.toString() + "]");
            }
            default: {
                throw new InternalError("Invalid state [" + this.state.toString() + "]");
            }
        }
    }

    protected abstract PktPacket getRequest();

    protected abstract short getExpectedReplyType();

    protected abstract ILnkPeerEndpoint createPeerEndpoint(LnkHandshaker.CompletionData var1) throws Exception;

    protected final void closeFinal() {
        LnkLTPAuthority.getInstance().release(this.ltp);
        this.state = State.CLOSED;
    }

    @Override
    public final void connectPost(IEmxDispatcher dispatcher, ILnkEventHandlerCore handler, int flags) throws ELnkOpFailedException {
        if ((flags & 2) == 0) {
            this.onEvent(Event.ON_START, new ConnectContext(dispatcher, handler, new Handshaker()));
        }
    }

    @Override
    public final void connectCancel(int flags) {
        this.onEvent(Event.ON_CANCEL, null);
    }

    @Override
    public final void close() throws ELnkOpFailedException {
        this.onEvent(Event.ON_CLOSE, null);
    }

    protected static enum State {
        INIT,
        HANDSHAKING,
        CONNECTED,
        FAILED,
        CANCELLING,
        CANCELLED,
        CLOSING,
        CLOSED;

    }

    private static enum Event {
        ON_START,
        ON_HANDSHAKE_SUCCESS,
        ON_HANDSHAKE_FAIL,
        ON_CANCEL,
        ON_CANCEL_COMPLETE,
        ON_CLOSE;

    }

    private final class Handshaker
    extends LnkHandshaker {
        Handshaker() {
            super(LnkLayeredClientEndpoint.this.config, LnkLayeredClientEndpoint.this.pep, 0, LnkLayeredClientEndpoint.this.ltp, LnkHandshaker.State.CONNECTED);
        }

        @Override
        protected final PktPacket prepareRequest() throws Exception {
            PktHeader pktHeader = LnkLayeredClientEndpoint.this.getRequest().getHeader();
            pktHeader.setSrcPort(LnkLayeredClientEndpoint.this.ltp);
            return LnkLayeredClientEndpoint.this.getRequest();
        }

        @Override
        protected final void validateRequest(PktPacket request) throws Exception {
            throw new InternalError("Client side of the handshake received request to validate handshake request!");
        }

        @Override
        protected final PktPacket prepareReply(PktPacket request) throws Exception {
            throw new InternalError("Client side of the handshake received request to prepare handshake reply!");
        }

        @Override
        protected final void validateReply(PktPacket reply) throws Exception {
            if (reply.getBody().getType() != LnkLayeredClientEndpoint.this.getExpectedReplyType()) {
                throw new ELnkHandshakeException("Invalid connect reply packet type [" + reply.getBody().getType() + "]");
            }
        }

        @Override
        protected final void onComplete(LnkHandshaker.CompletionData completionData) {
            if (completionData.status == null && LnkLayeredClientEndpoint.this.pep.isReadOperational()) {
                throw new InternalError("Read is operational after successful handshake completion!");
            }
            if (completionData.status == null) {
                LnkLayeredClientEndpoint.this.onEvent(Event.ON_HANDSHAKE_SUCCESS, completionData);
            } else if (completionData.status instanceof ELnkOpCancelledException) {
                LnkLayeredClientEndpoint.this.onEvent(Event.ON_CANCEL_COMPLETE, null);
            } else {
                LnkLayeredClientEndpoint.this.onEvent(Event.ON_HANDSHAKE_FAIL, completionData.status);
            }
        }
    }

    private final class ConnectContext {
        final ILnkEventHandlerCore handler;
        final IEmxDispatcher dispatcher;
        final Handshaker handshaker;

        ConnectContext(IEmxDispatcher dispatcher, ILnkEventHandlerCore handler, Handshaker handshaker) {
            this.dispatcher = dispatcher;
            this.handler = handler;
            this.handshaker = handshaker;
        }
    }
}

