/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.link;

import cern.colt.list.ObjectArrayList;
import com.neeve.config.Config;
import com.neeve.emx.IEmxDispatcher;
import com.neeve.link.ELnkAlreadyPresentException;
import com.neeve.link.ELnkException;
import com.neeve.link.ELnkNotCompatibleException;
import com.neeve.link.ELnkNotPresentException;
import com.neeve.link.ELnkReadOperationalException;
import com.neeve.link.ILnkPeerEndpoint;
import com.neeve.link.LnkObject;
import com.neeve.link.LnkRegistry;
import com.neeve.root.RootConfig;
import com.neeve.trace.Tracer;
import com.neeve.util.UtlAddressDescriptor;
import java.util.HashMap;
import java.util.Iterator;

public abstract class LnkContainer
extends LnkObject {
    private final String name;
    private final HashMap<String, ILnkPeerEndpoint> table;
    public static final int RMFLG_ALLOW_READ_OPERATIONAL = 1;

    protected LnkContainer(RootConfig.ObjectConfig config, String name) throws ELnkAlreadyPresentException {
        super(config);
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        this.name = name;
        this.table = new HashMap();
        Config.setTraceLevel((Tracer)this.tracer, (String)"nv.link.container.trace");
        this.threaded = true;
        LnkRegistry.getInstance().addContainer(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void addLink(ILnkPeerEndpoint pep) throws ELnkAlreadyPresentException, ELnkReadOperationalException, ELnkNotCompatibleException {
        HashMap<String, ILnkPeerEndpoint> hashMap = this.table;
        synchronized (hashMap) {
            if (this.table.containsKey(pep.getName())) throw new ELnkAlreadyPresentException();
            if (pep.isReadOperational()) throw new ELnkReadOperationalException();
            if (!this.isCompatible(pep)) {
                throw new ELnkNotCompatibleException();
            }
            this.table.put(pep.getName(), pep);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ILnkPeerEndpoint removeLink(String name, int flags) throws ELnkReadOperationalException {
        HashMap<String, ILnkPeerEndpoint> hashMap = this.table;
        synchronized (hashMap) {
            boolean flgAllowReadOperational;
            ILnkPeerEndpoint pep = this.table.get(name);
            boolean bl = flgAllowReadOperational = (flags & 1) == 1;
            if (pep != null) {
                if (flgAllowReadOperational || !pep.isReadOperational()) {
                    return this.table.remove(name);
                }
                throw new ELnkReadOperationalException();
            }
            return null;
        }
    }

    protected final void onStartRead(ILnkPeerEndpoint pep) throws ELnkNotPresentException, ELnkReadOperationalException, ELnkNotCompatibleException {
        if (pep.isReadOperational()) {
            throw new ELnkReadOperationalException();
        }
        if (pep.getContainer() != null) {
            if (pep.getContainer() != this) {
                throw new ELnkNotPresentException();
            }
        } else if (!this.isCompatible(pep)) {
            throw new ELnkNotCompatibleException();
        }
    }

    protected final void onStopRead(ILnkPeerEndpoint pep) throws ELnkNotPresentException, ELnkNotCompatibleException {
        if (pep.getContainer() != null) {
            if (pep.getContainer() != this) {
                throw new ELnkNotPresentException();
            }
        } else if (!this.isCompatible(pep)) {
            throw new ELnkNotCompatibleException();
        }
    }

    public final String getName() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ILnkPeerEndpoint getLink(String name) {
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        HashMap<String, ILnkPeerEndpoint> hashMap = this.table;
        synchronized (hashMap) {
            return this.table.get(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ObjectArrayList getLinks() {
        HashMap<String, ILnkPeerEndpoint> hashMap = this.table;
        synchronized (hashMap) {
            ObjectArrayList list = new ObjectArrayList();
            Iterator<ILnkPeerEndpoint> iterator = this.table.values().iterator();
            while (iterator.hasNext()) {
                list.add((Object)iterator.next());
            }
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int getCount() {
        HashMap<String, ILnkPeerEndpoint> hashMap = this.table;
        synchronized (hashMap) {
            return this.table.size();
        }
    }

    public final String touch(String descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException("descriptor cannot be null");
        }
        return descriptor + "&private=false&container=" + this.getName();
    }

    public final UtlAddressDescriptor touch(UtlAddressDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException("descriptor cannot be null");
        }
        descriptor.props.put("private", false);
        descriptor.props.put("container", this.getName());
        return descriptor;
    }

    public abstract boolean isCompatible(ILnkPeerEndpoint var1);

    public abstract void startRead(ILnkPeerEndpoint var1) throws ELnkNotPresentException, ELnkReadOperationalException, ELnkNotCompatibleException, ELnkException;

    public abstract IEmxDispatcher getCurrentReader();

    public abstract void stopRead(ILnkPeerEndpoint var1) throws ELnkNotPresentException, ELnkNotCompatibleException, ELnkException;

    public String toString() {
        return this.getName();
    }
}

