/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.server.thread;

import com.neeve.daemon.thread.DmnThread;
import com.neeve.daemon.thread.DmnThreadManager;
import com.neeve.daemon.thread.EDmnThreadException;
import com.neeve.emx.EmxFactory;
import com.neeve.emx.IEmxDispatcher;
import com.neeve.emx.IEmxEvent;
import com.neeve.emx.IEmxEventHandler;
import com.neeve.emx.IEmxUserEvent;
import com.neeve.server.thread.ESrvThreadException;
import com.neeve.server.thread.ISrvThreadAssignCompletionHandler;
import com.neeve.server.thread.SrvThreadAssignSuccessCompletionData;
import com.neeve.server.thread.SrvThreadConfig;
import com.neeve.trace.Tracer;
import com.neeve.util.UtlAddressDescriptor;
import com.neeve.util.UtlProps;
import java.util.Properties;

public final class SrvThreadManager
extends DmnThreadManager {
    private final IOEntityAssignCompleteEventHandler ioEntityAssignCompleteEventHandler = new IOEntityAssignCompleteEventHandler();

    private SrvThreadManager(String name) {
        super(name, SrvThreadConfig.getConfig());
    }

    public static final SrvThreadManager create(String name) {
        return new SrvThreadManager(name);
    }

    private final void onIOEntityAssignComplete(IEmxDispatcher dispatcher, IOEntityAssignmentTransferData data) {
        data.assignCompletionHandler.onAssignComplete(dispatcher, true, new SrvThreadAssignSuccessCompletionData(data.entity));
    }

    public final IEmxDispatcher getThreadForAcceptor(UtlAddressDescriptor descriptor) {
        return this.pool.getMainThread().getDispatcher();
    }

    public final IEmxDispatcher getThreadForHandshake(UtlAddressDescriptor descriptor) {
        return this.pool.getMainThread().getDispatcher();
    }

    public final void assignThreadToIOEntity(Object entity, Properties props, ISrvThreadAssignCompletionHandler completionHandler) throws ESrvThreadException {
        DmnThread thread;
        if (this.tracer.debug) {
            this.tracer.log("Assigning thread to entity " + entity + "...", Tracer.Level.DEBUG);
        }
        int threadAffinity = UtlProps.getValue((Properties)props, (String)"ThreadAffinity", (int)-1);
        if (this.tracer.debug) {
            this.tracer.log("Using thread affinity '" + threadAffinity + "'...", Tracer.Level.DEBUG);
        }
        try {
            if (threadAffinity == -2) {
                if (this.tracer.debug) {
                    this.tracer.log("Creating new thread for entity...", Tracer.Level.DEBUG);
                }
                thread = this.getThreadPool().createThread();
            } else {
                if (this.tracer.debug) {
                    this.tracer.log("Using one of the existing threads for entity...", Tracer.Level.DEBUG);
                }
                thread = this.getIOThreadByAffinity(threadAffinity);
            }
        }
        catch (EDmnThreadException e) {
            throw new ESrvThreadException((Throwable)((Object)e));
        }
        if (this.tracer.debug) {
            this.tracer.log("Posting user event to selected thread [" + thread.getDispatcher().getName() + "]...", Tracer.Level.DEBUG);
        }
        IEmxUserEvent userEvent = (IEmxUserEvent)EmxFactory.getInstance().createUserEvent(EmxFactory.EmxImpl.DEFAULT, (IEmxEventHandler)this.ioEntityAssignCompleteEventHandler).setAttachment((Object)new IOEntityAssignmentTransferData(entity, completionHandler));
        thread.getDispatcher().schedUserEv(userEvent);
    }

    private final class IOEntityAssignCompleteEventHandler
    implements IEmxEventHandler {
        private IOEntityAssignCompleteEventHandler() {
        }

        public final boolean onEvent(IEmxDispatcher dispatcher, IEmxEvent event) {
            SrvThreadManager.this.onIOEntityAssignComplete(dispatcher, (IOEntityAssignmentTransferData)event.getAttachment());
            return false;
        }
    }

    private final class IOEntityAssignmentTransferData
    extends AssignmentTransferData {
        IOEntityAssignmentTransferData(Object entity, ISrvThreadAssignCompletionHandler completionHandler) {
            super(entity, completionHandler);
        }
    }

    private abstract class AssignmentTransferData {
        final Object entity;
        final ISrvThreadAssignCompletionHandler assignCompletionHandler;

        AssignmentTransferData(Object entity, ISrvThreadAssignCompletionHandler assignCompletionHandler) {
            this.entity = entity;
            this.assignCompletionHandler = assignCompletionHandler;
        }
    }
}

