/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.server.admin.impl.sma;

import com.neeve.event.Event;
import com.neeve.event.IEventHandler;
import com.neeve.lang.XIterator;
import com.neeve.lang.XLongLinkedHashMap;
import com.neeve.rog.IRogMessage;
import com.neeve.server.admin.AdminSession;
import com.neeve.server.admin.AdminSessionFactory;
import com.neeve.server.admin.EAdminException;
import com.neeve.server.admin.EAdminOpFailedException;
import com.neeve.server.admin.EAdminOpServerErrorException;
import com.neeve.server.admin.EAdminOpTimeoutException;
import com.neeve.server.admin.impl.AdminSessionBase;
import com.neeve.server.mon.SrvMonHeartbeatMessage;
import com.neeve.server.mon.cnc.ISrvMonXvmRequest;
import com.neeve.server.mon.cnc.ISrvMonXvmResponse;
import com.neeve.server.mon.cnc.SrvMonGetLoadedAppsRequest;
import com.neeve.server.mon.cnc.SrvMonGetLoadedAppsResponse;
import com.neeve.server.mon.cnc.SrvMonGetTraceHistoryRequest;
import com.neeve.server.mon.cnc.SrvMonGetTraceHistoryResponse;
import com.neeve.server.mon.cnc.SrvMonInvokeCommandRequest;
import com.neeve.server.mon.cnc.SrvMonTrace;
import com.neeve.server.mon.cnc.SrvMonTraceRecord;
import com.neeve.server.mon.cnc.SrvMonXvmInfoRequest;
import com.neeve.server.mon.cnc.SrvMonXvmInfoResponse;
import com.neeve.sma.MessageBusBinding;
import com.neeve.sma.MessageBusBindingFactory;
import com.neeve.sma.MessageBusDescriptor;
import com.neeve.sma.MessageChannel;
import com.neeve.sma.MessageView;
import com.neeve.sma.SmaException;
import com.neeve.sma.event.MessageBusBindingFailedEvent;
import com.neeve.sma.event.MessageEvent;
import com.neeve.trace.Tracer;
import com.neeve.util.UtlProps;
import com.neeve.util.UtlThrowable;
import com.neeve.util.UtlUnit;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;

public final class AdminSmaSession
extends AdminSessionBase
implements AdminSession {
    public static final String TYPE = "sma";
    private final MessageBusDescriptor messageBusDescriptor;
    private final AtomicLong nextCorrelationId;
    private final AtomicBoolean traceJoinPending;
    private final AtomicBoolean appWatchJoinPending;
    private final XLongLinkedHashMap<MessageView> pendingRequests = new XLongLinkedHashMap();
    private final Object requestLock = new Object();
    private MessageBusBinding messageBusBinding;
    private MessageChannel.RawKeyResolutionTable krt;
    private MessageChannel requestChannel;
    private MessageChannel traceChannel;
    private MessageChannel heartbeatChannel;
    private MessageChannel eventChannel;
    private BusEventHandler busEventHandler;

    private AdminSmaSession(String adminClientId, String xvmName, AdminSession.EventHandler eventHandler, Properties sessionProps, Tracer tracer) throws EAdminException {
        super(adminClientId + "-" + xvmName, xvmName, eventHandler, sessionProps, tracer);
        this.messageBusDescriptor = AdminSessionFactory.loadAdminBusDescriptor(sessionProps);
        this.nextCorrelationId = new AtomicLong(System.currentTimeMillis());
        this.traceJoinPending = new AtomicBoolean(false);
        this.appWatchJoinPending = new AtomicBoolean(false);
        if (tracer.isEnabled(Tracer.Level.CONFIG)) {
            StringBuilder sb = new StringBuilder();
            sb.append("SMA Admin Session created for xvm '" + xvmName + "' {\n");
            sb.append("...busName=" + this.messageBusDescriptor.getName()).append("\n");
            sb.append("...busDescriptor=" + this.getConnectionDescriptor()).append("\n");
            sb.append("...adminClientId=" + this.adminClientId).append("\n");
            sb.append("...passiveMonitoringOnly=" + this.isPassiveMonitoringOnly()).append("\n");
            sb.append("...sessionProps {\n");
            HashMap filteredProps = (HashMap)UtlProps.getSubProps((Properties)sessionProps, (String)"nv.server.admin", (boolean)true, new HashMap());
            for (Map.Entry prop : filteredProps.entrySet()) {
                sb.append("......").append(String.valueOf(prop.getKey())).append("=").append(String.valueOf(prop.getValue())).append("\n");
            }
            sb.append("}");
            tracer.log(this.tracePrefix + sb.toString(), Tracer.Level.CONFIG);
        }
    }

    public static final AdminSmaSession create(String adminClientId, String xvmName, AdminSession.EventHandler eventHandler, Properties connectionProps, Tracer tracer) throws EAdminException {
        return new AdminSmaSession(adminClientId, xvmName, eventHandler, connectionProps, tracer);
    }

    public final void setKeyResolutionTable(MessageChannel.RawKeyResolutionTable krt) {
        this.krt = krt;
    }

    @Override
    public final String getTransportType() {
        return TYPE;
    }

    @Override
    public final String getConnectionDescriptor() {
        try {
            return this.messageBusDescriptor.getProviderConfigAsAddressDescriptor().toFullString();
        }
        catch (SmaException e) {
            return "Connection Descriptor Unavailable [" + e.getMessage() + "]";
        }
    }

    @Override
    protected final void doConnect() throws EAdminException {
        this.openAdminBusBinding();
        this.adminCompatVersion = 5;
        if (!this.isPassiveMonitoringOnly()) {
            SrvMonXvmInfoResponse xvmInfo = null;
            for (int i = 0; i < 5; ++i) {
                try {
                    xvmInfo = (SrvMonXvmInfoResponse)this.sendRequest(SrvMonXvmInfoRequest.create(), 200 + i * 50);
                    if (xvmInfo == null) continue;
                }
                catch (EAdminOpFailedException e) {
                    if (i != 4) continue;
                    if (!this.tracer.debug) break;
                    this.tracer.log("No response from peer admin app: " + e.getMessage(), Tracer.Level.DEBUG);
                }
                break;
            }
            if (xvmInfo == null) {
                throw new EAdminOpTimeoutException("Timed out waiting for admin app to come up");
            }
            this.systemName = xvmInfo.getSystemName();
            this.systemVersion = xvmInfo.getSystemVersion();
            this.setAdminCompatVersion(xvmInfo.getXvmAdminVersion());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final void doClose() {
        if (this.messageBusBinding != null) {
            try {
                this.messageBusBinding.close();
                if (this.tracer.fine) {
                    this.tracer.log(this.tracePrefix + " Closed Bus Binding", Tracer.Level.FINE);
                }
            }
            catch (SmaException e) {
                this.tracer.log("Error closing admin message bus binding: " + UtlThrowable.prepareStackTrace((Throwable)e), Tracer.Level.WARNING);
            }
            Object object = this.requestLock;
            synchronized (object) {
                this.requestLock.notifyAll();
            }
        }
    }

    @Override
    protected final void doStartAppWatch() throws EAdminOpFailedException {
        try {
            if (this.appWatchJoinPending.compareAndSet(false, true)) {
                if (!this.heartbeatChannel.isJoined()) {
                    this.heartbeatChannel.join(0);
                }
                if (!this.eventChannel.isJoined()) {
                    this.eventChannel.join(0);
                }
                if (!this.isPassiveMonitoringOnly()) {
                    SrvMonGetLoadedAppsRequest request = SrvMonGetLoadedAppsRequest.create();
                    this.sendRequest(request, 0);
                }
            }
        }
        catch (SmaException e) {
            try {
                this.doStopAppWatch();
            }
            catch (Exception e2) {
                this.tracer.log(this.tracePrefix + "Failed to stop app watch after app watch start failure: " + UtlThrowable.prepareStackTrace((Throwable)e2), Tracer.Level.WARNING);
            }
            throw new EAdminOpFailedException("Failed to start app watch [" + e.getMessage() + "]", e);
        }
    }

    @Override
    protected final void doStopAppWatch() throws EAdminOpFailedException {
        try {
            if (this.heartbeatChannel.isJoined()) {
                this.heartbeatChannel.leave(0);
            }
            if (this.eventChannel.isJoined()) {
                this.eventChannel.leave(0);
            }
        }
        catch (SmaException e) {
            throw new EAdminOpFailedException("Failed to stop app watch [" + e.getMessage() + "]", e);
        }
    }

    @Override
    protected final void doStartTraceWatch() throws EAdminOpFailedException {
        if (!this.traceChannel.isJoined()) {
            if (!this.isPassiveMonitoringOnly()) {
                if (this.tracer.fine) {
                    this.tracer.log(this.tracePrefix + "Active Monitoring enabled ... requesting trace history prior to joining trace stream.", Tracer.Level.FINE);
                }
                this.traceJoinPending.set(true);
            } else if (this.tracer.fine) {
                this.tracer.log(this.tracePrefix + "Passively joining XVM trace stream.", Tracer.Level.FINE);
            }
            try {
                this.traceChannel.join(0);
            }
            catch (SmaException e) {
                this.traceJoinPending.set(false);
                throw new EAdminOpFailedException("Failed to start trace watch [" + e.getMessage() + "]", e);
            }
            if (!this.isPassiveMonitoringOnly()) {
                try {
                    this.sendRequest(SrvMonGetTraceHistoryRequest.create(), 0);
                }
                catch (EAdminOpFailedException e) {
                    this.tracer.log(this.tracePrefix + "Failed to request trace history ... trace history will not be dispatched.", Tracer.Level.WARNING);
                    this.traceJoinPending.set(false);
                }
            }
        }
    }

    @Override
    protected final void doStopTraceWatch() throws EAdminOpFailedException {
        if (this.traceChannel.isJoined()) {
            try {
                this.traceChannel.leave(0);
            }
            catch (SmaException e) {
                throw new EAdminOpFailedException("Failed to stop trace watch [" + e.getMessage() + "]", e);
            }
        }
    }

    private final void openAdminBusBinding() throws EAdminException {
        if (this.tracer.fine) {
            this.tracer.log(this.tracePrefix + " Opening Bus Binding...", Tracer.Level.FINE);
        }
        this.busEventHandler = new BusEventHandler();
        this.messageBusDescriptor.getChannel("xvm-response").setChannelFilter("xvmName=" + this.xvmName + ";adminClientId=" + this.adminClientId);
        this.messageBusDescriptor.getChannel("xvm-trace").setChannelFilter("xvmName=" + this.xvmName);
        this.messageBusDescriptor.getChannel("xvm-heartbeat").setChannelFilter("xvmName=" + this.xvmName);
        this.messageBusDescriptor.getChannel("xvm-event").setChannelFilter("xvmName=" + this.xvmName);
        try {
            this.messageBusBinding = MessageBusBindingFactory.getInstance().createBinding(this.adminClientId, this.messageBusDescriptor, (IEventHandler)this.busEventHandler);
            this.requestChannel = this.messageBusBinding.getMessageChannel("xvm-request");
            this.traceChannel = this.messageBusBinding.getMessageChannel("xvm-trace");
            this.heartbeatChannel = this.messageBusBinding.getMessageChannel("xvm-heartbeat");
            this.eventChannel = this.messageBusBinding.getMessageChannel("xvm-event");
            MessageChannel responseChannel = this.messageBusBinding.getMessageChannel("xvm-response");
            if (!this.isPassiveMonitoringOnly()) {
                responseChannel.join(0);
            }
            this.messageBusBinding.start();
            if (this.tracer.fine) {
                this.tracer.log(this.tracePrefix + " Opened Bus Binding", Tracer.Level.FINE);
            }
        }
        catch (SmaException e) {
            if (this.messageBusBinding != null) {
                this.requestChannel = null;
                this.traceChannel = null;
                this.heartbeatChannel = null;
                this.eventChannel = null;
                try {
                    this.messageBusBinding.close();
                }
                catch (SmaException e1) {
                    this.tracer.log(this.tracePrefix + "Error closing message bus after open failure: " + UtlThrowable.prepareStackTrace((Throwable)e1), Tracer.Level.WARNING);
                }
                this.messageBusBinding = null;
            }
            throw new EAdminException(e.getMessage(), e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected final <RequestType extends IRogMessage & ISrvMonXvmRequest, ResponseType extends IRogMessage> ResponseType sendRequest(RequestType request, int timeoutInMillis) throws EAdminOpFailedException, EAdminOpServerErrorException, EAdminOpTimeoutException {
        if (this.isPassiveMonitoringOnly()) {
            throw new EAdminOpFailedException("Cannot send requests when session is configured for passive monitoring only.");
        }
        long correlationId = this.nextCorrelationId.getAndIncrement();
        ((ISrvMonXvmRequest)request).setAdminClientId(this.adminClientId);
        if (timeoutInMillis > 0) {
            ((ISrvMonXvmRequest)request).setCorrelationId(correlationId);
        }
        ((ISrvMonXvmRequest)request).setXvmName(this.xvmName);
        ((ISrvMonXvmRequest)request).setAdminClientCompatLevel("5");
        Object object = this.requestLock;
        synchronized (object) {
            try {
                if (timeoutInMillis > 0) {
                    request.setTag(6, null);
                    request.acquire();
                    this.pendingRequests.put(correlationId, request);
                }
                this.requestChannel.sendMessage(request, this.krt, 1);
                if (timeoutInMillis > 0) {
                    long deadline = System.currentTimeMillis() + (long)timeoutInMillis;
                    long timeLeft = deadline - System.currentTimeMillis();
                    while (timeLeft > 0L && request.getTag(6) == null) {
                        try {
                            this.requestLock.wait(deadline - System.currentTimeMillis());
                            if (this.busEventHandler.isFailed()) {
                                throw new EAdminOpFailedException("Connection failed while waiting for response", this.busEventHandler.getFailureCause());
                            }
                            if (this.state != AdminSessionBase.State.Init && this.state != AdminSessionBase.State.Open) {
                                throw new EAdminOpFailedException("Connection no longer open (" + (Object)((Object)this.state) + ") while waiting for response", this.busEventHandler.getFailureCause());
                            }
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                            throw new EAdminOpTimeoutException("Interrupted waiting for response", e);
                        }
                        timeLeft = deadline - System.currentTimeMillis();
                    }
                    IRogMessage response = (IRogMessage)request.getTag(6);
                    if (response == null) {
                        throw new EAdminOpTimeoutException("Timed out waiting for response to '" + this.getCommandName(request) + "' (" + UtlUnit.formatDuration((double)timeoutInMillis, (TimeUnit)TimeUnit.MILLISECONDS) + ")");
                    }
                    IRogMessage iRogMessage = response;
                    return (ResponseType)iRogMessage;
                }
                ResponseType deadline = null;
                return deadline;
            }
            catch (SmaException e) {
                throw new EAdminOpFailedException("Error sending '" + this.getCommandName(request) + "' request: " + e.getMessage(), e);
            }
            finally {
                if (timeoutInMillis > 0) {
                    this.pendingRequests.remove(correlationId);
                    request.setTag(6, null);
                    request.dispose();
                }
            }
        }
    }

    private final <RequestType extends IRogMessage & ISrvMonXvmRequest> String getCommandName(RequestType request) {
        if (request instanceof SrvMonInvokeCommandRequest) {
            return ((SrvMonInvokeCommandRequest)request).getCommandName();
        }
        return request.getClass().getSimpleName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final void onMessageReceived(MessageView messageView) {
        if (this.tracer.debug) {
            this.tracer.log(this.tracePrefix + "Received message: " + messageView, Tracer.Level.DEBUG);
        }
        if (messageView instanceof ISrvMonXvmResponse) {
            if (this.tracer.fine) {
                this.tracer.log(this.tracePrefix + "Received CnC Response: " + messageView, Tracer.Level.FINE);
            }
            ISrvMonXvmResponse metadata = (ISrvMonXvmResponse)messageView;
            long correlationId = metadata.getCorrelationId();
            Object object = this.requestLock;
            synchronized (object) {
                MessageView request = (MessageView)this.pendingRequests.get(correlationId);
                if (request != null) {
                    messageView.acquire();
                    request.setTag(6, (Object)messageView);
                    this.requestLock.notifyAll();
                    return;
                }
                if (correlationId > 0L && this.tracer.fine) {
                    this.tracer.log(this.tracePrefix + "Dropping stale CnC Response: " + messageView, Tracer.Level.FINE);
                }
            }
        }
        if (this.traceJoinPending.get()) {
            if (messageView instanceof SrvMonTraceRecord) {
                return;
            }
            if (messageView instanceof SrvMonGetTraceHistoryResponse) {
                SrvMonGetTraceHistoryResponse traceHistory = (SrvMonGetTraceHistoryResponse)messageView;
                if (this.tracer.fine) {
                    this.tracer.log(this.tracePrefix + "Received trace history up to seqNo" + traceHistory.getTraceSeqNo() + ", dispatching and joining live trace stream...", Tracer.Level.FINE);
                }
                XIterator<SrvMonTrace> traceIterator = traceHistory.getTraceRecordsIterator();
                int count = 0;
                while (traceIterator.hasNext()) {
                    SrvMonTrace record = (SrvMonTrace)traceIterator.next();
                    SrvMonTraceRecord toDispatch = SrvMonTraceRecord.create();
                    toDispatch.setTraceFrom(record.getTraceUnsafe());
                    toDispatch.setLevel(record.getLevel());
                    toDispatch.setThreadId(record.getThreadId());
                    toDispatch.setTimestamp(record.getTimestamp());
                    toDispatch.setProcessIdFrom(record.getProcessIdUnsafe());
                    toDispatch.setXvmNameFrom(record.getXvmNameUnsafe());
                    toDispatch.setHostAddressFrom(record.getHostAddressUnsafe());
                    toDispatch.setHostNameFrom(record.getHostNameUnsafe());
                    super.onMessageReceived((MessageView)toDispatch);
                    ++count;
                    toDispatch.dispose();
                }
                if (this.tracer.fine) {
                    this.tracer.log(this.tracePrefix + "Dispatched " + count + " trace records. Joining live trace stream", Tracer.Level.FINE);
                }
                this.traceJoinPending.set(false);
                return;
            }
        } else if (messageView instanceof SrvMonGetTraceHistoryResponse) {
            this.tracer.log(this.tracePrefix + "Dropping SrvMonGetTraceHistoryResponse (received while not joining trace)", Tracer.Level.WARNING);
            return;
        }
        if (this.appWatchJoinPending.get()) {
            switch (messageView.getVfid()) {
                case 34: {
                    if (this.tracer.fine) {
                        this.tracer.log(this.tracePrefix + "Dropping lifecycle event message '" + messageView.getClass().getSimpleName() + "' (received while app watch start pending)", Tracer.Level.FINE);
                    }
                    return;
                }
                case 35: {
                    if (this.tracer.fine) {
                        this.tracer.log(this.tracePrefix + "Dropping alert event message '" + messageView.getClass().getSimpleName() + "' (received while app watch start pending)", Tracer.Level.FINE);
                    }
                    return;
                }
                case 32: {
                    if (this.isPassiveMonitoringOnly() && messageView instanceof SrvMonHeartbeatMessage) {
                        if (!this.appWatchJoinPending.compareAndSet(true, false) || !this.tracer.fine) break;
                        this.tracer.log(this.tracePrefix + "Received initial passive monitoring heartbeat, app watch stream is now joined.", Tracer.Level.FINE);
                        break;
                    }
                    if (this.tracer.fine) {
                        this.tracer.log(this.tracePrefix + "Dropping monitoring message '" + messageView.getClass().getSimpleName() + "' (received while app watch start pending)", Tracer.Level.FINE);
                    }
                    return;
                }
            }
            if (messageView instanceof SrvMonGetLoadedAppsResponse) {
                if (this.appWatchJoinPending.compareAndSet(true, false)) {
                    if (this.tracer.fine) {
                        this.tracer.log(this.tracePrefix + "Received loaded apps response, app watch stream is now joined.", Tracer.Level.FINE);
                    }
                } else {
                    this.tracer.log(this.tracePrefix + "Dropping SrvMonGetLoadedAppsResponse (app watch join cancelled).", Tracer.Level.INFO);
                }
            }
        } else if (messageView instanceof SrvMonGetLoadedAppsResponse) {
            this.tracer.log(this.tracePrefix + "Dropping SrvMonGetLoadedAppsResponse (received without a pending app watch join).", Tracer.Level.INFO);
            return;
        }
        super.onMessageReceived(messageView);
    }

    private final class BusEventHandler
    implements IEventHandler {
        private Exception bindingFailedCause;

        private BusEventHandler() {
        }

        public final boolean isFailed() {
            return this.bindingFailedCause != null;
        }

        public final Exception getFailureCause() {
            return this.bindingFailedCause;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onEvent(Event event) {
            switch (event.getType()) {
                case 105: {
                    MessageEvent messageEvent = (MessageEvent)event;
                    AdminSmaSession.this.onMessageReceived(messageEvent.getMessageView());
                    break;
                }
                case 102: {
                    MessageBusBindingFailedEvent bindingFailedEvent = (MessageBusBindingFailedEvent)event;
                    this.bindingFailedCause = bindingFailedEvent.getCause();
                    AdminSmaSession.this.onAdminSessionFailure(bindingFailedEvent.getCause());
                    Object object = AdminSmaSession.this.requestLock;
                    synchronized (object) {
                        AdminSmaSession.this.requestLock.notifyAll();
                        break;
                    }
                }
                case 110: {
                    AdminSmaSession.this.tracer.log(AdminSmaSession.this.tracePrefix + "admin connection restored", Tracer.Level.INFO);
                    break;
                }
                case 109: {
                    AdminSmaSession.this.tracer.log(AdminSmaSession.this.tracePrefix + "admin connection reconnecting...", Tracer.Level.INFO);
                    break;
                }
                default: {
                    if (!((AdminSmaSession)AdminSmaSession.this).tracer.debug) break;
                    AdminSmaSession.this.tracer.log(AdminSmaSession.this.tracePrefix + "Ignoring unknown event: " + event, Tracer.Level.DEBUG);
                }
            }
        }
    }
}

