/*
 * Decompiled with CFR 0.152.
 */
package com.akiban.sql.compiler;

import com.akiban.sql.StandardException;
import com.akiban.sql.compiler.TypeCompiler;
import com.akiban.sql.types.DataTypeDescriptor;
import com.akiban.sql.types.TypeId;

public class TimestampTypeCompiler
extends TypeCompiler {
    protected TimestampTypeCompiler(TypeId typeId) {
        super(typeId);
    }

    @Override
    public boolean convertible(TypeId otherType, boolean forDataTypeFunction) {
        if (otherType.isStringTypeId() && !otherType.isLongConcatableTypeId()) {
            return true;
        }
        int otherJDBCTypeId = otherType.getJDBCTypeId();
        if (otherJDBCTypeId == 93) {
            return true;
        }
        return otherJDBCTypeId == 91 || otherJDBCTypeId == 92;
    }

    @Override
    public boolean compatible(TypeId otherType) {
        if (otherType.isStringTypeId() && !otherType.isLongConcatableTypeId()) {
            return true;
        }
        return this.getStoredFormatIdFromTypeId() == otherType.getTypeFormatId();
    }

    @Override
    public String getCorrespondingPrimitiveTypeName() {
        return "java.sql.Timestamp";
    }

    @Override
    public String getPrimitiveMethodName() {
        return "getTimestamp";
    }

    @Override
    public int getCastToCharWidth(DataTypeDescriptor dts) {
        return 26;
    }

    @Override
    public DataTypeDescriptor resolveArithmeticOperation(DataTypeDescriptor leftType, DataTypeDescriptor rightType, String operator) throws StandardException {
        boolean nullable;
        TypeId rightTypeId = rightType.getTypeId();
        boolean bl = nullable = leftType.isNullable() || rightType.isNullable();
        if (rightTypeId.isDateTimeTimeStampTypeId()) {
            if (operator.equals("-")) {
                return new DataTypeDescriptor(TypeId.INTERVAL_DAY_SECOND_ID, nullable);
            }
        } else if (rightTypeId.isIntervalTypeId() && (operator.equals("+") || operator.equals("-"))) {
            return leftType.getNullabilityType(nullable);
        }
        return super.resolveArithmeticOperation(leftType, rightType, operator);
    }
}

