/*
 * Decompiled with CFR 0.152.
 */
package com.eaio.uuid;

import com.eaio.util.lang.Hex;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.concurrent.atomic.AtomicLong;

public final class UUIDGen {
    private static AtomicLong lastTime = new AtomicLong(Long.MIN_VALUE);
    private static String macAddress = null;
    private static long clockSeqAndNode = Long.MIN_VALUE;

    public static long getClockSeqAndNode() {
        return clockSeqAndNode;
    }

    public static long newTime() {
        return UUIDGen.createTime(System.currentTimeMillis());
    }

    public static long createTime(long currentTimeMillis) {
        long timeMillis;
        block2: {
            long current;
            timeMillis = currentTimeMillis * 10000L + 122192928000000000L;
            while (true) {
                if (timeMillis > (current = lastTime.get())) {
                    if (!lastTime.compareAndSet(current, timeMillis)) continue;
                    break block2;
                }
                if (lastTime.compareAndSet(current, current + 1L)) break;
            }
            timeMillis = current + 1L;
        }
        long time = timeMillis << 32;
        time |= (timeMillis & 0xFFFF00000000L) >> 16;
        return time |= 0x1000L | timeMillis >> 48 & 0xFFFL;
    }

    public static String getMACAddress() {
        return macAddress;
    }

    static {
        macAddress = new HardwareAddressLookup().toString();
        if (macAddress != null) {
            clockSeqAndNode |= Hex.parseLong(macAddress);
        } else {
            try {
                byte[] local = InetAddress.getLocalHost().getAddress();
                clockSeqAndNode |= (long)(local[0] << 24) & 0xFF000000L;
                clockSeqAndNode |= (long)(local[1] << 16 & 0xFF0000);
                clockSeqAndNode |= (long)(local[2] << 8 & 0xFF00);
                clockSeqAndNode |= (long)(local[3] & 0xFF);
            }
            catch (UnknownHostException ex) {
                clockSeqAndNode |= (long)(Math.random() * 2.147483647E9);
            }
        }
        clockSeqAndNode |= (long)(Math.random() * 16383.0) << 48;
    }

    static class HardwareAddressLookup {
        HardwareAddressLookup() {
        }

        public String toString() {
            String out;
            block3: {
                out = null;
                try {
                    Enumeration<NetworkInterface> ifs = NetworkInterface.getNetworkInterfaces();
                    if (ifs == null) break block3;
                    while (ifs.hasMoreElements()) {
                        NetworkInterface iface = ifs.nextElement();
                        byte[] hardware = iface.getHardwareAddress();
                        if (hardware == null || hardware.length != 6 || hardware[1] == -1) continue;
                        out = Hex.append((Appendable)new StringBuilder(36), hardware).toString();
                        break;
                    }
                }
                catch (SocketException socketException) {
                    // empty catch block
                }
            }
            return out;
        }
    }
}

