/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.controller;

import com.neeve.controller.Controller;
import com.neeve.controller.System;
import com.neeve.ddl.DdlXMLParser;
import com.neeve.ddl.jaxb.DiscoveryDescriptor;
import com.neeve.ddl.jaxb.HierarchicalPropertySet;
import com.neeve.ddl.jaxb.Model;
import com.neeve.ddl.jaxb.XvmConfig;
import com.neeve.ddl.jaxb.XvmConfigList;
import com.neeve.emx.EmxNwLnkInetAddr;
import com.neeve.trace.Tracer;
import com.neeve.util.UtlAddressDescriptor;
import com.neeve.util.UtlNet;
import com.neeve.util.UtlProps;
import com.neeve.util.UtlTailoring;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Properties;

public final class XVM {
    private final Controller _controller;
    private final System _system;
    private final File _modelFile;
    private final String _name;
    private final UtlTailoring.PropertySource _envPropertySource;
    private final System.SystemConfigPropertySource _controllerPropertySource;
    private final File _xvmConfigFolder;
    private final File _localizedJvmParamsFile;
    private final File _localizedDdlFile;
    private final File _localizedXcsFile;
    private final File _localizedEnvFile;
    private long _lastControllerConfigModification = -1L;
    private HashMap<File, Long> configSourceFileModifications = new HashMap();
    private int _sshPort;
    private LinkedHashMap<String, String> _environment;
    private Model _xvmLocalizedModel;
    private XvmConfigList.Xvm _xvmModel;
    private boolean _provisioned;
    private boolean _enabled;

    XVM(String name, Controller controller, System system, File modelFile, System.SystemConfigPropertySource configPropertySource) throws Exception {
        this._controller = controller;
        this._system = system;
        this._modelFile = modelFile;
        this._name = name;
        this._environment = new LinkedHashMap();
        this._xvmConfigFolder = new File(this._modelFile.getParentFile(), "/.rumi/provisioning/" + this._system.getName() + "/" + this._name);
        if (!this._xvmConfigFolder.exists() && !this._xvmConfigFolder.mkdirs()) {
            throw new RuntimeException("Error creating xvm config folder " + this._xvmConfigFolder);
        }
        this._localizedDdlFile = new File(this._xvmConfigFolder, "localized." + this._name + ".config.xml");
        this._localizedXcsFile = new File(this._xvmConfigFolder, "localized." + this._name + ".config.xcs");
        this._localizedJvmParamsFile = new File(this._xvmConfigFolder, "localized." + this._name + ".jvm.params");
        this._localizedEnvFile = new File(this._xvmConfigFolder, "localized." + this._name + ".env");
        this.configSourceFileModifications.put(modelFile, -1L);
        this._controllerPropertySource = configPropertySource;
        this._envPropertySource = new UtlTailoring.PropertySource(){

            public String getValue(String key, String defaultValue) {
                String value = (String)XVM.this._environment.get(key);
                if (value != null) {
                    return value;
                }
                return XVM.this._controllerPropertySource.getValue(key, defaultValue);
            }
        };
        this.configure();
    }

    public boolean isConfigStale() {
        if (!this._localizedDdlFile.exists()) {
            return true;
        }
        if (this._lastControllerConfigModification != this._controllerPropertySource.getConfigModificationTime()) {
            return true;
        }
        for (Map.Entry<File, Long> fileEntry : this.configSourceFileModifications.entrySet()) {
            if (fileEntry.getValue() <= 0L) {
                if (!fileEntry.getKey().exists()) continue;
                return true;
            }
            if (!fileEntry.getKey().exists()) {
                return true;
            }
            if (fileEntry.getValue().longValue() == fileEntry.getKey().lastModified()) continue;
            return true;
        }
        return false;
    }

    final void configure() throws Exception {
        if (!this.isConfigStale()) {
            return;
        }
        this._lastControllerConfigModification = this._controllerPropertySource.getConfigModificationTime();
        this._environment.clear();
        this.initializeEnvironment();
        this._environment.put("nv.ddl.targetxvm", this._name);
        Model xvmLocalizedConfig = DdlXMLParser.parse((File)this._modelFile, (UtlTailoring.PropertySource)this._envPropertySource);
        XvmConfigList.Xvm xvmConfig = null;
        for (XvmConfigList.Xvm candidate : xvmLocalizedConfig.getXvms().getXvm()) {
            if (!this._name.equals(candidate.getName())) continue;
            xvmConfig = candidate;
        }
        if (xvmConfig == null) {
            throw new RuntimeException("XVM config for xvm '" + this._name + "' not found in DDL!");
        }
        this._enabled = xvmConfig.isEnabled();
        XvmConfig.Provisioning provisioningConfig = xvmConfig.getProvisioning();
        if (provisioningConfig == null) {
            provisioningConfig = new XvmConfig.Provisioning();
            xvmConfig.setProvisioning(provisioningConfig);
        }
        this.resolveHost(provisioningConfig);
        this.resolveSandboxPaths(provisioningConfig);
        this.configureJava(provisioningConfig);
        this.configureDiscovery(xvmLocalizedConfig, (XvmConfig)xvmConfig);
        this.configureAdminTransports(xvmLocalizedConfig, (XvmConfig)xvmConfig);
        if (provisioningConfig.getJvm().getJavaHome() != null) {
            this._environment.put("NVJRE", provisioningConfig.getJvm().getJavaHome());
        }
        this._environment.put("XVMRUNDIR", provisioningConfig.getRunDirectory());
        this._environment.put("XVMDATADIR", provisioningConfig.getDataDirectory());
        this._environment.put("XVMLOGDIR", provisioningConfig.getTraceLogDirectory());
        this._environment.put("WRAPPERLOGFILEPATH", provisioningConfig.getTraceLogDirectory());
        this.prepareEnvironmentFile();
        this.prepareXcsFile(xvmLocalizedConfig);
        this._xvmModel = xvmConfig;
        this._xvmLocalizedModel = xvmLocalizedConfig;
        this.configSourceFileModifications.put(this._modelFile, this._modelFile.lastModified());
    }

    private void configureDiscovery(Model xvmLocalizedConfig, XvmConfig xvmConfig) {
        String discoveryDescriptor;
        if (Boolean.valueOf(this._envPropertySource.getValue("nv.controller.configurexvmdiscovery", String.valueOf(true))).booleanValue() && (discoveryDescriptor = this._controller.getResolvedDiscoveryDescriptor()) != null) {
            boolean discoveryConfigured;
            Properties ddlEnv = new Properties();
            if (xvmLocalizedConfig.getEnv() != null) {
                ddlEnv.putAll((Map<?, ?>)DdlXMLParser.unmarshalProperties((HierarchicalPropertySet)xvmLocalizedConfig.getEnv()));
            }
            if (xvmConfig.getEnv() != null) {
                ddlEnv.putAll((Map<?, ?>)DdlXMLParser.unmarshalProperties((HierarchicalPropertySet)xvmConfig.getEnv()));
            }
            if (UtlProps.getValue((Properties)ddlEnv, (String)"nv.controller.suppressDiscoveryConfiguration", (boolean)false)) {
                this._controller.traceForTroubleshooting("nv.controller.suppressDiscoveryConfiguration is set for " + this._name + " xvm ... discovery configuration won't be configured.", Tracer.Level.INFO);
                return;
            }
            boolean bl = discoveryConfigured = UtlProps.getValue((Properties)ddlEnv, (String)"nv.discovery.descriptor") != null;
            if (!discoveryConfigured) {
                if (xvmConfig.getEnv() == null) {
                    xvmConfig.setEnv(new XvmConfig.Env());
                }
                Properties updated = new Properties();
                updated.setProperty("nv.discovery.descriptor", discoveryDescriptor);
                DdlXMLParser.addProperties((HierarchicalPropertySet)xvmConfig.getEnv(), (Properties)updated);
                if (xvmConfig.getDiscovery() != null) {
                    UtlAddressDescriptor discoveryAdddress = UtlAddressDescriptor.parse((String)discoveryDescriptor, null);
                    xvmConfig.getDiscovery().setAddress(discoveryAdddress.address);
                    xvmConfig.getDiscovery().setProvider(discoveryAdddress.type);
                    if (!discoveryAdddress.props.isEmpty()) {
                        Properties discoveryProperties = new Properties();
                        discoveryProperties.putAll((Map<?, ?>)discoveryAdddress.props);
                        if (xvmConfig.getDiscovery().getProperties() == null) {
                            xvmConfig.getDiscovery().setProperties(new DiscoveryDescriptor.Properties());
                        }
                        DdlXMLParser.addProperties((HierarchicalPropertySet)xvmConfig.getDiscovery().getProperties(), (Properties)discoveryProperties);
                    }
                } else if (xvmConfig.getDiscoveryDescriptor() != null) {
                    xvmConfig.setDiscoveryDescriptor(discoveryDescriptor);
                }
            }
        }
    }

    private void configureAdminTransports(Model xvmLocalizedConfig, XvmConfig xvmConfig) {
        if (Boolean.valueOf(this._envPropertySource.getValue("nv.controller.configurexvmadminconnectivity", String.valueOf(true))).booleanValue()) {
            boolean adminBusConfigured;
            boolean suppressAdminConfig;
            String controllerAdminTranportList = UtlProps.getValue((Properties)this._controllerPropertySource.getCurrentControllerConfig(), (String)"nv.server.admin.transports", (String)"direct").trim().toLowerCase();
            LinkedHashSet<String> controllerAdminTransports = new LinkedHashSet<String>(Arrays.asList(controllerAdminTranportList.split(",")));
            if (!controllerAdminTransports.contains("sma")) {
                return;
            }
            Properties ddlEnv = new Properties();
            if (xvmLocalizedConfig.getEnv() != null) {
                ddlEnv.putAll((Map<?, ?>)DdlXMLParser.unmarshalProperties((HierarchicalPropertySet)xvmLocalizedConfig.getEnv()));
            }
            if (xvmConfig.getEnv() != null) {
                ddlEnv.putAll((Map<?, ?>)DdlXMLParser.unmarshalProperties((HierarchicalPropertySet)xvmConfig.getEnv()));
            }
            if (suppressAdminConfig = UtlProps.getValue((Properties)ddlEnv, (String)"nv.controller.suppressAdminConfiguration", (boolean)false)) {
                this._controller.traceForTroubleshooting("nv.controller.suppressAdminConfiguration is set for " + this._name + " xvm ... admin bus won't be configured.", Tracer.Level.INFO);
                return;
            }
            boolean bl = adminBusConfigured = UtlProps.getValue((Properties)ddlEnv, (String)"nv.server.admin.sma.bus.descriptor") != null || UtlProps.getValue((Properties)ddlEnv, (String)"nv.server.admin.sma.bus.provider") != null;
            if (!adminBusConfigured) {
                if (xvmConfig.getEnv() == null) {
                    xvmConfig.setEnv(new XvmConfig.Env());
                }
                Properties updated = UtlProps.getSubProps((Properties)this._controllerPropertySource.getCurrentControllerConfig(), (String)"nv.server.admin", (boolean)false, (Properties)new Properties());
                DdlXMLParser.addProperties((HierarchicalPropertySet)xvmConfig.getEnv(), (Properties)updated);
                if (xvmConfig.getAdmin() == null) {
                    xvmConfig.setAdmin(new XvmConfig.Admin());
                }
                xvmConfig.getAdmin().setPassiveMonitoringOnly(Boolean.valueOf(UtlProps.getValue((Properties)this._controllerPropertySource.getCurrentControllerConfig(), (String)"nv.server.admin.passivemonitoringonly", (boolean)false)));
                if (xvmConfig.getAdmin().getTransports() == null) {
                    xvmConfig.getAdmin().setTransports(new XvmConfig.Admin.Transports());
                }
                if (xvmConfig.getAdmin().getTransports().getSma() == null) {
                    xvmConfig.getAdmin().getTransports().setSma(new XvmConfig.Admin.Transports.Sma());
                }
                XvmConfig.Admin.Transports.Sma smaConfig = xvmConfig.getAdmin().getTransports().getSma();
                smaConfig.setEnabled(Boolean.valueOf(true));
                smaConfig.setBusName(this._controllerPropertySource.getValue("nv.server.admin.sma.bus.name", "xvm-admin"));
            } else {
                this._controller.traceForTroubleshooting("nv.controller.suppressAdminConfiguration is set for " + this._name + " xvm ... admin bus won't be configured.", Tracer.Level.INFO);
            }
        }
    }

    private void resolveHost(XvmConfig.Provisioning provisioningConfig) throws Exception {
        String offDdlConfigHost = this.getOffDDLHostConfig();
        String onDDlConfigHost = provisioningConfig.getHost();
        String host = onDDlConfigHost;
        if (host == null) {
            host = offDdlConfigHost != null ? offDdlConfigHost : ".";
        } else if (offDdlConfigHost != null) {
            this._controller.traceForTroubleshooting("Host '" + host + "' set in xvm '" + this._name + "'s provisioning used in place of '" + offDdlConfigHost + "' configured in controller environment (controller.conf).", Tracer.Level.VERBOSE);
        }
        if (host.contains(":")) {
            EmxNwLnkInetAddr inetAddr = EmxNwLnkInetAddr.parse((String)host);
            host = inetAddr.host;
            this._sshPort = inetAddr.port;
        } else if (host == ".") {
            this._sshPort = 0;
        } else {
            int sshPort = Integer.parseInt(this._controllerPropertySource.getValue(String.format("nv.controller.%s.sshport", host), "-1"));
            if (sshPort == -1) {
                try {
                    InetAddress hostAddress = InetAddress.getByName(host);
                    if (hostAddress != null && UtlNet.isAddressLocal((InetAddress)hostAddress)) {
                        host = ".";
                        sshPort = 0;
                    } else {
                        sshPort = Integer.parseInt(this._controllerPropertySource.getValue(String.format("nv.controller.%s.sshport", hostAddress.getHostAddress()), "-1"));
                    }
                }
                catch (Exception e) {
                    this._controller.traceForTroubleshooting("Could not resolve host address for '" + host + "' for xvm '" + this._name + " (" + e.getLocalizedMessage() + ").", Tracer.Level.VERBOSE);
                }
            }
            if (sshPort == -1) {
                this._controller.traceForTroubleshooting("No ssh port configured for host '" + host + "' for xvm '" + this._name + " via 'nv.controller." + host + ".sshport'. Using default port of 22.", Tracer.Level.VERBOSE);
                sshPort = 22;
            }
            this._sshPort = sshPort;
        }
        provisioningConfig.setHost(host);
    }

    private String getOffDDlHostSandboxRoot(String host) {
        if (host.equals(".")) {
            return this._controller.getLocalXVMSandboxRoot();
        }
        return this._controllerPropertySource.getValue(String.format("nv.controller.xvm.hostsandboxroot.%s", host), this._controllerPropertySource.getValue(String.format("nv.controller.hostrunroot.%s", host), null));
    }

    private String getOffDDLHostConfig() throws Exception {
        String val = this._controllerPropertySource.getValue(String.format("nv.controller.xvm.sandboxroot.%s", this._name), this._controllerPropertySource.getValue(String.format("nv.controller.xvmrunroot.%s", this._name), null));
        return val != null ? UtlAddressDescriptor.parse((CharSequence)val).type : null;
    }

    private String getOffDDLSandboxRootConfig(String host) throws Exception {
        String ret = this._controllerPropertySource.getValue(String.format("nv.controller.xvm.sandboxroot.%s", this._name), this._controllerPropertySource.getValue(String.format("nv.controller.xvmrunroot.%s", this._name), null));
        String string = ret = ret != null ? UtlAddressDescriptor.parse((CharSequence)ret).config : null;
        if (ret == null) {
            ret = this.getOffDDlHostSandboxRoot(host);
        }
        if (ret == null) {
            ret = "/rumi";
        }
        if (!this.isAbsoluteFilePath(ret)) {
            ret = this.stripTrailingSlashes("/rumi/" + ret);
        }
        return ret;
    }

    private String getOffDDLRunRootConfig() {
        return this._controllerPropertySource.getValue(String.format("nv.controller.xvm.runroot.%s", this._name), null);
    }

    private String getOffDDLDataRootConfig() {
        return this._controllerPropertySource.getValue(String.format("nv.controller.xvm.dataroot.%s", this._name), null);
    }

    private String getOffDDLLogRootConfig() {
        return this._controllerPropertySource.getValue(String.format("nv.controller.xvm.logroot.%s", this._name), this._controllerPropertySource.getValue(String.format("nv.controller.xvmlogroot.%s", this._name), null));
    }

    private void resolveSandboxPaths(XvmConfig.Provisioning provisioningConfig) throws Exception {
        String defaultSandboxRootDirectory = this.getOffDDLSandboxRootConfig(provisioningConfig.getHost());
        String sandboxRootDirectory = provisioningConfig.getRootDirectory();
        if (sandboxRootDirectory == null) {
            sandboxRootDirectory = defaultSandboxRootDirectory;
        }
        if (!this.isAbsoluteFilePath(sandboxRootDirectory)) {
            sandboxRootDirectory = this.stripTrailingSlashes(defaultSandboxRootDirectory + "/" + sandboxRootDirectory);
        }
        provisioningConfig.setRootDirectory(sandboxRootDirectory);
        String runRoot = provisioningConfig.getRunDirectory();
        if (runRoot == null && (runRoot = this.getOffDDLRunRootConfig()) == null) {
            runRoot = "run";
        }
        if (!this.isAbsoluteFilePath(runRoot)) {
            runRoot = this.stripTrailingSlashes(sandboxRootDirectory + "/" + runRoot);
        }
        runRoot = provisioningConfig.isQualifyPathsWithSystem() == null || provisioningConfig.isQualifyPathsWithSystem() != false ? this.concatenateDirectoryPath(runRoot, this._system.getName() + "/" + this._name) : this.stripTrailingSlashes(runRoot);
        provisioningConfig.setRunDirectory(runRoot);
        String dataRoot = provisioningConfig.getDataDirectory();
        if (dataRoot == null && (dataRoot = this.getOffDDLDataRootConfig()) == null) {
            dataRoot = "rdat";
        }
        if (!this.isAbsoluteFilePath(dataRoot)) {
            dataRoot = this.stripTrailingSlashes(sandboxRootDirectory + "/" + dataRoot);
        }
        dataRoot = provisioningConfig.isQualifyPathsWithSystem() == null || provisioningConfig.isQualifyPathsWithSystem() != false ? this.concatenateDirectoryPath(dataRoot, this._name) : this.stripTrailingSlashes(dataRoot);
        provisioningConfig.setDataDirectory(dataRoot);
        String logRoot = provisioningConfig.getTraceLogDirectory();
        if (logRoot == null && (logRoot = this.getOffDDLLogRootConfig()) == null) {
            logRoot = "logs";
        }
        if (!this.isAbsoluteFilePath(logRoot)) {
            logRoot = this.stripTrailingSlashes(sandboxRootDirectory + "/" + logRoot);
        }
        logRoot = provisioningConfig.isQualifyPathsWithSystem() == null || provisioningConfig.isQualifyPathsWithSystem() != false ? this.concatenateDirectoryPath(logRoot, this._name) : this.stripTrailingSlashes(logRoot);
        provisioningConfig.setTraceLogDirectory(logRoot);
        if (provisioningConfig.getHost().equals(".")) {
            provisioningConfig.setRootDirectory(this.resolveLocalCanonicalPath(provisioningConfig.getRootDirectory()));
            provisioningConfig.setRunDirectory(this.resolveLocalCanonicalPath(provisioningConfig.getRunDirectory()));
            provisioningConfig.setDataDirectory(this.resolveLocalCanonicalPath(provisioningConfig.getDataDirectory()));
            provisioningConfig.setTraceLogDirectory(this.resolveLocalCanonicalPath(provisioningConfig.getTraceLogDirectory()));
        }
        provisioningConfig.setQualifyPathsWithSystem(Boolean.valueOf(false));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void configureJava(XvmConfig.Provisioning provisioningConfig) throws Exception {
        String jvmParams;
        XvmConfig.Provisioning.Jvm jvmConfig = provisioningConfig.getJvm();
        if (jvmConfig == null) {
            jvmConfig = new XvmConfig.Provisioning.Jvm();
            provisioningConfig.setJvm(jvmConfig);
        }
        StringBuilder jvmParamsBuilder = new StringBuilder();
        DdlXMLParser.parseAndAppendJvmParams((XvmConfig.Provisioning.Jvm)jvmConfig, (Appendable)jvmParamsBuilder);
        File jvmParamsFile = new File(this._system.getHome() + File.separator + this._name + ".jvm.params");
        this.configSourceFileModifications.put(jvmParamsFile, jvmParamsFile.lastModified());
        if (!jvmParamsFile.exists()) {
            jvmParamsFile = new File(this._system.getHome() + File.separator + "xvm.jvm.params");
            this.configSourceFileModifications.put(jvmParamsFile, jvmParamsFile.lastModified());
            if (!jvmParamsFile.exists()) {
                jvmParamsFile = null;
            }
        }
        if (jvmParamsFile != null) {
            try (BufferedReader reader = new BufferedReader(new FileReader(jvmParamsFile));){
                String str;
                while ((str = reader.readLine()) != null) {
                    String jvmParamsLine = UtlTailoring.substitute((String)str, (UtlTailoring.PropertySource)this._envPropertySource);
                    if (jvmParamsLine.trim().length() <= 0) continue;
                    jvmParamsBuilder.append(" ").append(jvmParamsLine);
                }
            }
        }
        if ((jvmParams = jvmParamsBuilder.toString().trim()).length() > 0) {
            jvmConfig.setJvmParams(jvmParams);
        }
        this.deleteAndRecreateFile(this._localizedJvmParamsFile);
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(this._localizedJvmParamsFile, false));){
            writer.write(jvmParams);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void prepareXcsFile(Model xvmLocalizedModel) throws Exception {
        this.deleteAndRecreateFile(this._localizedDdlFile);
        try (BufferedWriter ddlWriter = new BufferedWriter(new FileWriter(this._localizedDdlFile, false));){
            DdlXMLParser.toXml((Model)xvmLocalizedModel, (Appendable)ddlWriter);
            ddlWriter.flush();
        }
        this.deleteAndRecreateFile(this._localizedXcsFile);
        try (BufferedWriter xcsWriter = new BufferedWriter(new FileWriter(this._localizedXcsFile, false));){
            DdlXMLParser.toXcs((Model)xvmLocalizedModel, (boolean)true, (UtlTailoring.PropertySource)this._envPropertySource, (Appendable)xcsWriter);
            xcsWriter.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void prepareEnvironmentFile() throws Exception {
        this.deleteAndRecreateFile(this._localizedEnvFile);
        try (PrintWriter envWriter = new PrintWriter(new BufferedWriter(new FileWriter(this._localizedEnvFile, false)));){
            if (this._environment.get("nv.ddl.targetxvm") != null) {
                envWriter.println("set.nv.ddl.targetxvm=" + this._environment.get("nv.ddl.targetxvm"));
            }
            if (this._environment.get("XVMRUNDIR") != null) {
                envWriter.println("set.XVMRUNDIR=" + this._environment.get("XVMRUNDIR"));
            }
            if (this._environment.get("XVMDATADIR") != null) {
                envWriter.println("set.XVMDATADIR=" + this._environment.get("XVMDATADIR"));
            }
            if (this._environment.get("XVMLOGDIR") != null) {
                envWriter.println("set.XVMLOGDIR=" + this._environment.get("XVMLOGDIR"));
            }
            for (String key : this._environment.keySet()) {
                String value = this._environment.get(key);
                if (key.equals("nv.ddl.targetxvm") || key.equals("XVMRUNDIR") || key.equals("XVMDATADIR") || key.equals("XVMLOGDIR")) continue;
                envWriter.println("set." + key + "=" + value);
            }
            envWriter.flush();
        }
    }

    private final void deleteAndRecreateFile(File file) throws IOException {
        for (int deleteAttempts = 5; file.exists() && deleteAttempts > 0 && !file.delete(); --deleteAttempts) {
            try {
                Thread.sleep(500L);
                continue;
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
                break;
            }
        }
        if (file.exists()) {
            throw new RuntimeException("Error deleting " + file.getAbsolutePath());
        }
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        if (!file.createNewFile()) {
            throw new RuntimeException("Error creating " + file.getAbsolutePath());
        }
    }

    private final boolean isAbsoluteFilePath(String path) {
        if (path.startsWith("/")) {
            return true;
        }
        return path.replace('\\', '/').indexOf(":/") > 0;
    }

    private final String concatenateDirectoryPath(String parent, String subdir) {
        String result = null;
        result = parent.length() == 0 ? subdir : (parent.endsWith("/") ? parent + subdir : parent + "/" + subdir);
        if (result.length() > 1 && result.endsWith("/")) {
            result = result.substring(0, result.length() - 1);
        }
        return result;
    }

    private final String stripTrailingSlashes(String path) {
        if (path.length() > 1 && path.endsWith("/")) {
            return path.substring(0, path.length() - 1);
        }
        return path;
    }

    private final String resolveLocalCanonicalPath(String directoryName) {
        File directory = new File(directoryName);
        if (!directory.isAbsolute()) {
            directory = new File(this._controller.getLocalXVMSandboxRoot(), directoryName.replace("/", File.separator));
        }
        try {
            directory = directory.getCanonicalFile();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return directory.getAbsolutePath().replace("/", File.separator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void updateEnvironmentFrom(File envFile, StringBuilder sb) throws Exception {
        this.configSourceFileModifications.put(envFile, envFile.lastModified());
        sb.append("...").append(envFile.getAbsolutePath()).append("...");
        if (envFile.exists()) {
            try (BufferedReader reader = new BufferedReader(new FileReader(envFile));){
                String str;
                while ((str = reader.readLine()) != null) {
                    int index;
                    if ((str = str.trim()).length() <= 0 || str.startsWith("//") || str.startsWith("#") || (index = str.indexOf("=")) < 0) continue;
                    this._environment.put(str.substring(0, index), str.substring(index + 1));
                }
                sb.append("OK").append("\n");
            }
        } else {
            sb.append("X (does not exist)").append("\n");
        }
    }

    private final void localizeEnvironment() throws Exception {
        LinkedHashMap<String, String> substEnvironment = new LinkedHashMap<String, String>();
        for (String key : this._environment.keySet()) {
            String value = this._environment.get(key);
            substEnvironment.put(UtlTailoring.substitute((String)key, (UtlTailoring.PropertySource)this._controllerPropertySource), UtlTailoring.substitute((String)value, (UtlTailoring.PropertySource)this._controllerPropertySource));
        }
        this._environment = substEnvironment;
    }

    private final void initializeEnvironment() throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append("\n").append("Initializing environment for '" + this._name + "'...").append("\n");
        String commaSeparatedQualifiers = UtlProps.getValue((Properties)this._controller.getConfig(), (String)"nv.controller.env.qualifiers", null);
        if (commaSeparatedQualifiers != null) {
            this._controller.trace("'nv.controller.env.qualifiers' is deprecated and will be removed in a future release.", Tracer.Level.WARNING);
        }
        String[] qualifiers = commaSeparatedQualifiers != null ? commaSeparatedQualifiers.split(",") : new String[]{};
        for (int i = 0; i < qualifiers.length; ++i) {
            qualifiers[i] = qualifiers[i].trim();
        }
        this.updateEnvironmentFrom(new File(this._system.getHome() + File.separator + "xvm.env"), sb);
        for (String qualifier : qualifiers) {
            if (qualifier.length() <= 0) continue;
            this.updateEnvironmentFrom(new File(this._system.getHome() + File.separator + "xvm." + qualifier + ".env"), sb);
        }
        this.updateEnvironmentFrom(new File(this._system.getHome() + File.separator + this._name + ".env"), sb);
        for (String qualifier : qualifiers) {
            if (qualifier.length() <= 0) continue;
            this.updateEnvironmentFrom(new File(this._system.getHome() + File.separator + this._name + "." + qualifier + ".env"), sb);
        }
        this.localizeEnvironment();
        sb.append("...").append("resolved environment {").append("\n");
        for (String key : this._environment.keySet()) {
            String value = this._environment.get(key);
            sb.append("......").append(key).append("=").append(value).append("\n");
        }
        sb.append("...").append("}").append("\n");
        this._controller.trace(sb.toString(), Tracer.Level.VERBOSE);
    }

    final void provisioned(boolean val) {
        this._provisioned = val;
    }

    final boolean provisioned() {
        return this._provisioned;
    }

    public final String name() {
        return this._name;
    }

    public final String displayName() {
        return this._xvmModel.getDisplayName() == null ? this.name() : this._xvmModel.getDisplayName();
    }

    public final Model getXvmLocalizedModel() {
        return this._xvmLocalizedModel;
    }

    public final XvmConfigList.Xvm ddlElement() {
        return this._xvmModel;
    }

    public final String host() {
        return this._xvmModel.getProvisioning().getHost();
    }

    public final int sshPort() {
        return this._sshPort;
    }

    public final boolean enabled() {
        return this._enabled;
    }

    public final String runDir() {
        return this._xvmModel.getProvisioning().getRunDirectory();
    }

    public final String dataDir() {
        return this._xvmModel.getProvisioning().getDataDirectory();
    }

    public String traceLogsDir() {
        return this._xvmModel.getProvisioning().getTraceLogDirectory();
    }

    public final Map<String, String> environment() {
        return this._environment;
    }

    public File getConfigFile() {
        return this._localizedDdlFile;
    }

    public File getXcsFile() {
        return this._localizedXcsFile;
    }

    public File getEnvironmentFile() {
        return this._localizedEnvFile;
    }

    public File getJVMParamsFile() {
        return this._localizedJvmParamsFile;
    }

    public final String toString() {
        return this.host() + ":" + this.sshPort() + "://" + this.runDir();
    }
}

