/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.controller;

import com.neeve.controller.Command;
import com.neeve.controller.Controller;
import com.neeve.controller.ProgressMonitorHelper;
import com.neeve.controller.Script;
import com.neeve.controller.System;
import com.neeve.controller.XVM;
import com.neeve.controller.XVMUnreachableException;
import com.neeve.controller.util.ProcessHelper;
import com.neeve.util.UtlThrowable;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

final class Launch
extends Command {
    private String _sshUser;
    private String _sshKeyFile;
    private XVM _xvm;
    private boolean _launched;
    private String _numaNode;
    private List<String> _apps = new ArrayList<String>();

    Launch(Controller controller, ProgressMonitorHelper progressMonitorHelper, System system, Script script, int lineNum, String line) {
        super(controller, progressMonitorHelper, system, script, lineNum, line);
    }

    private final ProcessBuilder createLauncher() {
        if (!(this._xvm.host().equals(".") || this._sshUser != null && this._sshKeyFile != null)) {
            this.error("ssh user and key file needs to be provided for remote execution");
        }
        ArrayList<String> command = new ArrayList<String>();
        command.add(this.resolveScript("ruclaunch"));
        command.add(this._xvm.host().equals(".") ? "sh" : "ssh");
        command.add(this._xvm.runDir());
        command.add(this._xvm.traceLogsDir());
        command.add(this._xvm.name());
        command.add(this._numaNode != null ? this._numaNode : "default");
        if (!this._xvm.host().equals(".")) {
            command.add(this._sshUser + "@" + this._xvm.host());
            command.add(this._sshKeyFile);
            command.add(String.valueOf(this._xvm.sshPort()));
        }
        ProcessBuilder pb = new ProcessBuilder(command);
        pb.redirectErrorStream(true);
        ProcessHelper.cleanEnvironment(pb.environment());
        return pb;
    }

    private final void syntaxError(int lineNum) {
        this.error("Line " + lineNum + ": Syntax error: launch the <xvmName> xvm [on numa node <n>]");
    }

    @Override
    final String name() {
        return "launch";
    }

    @Override
    final boolean parse(Command.Args tokenizer) {
        this._sshUser = this.getSshUser();
        this._sshKeyFile = this.getSshKeyFile();
        if (!tokenizer.hasMoreTokens() || !tokenizer.nextToken().equalsIgnoreCase("the")) {
            this.syntaxError(this.lineNum());
        }
        if (!tokenizer.hasMoreTokens()) {
            this.syntaxError(this.lineNum());
        }
        String token = tokenizer.nextToken();
        this._xvm = this.system().getXVM(token);
        if (this._xvm == null) {
            this.error("Line " + this.lineNum() + ": XVM '" + token + "' is not configured in the '" + this.system().getHome().getName() + "' system");
        }
        if (!tokenizer.hasMoreTokens() || !tokenizer.nextToken().equalsIgnoreCase("xvm")) {
            this.syntaxError(this.lineNum());
        }
        if (tokenizer.hasMoreTokens()) {
            if (!tokenizer.nextToken().equalsIgnoreCase("on")) {
                this.syntaxError(this.lineNum());
            }
            if (!tokenizer.hasMoreTokens() || !tokenizer.nextToken().equalsIgnoreCase("numa")) {
                this.syntaxError(this.lineNum());
            }
            if (!tokenizer.hasMoreTokens() || !tokenizer.nextToken().equalsIgnoreCase("node")) {
                this.syntaxError(this.lineNum());
            }
            if (!tokenizer.hasMoreTokens()) {
                this.syntaxError(this.lineNum());
            }
            this._numaNode = tokenizer.nextToken();
            Integer.parseInt(this._numaNode);
        }
        return true;
    }

    @Override
    final void execute() {
        try {
            if (!this.mock()) {
                try {
                    this.remoteCommand(this._xvm.name(), null, null, false, false, 0);
                    this.error("Launch failed [server '" + this._xvm.name() + "' is already running]", null);
                }
                catch (XVMUnreachableException e) {
                    String line;
                    ProcessBuilder pb = this.createLauncher();
                    Process process = pb.start();
                    BufferedReader br = new BufferedReader(new InputStreamReader(process.getInputStream()));
                    while ((line = br.readLine()) != null) {
                        this.troubleshootingInfo(line);
                    }
                    while (true) {
                        try {
                            process.waitFor();
                        }
                        catch (InterruptedException interruptedException) {
                            continue;
                        }
                        break;
                    }
                    if (process.exitValue() != 0) {
                        this.error("Launch failed [exit code '" + process.exitValue() + "']");
                    }
                    this.remoteCommand(this._xvm.name(), null, null, false, true, 0);
                }
            }
            try {
                StringTokenizer tokenizer = new StringTokenizer((String)this.remoteCommand(this._xvm.name(), null, "app_list", true, 0), ",");
                while (tokenizer.hasMoreTokens()) {
                    this._apps.add(tokenizer.nextToken());
                }
                this._launched = true;
            }
            catch (XVMUnreachableException e) {
                if (this.isTreatUnreachableXVMAsNonFatal()) {
                    this.info("......server '" + this._xvm.name() + "' is unreachable. configured to ignore...");
                }
            }
        }
        catch (Exception e) {
            this.error("Launch failed [" + e.toString() + "]", e);
        }
    }

    final String xvmName() {
        return this._xvm.name();
    }

    final boolean launched() {
        return this._launched;
    }

    final List<String> apps() {
        return this._apps;
    }

    @Override
    final void cleanup() {
        if (this._launched) {
            this.info("......stopping XVM '" + this._xvm.name() + "'...");
            try {
                this.remoteCommand(this._xvm.name(), null, "kill", false, 0);
                for (int i = 0; i < 5; ++i) {
                    try {
                        this.remoteCommand(this._xvm.name(), null, null, false, 0);
                    }
                    catch (Exception e) {
                        this.info("......XVM stopped successfully [" + e.getMessage() + "].");
                        return;
                    }
                    this.info("......waiting for XVM to stop...");
                    this.sleep(1000L);
                }
                this.warning("......WARNING: Failed to stop the '" + this._xvm.name() + "' XVM [?]");
            }
            catch (Exception e) {
                this.warning("......WARNING: Failed to stop the '" + this._xvm.name() + "' XVM [" + e.toString() + "] ... see troubleshooting logs.");
                this.troubleshootingInfo(UtlThrowable.prepareStackTrace((Throwable)e));
            }
        }
    }
}

