/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.controller;

import com.neeve.controller.Controller;
import com.neeve.controller.ProgressMonitorHelper;
import com.neeve.controller.Script;
import com.neeve.controller.System;
import java.io.File;
import java.util.Arrays;
import java.util.NoSuchElementException;

public abstract class Command {
    private final Controller _controller;
    private final ProgressMonitorHelper _progressMonitorHelper;
    private final System _system;
    private final Script _script;
    private final int _lineNum;
    private final String _line;
    private boolean _mock;

    Command(Controller controller, ProgressMonitorHelper progressMonitorHelper, System system, Script script, int lineNum, String line) {
        this._controller = controller;
        this._progressMonitorHelper = progressMonitorHelper;
        this._system = system;
        this._script = script;
        this._lineNum = lineNum;
        this._line = line;
    }

    final Command mock(boolean val) {
        this._mock = val;
        return this;
    }

    final System system() {
        return this._system;
    }

    final Script script() {
        return this._script;
    }

    final void error(String str) {
        this._progressMonitorHelper.error(str);
    }

    final void error(String str, Throwable thrown) {
        this._progressMonitorHelper.error(str, thrown);
    }

    final void troubleshootingInfo(String str) {
        this._progressMonitorHelper.troubleshootingInfo(str);
    }

    final void info(String str) {
        this._progressMonitorHelper.info(str);
    }

    final void warning(String str) {
        this._progressMonitorHelper.warning(str);
    }

    final String getSshUser() {
        return this._controller.getSshUser();
    }

    final String getSshKeyFile() {
        return this._controller.getSshKeyFile();
    }

    final boolean isTreatUnreachableXVMAsNonFatal() {
        return this._controller.isTreatUnreachableXVMAsNonFatal();
    }

    final String resolveScript(String name) {
        return this._controller.resolveScript(name);
    }

    final Object remoteCommand(String xvmName, String appName, String command, boolean sync, boolean waitForXVMToLaunch, int numAppPingAttempts) throws Exception {
        return this._progressMonitorHelper.remoteCommand(xvmName, appName, command, sync, waitForXVMToLaunch, numAppPingAttempts);
    }

    final Object remoteCommand(String xvmName, String appName, String command, boolean sync, int numAppPingAttempts) throws Exception {
        return this._progressMonitorHelper.remoteCommand(xvmName, appName, command, sync, numAppPingAttempts);
    }

    final File getDistribution() {
        return this._controller.getDistribution();
    }

    final String getDistributionPlatform() {
        return this._controller.getDistributionPlatform();
    }

    final int getDistributionMajorVersion() {
        return this._controller.getDistributionMajorVersion();
    }

    final int getDistributionMinorVersion() {
        return this._controller.getDistributionMinorVersion();
    }

    final void sleep(long ms) {
        this._controller.sleep(ms);
    }

    abstract String name();

    abstract boolean parse(Args var1);

    abstract void execute();

    abstract void cleanup();

    public final boolean mock() {
        return this._mock;
    }

    public final int lineNum() {
        return this._lineNum;
    }

    public final String line() {
        return this._line;
    }

    protected final String[] getRemainingArgs(Args tokenizer) {
        return tokenizer.remainingArgs();
    }

    static class Args {
        private String[] args;
        private int index;

        Args(String[] args, int index) {
            this.args = args;
            this.index = index;
        }

        public boolean hasMoreTokens() {
            return this.index < this.args.length;
        }

        public String nextToken() {
            if (this.index >= this.args.length) {
                throw new NoSuchElementException("no more arguments");
            }
            return this.args[this.index++];
        }

        public String[] remainingArgs() {
            if (!this.hasMoreTokens()) {
                return new String[0];
            }
            return Arrays.copyOfRange(this.args, this.index, this.args.length);
        }
    }
}

