/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.build;

import com.neeve.build.Packager;
import com.neeve.build.RumiSystem;
import com.neeve.tools.interactive.commands.AnnotatedCommand;
import java.io.File;
import java.io.IOException;

@AnnotatedCommand.Command(keywords={"xar"}, description="Manipulates Rumi xar files")
public class XarPackager
extends AnnotatedCommand {
    public static final String RUMI_ARCHIVE_SUFFIX = ".xar";
    @AnnotatedCommand.Option(shortForm=118, longForm="verbose", defaultValue="false", required=false, description="Displays extracted files")
    boolean verbose;
    @AnnotatedCommand.Option(shortForm=120, longForm="extract", defaultValue="true", required=false, description="Indicates that the supplied file should be extracted")
    boolean extract;
    @AnnotatedCommand.Argument(position=0, name="xarFile", required=true, description="description specifies the xar file to extract")
    File xar;
    @AnnotatedCommand.Argument(position=1, name="destination", required=true, description="The destination folder to which to extract")
    File destination;

    public static File archive(RumiSystem system, File outputDirectory) throws IOException {
        if (!outputDirectory.exists()) {
            outputDirectory.mkdirs();
        }
        File xar = new File(outputDirectory, system.getName() + RUMI_ARCHIVE_SUFFIX);
        Packager.archive(system.stage(), xar);
        return xar;
    }

    public static void extract(File source, File targetDir, boolean verbose) throws IOException {
        Packager.extract(source, targetDir, verbose);
    }

    public void execute() throws Exception {
        if (this.extract) {
            Packager.extract(this.xar, this.destination, this.verbose);
        } else {
            this.console().error("This tool only supports extraction of a xar");
        }
    }

    public static final void main(String[] args) {
        new XarPackager().run(args);
    }
}

