/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.rog.impl;

import com.eaio.uuid.UUID;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.neeve.io.IOBuffer;
import com.neeve.io.IOElasticBuffer;
import com.neeve.lang.XString;
import com.neeve.ods.IStoreObject;
import com.neeve.pkt.PktFactory;
import com.neeve.pkt.PktPacket;
import com.neeve.rog.IRogCopyableNode;
import com.neeve.rog.IRogMessage;
import com.neeve.rog.impl.RogNode;
import com.neeve.rog.impl.RogPacketMessageFactory;
import com.neeve.sma.MessageReflector;
import com.neeve.util.UtlPool;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;

public class RogPacketMessage
extends RogNode
implements IRogMessage,
MessageReflector,
IRogCopyableNode<RogPacketMessage>,
UtlPool.Item<RogPacketMessage> {
    static final UtlPool<RogPacketMessage> POOL = UtlPool.create((String)"rog_pktmessage", (String)"default", (UtlPool.Factory)new PoolFactory(), (UtlPool.Params)UtlPool.Params.create().setThreaded(true));
    private UtlPool<RogPacketMessage> _pool;

    private RogPacketMessage(UUID id) {
        super((short)4, (short)7, (short)1, id, false);
        this.setMessageReflector(this);
    }

    public static final RogPacketMessage create() {
        return RogPacketMessageFactory.createPacketMessage();
    }

    private final void checkAndDisposeExistingPacket() {
        PktPacket packet = (PktPacket)this.getMessage();
        if (packet != null) {
            packet.dispose();
            this.setMessage(1, null);
        }
    }

    public static final XString getGlobalTypeString() {
        return XString.create((String)(Integer.toHexString(-7) + "-" + Integer.toHexString(1)));
    }

    @Override
    public final IStoreObject.EncodingType getContentEncodingType() {
        return IStoreObject.EncodingType.Custom;
    }

    @Override
    public final PktPacket serialize() {
        return this.serializeToPacket();
    }

    @Override
    public final IStoreObject deserialize(PktPacket packet) {
        return this.deserializeFromPacket(packet);
    }

    public final void sync() {
        if (this.getMessage() == null) {
            this.setMessage(1, PktFactory.getInstance().createPacket(256));
        }
    }

    @JsonGetter(value="rawMessage")
    public final byte[] serializeToByteArray() {
        this.sync();
        PktPacket packet = (PktPacket)this.getMessage();
        byte[] bytes = new byte[packet.getSerializedLength()];
        packet.serialize(bytes, 0);
        return bytes;
    }

    public final int serializeTo(byte[] array, int offset) {
        this.sync();
        return ((PktPacket)this.getMessage()).serialize(array, offset);
    }

    public final ByteBuffer serializeToByteBuffer() {
        this.sync();
        PktPacket packet = (PktPacket)this.getMessage();
        ByteBuffer buffer = IOBuffer.allocateByteBuffer((int)packet.getSerializedLength(), (boolean)true);
        packet.serialize(buffer);
        return buffer;
    }

    public final int serializeTo(ByteBuffer buffer) {
        this.sync();
        return ((PktPacket)this.getMessage()).serialize(buffer);
    }

    public final IOBuffer serializeToIOBuffer(boolean useNative) {
        this.sync();
        PktPacket packet = (PktPacket)this.getMessage();
        IOBuffer ioBuffer = IOBuffer.create((int)packet.getSerializedLength());
        packet.serialize(ioBuffer, 0);
        return ioBuffer;
    }

    public final int serializeTo(IOBuffer buffer, int offset) {
        this.sync();
        return ((PktPacket)this.getMessage()).serialize(buffer, offset);
    }

    public final int serializeTo(IOElasticBuffer buffer, int offset) {
        this.sync();
        buffer.setLength(offset + ((PktPacket)this.getMessage()).getSerializedLength());
        return this.serializeTo(buffer.getBackingBufferUnsafe(), buffer.getOffset() + offset);
    }

    public final PktPacket serializeToPacket() {
        this.sync();
        PktPacket packet = (PktPacket)this.getMessage();
        packet.acquire();
        return packet;
    }

    @Override
    public final int serializeTo(PktPacket packet) {
        this.sync();
        return packet.deserialize((PktPacket)this.getMessage());
    }

    public final int serializeTo(long addr, int offset) {
        this.sync();
        return ((PktPacket)this.getMessage()).serialize(addr, offset, true);
    }

    public String serializeToJson() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            RogPacketMessageFactory.mapper.writeValue((OutputStream)baos, (Object)this);
            return baos.toString();
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
    }

    public final RogPacketMessage deserializeFromByteArray(byte[] array) {
        return this.deserializeFromByteBuffer(IOBuffer.wrapByteBuffer((byte[])array));
    }

    public final RogPacketMessage deserializeFrom(byte[] array, int offset, int len) {
        return this.deserializeFromByteBuffer(IOBuffer.wrapByteBuffer((byte[])array, (int)offset, (int)len));
    }

    public final RogPacketMessage deserializeFromByteBuffer(ByteBuffer buffer) {
        try {
            this.checkAndDisposeExistingPacket();
            this.setMessage(1, PktFactory.getInstance().createPacket(buffer, buffer.position(), buffer.remaining()));
            return this;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public final RogPacketMessage deserializeFrom(ByteBuffer buffer) {
        return this.deserializeFromByteBuffer(buffer);
    }

    public final RogPacketMessage deserializeFrom(IOBuffer buffer, int offset, int len) {
        try {
            this.checkAndDisposeExistingPacket();
            this.setMessage(1, PktFactory.getInstance().createPacket(buffer, offset, len, false));
            return this;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public final RogPacketMessage deserializeFrom(IOElasticBuffer buffer, int offset, int len) {
        return this.deserializeFrom(buffer.getBackingBufferUnsafe(), buffer.getOffset() + offset, len);
    }

    public final RogPacketMessage deserializeFromPacket(PktPacket packet) {
        if (this.getMessage() == packet) {
            return this;
        }
        this.checkAndDisposeExistingPacket();
        this.setMessage(1, packet);
        return this;
    }

    public final RogPacketMessage deserializeFrom(PktPacket packet) {
        return this.deserializeFromPacket(packet);
    }

    public final RogPacketMessage deserializeFrom(long addr, int offset, int len) {
        try {
            this.checkAndDisposeExistingPacket();
            this.setMessage(1, PktFactory.getInstance().createPacket(addr, offset, len));
            return this;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public final RogPacketMessage deserializeFromJson(String json) {
        try {
            RogPacketMessageFactory.mapper.reader().withValueToUpdate((Object)this).readValue(json);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    @Override
    public final RogPacketMessage copy() {
        IOBuffer buffer = this.serializeToIOBuffer(true);
        RogPacketMessage copy = RogPacketMessage.create();
        copy.deserializeFrom(buffer, 0, ((PktPacket)this.getMessage()).getSerializedLength());
        buffer.dispose();
        this.copyCopyableFieldsToCopy(copy);
        return copy;
    }

    public final boolean needsSync() {
        return false;
    }

    public final boolean fieldExists(Object message, String name) {
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        return false;
    }

    public final boolean isFieldReflectable(Object message, String name) {
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        return false;
    }

    public final String getFieldValueAsString(Object message, String name) {
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        return null;
    }

    public String getFieldValueAsString(Object message, String[] pathComponents) {
        if (pathComponents == null) {
            throw new IllegalArgumentException("pathComponents cannot be null");
        }
        return null;
    }

    public XString getFieldValueAsRawString(Object message, String name) {
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        return null;
    }

    public XString getFieldValueAsRawString(Object message, String[] pathComponents) {
        if (pathComponents == null) {
            throw new IllegalArgumentException("pathComponents cannot be null");
        }
        return null;
    }

    public final RogPacketMessage init() {
        this.setMessage(1, null);
        return this;
    }

    public final RogPacketMessage setPool(UtlPool<RogPacketMessage> pool) {
        this._pool = pool;
        return this;
    }

    public final UtlPool<RogPacketMessage> getPool() {
        return this._pool;
    }

    @Override
    public int dispose() {
        int count = super.dispose();
        if (count < 0 && this._pool != null) {
            throw new IllegalStateException("attempt to dispose an already disposed entity");
        }
        if (count == 0) {
            this.checkAndDisposeExistingPacket();
            if (this._pool != null) {
                this._pool.put((UtlPool.Item)this);
            }
        }
        return count;
    }

    @Override
    public void undispose(UUID id) {
        super.undispose(id);
    }

    private static final class PoolFactory
    implements UtlPool.Factory<RogPacketMessage> {
        private PoolFactory() {
        }

        public final RogPacketMessage createItem(Object object) {
            PoolFactoryItemCreateArgument arg = (PoolFactoryItemCreateArgument)object;
            arg.wasCreated = true;
            return new RogPacketMessage(arg.id);
        }

        public final RogPacketMessage[] createItemArray(int size) {
            return new RogPacketMessage[size];
        }
    }

    static final class PoolFactoryItemCreateArgument {
        UUID id;
        boolean wasCreated;

        PoolFactoryItemCreateArgument() {
        }

        PoolFactoryItemCreateArgument init(UUID id) {
            this.id = id;
            this.wasCreated = false;
            return this;
        }
    }
}

