/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.query.impl;

import com.google.common.collect.AbstractIterator;
import com.neeve.query.QueryResult;
import com.neeve.query.QueryResultSet;
import com.neeve.query.impl.QueryAggregateField;
import com.neeve.query.impl.QueryCompositeResult;
import com.neeve.query.impl.QueryResultSetImpl;
import com.neeve.query.impl.QuerySortArea;
import java.util.Iterator;
import java.util.Map;

public class QueryAggregateResult<T>
extends QueryCompositeResult<T> {
    private QueryResultSetImpl<?, T> resultSet;
    private QuerySortArea<T> sortArea = null;
    private String aggregationMapId = null;

    public QueryAggregateResult(Iterable<QueryResult<T>> queryResults, QueryResultSetImpl<?, T> resultSet) {
        super(queryResults);
        this.resultSet = resultSet;
        this.sortArea = resultSet.getSortArea();
    }

    @Override
    public Iterator<QueryResultSet.Row<T>> iterator() {
        this.aggregationMapId = this.sortArea.createCollectionId();
        Map map = this.sortArea.getHashMap(this.aggregationMapId);
        for (QueryResult queryResult : this.queryResults) {
            for (QueryResultSet.Row row : queryResult) {
                QueryResultSetImpl.RowImpl rowImpl = (QueryResultSetImpl.RowImpl)row;
                QueryAggregateField.Aggregate repoAggregate = rowImpl.getAggregate();
                QueryAggregateField.Key key = repoAggregate.getKey();
                if (map.containsKey(key)) {
                    QueryAggregateField.Aggregate aggregate = (QueryAggregateField.Aggregate)map.get(key);
                    QueryAggregateField.Aggregate merged = aggregate.merge(repoAggregate);
                    map.put(key, merged);
                    continue;
                }
                map.put(key, repoAggregate);
            }
        }
        final Iterator aggIter = map.values().iterator();
        return new AbstractIterator<QueryResultSet.Row<T>>(){

            protected QueryResultSet.Row<T> computeNext() {
                if (aggIter.hasNext()) {
                    return QueryAggregateResult.this.resultSet.forAggregate((QueryAggregateField.Aggregate)aggIter.next());
                }
                return (QueryResultSet.Row)this.endOfData();
            }
        };
    }

    @Override
    public void close() {
        super.close();
        if (this.aggregationMapId != null) {
            this.sortArea.dropCollection(this.aggregationMapId);
        }
    }
}

