/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.ods;

import com.neeve.ods.IStoreBinding;
import com.neeve.ods.IStoreEventHandler;
import com.neeve.ods.IStoreReplicatorNotificationHandler;
import com.neeve.ods.OdsException;
import com.neeve.ods.OdsObject;
import com.neeve.ods.StoreBinding;
import com.neeve.ods.StoreDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.UUID;

public final class StoreBindingFactory
extends OdsObject {
    private static final StoreBindingFactory instance = new StoreBindingFactory();
    public static final int FLG_EVENT_SOURCING = 1;
    public static final int FLG_CREATE_CORE_BINDING = 2;

    private StoreBindingFactory() {
        super(null);
    }

    public static final StoreBindingFactory getInstance() {
        return instance;
    }

    private final IStoreBinding createBinding(String className, String memberName, StoreDescriptor descriptor, IStoreEventHandler eventHandler, IStoreReplicatorNotificationHandler replicatorNotificationHandler, int flags) throws OdsException {
        Class<?> bindingClass = null;
        try {
            bindingClass = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new OdsException("Store binding class [" + className + "] could not be found");
        }
        catch (UnsupportedClassVersionError e) {
            throw new OdsException("Store binding class [" + className + "] is not supported by this VM <version=" + System.getProperty("java.vm.version") + ">");
        }
        Method bindingCreateMethod = null;
        try {
            Class[] parameterTypes = new Class[]{Class.forName("java.lang.String"), Class.forName("com.neeve.ods.StoreDescriptor"), Class.forName("com.neeve.ods.IStoreEventHandler"), Class.forName("com.neeve.ods.IStoreReplicatorNotificationHandler"), Class.forName("java.lang.Integer")};
            bindingCreateMethod = bindingClass.getMethod("create", parameterTypes);
        }
        catch (ClassNotFoundException e) {
            throw new InternalError("Failed to load java.util.Properties during instantiation of store binding class [" + className + "]");
        }
        catch (SecurityException e) {
            throw new OdsException("Access to instantiation method in store binding class [" + className + "] is denied");
        }
        catch (NoSuchMethodException e) {
            throw new OdsException("Instantiation method in store binding class [" + className + "] could not be found");
        }
        IStoreBinding binding = null;
        try {
            try {
                Object[] parameters = new Object[]{memberName, descriptor, eventHandler, replicatorNotificationHandler, flags};
                binding = (IStoreBinding)bindingCreateMethod.invoke(null, parameters);
                if (binding == null) {
                    throw new OdsException("Instantiation method in store binding class [" + className + "] returned a null object");
                }
            }
            catch (ClassCastException e) {
                throw new OdsException("Instantiation method in store binding class [" + className + "] returned object of incorrect type");
            }
        }
        catch (IllegalAccessException e) {
            throw new OdsException("Access to instantiation method in store binding class [" + className + "] is denied");
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof OdsException) {
                throw (OdsException)e.getCause();
            }
            throw new OdsException(e.getCause());
        }
        return binding;
    }

    public final IStoreBinding createBinding(String memberName, StoreDescriptor descriptor, IStoreEventHandler eventHandler, IStoreReplicatorNotificationHandler replicatorNotificationHandler, int flags) throws OdsException {
        boolean createCoreBinding;
        if (descriptor == null) {
            throw new IllegalArgumentException("descriptor cannot be null");
        }
        boolean bl = createCoreBinding = (flags & 2) == 2;
        if (createCoreBinding) {
            return this.createBinding("com.neeve.ods.impl.StoreBindingImpl", memberName == null ? UUID.randomUUID().toString() : memberName, descriptor, eventHandler, replicatorNotificationHandler, flags);
        }
        return StoreBinding.create(memberName, descriptor, eventHandler, replicatorNotificationHandler, flags);
    }

    public final IStoreBinding createBinding(String memberName, StoreDescriptor descriptor, IStoreEventHandler eventHandler, int flags) throws OdsException {
        return this.createBinding(memberName, descriptor, eventHandler, null, flags);
    }

    public final IStoreBinding createBinding(String memberName, StoreDescriptor descriptor, IStoreEventHandler eventHandler, IStoreReplicatorNotificationHandler replicatorNotificationHandler) throws OdsException {
        return this.createBinding(memberName, descriptor, eventHandler, replicatorNotificationHandler, 0);
    }

    public final IStoreBinding createBinding(String memberName, StoreDescriptor descriptor, IStoreEventHandler eventHandler) throws OdsException {
        return this.createBinding(memberName, descriptor, eventHandler, null);
    }

    public final IStoreBinding createBinding(String memberName, String storeName, IStoreEventHandler eventHandler, IStoreReplicatorNotificationHandler replicatorNotificationHandler, int flags) throws OdsException {
        return this.createBinding(memberName, StoreDescriptor.load(storeName), eventHandler, replicatorNotificationHandler);
    }

    public final IStoreBinding createBinding(String memberName, String storeName, IStoreEventHandler eventHandler) throws OdsException {
        return this.createBinding(memberName, storeName, eventHandler, null, 0);
    }

    public final IStoreBinding createBinding(String memberName, String storeName, IStoreEventHandler eventHandler, int flags) throws OdsException {
        return this.createBinding(memberName, storeName, eventHandler, null, flags);
    }
}

