/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.lang;

import com.neeve.lang.XCollection;
import com.neeve.lang.XDoubleCollection;
import com.neeve.lang.XDoubleIterator;
import com.neeve.lang.XDoubleIteratorImpl;
import com.neeve.lang.XDoubleList;
import com.neeve.lang.XDoubleListIterator;
import com.neeve.lang.XDoubleSet;
import java.util.List;

public abstract class XDoubleCollectionBase
implements XDoubleCollection {
    private XDoubleIteratorImpl reusableIterator;

    protected XDoubleCollectionBase() {
    }

    @Override
    public abstract int size();

    @Override
    public abstract XCollection.Record head();

    @Override
    public abstract XCollection.Record tail();

    @Override
    public abstract double valueOf(XCollection.Record var1);

    @Override
    public abstract void delete(XCollection.Record var1);

    @Override
    public XDoubleCollection unmodifiable() {
        return new Unmodifiable();
    }

    @Override
    public XDoubleCollection shared() {
        return new Shared();
    }

    @Override
    public XDoubleIterator iterator() {
        return XDoubleIteratorImpl.valueOf(this);
    }

    @Override
    public XDoubleIterator reusableIterator() {
        if (this.reusableIterator == null) {
            this.reusableIterator = XDoubleIteratorImpl.valueOf(this);
        } else {
            this.reusableIterator.toFirst();
        }
        return this.reusableIterator;
    }

    @Override
    public boolean supportsIteratorModifications() {
        return true;
    }

    @Override
    public boolean add(double value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(double value) {
        XCollection.Record r = this.head();
        XCollection.Record end = this.tail();
        while ((r = r.getNext()) != end) {
            if (value != this.valueOf(r)) continue;
            this.delete(r);
            return true;
        }
        return false;
    }

    @Override
    public void clear() {
        XCollection.Record head = this.head();
        for (XCollection.Record r = this.tail().getPrevious(); r != head; r = r.getPrevious()) {
            this.delete(r);
        }
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean contains(double value) {
        XCollection.Record r = this.head();
        XCollection.Record end = this.tail();
        while ((r = r.getNext()) != end) {
            if (value != this.valueOf(r)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean addAll(XDoubleCollection c) {
        boolean modified = false;
        XDoubleIterator itr = c.iterator();
        while (itr.hasNext()) {
            if (!this.add(itr.next())) continue;
            modified = true;
        }
        return modified;
    }

    @Override
    public boolean containsAll(XDoubleCollection c) {
        XDoubleIterator itr = c.iterator();
        while (itr.hasNext()) {
            if (this.contains(itr.next())) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean removeAll(XDoubleCollection c) {
        boolean modified = false;
        XCollection.Record head = this.head();
        XCollection.Record r = this.tail().getPrevious();
        while (r != head) {
            XCollection.Record previous = r.getPrevious();
            if (c.contains(this.valueOf(r))) {
                this.delete(r);
                modified = true;
            }
            r = previous;
        }
        return modified;
    }

    @Override
    public boolean retainAll(XDoubleCollection c) {
        boolean modified = false;
        XCollection.Record head = this.head();
        XCollection.Record r = this.tail().getPrevious();
        while (r != head) {
            XCollection.Record previous = r.getPrevious();
            if (!c.contains(this.valueOf(r))) {
                this.delete(r);
                modified = true;
            }
            r = previous;
        }
        return modified;
    }

    @Override
    public double[] toArray() {
        return this.toArray(new double[this.size()]);
    }

    @Override
    public double[] toArray(double[] array) {
        int size = this.size();
        if (array.length < size) {
            array = new double[size];
        }
        if (array.length > size) {
            array[size] = -1.0;
        }
        int i = 0;
        double[] arrayView = array;
        XCollection.Record r = this.head();
        XCollection.Record end = this.tail();
        while ((r = r.getNext()) != end) {
            arrayView[i++] = this.valueOf(r);
        }
        return array;
    }

    public String toString() {
        XDoubleIterator it = this.iterator();
        if (!it.hasNext()) {
            return "[]";
        }
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        while (true) {
            double e = it.next();
            sb.append(e);
            if (!it.hasNext()) {
                return sb.append(']').toString();
            }
            sb.append(',').append(' ');
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (this instanceof XDoubleList) {
            return obj instanceof XDoubleList ? this.equalsOrder((XDoubleList)obj) : false;
        }
        if (obj instanceof XDoubleList) {
            return false;
        }
        if (!(obj instanceof XDoubleCollection)) {
            return false;
        }
        XDoubleCollection that = (XDoubleCollection)obj;
        return this == that || this.size() == that.size() && this.containsAll(that);
    }

    private boolean equalsOrder(XDoubleList that) {
        if (that == this) {
            return true;
        }
        if (this.size() != that.size()) {
            return false;
        }
        XDoubleIterator thatIterator = that.iterator();
        XCollection.Record r = this.head();
        XCollection.Record end = this.tail();
        while ((r = r.getNext()) != end) {
            double o2;
            double o1 = this.valueOf(r);
            if (o1 == (o2 = thatIterator.next())) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        if (this instanceof List) {
            return this.hashCodeList();
        }
        int hash = 0;
        XCollection.Record r = this.head();
        XCollection.Record end = this.tail();
        while ((r = r.getNext()) != end) {
            hash += XDoubleCollectionBase.hashCodeFor(this.valueOf(r));
        }
        return hash;
    }

    private int hashCodeList() {
        int h = 1;
        XCollection.Record r = this.head();
        XCollection.Record end = this.tail();
        while ((r = r.getNext()) != end) {
            h = 31 * h + XDoubleCollectionBase.hashCodeFor(this.valueOf(r));
        }
        return h;
    }

    static int hashCodeFor(double value) {
        long bits = Double.doubleToLongBits(value);
        return (int)(bits ^ bits >>> 32);
    }

    private class Shared
    implements XDoubleCollection {
        private Shared() {
        }

        @Override
        public synchronized int size() {
            return XDoubleCollectionBase.this.size();
        }

        @Override
        public synchronized boolean isEmpty() {
            return XDoubleCollectionBase.this.isEmpty();
        }

        @Override
        public synchronized boolean contains(double o) {
            return XDoubleCollectionBase.this.contains(o);
        }

        @Override
        public synchronized double[] toArray() {
            return XDoubleCollectionBase.this.toArray();
        }

        @Override
        public synchronized double[] toArray(double[] a) {
            return XDoubleCollectionBase.this.toArray(a);
        }

        @Override
        public synchronized XDoubleIterator iterator() {
            return new CollectionArrayIterator(XDoubleCollectionBase.this.toArray());
        }

        @Override
        public XDoubleIterator reusableIterator() {
            throw new UnsupportedOperationException("Reusable iterator not supported for this shared collection");
        }

        @Override
        public synchronized boolean supportsIteratorModifications() {
            return XDoubleCollectionBase.this.supportsIteratorModifications();
        }

        @Override
        public synchronized boolean add(double e) {
            return XDoubleCollectionBase.this.add(e);
        }

        @Override
        public synchronized boolean remove(double o) {
            return XDoubleCollectionBase.this.remove(o);
        }

        @Override
        public synchronized boolean containsAll(XDoubleCollection c) {
            return XDoubleCollectionBase.this.containsAll(c);
        }

        @Override
        public synchronized boolean addAll(XDoubleCollection c) {
            return XDoubleCollectionBase.this.addAll(c);
        }

        @Override
        public synchronized boolean removeAll(XDoubleCollection c) {
            return XDoubleCollectionBase.this.removeAll(c);
        }

        @Override
        public synchronized boolean retainAll(XDoubleCollection c) {
            return XDoubleCollectionBase.this.retainAll(c);
        }

        @Override
        public synchronized void clear() {
            XDoubleCollectionBase.this.clear();
        }

        public synchronized String toString() {
            return XDoubleCollectionBase.this.toString();
        }

        @Override
        public synchronized XCollection.Record head() {
            return XDoubleCollectionBase.this.head();
        }

        @Override
        public synchronized XCollection.Record tail() {
            return XDoubleCollectionBase.this.tail();
        }

        @Override
        public double valueOf(XCollection.Record record) {
            return XDoubleCollectionBase.this.valueOf(record);
        }

        @Override
        public synchronized void delete(XCollection.Record record) {
            XDoubleCollectionBase.this.delete(record);
        }

        @Override
        public XDoubleCollection unmodifiable() {
            return XDoubleCollectionBase.this.unmodifiable();
        }

        @Override
        public XDoubleCollection shared() {
            return this;
        }

        private class CollectionArrayIterator
        implements XDoubleIterator {
            private double[] _elements;
            private int _index;
            private double _next;
            private boolean removed;

            public CollectionArrayIterator(double[] elements) {
                this._elements = elements;
                this.removed = true;
            }

            @Override
            public boolean hasNext() {
                return this._index < this._elements.length;
            }

            @Override
            public double next() {
                this.removed = false;
                this._next = this._elements[this._index++];
                return this._next;
            }

            @Override
            public void remove() {
                if (this.removed) {
                    throw new IllegalStateException("No element to remove");
                }
                Shared.this.remove(this._next);
                this.removed = true;
            }

            @Override
            public CollectionArrayIterator toFirst() {
                this._index = 0;
                this._next = 0.0;
                this._elements = Shared.this.toArray();
                this.removed = true;
                return this;
            }
        }
    }

    class Unmodifiable
    extends XDoubleCollectionBase
    implements XDoubleSet,
    XDoubleList {
        Unmodifiable() {
        }

        @Override
        public int size() {
            return XDoubleCollectionBase.this.size();
        }

        @Override
        public XCollection.Record head() {
            return XDoubleCollectionBase.this.head();
        }

        @Override
        public XCollection.Record tail() {
            return XDoubleCollectionBase.this.tail();
        }

        @Override
        public double valueOf(XCollection.Record record) {
            return XDoubleCollectionBase.this.valueOf(record);
        }

        @Override
        public boolean contains(double value) {
            return XDoubleCollectionBase.this.contains(value);
        }

        @Override
        public boolean containsAll(XDoubleCollection c) {
            return XDoubleCollectionBase.this.containsAll(c);
        }

        @Override
        public boolean add(double obj) {
            throw new UnsupportedOperationException("Unmodifiable");
        }

        @Override
        public void delete(XCollection.Record node) {
            throw new UnsupportedOperationException("Unmodifiable");
        }

        @Override
        public boolean addAll(int index, XDoubleCollection c) {
            throw new UnsupportedOperationException("Unmodifiable");
        }

        @Override
        public double get(int index) {
            return ((XDoubleList)((Object)XDoubleCollectionBase.this)).get(index);
        }

        @Override
        public double set(int index, double element) {
            throw new UnsupportedOperationException("Unmodifiable");
        }

        @Override
        public void add(int index, double element) {
            throw new UnsupportedOperationException("Unmodifiable");
        }

        @Override
        public boolean remove(double index) {
            throw new UnsupportedOperationException("Unmodifiable");
        }

        @Override
        public double remove(int index) {
            throw new UnsupportedOperationException("Unmodifiable");
        }

        @Override
        public int indexOf(double o) {
            return ((XDoubleList)((Object)XDoubleCollectionBase.this)).indexOf(o);
        }

        @Override
        public int lastIndexOf(double o) {
            return ((XDoubleList)((Object)XDoubleCollectionBase.this)).lastIndexOf(o);
        }

        @Override
        public XDoubleListIterator listIterator() {
            throw new UnsupportedOperationException("List iterator not supported for unmodifiable collection");
        }

        @Override
        public XDoubleListIterator listIterator(int index) {
            throw new UnsupportedOperationException("List iterator not supported for unmodifiable collection");
        }

        @Override
        public XDoubleList subList(int fromIndex, int toIndex) {
            throw new UnsupportedOperationException("Sub-List not supported for unmodifiable collection");
        }
    }
}

