/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.adm;

import com.neeve.adm.AdmEnumeration;
import com.neeve.adm.AdmField;
import com.neeve.adm.AdmPrimitive;
import com.neeve.adm.AdmString;
import com.neeve.adm.AdmType;
import java.util.ArrayList;
import java.util.List;

public final class AdmFieldBlock {
    private final int id;
    private final List<AdmField> fields = new ArrayList<AdmField>();
    private int index;
    private int serializedLength;

    public AdmFieldBlock(int id) {
        this.id = id;
        this.index = Integer.MAX_VALUE;
    }

    public final int id() {
        return this.id;
    }

    public final int index() {
        return this.index;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void add(AdmField field) {
        this.fields.add(field);
        AdmType fieldType = field.getType();
        if (fieldType instanceof AdmPrimitive) {
            if (fieldType instanceof AdmString) {
                if (field.getLength() <= 0) throw new IllegalArgumentException("a block cannot contain variable length fields");
                this.serializedLength += field.getLength();
            } else {
                this.serializedLength += ((AdmPrimitive)fieldType).getType().getSerializedLength();
            }
        } else {
            if (!(fieldType instanceof AdmEnumeration)) throw new IllegalArgumentException("a block cannot contain variable length fields");
            this.serializedLength += AdmPrimitive.Type.Integer.getSerializedLength();
        }
        this.index = Math.min(this.index, field.getIndex());
        field.setIndex(0);
    }

    public final List<AdmField> fields() {
        return this.fields;
    }

    public final int serializedLength() {
        return this.serializedLength;
    }
}

