/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.cloud.civo.messages;

import com.eaio.uuid.UUID;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.neeve.adm.runtime.AdmRuntime;
import com.neeve.adm.runtime.annotations.AdmFactoryInfo;
import com.neeve.adm.runtime.annotations.AdmGenerated;
import com.neeve.cloud.civo.messages.IInstanceSize;
import com.neeve.cloud.civo.messages.MessageFactory;
import com.neeve.config.Config;
import com.neeve.io.IOBuffer;
import com.neeve.io.IOElasticBuffer;
import com.neeve.lang.IXStringFactory;
import com.neeve.lang.XString;
import com.neeve.lang.XStringDeserializer;
import com.neeve.memory.MemoryStats;
import com.neeve.pkt.PktFactory;
import com.neeve.pkt.PktPacket;
import com.neeve.quark.IQuarkChildSerializationCompletionCallback;
import com.neeve.query.impl.index.IdxMappable;
import com.neeve.rog.IRogFieldReflector;
import com.neeve.rog.impl.RogNonTransactionalField;
import com.neeve.sma.MessageReflector;
import com.neeve.util.UtlPool;
import com.neeve.util.UtlReflection;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.text.SimpleDateFormat;
import java.util.Currency;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.TimeZone;
import java.util.concurrent.atomic.AtomicInteger;

@AdmGenerated(encoding="quark", compatLevel="5.0.0", admVersion="nvx-rumi-adm v4.0 (build 594)", date="10/9/25 5:18 AM", buildInfo="nvx-rumi-cloud-2.0.54 (Rumi ADM Maven Plugin)")
@AdmFactoryInfo(factoryClass=MessageFactory.class, vfid=-1, ofid=-1, typeId=1004)
@JsonPropertyOrder(value={"cpuCores", "ramInMb", "diskInGb", "selectable", "name", "niceName", "description"})
public final class InstanceSize
implements IInstanceSize,
MessageReflector,
IdxMappable,
UtlPool.Item<InstanceSize>,
AdmRuntime.BufferSizer {
    private static final RogNonTransactionalField<InstanceSize, Integer> _cpuCoresReflector = new RogNonTransactionalField<InstanceSize, Integer>("cpuCores", InstanceSize.class, "cpuCores", Integer.class, null){
        private static final long serialVersionUID = 1L;
        private final ThreadLocal<CpuCoresDeserializer> _fieldDeserializer = new ThreadLocal();

        private final CpuCoresDeserializer getFieldDeserializer() {
            CpuCoresDeserializer fieldDeserializer = this._fieldDeserializer.get();
            if (fieldDeserializer == null) {
                fieldDeserializer = new CpuCoresDeserializer();
                this._fieldDeserializer.set(fieldDeserializer);
            }
            return fieldDeserializer;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final boolean resolveFieldValue(InstanceSize node) {
            if (node.hasPojo()) {
                return node.hasCpuCores();
            }
            Deserializer entityDeserializer = node.deserializer(true);
            try {
                CpuCoresDeserializer fieldDeserializer = this.getFieldDeserializer();
                fieldDeserializer.run(entityDeserializer);
                boolean bl = fieldDeserializer.wasSet();
                return bl;
            }
            finally {
                node.disposeDeserializer();
            }
        }

        private final int getResolvedFieldValue(InstanceSize node) {
            if (node.hasPojo()) {
                return node.getCpuCores();
            }
            return this.getFieldDeserializer()._value;
        }

        public final void setValue(InstanceSize node, Integer value) {
            if (value == null) {
                node.clearCpuCores();
            } else {
                node.setCpuCores(value);
            }
        }

        public final boolean hasValue(InstanceSize node) {
            return this.resolveFieldValue(node);
        }

        public final Integer getValue(InstanceSize node) {
            return this.resolveFieldValue(node) ? Integer.valueOf(this.getResolvedFieldValue(node)) : null;
        }

        public final boolean appendValueTo(InstanceSize node, XString target) {
            if (this.resolveFieldValue(node)) {
                target.append((long)this.getResolvedFieldValue(node));
                return true;
            }
            return false;
        }
    };
    private static final RogNonTransactionalField<InstanceSize, Integer> _ramInMbReflector = new RogNonTransactionalField<InstanceSize, Integer>("ramInMb", InstanceSize.class, "ramInMb", Integer.class, null){
        private static final long serialVersionUID = 1L;
        private final ThreadLocal<RamInMbDeserializer> _fieldDeserializer = new ThreadLocal();

        private final RamInMbDeserializer getFieldDeserializer() {
            RamInMbDeserializer fieldDeserializer = this._fieldDeserializer.get();
            if (fieldDeserializer == null) {
                fieldDeserializer = new RamInMbDeserializer();
                this._fieldDeserializer.set(fieldDeserializer);
            }
            return fieldDeserializer;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final boolean resolveFieldValue(InstanceSize node) {
            if (node.hasPojo()) {
                return node.hasRamInMb();
            }
            Deserializer entityDeserializer = node.deserializer(true);
            try {
                RamInMbDeserializer fieldDeserializer = this.getFieldDeserializer();
                fieldDeserializer.run(entityDeserializer);
                boolean bl = fieldDeserializer.wasSet();
                return bl;
            }
            finally {
                node.disposeDeserializer();
            }
        }

        private final int getResolvedFieldValue(InstanceSize node) {
            if (node.hasPojo()) {
                return node.getRamInMb();
            }
            return this.getFieldDeserializer()._value;
        }

        public final void setValue(InstanceSize node, Integer value) {
            if (value == null) {
                node.clearRamInMb();
            } else {
                node.setRamInMb(value);
            }
        }

        public final boolean hasValue(InstanceSize node) {
            return this.resolveFieldValue(node);
        }

        public final Integer getValue(InstanceSize node) {
            return this.resolveFieldValue(node) ? Integer.valueOf(this.getResolvedFieldValue(node)) : null;
        }

        public final boolean appendValueTo(InstanceSize node, XString target) {
            if (this.resolveFieldValue(node)) {
                target.append((long)this.getResolvedFieldValue(node));
                return true;
            }
            return false;
        }
    };
    private static final RogNonTransactionalField<InstanceSize, Integer> _diskInGbReflector = new RogNonTransactionalField<InstanceSize, Integer>("diskInGb", InstanceSize.class, "diskInGb", Integer.class, null){
        private static final long serialVersionUID = 1L;
        private final ThreadLocal<DiskInGbDeserializer> _fieldDeserializer = new ThreadLocal();

        private final DiskInGbDeserializer getFieldDeserializer() {
            DiskInGbDeserializer fieldDeserializer = this._fieldDeserializer.get();
            if (fieldDeserializer == null) {
                fieldDeserializer = new DiskInGbDeserializer();
                this._fieldDeserializer.set(fieldDeserializer);
            }
            return fieldDeserializer;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final boolean resolveFieldValue(InstanceSize node) {
            if (node.hasPojo()) {
                return node.hasDiskInGb();
            }
            Deserializer entityDeserializer = node.deserializer(true);
            try {
                DiskInGbDeserializer fieldDeserializer = this.getFieldDeserializer();
                fieldDeserializer.run(entityDeserializer);
                boolean bl = fieldDeserializer.wasSet();
                return bl;
            }
            finally {
                node.disposeDeserializer();
            }
        }

        private final int getResolvedFieldValue(InstanceSize node) {
            if (node.hasPojo()) {
                return node.getDiskInGb();
            }
            return this.getFieldDeserializer()._value;
        }

        public final void setValue(InstanceSize node, Integer value) {
            if (value == null) {
                node.clearDiskInGb();
            } else {
                node.setDiskInGb(value);
            }
        }

        public final boolean hasValue(InstanceSize node) {
            return this.resolveFieldValue(node);
        }

        public final Integer getValue(InstanceSize node) {
            return this.resolveFieldValue(node) ? Integer.valueOf(this.getResolvedFieldValue(node)) : null;
        }

        public final boolean appendValueTo(InstanceSize node, XString target) {
            if (this.resolveFieldValue(node)) {
                target.append((long)this.getResolvedFieldValue(node));
                return true;
            }
            return false;
        }
    };
    private static final RogNonTransactionalField<InstanceSize, Boolean> _selectableReflector = new RogNonTransactionalField<InstanceSize, Boolean>("selectable", InstanceSize.class, "selectable", Boolean.class, null){
        private static final long serialVersionUID = 1L;
        private final ThreadLocal<SelectableDeserializer> _fieldDeserializer = new ThreadLocal();

        private final SelectableDeserializer getFieldDeserializer() {
            SelectableDeserializer fieldDeserializer = this._fieldDeserializer.get();
            if (fieldDeserializer == null) {
                fieldDeserializer = new SelectableDeserializer();
                this._fieldDeserializer.set(fieldDeserializer);
            }
            return fieldDeserializer;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final boolean resolveFieldValue(InstanceSize node) {
            if (node.hasPojo()) {
                return node.hasSelectable();
            }
            Deserializer entityDeserializer = node.deserializer(true);
            try {
                SelectableDeserializer fieldDeserializer = this.getFieldDeserializer();
                fieldDeserializer.run(entityDeserializer);
                boolean bl = fieldDeserializer.wasSet();
                return bl;
            }
            finally {
                node.disposeDeserializer();
            }
        }

        private final boolean getResolvedFieldValue(InstanceSize node) {
            if (node.hasPojo()) {
                return node.getSelectable();
            }
            return this.getFieldDeserializer()._value;
        }

        public final void setValue(InstanceSize node, Boolean value) {
            if (value == null) {
                node.clearSelectable();
            } else {
                node.setSelectable(value);
            }
        }

        public final boolean hasValue(InstanceSize node) {
            return this.resolveFieldValue(node);
        }

        public final Boolean getValue(InstanceSize node) {
            return this.resolveFieldValue(node) ? Boolean.valueOf(this.getResolvedFieldValue(node)) : null;
        }

        public final boolean appendValueTo(InstanceSize node, XString target) {
            if (this.resolveFieldValue(node)) {
                target.append(this.getResolvedFieldValue(node));
                return true;
            }
            return false;
        }
    };
    private static final RogNonTransactionalField<InstanceSize, String> _nameReflector = new RogNonTransactionalField<InstanceSize, String>("name", InstanceSize.class, "name", String.class, null){
        private static final long serialVersionUID = 1L;
        private final ThreadLocal<NameDeserializer> _fieldDeserializer = new ThreadLocal();

        private final NameDeserializer getFieldDeserializer() {
            NameDeserializer fieldDeserializer = this._fieldDeserializer.get();
            if (fieldDeserializer == null) {
                fieldDeserializer = new NameDeserializer();
                this._fieldDeserializer.set(fieldDeserializer);
            }
            return fieldDeserializer;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final boolean resolveFieldValue(InstanceSize node) {
            if (node.hasPojo()) {
                return node.hasName();
            }
            Deserializer entityDeserializer = node.deserializer(true);
            try {
                NameDeserializer fieldDeserializer = this.getFieldDeserializer();
                fieldDeserializer.run(entityDeserializer);
                boolean bl = fieldDeserializer.wasSet();
                return bl;
            }
            finally {
                node.disposeDeserializer();
            }
        }

        private final XString getResolvedFieldValue(InstanceSize node) {
            if (node.hasPojo()) {
                return node.getNameUnsafe();
            }
            return this.getFieldDeserializer()._value;
        }

        public final void setValue(InstanceSize node, String value) {
            if (value == null) {
                node.clearName();
            } else {
                node.setName(value);
            }
        }

        public final boolean hasValue(InstanceSize node) {
            return this.resolveFieldValue(node);
        }

        public final String getValue(InstanceSize node) {
            XString val = this.resolveFieldValue(node) ? this.getResolvedFieldValue(node) : null;
            return val == null ? null : val.getValue();
        }

        public final boolean appendValueTo(InstanceSize node, XString target) {
            if (this.resolveFieldValue(node)) {
                target.append(this.getResolvedFieldValue(node));
                return true;
            }
            return false;
        }
    };
    private static final RogNonTransactionalField<InstanceSize, String> _niceNameReflector = new RogNonTransactionalField<InstanceSize, String>("niceName", InstanceSize.class, "niceName", String.class, null){
        private static final long serialVersionUID = 1L;
        private final ThreadLocal<NiceNameDeserializer> _fieldDeserializer = new ThreadLocal();

        private final NiceNameDeserializer getFieldDeserializer() {
            NiceNameDeserializer fieldDeserializer = this._fieldDeserializer.get();
            if (fieldDeserializer == null) {
                fieldDeserializer = new NiceNameDeserializer();
                this._fieldDeserializer.set(fieldDeserializer);
            }
            return fieldDeserializer;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final boolean resolveFieldValue(InstanceSize node) {
            if (node.hasPojo()) {
                return node.hasNiceName();
            }
            Deserializer entityDeserializer = node.deserializer(true);
            try {
                NiceNameDeserializer fieldDeserializer = this.getFieldDeserializer();
                fieldDeserializer.run(entityDeserializer);
                boolean bl = fieldDeserializer.wasSet();
                return bl;
            }
            finally {
                node.disposeDeserializer();
            }
        }

        private final XString getResolvedFieldValue(InstanceSize node) {
            if (node.hasPojo()) {
                return node.getNiceNameUnsafe();
            }
            return this.getFieldDeserializer()._value;
        }

        public final void setValue(InstanceSize node, String value) {
            if (value == null) {
                node.clearNiceName();
            } else {
                node.setNiceName(value);
            }
        }

        public final boolean hasValue(InstanceSize node) {
            return this.resolveFieldValue(node);
        }

        public final String getValue(InstanceSize node) {
            XString val = this.resolveFieldValue(node) ? this.getResolvedFieldValue(node) : null;
            return val == null ? null : val.getValue();
        }

        public final boolean appendValueTo(InstanceSize node, XString target) {
            if (this.resolveFieldValue(node)) {
                target.append(this.getResolvedFieldValue(node));
                return true;
            }
            return false;
        }
    };
    private static final RogNonTransactionalField<InstanceSize, String> _descriptionReflector = new RogNonTransactionalField<InstanceSize, String>("description", InstanceSize.class, "description", String.class, null){
        private static final long serialVersionUID = 1L;
        private final ThreadLocal<DescriptionDeserializer> _fieldDeserializer = new ThreadLocal();

        private final DescriptionDeserializer getFieldDeserializer() {
            DescriptionDeserializer fieldDeserializer = this._fieldDeserializer.get();
            if (fieldDeserializer == null) {
                fieldDeserializer = new DescriptionDeserializer();
                this._fieldDeserializer.set(fieldDeserializer);
            }
            return fieldDeserializer;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final boolean resolveFieldValue(InstanceSize node) {
            if (node.hasPojo()) {
                return node.hasDescription();
            }
            Deserializer entityDeserializer = node.deserializer(true);
            try {
                DescriptionDeserializer fieldDeserializer = this.getFieldDeserializer();
                fieldDeserializer.run(entityDeserializer);
                boolean bl = fieldDeserializer.wasSet();
                return bl;
            }
            finally {
                node.disposeDeserializer();
            }
        }

        private final XString getResolvedFieldValue(InstanceSize node) {
            if (node.hasPojo()) {
                return node.getDescriptionUnsafe();
            }
            return this.getFieldDeserializer()._value;
        }

        public final void setValue(InstanceSize node, String value) {
            if (value == null) {
                node.clearDescription();
            } else {
                node.setDescription(value);
            }
        }

        public final boolean hasValue(InstanceSize node) {
            return this.resolveFieldValue(node);
        }

        public final String getValue(InstanceSize node) {
            XString val = this.resolveFieldValue(node) ? this.getResolvedFieldValue(node) : null;
            return val == null ? null : val.getValue();
        }

        public final boolean appendValueTo(InstanceSize node, XString target) {
            if (this.resolveFieldValue(node)) {
                target.append(this.getResolvedFieldValue(node));
                return true;
            }
            return false;
        }
    };
    private static final HashMap<String, IRogFieldReflector<InstanceSize, ?>> _fieldReflectors = new HashMap(7);
    private static final boolean _conserveMemory;
    private static final boolean _freeBackingStorageOnClear;
    private static final MemoryStats _memstats;
    private static final InstanceSizePoolFactory _instanceSizeFactory;
    private static final InstanceSizePojoPoolFactory _instanceSizePojoFactory;
    private static final InstanceSizeSerializerPoolFactory _instanceSizeSerializerFactory;
    private static final InstanceSizeDeserializerPoolFactory _instanceSizeDeserializerFactory;
    static final UtlPool<InstanceSize> _entityPool;
    static final UtlPool<Pojo> _entityPojoPool;
    static final UtlPool<Serializer> _entitySerializerPool;
    static final UtlPool<Deserializer> _entityDeserializerPool;
    private final AtomicInteger _ownershipCount = new AtomicInteger(1);
    private UtlPool<InstanceSize> _pool;
    private long _serializedBuffer;
    private int _serializedBufferLength;
    private int _serializedBufferCapacity;
    private Serializer _serializer;
    private Deserializer _deserializer;
    private Pojo _pojo;
    private boolean readOnly;
    private boolean created = true;
    public static final InstanceSize[] EMPTY_ARRAY;

    InstanceSize() {
    }

    public static InstanceSize create() {
        InstanceSize entity = (InstanceSize)_entityPool.get(null);
        _memstats.onEntityAllocated(InstanceSize.class, MemoryStats.EntityType.EmbeddedEntity, !entity.created);
        return entity;
    }

    private final long serializedBuffer(int len) {
        long oldBuffer = this._serializedBuffer;
        int oldCapacity = this._serializedBufferCapacity;
        int newCapacity = Math.max(len, 3);
        this._serializedBuffer = IOBuffer.ensureMemoryBlockCapacity((long)this._serializedBuffer, (long)this._serializedBufferCapacity, (int)newCapacity, (boolean)false);
        if (newCapacity > oldCapacity) {
            if (oldBuffer != 0L) {
                _memstats.onEntityDataDisposed(InstanceSize.class, MemoryStats.EntityType.EmbeddedEntity, oldCapacity, true);
            }
            _memstats.onEntityDataAllocated(InstanceSize.class, MemoryStats.EntityType.EmbeddedEntity, newCapacity);
            this._serializedBufferCapacity = newCapacity;
        }
        return this._serializedBuffer;
    }

    public final boolean hasSerializedBuffer() {
        return this._serializedBuffer != 0L;
    }

    @JsonIgnore
    public final long getSerializedBuffer() {
        return this._serializedBuffer;
    }

    @JsonIgnore
    public final int getSerializedBufferCapacity() {
        return this._serializedBufferCapacity;
    }

    final void setSerializedBufferLength(int val) {
        this._serializedBufferLength = val;
    }

    @JsonIgnore
    public final int getSerializedBufferLength() {
        return this._serializedBufferLength;
    }

    public final Serializer serializer(int length, boolean autoResizeTargetBuffer) {
        if (this._serializer == null) {
            this._serializer = Serializer.create();
        }
        this.serializedBuffer(length);
        if (autoResizeTargetBuffer) {
            this._serializer.setSizer(this);
        }
        return this._serializer.init(this);
    }

    public final Serializer serializer(int minimumLength) {
        return this.serializer(minimumLength, true);
    }

    public final Serializer serializer() {
        return this.serializer(1024, true);
    }

    public final long ensureCapacity(long addr, int capacity) {
        if (capacity <= this._serializedBufferCapacity) {
            return addr;
        }
        int newLength = capacity <= this._serializedBufferCapacity ? capacity : Math.max(capacity, this._serializedBufferCapacity * 2);
        this._serializedBuffer = IOBuffer.ensureMemoryBlockCapacity((long)this._serializedBuffer, (long)this._serializedBufferCapacity, (int)newLength, (boolean)false);
        this._serializedBufferCapacity = newLength;
        return this._serializedBuffer;
    }

    public final Deserializer deserializer(boolean createBuffer) {
        if (!this.hasSerializedBuffer() && createBuffer) {
            this.serializedBuffer(0);
        }
        if (!this.hasSerializedBuffer()) {
            throw new IllegalStateException("no backing serialized buffer");
        }
        if (this._deserializer == null) {
            this._deserializer = Deserializer.create();
        }
        return this._deserializer.init(this._serializedBuffer, 0, this._serializedBufferLength);
    }

    public final Deserializer deserializer() {
        return this.deserializer(false);
    }

    public final boolean hasPojo() {
        return this._pojo != null && this._pojo.isInitialized();
    }

    public final boolean hasDirtyPojo() {
        return this.hasPojo() && this._pojo.isDirty();
    }

    public final Pojo pojo(boolean onlyPojos) {
        if (this._pojo == null) {
            this._pojo = Pojo.create();
        }
        if (onlyPojos) {
            this._pojo.setOnlyPojos();
        } else {
            this._pojo.clearOnlyPojos();
        }
        if (!this._pojo.isInitialized()) {
            if (this.hasSerializedBuffer()) {
                this._pojo.deserialize(this.deserializer());
                this._pojo.clearDirty();
            } else {
                this._pojo.setInitialized();
            }
            if (this.readOnly) {
                this._pojo.setAsReadOnly();
            }
        }
        if (onlyPojos) {
            this.conserveMemory(AdmRuntime.DataStoragePolicy.OnlyPojo);
        }
        return this._pojo;
    }

    public final Pojo pojo() {
        return this.pojo(false);
    }

    public final void disposeSerializedBuffer(boolean gcDisposed) {
        if (this.hasSerializedBuffer()) {
            IOBuffer.freeMemoryBlock((long)this._serializedBuffer, (int)this._serializedBufferCapacity);
            _memstats.onEntityDataDisposed(InstanceSize.class, MemoryStats.EntityType.EmbeddedEntity, this._serializedBufferCapacity, !gcDisposed);
            this._serializedBuffer = 0L;
            this._serializedBufferLength = 0;
            this._serializedBufferCapacity = 0;
        }
    }

    public final void disposeSerializedBuffer() {
        this.disposeSerializedBuffer(false);
    }

    public final void disposeSerializer() {
        if (this._serializer != null) {
            this._serializer.dispose();
            this._serializer = null;
        }
    }

    public final void disposeDeserializer() {
        if (this._deserializer != null) {
            this._deserializer.dispose();
            this._deserializer = null;
        }
    }

    public final void disposePojo(boolean sync) {
        if (sync) {
            this.sync();
        }
        if (this._pojo != null) {
            this._pojo.dispose();
            this._pojo = null;
        }
    }

    public final void disposePojo() {
        this.disposePojo(false);
    }

    private final void conserveMemory(AdmRuntime.DataStoragePolicy policy) {
        switch (policy) {
            case OnlySerialized: {
                this.sync();
                this.disposeSerializer();
                this.disposeDeserializer();
                this.disposePojo(false);
                break;
            }
            case OnlyPojo: {
                this.disposeSerializer();
                this.disposeDeserializer();
                if (this._pojo == null || !this._pojo.isInitialized()) {
                    this.pojo(false);
                }
                this.disposeSerializedBuffer();
                this._pojo.forceDirty();
                break;
            }
            case SerializedOrPojo: {
                this.disposeSerializer();
                this.disposeDeserializer();
                if (this._pojo == null || !this._pojo.isInitialized()) break;
                this.disposeSerializedBuffer();
                this._pojo.forceDirty();
                break;
            }
        }
    }

    public final void clear(boolean disposeMembers, boolean freeBackingStorage) {
        if (this._pojo != null) {
            if (disposeMembers) {
                this._pojo.clear(freeBackingStorage);
                this.disposePojo(false);
            } else {
                this._pojo.reset(freeBackingStorage);
            }
        }
        if (freeBackingStorage || disposeMembers) {
            this.disposeSerializedBuffer();
        } else {
            this._serializedBufferLength = 0;
        }
        this.readOnly = false;
    }

    public final void clear(boolean disposeMembers) {
        this.clear(disposeMembers, _freeBackingStorageOnClear);
    }

    public final void clear() {
        this.clear(_conserveMemory, _freeBackingStorageOnClear);
    }

    public final void reset(boolean disposeMembers, boolean freeBackingStorage) {
        this.clear(disposeMembers, freeBackingStorage);
        if (disposeMembers) {
            this.disposeSerializer();
            this.disposeDeserializer();
        }
    }

    public final void reset(boolean disposeMembers) {
        this.reset(disposeMembers, _conserveMemory);
    }

    public final void reset() {
        this.reset(_conserveMemory, _conserveMemory);
    }

    public final String serializeToRawJson() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            MessageFactory.mapper.writeValue((OutputStream)baos, (Object)this);
            return new String(baos.toByteArray(), "utf-8");
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
    }

    public final int serializeTo(Serializer serializer) {
        this.sync();
        if (this.hasSerializedBuffer()) {
            serializer.putFrom(this._serializedBuffer, 0, this._serializedBufferLength);
        }
        return this._serializedBufferLength;
    }

    public final void sync() {
        if (this.hasDirtyPojo()) {
            this._serializedBufferLength = this._pojo.serialize(this.serializer(this._pojo.getSerializedLength(), false));
            this._pojo.clearDirty();
        } else if (!this.hasSerializedBuffer()) {
            this.serializedBuffer(0);
        }
    }

    public final byte[] serializeToByteArray() {
        this.sync();
        byte[] array = new byte[this._serializedBufferLength];
        this.serializeTo(array, 0);
        return array;
    }

    public final int serializeTo(byte[] array, int offset) {
        this.sync();
        if (this._serializedBufferLength > array.length - offset) {
            throw new IllegalArgumentException("array too small");
        }
        if (this.hasSerializedBuffer()) {
            IOBuffer.getTo((long)this._serializedBuffer, (int)0, (byte[])array, (int)offset, (int)this._serializedBufferLength);
        }
        return this._serializedBufferLength;
    }

    public final ByteBuffer serializeToByteBuffer() {
        this.sync();
        ByteBuffer buffer = ByteBuffer.allocate(this._serializedBufferLength);
        this.serializeTo(buffer);
        return buffer;
    }

    public final int serializeTo(ByteBuffer buffer) {
        this.sync();
        if (this._serializedBufferLength > buffer.capacity() - buffer.position()) {
            throw new IllegalArgumentException("buffer too small");
        }
        buffer.limit(buffer.position() + this._serializedBufferLength);
        if (this.hasSerializedBuffer()) {
            IOBuffer.getTo((long)this._serializedBuffer, (int)0, (ByteBuffer)buffer, (int)this._serializedBufferLength);
        }
        return this._serializedBufferLength;
    }

    public final IOBuffer serializeToIOBuffer(boolean useNative) {
        this.sync();
        IOBuffer buffer = IOBuffer.create((int)this._serializedBufferLength);
        this.serializeTo(buffer, 0);
        return buffer;
    }

    public final int serializeTo(IOBuffer buffer, int offset) {
        this.sync();
        if (this._serializedBufferLength > buffer.getLength() - offset) {
            throw new IllegalArgumentException("buffer too small");
        }
        if (this.hasSerializedBuffer()) {
            IOBuffer.copy((long)this._serializedBuffer, (int)0, (long)buffer.getNativeAddress(), (int)offset, (int)this._serializedBufferLength);
        }
        return this._serializedBufferLength;
    }

    public final int serializeTo(IOElasticBuffer buffer, int offset) {
        this.sync();
        buffer.setLength(offset + this._serializedBufferLength);
        return this.serializeTo(buffer.getBackingBufferUnsafe(), buffer.getOffset() + offset);
    }

    public final PktPacket serializeToPacket() {
        PktPacket packet = PktFactory.getInstance().createPacket(257);
        this.serializeTo(packet);
        return packet;
    }

    public final int serializeTo(PktPacket packet) {
        this.sync();
        if (this.hasSerializedBuffer()) {
            packet.getBody().deserialize(this._serializedBuffer, 0, this._serializedBufferLength);
        }
        return this._serializedBufferLength;
    }

    public final int serializeTo(long addr, int offset) {
        this.sync();
        if (this.hasSerializedBuffer()) {
            IOBuffer.copy((long)this._serializedBuffer, (int)0, (long)addr, (int)offset, (int)this._serializedBufferLength);
        }
        return this._serializedBufferLength;
    }

    public final String serializeToJson() {
        return this.serializeToRawJson();
    }

    public final InstanceSize deserializeFromRawJson(String json) {
        try {
            MessageFactory.mapper.reader().withValueToUpdate((Object)this).readValue(json);
            return this;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public final InstanceSize deserializeFrom(Deserializer deserializer) {
        if (!deserializer.isInitialized()) {
            throw new IllegalArgumentException("can only deserialize from an initialized deserializer");
        }
        if (this._pojo != null) {
            this._pojo.reset();
        }
        this._serializedBufferLength = 0;
        if (deserializer != null) {
            this._serializedBufferLength = deserializer.getSerializedLength();
            deserializer.getTo(this.serializedBuffer(this._serializedBufferLength), 0);
        }
        return this;
    }

    public final InstanceSize deserializeFrom(InstanceSize val) {
        return this.deserializeFrom(val.getSerializedBuffer(), 0, val.getSerializedBufferLength());
    }

    public final InstanceSize wrap(IOBuffer buffer, int len) {
        if (this._pojo != null) {
            this._pojo.reset();
        }
        this.disposeSerializedBuffer();
        this._serializedBuffer = buffer.getNativeAddress();
        this._serializedBufferLength = len;
        return this;
    }

    public final InstanceSize deserializeFromByteArray(byte[] array) {
        return this.deserializeFrom(array, 0, array.length);
    }

    public final InstanceSize deserializeFrom(byte[] array, int offset, int len) {
        if (this._pojo != null) {
            this._pojo.reset();
        }
        int n = this._serializedBufferLength = array != null ? len : 0;
        if (array != null) {
            IOBuffer.putFrom((long)this.serializedBuffer(len), (int)0, (byte[])array, (int)offset, (int)len);
        }
        return this;
    }

    public final InstanceSize deserializeFromByteBuffer(ByteBuffer buffer) {
        return this.deserializeFrom(buffer);
    }

    public final InstanceSize deserializeFrom(ByteBuffer buffer) {
        if (this._pojo != null) {
            this._pojo.reset();
        }
        int n = this._serializedBufferLength = buffer != null ? buffer.remaining() : 0;
        if (buffer != null) {
            IOBuffer.putFrom((long)this.serializedBuffer(this._serializedBufferLength), (int)0, (ByteBuffer)buffer, (int)buffer.position(), (int)this._serializedBufferLength);
        }
        return this;
    }

    public final InstanceSize deserializeFrom(IOBuffer buffer, int offset, int len) {
        if (this._pojo != null) {
            this._pojo.reset();
        }
        int n = this._serializedBufferLength = buffer != null ? len : 0;
        if (buffer != null) {
            IOBuffer.copy((long)buffer.getNativeAddress(), (int)offset, (long)this.serializedBuffer(len), (int)0, (int)len);
        }
        return this;
    }

    public final InstanceSize deserializeFrom(IOElasticBuffer buffer, int offset, int len) {
        return this.deserializeFrom(buffer.getBackingBufferUnsafe(), buffer.getOffset() + offset, len);
    }

    public final InstanceSize deserializeFromPacket(PktPacket packet) {
        return this.deserializeFrom(packet);
    }

    public final InstanceSize deserializeFrom(PktPacket packet) {
        try {
            IOElasticBuffer buffer = packet.getBody().getBuffer();
            InstanceSize instanceSize = this.deserializeFrom(buffer, 0, buffer.getLength());
            return instanceSize;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            packet.dispose();
        }
    }

    public final InstanceSize deserializeFrom(long addr, int offset, int len) {
        if (this._pojo != null) {
            this._pojo.reset();
        }
        this._serializedBufferLength = len;
        IOBuffer.copy((long)addr, (int)offset, (long)this.serializedBuffer(len), (int)0, (int)len);
        return this;
    }

    public final InstanceSize deserializeFromJson(String json) {
        this.deserializeFromRawJson(json);
        return this;
    }

    public final void copyInto(InstanceSize copy) {
        copy.clear();
        this.sync();
        if (this.hasSerializedBuffer()) {
            copy.deserializeFrom(this._serializedBuffer, 0, this._serializedBufferLength);
        }
    }

    public final InstanceSize copy() {
        InstanceSize copy = InstanceSize.create();
        this.copyInto(copy);
        return copy;
    }

    public boolean needsSync() {
        return false;
    }

    public final boolean fieldExists(Object message, String name) {
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        return _fieldReflectors.containsKey(name) || UtlReflection.hasPath((Object)message, (String)name);
    }

    public final boolean isFieldReflectable(Object message, String name) {
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        if (_fieldReflectors.containsKey(name)) {
            return true;
        }
        Class c = UtlReflection.getUnwrappedReturnType(message.getClass(), (String)name);
        if (c == null || c.isArray()) {
            return false;
        }
        if (c.isEnum() || c.isPrimitive()) {
            return true;
        }
        return c == Date.class || c == Currency.class || c == String.class || XString.class.isAssignableFrom(c);
    }

    public final String getFieldValueAsString(Object message, String name) {
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        return this.getFieldValueAsString(message, name.split("\\."));
    }

    public final String getFieldValueAsString(Object message, String[] pathComponents) {
        if (pathComponents == null || pathComponents.length == 0) {
            throw new IllegalArgumentException("pathComponents cannot be null or 0 length");
        }
        if (pathComponents.length != 1) {
            Object object = UtlReflection.getProperty((Object)this, (int)0, (String[])pathComponents);
            return object == null ? null : String.valueOf(object);
        }
        IRogFieldReflector<InstanceSize, ?> reflector = _fieldReflectors.get(pathComponents[0]);
        if (reflector != null) {
            Object val = reflector.getValue((Object)this);
            if (val != null) {
                return val.toString();
            }
            return null;
        }
        return null;
    }

    public final XString getFieldValueAsRawString(Object message, String name) {
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        return this.getFieldValueAsRawString(message, name.split("\\."));
    }

    public final XString getFieldValueAsRawString(Object message, String[] pathComponents) {
        if (pathComponents == null || pathComponents.length == 0) {
            throw new IllegalArgumentException("pathComponents cannot be null or 0 length");
        }
        if (pathComponents.length != 1) {
            Object object = UtlReflection.getProperty((Object)this, (int)0, (String[])pathComponents);
            return object == null ? null : XString.create((String)object.toString());
        }
        IRogFieldReflector<InstanceSize, ?> reflector = _fieldReflectors.get(pathComponents[0]);
        if (reflector != null) {
            Object val = reflector.getValue((Object)this);
            if (val != null) {
                return XString.create((String)val.toString());
            }
            return null;
        }
        return null;
    }

    public final boolean appendFieldValueTo(Object message, String name, XString target) {
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        return this.appendFieldValueTo(message, name.split("\\."), target);
    }

    public final boolean appendFieldValueTo(Object node, String[] pathComponents, XString target) {
        if (pathComponents == null || pathComponents.length == 0) {
            throw new IllegalArgumentException("pathComponents cannot be null or 0 length");
        }
        if (pathComponents.length != 1) {
            Object object = UtlReflection.getProperty((Object)this, (int)0, (String[])pathComponents);
            if (object == null) {
                return false;
            }
            target.append((CharSequence)object.toString());
            return true;
        }
        IRogFieldReflector<InstanceSize, ?> reflector = _fieldReflectors.get(pathComponents[0]);
        if (reflector != null) {
            return reflector.appendValueTo((Object)this, target);
        }
        return false;
    }

    public final void setAsReadOnly() {
        this.readOnly = true;
        if (this._pojo != null) {
            this._pojo.setAsReadOnly();
        }
    }

    public static final int getCpuCoresFieldId() {
        return 3;
    }

    @Override
    @JsonProperty(value="cpu_cores")
    public final void setCpuCores(int val) {
        this.pojo().setCpuCores(val);
    }

    @Override
    @JsonIgnore
    public final int getCpuCores() {
        return this.pojo().getCpuCores();
    }

    @Override
    @JsonProperty(value="cpu_cores")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public final Integer getCpuCoresAsObject() {
        if (!this.hasCpuCores()) {
            return null;
        }
        return this.getCpuCores();
    }

    @Override
    public final boolean hasCpuCores() {
        return this.pojo().hasCpuCores();
    }

    @Override
    public final void clearCpuCores() {
        this.pojo().clearCpuCores();
    }

    public static final int getRamInMbFieldId() {
        return 4;
    }

    @Override
    @JsonProperty(value="ram_mb")
    public final void setRamInMb(int val) {
        this.pojo().setRamInMb(val);
    }

    @Override
    @JsonIgnore
    public final int getRamInMb() {
        return this.pojo().getRamInMb();
    }

    @Override
    @JsonProperty(value="ram_mb")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public final Integer getRamInMbAsObject() {
        if (!this.hasRamInMb()) {
            return null;
        }
        return this.getRamInMb();
    }

    @Override
    public final boolean hasRamInMb() {
        return this.pojo().hasRamInMb();
    }

    @Override
    public final void clearRamInMb() {
        this.pojo().clearRamInMb();
    }

    public static final int getDiskInGbFieldId() {
        return 5;
    }

    @Override
    @JsonProperty(value="disk_gb")
    public final void setDiskInGb(int val) {
        this.pojo().setDiskInGb(val);
    }

    @Override
    @JsonIgnore
    public final int getDiskInGb() {
        return this.pojo().getDiskInGb();
    }

    @Override
    @JsonProperty(value="disk_gb")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public final Integer getDiskInGbAsObject() {
        if (!this.hasDiskInGb()) {
            return null;
        }
        return this.getDiskInGb();
    }

    @Override
    public final boolean hasDiskInGb() {
        return this.pojo().hasDiskInGb();
    }

    @Override
    public final void clearDiskInGb() {
        this.pojo().clearDiskInGb();
    }

    public static final int getSelectableFieldId() {
        return 7;
    }

    @Override
    @JsonProperty(value="selectable")
    public final void setSelectable(boolean val) {
        this.pojo().setSelectable(val);
    }

    @Override
    @JsonIgnore
    public final boolean getSelectable() {
        return this.pojo().getSelectable();
    }

    @Override
    @JsonProperty(value="selectable")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public final Boolean getSelectableAsObject() {
        if (!this.hasSelectable()) {
            return null;
        }
        return this.getSelectable();
    }

    @Override
    public final boolean hasSelectable() {
        return this.pojo().hasSelectable();
    }

    @Override
    public final void clearSelectable() {
        this.pojo().clearSelectable();
    }

    public static final int getNameFieldId() {
        return 1;
    }

    @Override
    @JsonProperty(value="name")
    public final void setName(String val) {
        this.pojo().setNameFrom(val);
    }

    @Override
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public final String getName() {
        if (!this.hasName()) {
            return null;
        }
        return this.pojo()._usrName.getAsString();
    }

    @Override
    @JsonIgnore
    public final void lendName(XString val) {
        if (val == null || !val.hasValue() || val.isNull()) {
            this.setName(null);
            return;
        }
        if (!val.isImmutable()) {
            throw new IllegalArgumentException("value is mutable");
        }
        this.pojo().setNameFrom(val);
    }

    @Override
    @JsonIgnore
    public final void setNameFrom(long val) {
        this.pojo().setNameFrom(val);
    }

    @Override
    @JsonIgnore
    public final <T extends XString> T getNameTo(IXStringFactory<T> factory) {
        XString to = factory.create(false);
        this.pojo().getNameTo(to);
        return (T)to;
    }

    @Override
    @JsonIgnore
    public final void setNameFrom(XString val) {
        this.pojo().setNameFrom(val);
    }

    @Override
    @JsonIgnore
    public final void getNameTo(XString val) {
        this.pojo().getNameTo(val);
    }

    @Override
    @JsonIgnore
    public final XString getNameUnsafe() {
        return this.pojo().getName();
    }

    @Override
    public final boolean hasName() {
        return this.pojo().hasName();
    }

    @Override
    public final void clearName() {
        this.pojo().clearName();
    }

    public static final int getNiceNameFieldId() {
        return 2;
    }

    @Override
    @JsonProperty(value="nice_name")
    public final void setNiceName(String val) {
        this.pojo().setNiceNameFrom(val);
    }

    @Override
    @JsonProperty(value="nice_name")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public final String getNiceName() {
        if (!this.hasNiceName()) {
            return null;
        }
        return this.pojo()._usrNiceName.getAsString();
    }

    @Override
    @JsonIgnore
    public final void lendNiceName(XString val) {
        if (val == null || !val.hasValue() || val.isNull()) {
            this.setNiceName(null);
            return;
        }
        if (!val.isImmutable()) {
            throw new IllegalArgumentException("value is mutable");
        }
        this.pojo().setNiceNameFrom(val);
    }

    @Override
    @JsonIgnore
    public final void setNiceNameFrom(long val) {
        this.pojo().setNiceNameFrom(val);
    }

    @Override
    @JsonIgnore
    public final <T extends XString> T getNiceNameTo(IXStringFactory<T> factory) {
        XString to = factory.create(false);
        this.pojo().getNiceNameTo(to);
        return (T)to;
    }

    @Override
    @JsonIgnore
    public final void setNiceNameFrom(XString val) {
        this.pojo().setNiceNameFrom(val);
    }

    @Override
    @JsonIgnore
    public final void getNiceNameTo(XString val) {
        this.pojo().getNiceNameTo(val);
    }

    @Override
    @JsonIgnore
    public final XString getNiceNameUnsafe() {
        return this.pojo().getNiceName();
    }

    @Override
    public final boolean hasNiceName() {
        return this.pojo().hasNiceName();
    }

    @Override
    public final void clearNiceName() {
        this.pojo().clearNiceName();
    }

    public static final int getDescriptionFieldId() {
        return 6;
    }

    @Override
    @JsonProperty(value="description")
    public final void setDescription(String val) {
        this.pojo().setDescriptionFrom(val);
    }

    @Override
    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public final String getDescription() {
        if (!this.hasDescription()) {
            return null;
        }
        return this.pojo()._usrDescription.getAsString();
    }

    @Override
    @JsonIgnore
    public final void lendDescription(XString val) {
        if (val == null || !val.hasValue() || val.isNull()) {
            this.setDescription(null);
            return;
        }
        if (!val.isImmutable()) {
            throw new IllegalArgumentException("value is mutable");
        }
        this.pojo().setDescriptionFrom(val);
    }

    @Override
    @JsonIgnore
    public final void setDescriptionFrom(long val) {
        this.pojo().setDescriptionFrom(val);
    }

    @Override
    @JsonIgnore
    public final <T extends XString> T getDescriptionTo(IXStringFactory<T> factory) {
        XString to = factory.create(false);
        this.pojo().getDescriptionTo(to);
        return (T)to;
    }

    @Override
    @JsonIgnore
    public final void setDescriptionFrom(XString val) {
        this.pojo().setDescriptionFrom(val);
    }

    @Override
    @JsonIgnore
    public final void getDescriptionTo(XString val) {
        this.pojo().getDescriptionTo(val);
    }

    @Override
    @JsonIgnore
    public final XString getDescriptionUnsafe() {
        return this.pojo().getDescription();
    }

    @Override
    public final boolean hasDescription() {
        return this.pojo().hasDescription();
    }

    @Override
    public final void clearDescription() {
        this.pojo().clearDescription();
    }

    public static final <T> IRogFieldReflector<InstanceSize, T> getFieldReflector(String name) {
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        return InstanceSize.getFieldReflector(name.split("\\."));
    }

    public static final <T> IRogFieldReflector<InstanceSize, T> getFieldReflector(String[] pathComponents) {
        if (pathComponents == null || pathComponents.length == 0) {
            throw new IllegalArgumentException("pathComponents cannot be null or 0 length");
        }
        if (pathComponents.length != 1) {
            throw new IllegalArgumentException("fetching of reflectable field accessors for nested fields is currently not supported");
        }
        return _fieldReflectors.get(pathComponents[0]);
    }

    public final Object getQueryFieldValue(String name) {
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        IRogFieldReflector<InstanceSize, ?> reflector = _fieldReflectors.get(name);
        if (reflector != null) {
            return reflector.getValue((Object)this);
        }
        return null;
    }

    public final InstanceSize init() {
        this.reset();
        this._ownershipCount.set(1);
        return this;
    }

    public final InstanceSize setPool(UtlPool<InstanceSize> pool) {
        this._pool = pool;
        return this;
    }

    public final UtlPool<InstanceSize> getPool() {
        return this._pool;
    }

    public final InstanceSize acquire() {
        int val = this._ownershipCount.incrementAndGet();
        if (val <= 1 && this._pool != null) {
            throw new IllegalStateException("attempt to acquire an already disposed entity");
        }
        return this;
    }

    public final int getOwnershipCount() {
        return this._ownershipCount.get();
    }

    public final void dispose(boolean freeBackingStorage) {
        int val = this._ownershipCount.decrementAndGet();
        if (val < 0 && this._pool != null) {
            throw new IllegalStateException("attempt to dispose an already disposed entity");
        }
        if (val == 0 && this._pool != null) {
            this.created = false;
            if (freeBackingStorage) {
                this.clear(true);
            }
            this._pool.put((UtlPool.Item)this);
            _memstats.onEntityDisposed(InstanceSize.class, MemoryStats.EntityType.EmbeddedEntity, true);
        }
    }

    public final void dispose() {
        this.dispose(false);
    }

    public final Object clone() {
        InstanceSize clonee = InstanceSize.create();
        if (this.hasCpuCores()) {
            clonee.setCpuCores(this.getCpuCores());
        }
        if (this.hasRamInMb()) {
            clonee.setRamInMb(this.getRamInMb());
        }
        if (this.hasDiskInGb()) {
            clonee.setDiskInGb(this.getDiskInGb());
        }
        if (this.hasSelectable()) {
            clonee.setSelectable(this.getSelectable());
        }
        if (this.hasName()) {
            clonee.setName(this.getName());
        }
        if (this.hasNiceName()) {
            clonee.setNiceName(this.getNiceName());
        }
        if (this.hasDescription()) {
            clonee.setDescription(this.getDescription());
        }
        return clonee;
    }

    public final boolean isValid() {
        return true;
    }

    public final void getValidationErrors(List<XString> results, String errorPrefix) {
    }

    public final String toString() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd-HH:mm:ss.SSS");
        dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        StringBuilder builder = new StringBuilder();
        builder.append("{");
        int c = 0;
        if (this.hasCpuCores()) {
            builder.append(0 == c++ ? "" : ",").append("CpuCores=").append(this.getCpuCores());
        }
        if (this.hasRamInMb()) {
            builder.append(0 == c++ ? "" : ",").append("RamInMb=").append(this.getRamInMb());
        }
        if (this.hasDiskInGb()) {
            builder.append(0 == c++ ? "" : ",").append("DiskInGb=").append(this.getDiskInGb());
        }
        if (this.hasSelectable()) {
            builder.append(0 == c++ ? "" : ",").append("Selectable=").append(this.getSelectable());
        }
        if (this.hasName()) {
            builder.append(0 == c++ ? "" : ",").append("Name=").append(this.getName());
        }
        if (this.hasNiceName()) {
            builder.append(0 == c++ ? "" : ",").append("NiceName=").append(this.getNiceName());
        }
        if (this.hasDescription()) {
            builder.append(0 == c++ ? "" : ",").append("Description=").append(this.getDescription());
        }
        builder.append("}");
        return builder.toString();
    }

    static {
        _fieldReflectors.put("CpuCores", (IRogFieldReflector<InstanceSize, ?>)_cpuCoresReflector);
        _fieldReflectors.put("cpuCores", (IRogFieldReflector<InstanceSize, ?>)_cpuCoresReflector);
        _fieldReflectors.put("RamInMb", (IRogFieldReflector<InstanceSize, ?>)_ramInMbReflector);
        _fieldReflectors.put("ramInMb", (IRogFieldReflector<InstanceSize, ?>)_ramInMbReflector);
        _fieldReflectors.put("DiskInGb", (IRogFieldReflector<InstanceSize, ?>)_diskInGbReflector);
        _fieldReflectors.put("diskInGb", (IRogFieldReflector<InstanceSize, ?>)_diskInGbReflector);
        _fieldReflectors.put("Selectable", (IRogFieldReflector<InstanceSize, ?>)_selectableReflector);
        _fieldReflectors.put("selectable", (IRogFieldReflector<InstanceSize, ?>)_selectableReflector);
        _fieldReflectors.put("Name", (IRogFieldReflector<InstanceSize, ?>)_nameReflector);
        _fieldReflectors.put("name", (IRogFieldReflector<InstanceSize, ?>)_nameReflector);
        _fieldReflectors.put("NiceName", (IRogFieldReflector<InstanceSize, ?>)_niceNameReflector);
        _fieldReflectors.put("niceName", (IRogFieldReflector<InstanceSize, ?>)_niceNameReflector);
        _fieldReflectors.put("Description", (IRogFieldReflector<InstanceSize, ?>)_descriptionReflector);
        _fieldReflectors.put("description", (IRogFieldReflector<InstanceSize, ?>)_descriptionReflector);
        _conserveMemory = Config.conserveMemory();
        _freeBackingStorageOnClear = Config.getValue((String)("nv.tuning.memory." + InstanceSize.class.getName() + ".freeBackingStorageOnClear"), (boolean)Config.getValue((String)"nv.tuning.memory.freeBackingStorageOnClear", (boolean)_conserveMemory));
        _memstats = MemoryStats.getInstance();
        _instanceSizeFactory = new InstanceSizePoolFactory();
        _instanceSizePojoFactory = new InstanceSizePojoPoolFactory();
        _instanceSizeSerializerFactory = new InstanceSizeSerializerPoolFactory();
        _instanceSizeDeserializerFactory = new InstanceSizeDeserializerPoolFactory();
        _entityPool = UtlPool.create((String)"quark.entity", (String)"InstanceSizeQuarkEntity.1.1004", (UtlPool.Factory)_instanceSizeFactory, (UtlPool.Params)AdmRuntime.configurePoolParams(InstanceSize.class, (UtlPool.Params)UtlPool.Params.create().setThreaded(true))).setEvictedItemReceiver((UtlPool.EvictedItemReceiver)new InstanceSizePoolEvictedItemReceiver());
        _entityPojoPool = UtlPool.create((String)"quark.entity.pojo", (String)"InstanceSizeQuarkEntityPojo.1.1004", (UtlPool.Factory)_instanceSizePojoFactory, (UtlPool.Params)AdmRuntime.configurePoolParams(Pojo.class, (UtlPool.Params)UtlPool.Params.create().setThreaded(true))).setEvictedItemReceiver((UtlPool.EvictedItemReceiver)new InstanceSizePojoPoolEvictedItemReceiver());
        _entitySerializerPool = UtlPool.create((String)"quark.entity.serializer", (String)"InstanceSizeQuarkEntitySerializer.1.1004", (UtlPool.Factory)_instanceSizeSerializerFactory, (UtlPool.Params)AdmRuntime.configurePoolParams(Serializer.class, (UtlPool.Params)UtlPool.Params.create().setThreaded(true))).setEvictedItemReceiver((UtlPool.EvictedItemReceiver)new InstanceSizeSerializerPoolEvictedItemReceiver());
        _entityDeserializerPool = UtlPool.create((String)"quark.entity.deserializer", (String)"InstanceSizeQuarkEntityDeserializer.1.1004", (UtlPool.Factory)_instanceSizeDeserializerFactory, (UtlPool.Params)AdmRuntime.configurePoolParams(Deserializer.class, (UtlPool.Params)UtlPool.Params.create().setThreaded(true))).setEvictedItemReceiver((UtlPool.EvictedItemReceiver)new InstanceSizeDeserializerPoolEvictedItemReceiver());
        EMPTY_ARRAY = new InstanceSize[0];
    }

    private static final class DescriptionDeserializer
    extends Deserializer.AbstractCallbackImpl {
        private static final byte FLG_WASRUN = 1;
        private static final byte FLG_WASSET = 2;
        private final XString _value = XString.create();
        private Deserializer _deserializer;
        private byte _flags;

        private DescriptionDeserializer() {
        }

        private final void setWasRun() {
            this._flags = (byte)(this._flags | 1);
        }

        private final void setWasSet() {
            this._flags = (byte)(this._flags | 2);
        }

        final void run(Deserializer deserializer) {
            this._flags = 0;
            this._deserializer = deserializer;
            this._deserializer.run(this);
            this.setWasRun();
        }

        final boolean wasRun() {
            return (this._flags & 1) != 0;
        }

        final boolean wasSet() {
            return (this._flags & 2) != 0;
        }

        @Override
        public final void handleDescription(XStringDeserializer val) {
            val.getTo(this._value);
            this.setWasSet();
            this._deserializer.stop();
        }
    }

    private static final class NiceNameDeserializer
    extends Deserializer.AbstractCallbackImpl {
        private static final byte FLG_WASRUN = 1;
        private static final byte FLG_WASSET = 2;
        private final XString _value = XString.create();
        private Deserializer _deserializer;
        private byte _flags;

        private NiceNameDeserializer() {
        }

        private final void setWasRun() {
            this._flags = (byte)(this._flags | 1);
        }

        private final void setWasSet() {
            this._flags = (byte)(this._flags | 2);
        }

        final void run(Deserializer deserializer) {
            this._flags = 0;
            this._deserializer = deserializer;
            this._deserializer.run(this);
            this.setWasRun();
        }

        final boolean wasRun() {
            return (this._flags & 1) != 0;
        }

        final boolean wasSet() {
            return (this._flags & 2) != 0;
        }

        @Override
        public final void handleNiceName(XStringDeserializer val) {
            val.getTo(this._value);
            this.setWasSet();
            this._deserializer.stop();
        }
    }

    private static final class NameDeserializer
    extends Deserializer.AbstractCallbackImpl {
        private static final byte FLG_WASRUN = 1;
        private static final byte FLG_WASSET = 2;
        private final XString _value = XString.create();
        private Deserializer _deserializer;
        private byte _flags;

        private NameDeserializer() {
        }

        private final void setWasRun() {
            this._flags = (byte)(this._flags | 1);
        }

        private final void setWasSet() {
            this._flags = (byte)(this._flags | 2);
        }

        final void run(Deserializer deserializer) {
            this._flags = 0;
            this._deserializer = deserializer;
            this._deserializer.run(this);
            this.setWasRun();
        }

        final boolean wasRun() {
            return (this._flags & 1) != 0;
        }

        final boolean wasSet() {
            return (this._flags & 2) != 0;
        }

        @Override
        public final void handleName(XStringDeserializer val) {
            val.getTo(this._value);
            this.setWasSet();
            this._deserializer.stop();
        }
    }

    private static final class SelectableDeserializer
    extends Deserializer.AbstractCallbackImpl {
        private static final byte FLG_WASRUN = 1;
        private static final byte FLG_WASSET = 2;
        private boolean _value;
        private Deserializer _deserializer;
        private byte _flags;

        private SelectableDeserializer() {
        }

        private final void setWasRun() {
            this._flags = (byte)(this._flags | 1);
        }

        private final void setWasSet() {
            this._flags = (byte)(this._flags | 2);
        }

        final void run(Deserializer deserializer) {
            this._flags = 0;
            this._deserializer = deserializer;
            this._deserializer.run(this);
            this.setWasRun();
        }

        final boolean wasRun() {
            return (this._flags & 1) != 0;
        }

        final boolean wasSet() {
            return (this._flags & 2) != 0;
        }

        @Override
        public final void handleSelectable(boolean val) {
            this._value = val;
            this.setWasSet();
            this._deserializer.stop();
        }
    }

    private static final class DiskInGbDeserializer
    extends Deserializer.AbstractCallbackImpl {
        private static final byte FLG_WASRUN = 1;
        private static final byte FLG_WASSET = 2;
        private int _value;
        private Deserializer _deserializer;
        private byte _flags;

        private DiskInGbDeserializer() {
        }

        private final void setWasRun() {
            this._flags = (byte)(this._flags | 1);
        }

        private final void setWasSet() {
            this._flags = (byte)(this._flags | 2);
        }

        final void run(Deserializer deserializer) {
            this._flags = 0;
            this._deserializer = deserializer;
            this._deserializer.run(this);
            this.setWasRun();
        }

        final boolean wasRun() {
            return (this._flags & 1) != 0;
        }

        final boolean wasSet() {
            return (this._flags & 2) != 0;
        }

        @Override
        public final void handleDiskInGb(int val) {
            this._value = val;
            this.setWasSet();
            this._deserializer.stop();
        }
    }

    private static final class RamInMbDeserializer
    extends Deserializer.AbstractCallbackImpl {
        private static final byte FLG_WASRUN = 1;
        private static final byte FLG_WASSET = 2;
        private int _value;
        private Deserializer _deserializer;
        private byte _flags;

        private RamInMbDeserializer() {
        }

        private final void setWasRun() {
            this._flags = (byte)(this._flags | 1);
        }

        private final void setWasSet() {
            this._flags = (byte)(this._flags | 2);
        }

        final void run(Deserializer deserializer) {
            this._flags = 0;
            this._deserializer = deserializer;
            this._deserializer.run(this);
            this.setWasRun();
        }

        final boolean wasRun() {
            return (this._flags & 1) != 0;
        }

        final boolean wasSet() {
            return (this._flags & 2) != 0;
        }

        @Override
        public final void handleRamInMb(int val) {
            this._value = val;
            this.setWasSet();
            this._deserializer.stop();
        }
    }

    private static final class CpuCoresDeserializer
    extends Deserializer.AbstractCallbackImpl {
        private static final byte FLG_WASRUN = 1;
        private static final byte FLG_WASSET = 2;
        private int _value;
        private Deserializer _deserializer;
        private byte _flags;

        private CpuCoresDeserializer() {
        }

        private final void setWasRun() {
            this._flags = (byte)(this._flags | 1);
        }

        private final void setWasSet() {
            this._flags = (byte)(this._flags | 2);
        }

        final void run(Deserializer deserializer) {
            this._flags = 0;
            this._deserializer = deserializer;
            this._deserializer.run(this);
            this.setWasRun();
        }

        final boolean wasRun() {
            return (this._flags & 1) != 0;
        }

        final boolean wasSet() {
            return (this._flags & 2) != 0;
        }

        @Override
        public final void handleCpuCores(int val) {
            this._value = val;
            this.setWasSet();
            this._deserializer.stop();
        }
    }

    public static final class Pojo
    implements UtlPool.Item<Pojo> {
        private static final byte FLG_CREATED = 1;
        private static final byte FLG_POOLED = 2;
        private static final byte FLG_PRIVATE = 4;
        private static final byte FLG_ONLY_POJOS = 8;
        private static final MemoryStats _memstats = MemoryStats.getInstance();
        private final long[] _fieldBitmask = new long[1];
        private final DeserializationCallback _deserializationCallback = new DeserializationCallback();
        private UtlPool<Pojo> _pool;
        private int _serializedLength;
        private boolean _initialized;
        private boolean _readonly;
        private boolean _dirty;
        private byte _flags;
        private int _usrCpuCores;
        private int _usrRamInMb;
        private int _usrDiskInGb;
        private boolean _usrSelectable;
        private XString _usrName = XString.create();
        private XString _usrNiceName = XString.create();
        private XString _usrDescription = XString.create();

        Pojo() {
            this.setCreated();
        }

        public static final Pojo create(boolean pvt) {
            Pojo pojo = (Pojo)_entityPojoPool.get(null);
            if (pvt) {
                pojo.setPrivate();
            } else {
                pojo.clearPrivate();
                _memstats.onEntityPojoAllocated(InstanceSize.class, MemoryStats.EntityType.EmbeddedEntity, !pojo.isCreated());
            }
            return pojo.clearPooled();
        }

        public static final Pojo create() {
            return Pojo.create(false);
        }

        public final boolean hasCpuCores() {
            return (this._fieldBitmask[0] & 1L) != 0L;
        }

        public final int getCpuCores() {
            return this._usrCpuCores;
        }

        public final void setCpuCores(int val) {
            if (this._readonly) {
                throw new IllegalStateException("node is read only");
            }
            if (!this.hasCpuCores()) {
                this._serializedLength += 6;
            }
            this._fieldBitmask[0] = this._fieldBitmask[0] | 1L;
            this._usrCpuCores = val;
            this._dirty = true;
        }

        public final void clearCpuCores() {
            if (this._readonly) {
                throw new IllegalStateException("node is read only");
            }
            if (!this.hasCpuCores()) {
                return;
            }
            this._usrCpuCores = 0;
            this._fieldBitmask[0] = this._fieldBitmask[0] & 0xFFFFFFFFFFFFFFFEL;
            this._dirty = true;
            this._serializedLength -= 6;
        }

        public final boolean hasRamInMb() {
            return (this._fieldBitmask[0] & 2L) != 0L;
        }

        public final int getRamInMb() {
            return this._usrRamInMb;
        }

        public final void setRamInMb(int val) {
            if (this._readonly) {
                throw new IllegalStateException("node is read only");
            }
            if (!this.hasRamInMb()) {
                this._serializedLength += 6;
            }
            this._fieldBitmask[0] = this._fieldBitmask[0] | 2L;
            this._usrRamInMb = val;
            this._dirty = true;
        }

        public final void clearRamInMb() {
            if (this._readonly) {
                throw new IllegalStateException("node is read only");
            }
            if (!this.hasRamInMb()) {
                return;
            }
            this._usrRamInMb = 0;
            this._fieldBitmask[0] = this._fieldBitmask[0] & 0xFFFFFFFFFFFFFFFDL;
            this._dirty = true;
            this._serializedLength -= 6;
        }

        public final boolean hasDiskInGb() {
            return (this._fieldBitmask[0] & 4L) != 0L;
        }

        public final int getDiskInGb() {
            return this._usrDiskInGb;
        }

        public final void setDiskInGb(int val) {
            if (this._readonly) {
                throw new IllegalStateException("node is read only");
            }
            if (!this.hasDiskInGb()) {
                this._serializedLength += 6;
            }
            this._fieldBitmask[0] = this._fieldBitmask[0] | 4L;
            this._usrDiskInGb = val;
            this._dirty = true;
        }

        public final void clearDiskInGb() {
            if (this._readonly) {
                throw new IllegalStateException("node is read only");
            }
            if (!this.hasDiskInGb()) {
                return;
            }
            this._usrDiskInGb = 0;
            this._fieldBitmask[0] = this._fieldBitmask[0] & 0xFFFFFFFFFFFFFFFBL;
            this._dirty = true;
            this._serializedLength -= 6;
        }

        public final boolean hasSelectable() {
            return (this._fieldBitmask[0] & 8L) != 0L;
        }

        public final boolean getSelectable() {
            return this._usrSelectable;
        }

        public final void setSelectable(boolean val) {
            if (this._readonly) {
                throw new IllegalStateException("node is read only");
            }
            if (!this.hasSelectable()) {
                this._serializedLength += 3;
            }
            this._fieldBitmask[0] = this._fieldBitmask[0] | 8L;
            this._usrSelectable = val;
            this._dirty = true;
        }

        public final void clearSelectable() {
            if (this._readonly) {
                throw new IllegalStateException("node is read only");
            }
            if (!this.hasSelectable()) {
                return;
            }
            this._usrSelectable = false;
            this._fieldBitmask[0] = this._fieldBitmask[0] & 0xFFFFFFFFFFFFFFF7L;
            this._dirty = true;
            this._serializedLength -= 3;
        }

        public final boolean hasName() {
            return (this._fieldBitmask[0] & 0x10L) != 0L;
        }

        public final XString getName() {
            if (!this.hasName() || this._usrName.isNull()) {
                return null;
            }
            return this._usrName;
        }

        public final void getNameTo(XString val) {
            if (!this.hasName() || this._usrName.isNull()) {
                val.clear();
                return;
            }
            this._usrName.getTo(val);
        }

        public final void setNameFrom(String val) {
            if (this._readonly) {
                throw new IllegalStateException("node is read only");
            }
            if (val == null) {
                this.clearName();
                return;
            }
            int nbytes1 = this._usrName.serializedLength();
            this._usrName.setFrom(val);
            int nbytes2 = this._usrName.serializedLength();
            if (this.hasName()) {
                this._serializedLength += nbytes2 - nbytes1;
            } else {
                this._serializedLength += nbytes2 + 6;
                this._fieldBitmask[0] = this._fieldBitmask[0] | 0x10L;
            }
            this._dirty = true;
        }

        public final void setNameFrom(CharSequence val) {
            if (this._readonly) {
                throw new IllegalStateException("node is read only");
            }
            if (val == null) {
                this.clearName();
                return;
            }
            int nbytes1 = this._usrName.serializedLength();
            this._usrName.setFrom(val);
            int nbytes2 = this._usrName.serializedLength();
            if (this.hasName()) {
                this._serializedLength += nbytes2 - nbytes1;
            } else {
                this._serializedLength += nbytes2 + 6;
                this._fieldBitmask[0] = this._fieldBitmask[0] | 0x10L;
            }
            this._dirty = true;
        }

        public final void setNameFrom(long val) {
            if (this._readonly) {
                throw new IllegalStateException("node is read only");
            }
            int nbytes1 = this._usrName.serializedLength();
            this._usrName.setFrom(val);
            int nbytes2 = this._usrName.serializedLength();
            if (this.hasName()) {
                this._serializedLength += nbytes2 - nbytes1;
            } else {
                this._serializedLength += nbytes2 + 6;
                this._fieldBitmask[0] = this._fieldBitmask[0] | 0x10L;
            }
            this._dirty = true;
        }

        public final void setNameFrom(byte[] val, int offset, int len) {
            if (this._readonly) {
                throw new IllegalStateException("node is read only");
            }
            if (val == null) {
                this.clearName();
                return;
            }
            int nbytes1 = this._usrName.serializedLength();
            this._usrName.setFrom(val, offset, len);
            int nbytes2 = this._usrName.serializedLength();
            if (this.hasName()) {
                this._serializedLength += nbytes2 - nbytes1;
            } else {
                this._serializedLength += nbytes2 + 6;
                this._fieldBitmask[0] = this._fieldBitmask[0] | 0x10L;
            }
            this._dirty = true;
        }

        public final void setNameFrom(XString val) {
            if (this._readonly) {
                throw new IllegalStateException("node is read only");
            }
            if (val == null || val.isNull()) {
                this.clearName();
                return;
            }
            int nbytes1 = this._usrName.serializedLength();
            this._usrName.setFrom(val);
            int nbytes2 = this._usrName.serializedLength();
            if (this.hasName()) {
                this._serializedLength += nbytes2 - nbytes1;
            } else {
                this._serializedLength += nbytes2 + 6;
                this._fieldBitmask[0] = this._fieldBitmask[0] | 0x10L;
            }
            this._dirty = true;
        }

        public final void setNameFrom(XStringDeserializer val) {
            if (this._readonly) {
                throw new IllegalStateException("node is read only");
            }
            if (val == null) {
                this.clearName();
                return;
            }
            int nbytes1 = this._usrName.serializedLength();
            val.getTo(this._usrName);
            int nbytes2 = this._usrName.serializedLength();
            if (this.hasName()) {
                this._serializedLength += nbytes2 - nbytes1;
            } else {
                this._serializedLength += nbytes2 + 6;
                this._fieldBitmask[0] = this._fieldBitmask[0] | 0x10L;
            }
            this._dirty = true;
        }

        public final void clearName(boolean freeBackingStorage) {
            if (this._readonly) {
                throw new IllegalStateException("node is read only");
            }
            if (!this.hasName()) {
                return;
            }
            this._serializedLength -= this._usrName.serializedLength() + 6;
            this._usrName.clear(freeBackingStorage);
            this._fieldBitmask[0] = this._fieldBitmask[0] & 0xFFFFFFFFFFFFFFEFL;
            this._dirty = true;
        }

        public final void clearName() {
            this.clearName(false);
        }

        public final boolean hasNiceName() {
            return (this._fieldBitmask[0] & 0x20L) != 0L;
        }

        public final XString getNiceName() {
            if (!this.hasNiceName() || this._usrNiceName.isNull()) {
                return null;
            }
            return this._usrNiceName;
        }

        public final void getNiceNameTo(XString val) {
            if (!this.hasNiceName() || this._usrNiceName.isNull()) {
                val.clear();
                return;
            }
            this._usrNiceName.getTo(val);
        }

        public final void setNiceNameFrom(String val) {
            if (this._readonly) {
                throw new IllegalStateException("node is read only");
            }
            if (val == null) {
                this.clearNiceName();
                return;
            }
            int nbytes1 = this._usrNiceName.serializedLength();
            this._usrNiceName.setFrom(val);
            int nbytes2 = this._usrNiceName.serializedLength();
            if (this.hasNiceName()) {
                this._serializedLength += nbytes2 - nbytes1;
            } else {
                this._serializedLength += nbytes2 + 6;
                this._fieldBitmask[0] = this._fieldBitmask[0] | 0x20L;
            }
            this._dirty = true;
        }

        public final void setNiceNameFrom(CharSequence val) {
            if (this._readonly) {
                throw new IllegalStateException("node is read only");
            }
            if (val == null) {
                this.clearNiceName();
                return;
            }
            int nbytes1 = this._usrNiceName.serializedLength();
            this._usrNiceName.setFrom(val);
            int nbytes2 = this._usrNiceName.serializedLength();
            if (this.hasNiceName()) {
                this._serializedLength += nbytes2 - nbytes1;
            } else {
                this._serializedLength += nbytes2 + 6;
                this._fieldBitmask[0] = this._fieldBitmask[0] | 0x20L;
            }
            this._dirty = true;
        }

        public final void setNiceNameFrom(long val) {
            if (this._readonly) {
                throw new IllegalStateException("node is read only");
            }
            int nbytes1 = this._usrNiceName.serializedLength();
            this._usrNiceName.setFrom(val);
            int nbytes2 = this._usrNiceName.serializedLength();
            if (this.hasNiceName()) {
                this._serializedLength += nbytes2 - nbytes1;
            } else {
                this._serializedLength += nbytes2 + 6;
                this._fieldBitmask[0] = this._fieldBitmask[0] | 0x20L;
            }
            this._dirty = true;
        }

        public final void setNiceNameFrom(byte[] val, int offset, int len) {
            if (this._readonly) {
                throw new IllegalStateException("node is read only");
            }
            if (val == null) {
                this.clearNiceName();
                return;
            }
            int nbytes1 = this._usrNiceName.serializedLength();
            this._usrNiceName.setFrom(val, offset, len);
            int nbytes2 = this._usrNiceName.serializedLength();
            if (this.hasNiceName()) {
                this._serializedLength += nbytes2 - nbytes1;
            } else {
                this._serializedLength += nbytes2 + 6;
                this._fieldBitmask[0] = this._fieldBitmask[0] | 0x20L;
            }
            this._dirty = true;
        }

        public final void setNiceNameFrom(XString val) {
            if (this._readonly) {
                throw new IllegalStateException("node is read only");
            }
            if (val == null || val.isNull()) {
                this.clearNiceName();
                return;
            }
            int nbytes1 = this._usrNiceName.serializedLength();
            this._usrNiceName.setFrom(val);
            int nbytes2 = this._usrNiceName.serializedLength();
            if (this.hasNiceName()) {
                this._serializedLength += nbytes2 - nbytes1;
            } else {
                this._serializedLength += nbytes2 + 6;
                this._fieldBitmask[0] = this._fieldBitmask[0] | 0x20L;
            }
            this._dirty = true;
        }

        public final void setNiceNameFrom(XStringDeserializer val) {
            if (this._readonly) {
                throw new IllegalStateException("node is read only");
            }
            if (val == null) {
                this.clearNiceName();
                return;
            }
            int nbytes1 = this._usrNiceName.serializedLength();
            val.getTo(this._usrNiceName);
            int nbytes2 = this._usrNiceName.serializedLength();
            if (this.hasNiceName()) {
                this._serializedLength += nbytes2 - nbytes1;
            } else {
                this._serializedLength += nbytes2 + 6;
                this._fieldBitmask[0] = this._fieldBitmask[0] | 0x20L;
            }
            this._dirty = true;
        }

        public final void clearNiceName(boolean freeBackingStorage) {
            if (this._readonly) {
                throw new IllegalStateException("node is read only");
            }
            if (!this.hasNiceName()) {
                return;
            }
            this._serializedLength -= this._usrNiceName.serializedLength() + 6;
            this._usrNiceName.clear(freeBackingStorage);
            this._fieldBitmask[0] = this._fieldBitmask[0] & 0xFFFFFFFFFFFFFFDFL;
            this._dirty = true;
        }

        public final void clearNiceName() {
            this.clearNiceName(false);
        }

        public final boolean hasDescription() {
            return (this._fieldBitmask[0] & 0x40L) != 0L;
        }

        public final XString getDescription() {
            if (!this.hasDescription() || this._usrDescription.isNull()) {
                return null;
            }
            return this._usrDescription;
        }

        public final void getDescriptionTo(XString val) {
            if (!this.hasDescription() || this._usrDescription.isNull()) {
                val.clear();
                return;
            }
            this._usrDescription.getTo(val);
        }

        public final void setDescriptionFrom(String val) {
            if (this._readonly) {
                throw new IllegalStateException("node is read only");
            }
            if (val == null) {
                this.clearDescription();
                return;
            }
            int nbytes1 = this._usrDescription.serializedLength();
            this._usrDescription.setFrom(val);
            int nbytes2 = this._usrDescription.serializedLength();
            if (this.hasDescription()) {
                this._serializedLength += nbytes2 - nbytes1;
            } else {
                this._serializedLength += nbytes2 + 6;
                this._fieldBitmask[0] = this._fieldBitmask[0] | 0x40L;
            }
            this._dirty = true;
        }

        public final void setDescriptionFrom(CharSequence val) {
            if (this._readonly) {
                throw new IllegalStateException("node is read only");
            }
            if (val == null) {
                this.clearDescription();
                return;
            }
            int nbytes1 = this._usrDescription.serializedLength();
            this._usrDescription.setFrom(val);
            int nbytes2 = this._usrDescription.serializedLength();
            if (this.hasDescription()) {
                this._serializedLength += nbytes2 - nbytes1;
            } else {
                this._serializedLength += nbytes2 + 6;
                this._fieldBitmask[0] = this._fieldBitmask[0] | 0x40L;
            }
            this._dirty = true;
        }

        public final void setDescriptionFrom(long val) {
            if (this._readonly) {
                throw new IllegalStateException("node is read only");
            }
            int nbytes1 = this._usrDescription.serializedLength();
            this._usrDescription.setFrom(val);
            int nbytes2 = this._usrDescription.serializedLength();
            if (this.hasDescription()) {
                this._serializedLength += nbytes2 - nbytes1;
            } else {
                this._serializedLength += nbytes2 + 6;
                this._fieldBitmask[0] = this._fieldBitmask[0] | 0x40L;
            }
            this._dirty = true;
        }

        public final void setDescriptionFrom(byte[] val, int offset, int len) {
            if (this._readonly) {
                throw new IllegalStateException("node is read only");
            }
            if (val == null) {
                this.clearDescription();
                return;
            }
            int nbytes1 = this._usrDescription.serializedLength();
            this._usrDescription.setFrom(val, offset, len);
            int nbytes2 = this._usrDescription.serializedLength();
            if (this.hasDescription()) {
                this._serializedLength += nbytes2 - nbytes1;
            } else {
                this._serializedLength += nbytes2 + 6;
                this._fieldBitmask[0] = this._fieldBitmask[0] | 0x40L;
            }
            this._dirty = true;
        }

        public final void setDescriptionFrom(XString val) {
            if (this._readonly) {
                throw new IllegalStateException("node is read only");
            }
            if (val == null || val.isNull()) {
                this.clearDescription();
                return;
            }
            int nbytes1 = this._usrDescription.serializedLength();
            this._usrDescription.setFrom(val);
            int nbytes2 = this._usrDescription.serializedLength();
            if (this.hasDescription()) {
                this._serializedLength += nbytes2 - nbytes1;
            } else {
                this._serializedLength += nbytes2 + 6;
                this._fieldBitmask[0] = this._fieldBitmask[0] | 0x40L;
            }
            this._dirty = true;
        }

        public final void setDescriptionFrom(XStringDeserializer val) {
            if (this._readonly) {
                throw new IllegalStateException("node is read only");
            }
            if (val == null) {
                this.clearDescription();
                return;
            }
            int nbytes1 = this._usrDescription.serializedLength();
            val.getTo(this._usrDescription);
            int nbytes2 = this._usrDescription.serializedLength();
            if (this.hasDescription()) {
                this._serializedLength += nbytes2 - nbytes1;
            } else {
                this._serializedLength += nbytes2 + 6;
                this._fieldBitmask[0] = this._fieldBitmask[0] | 0x40L;
            }
            this._dirty = true;
        }

        public final void clearDescription(boolean freeBackingStorage) {
            if (this._readonly) {
                throw new IllegalStateException("node is read only");
            }
            if (!this.hasDescription()) {
                return;
            }
            this._serializedLength -= this._usrDescription.serializedLength() + 6;
            this._usrDescription.clear(freeBackingStorage);
            this._fieldBitmask[0] = this._fieldBitmask[0] & 0xFFFFFFFFFFFFFFBFL;
            this._dirty = true;
        }

        public final void clearDescription() {
            this.clearDescription(false);
        }

        public final void clear(boolean freeBackingStorage) {
            this._readonly = false;
            this._usrCpuCores = 0;
            this._usrRamInMb = 0;
            this._usrDiskInGb = 0;
            this._usrSelectable = false;
            if (freeBackingStorage) {
                this.clearName(true);
            }
            if (freeBackingStorage) {
                this.clearNiceName(true);
            }
            if (freeBackingStorage) {
                this.clearDescription(true);
            }
            this._fieldBitmask[0] = 0L;
            this._serializedLength = 0;
            this._dirty = true;
        }

        public final void clear() {
            this.clear(_freeBackingStorageOnClear);
        }

        private final Pojo setCreated() {
            this._flags = (byte)(this._flags | 1);
            return this;
        }

        private final boolean isCreated() {
            return (this._flags & 1) != 0;
        }

        private final Pojo clearCreated() {
            this._flags = (byte)(this._flags & 0xFFFFFFFE);
            return this;
        }

        private final Pojo setPooled() {
            this._flags = (byte)(this._flags | 2);
            return this;
        }

        private final boolean isPooled() {
            return (this._flags & 2) != 0;
        }

        private final Pojo clearPooled() {
            this._flags = (byte)(this._flags & 0xFFFFFFFD);
            return this;
        }

        private final Pojo setPrivate() {
            this._flags = (byte)(this._flags | 4);
            return this;
        }

        private final boolean isPrivate() {
            return (this._flags & 4) != 0;
        }

        private final Pojo clearPrivate() {
            this._flags = (byte)(this._flags & 0xFFFFFFFB);
            return this;
        }

        private final Pojo setOnlyPojos() {
            this._flags = (byte)(this._flags | 8);
            return this;
        }

        private final boolean isOnlyPojos() {
            return (this._flags & 8) != 0;
        }

        private final Pojo clearOnlyPojos() {
            this._flags = (byte)(this._flags & 0xFFFFFFF7);
            return this;
        }

        public final void setAsReadOnly() {
            this._readonly = true;
        }

        public final boolean isInitialized() {
            return this._initialized;
        }

        public final void setInitialized() {
            this._initialized = true;
        }

        public final void clearDirty() {
            this._dirty = false;
        }

        public final void forceDirty() {
            this._dirty = true;
        }

        public final boolean isDirty() {
            return this._dirty;
        }

        public final int getSerializedLength() {
            int len = this._serializedLength;
            return len;
        }

        public final int serialize(Serializer serializer) {
            if (!serializer.isInitialized()) {
                throw new IllegalArgumentException("serializer not initialized");
            }
            if (this.hasCpuCores()) {
                serializer.cpuCores(this._usrCpuCores);
            }
            if (this.hasRamInMb()) {
                serializer.ramInMb(this._usrRamInMb);
            }
            if (this.hasDiskInGb()) {
                serializer.diskInGb(this._usrDiskInGb);
            }
            if (this.hasSelectable()) {
                serializer.selectable(this._usrSelectable);
            }
            if (this.hasName()) {
                serializer.name(this._usrName);
            }
            if (this.hasNiceName()) {
                serializer.niceName(this._usrNiceName);
            }
            if (this.hasDescription()) {
                serializer.description(this._usrDescription);
            }
            return serializer.done();
        }

        public final void deserialize(Deserializer deserializer) {
            if (!deserializer.isInitialized()) {
                throw new IllegalArgumentException("deserializer not initialized");
            }
            this.clear();
            deserializer.run(this._deserializationCallback);
            this._initialized = true;
        }

        public final Pojo reset(boolean freeBackingStorage) {
            this.clear(freeBackingStorage);
            this._dirty = false;
            this._initialized = false;
            return this;
        }

        public final Pojo reset() {
            return this.reset(_conserveMemory);
        }

        public final Pojo init() {
            return this.reset();
        }

        public final Pojo setPool(UtlPool<Pojo> pool) {
            this._pool = pool;
            return this;
        }

        public final UtlPool<Pojo> getPool() {
            return this._pool;
        }

        final void dispose() {
            this.clearCreated();
            if (this._pool != null) {
                this.setPooled();
                this._pool.put((UtlPool.Item)this);
                if (!this.isPrivate()) {
                    _memstats.onEntityPojoDisposed(InstanceSize.class, MemoryStats.EntityType.EmbeddedEntity, true);
                }
            }
        }

        private final class DeserializationCallback
        implements Deserializer.Callback {
            private DeserializationCallback() {
            }

            @Override
            public final void handleCpuCores(int val) {
                Pojo.this.setCpuCores(val);
            }

            @Override
            public final void handleRamInMb(int val) {
                Pojo.this.setRamInMb(val);
            }

            @Override
            public final void handleDiskInGb(int val) {
                Pojo.this.setDiskInGb(val);
            }

            @Override
            public final void handleSelectable(boolean val) {
                Pojo.this.setSelectable(val);
            }

            @Override
            public final void handleName(XStringDeserializer val) {
                Pojo.this.setNameFrom(val);
            }

            @Override
            public final void handleNiceName(XStringDeserializer val) {
                Pojo.this.setNiceNameFrom(val);
            }

            @Override
            public final void handleDescription(XStringDeserializer val) {
                Pojo.this.setDescriptionFrom(val);
            }
        }
    }

    public static final class Deserializer
    implements UtlPool.Item<Deserializer> {
        private final XStringDeserializer _stringDeserializer = XStringDeserializer.create();
        private static final byte FLG_CREATED = 1;
        private static final byte FLG_POOLED = 2;
        private static final byte FLG_PRIVATE = 4;
        private static final MemoryStats _memstats = MemoryStats.getInstance();
        private long _addr;
        private int _offset;
        private int _len;
        private boolean _stopped;
        private UtlPool<Deserializer> _pool;
        private byte _flags;

        Deserializer() {
            this.setCreated();
        }

        public static final Deserializer create(boolean pvt) {
            Deserializer deserializer = (Deserializer)_entityDeserializerPool.get(null);
            if (pvt) {
                deserializer.setPrivate();
            } else {
                deserializer.clearPrivate();
                _memstats.onEntityDeserializerAllocated(InstanceSize.class, MemoryStats.EntityType.EmbeddedEntity, !deserializer.isCreated());
            }
            return deserializer.clearPooled();
        }

        public static final Deserializer create() {
            return Deserializer.create(false);
        }

        private final Deserializer setCreated() {
            this._flags = (byte)(this._flags | 1);
            return this;
        }

        private final boolean isCreated() {
            return (this._flags & 1) != 0;
        }

        private final Deserializer clearCreated() {
            this._flags = (byte)(this._flags & 0xFFFFFFFE);
            return this;
        }

        private final Deserializer setPooled() {
            this._flags = (byte)(this._flags | 2);
            return this;
        }

        private final boolean isPooled() {
            return (this._flags & 2) != 0;
        }

        private final Deserializer clearPooled() {
            this._flags = (byte)(this._flags & 0xFFFFFFFD);
            return this;
        }

        private final Deserializer setPrivate() {
            this._flags = (byte)(this._flags | 4);
            return this;
        }

        private final boolean isPrivate() {
            return (this._flags & 4) != 0;
        }

        private final Deserializer clearPrivate() {
            this._flags = (byte)(this._flags & 0xFFFFFFFB);
            return this;
        }

        public final Deserializer init(long addr, int offset, int len) {
            this._addr = addr;
            this._offset = offset;
            this._len = len;
            return this;
        }

        public final Deserializer init(IOBuffer buffer, int offset, int len) {
            this._addr = buffer.getNativeAddress();
            this._offset = offset;
            this._len = len;
            return this;
        }

        public final boolean isInitialized() {
            return this._addr != 0L;
        }

        public final int getSerializedLength() {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            return this._len;
        }

        public final void getTo(IOBuffer buffer, int offset) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            if (buffer.getLength() - offset < this._len) {
                throw new IllegalArgumentException("not enough space in supplied buffer");
            }
            buffer.putFrom(offset, this._addr, this._offset, this._len);
        }

        public final int getTo(long addr, int offset) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            IOBuffer.copy((long)this._addr, (int)this._offset, (long)addr, (int)offset, (int)this._len);
            return this._len;
        }

        public final void run(Callback cb) {
            int flen;
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            long addr = this._addr;
            int lim = this._offset + this._len;
            this._stopped = false;
            block16: for (int pos = this._offset; !this._stopped && pos < lim; pos += 2 + flen) {
                switch ((IOBuffer.getShort((long)addr, (int)pos) & 0xFFFF) >>> 3) {
                    case 3: {
                        flen = 4;
                        cb.handleCpuCores(IOBuffer.getInt((long)addr, (int)(pos + 2)));
                        continue block16;
                    }
                    case 4: {
                        flen = 4;
                        cb.handleRamInMb(IOBuffer.getInt((long)addr, (int)(pos + 2)));
                        continue block16;
                    }
                    case 5: {
                        flen = 4;
                        cb.handleDiskInGb(IOBuffer.getInt((long)addr, (int)(pos + 2)));
                        continue block16;
                    }
                    case 7: {
                        flen = 1;
                        cb.handleSelectable(IOBuffer.getByte((long)addr, (int)(pos + 2)) == 1);
                        continue block16;
                    }
                    case 1: {
                        flen = IOBuffer.getInt((long)addr, (int)(pos + 2));
                        cb.handleName(this._stringDeserializer.init(addr, pos + 6, flen));
                        flen += 4;
                        continue block16;
                    }
                    case 2: {
                        flen = IOBuffer.getInt((long)addr, (int)(pos + 2));
                        cb.handleNiceName(this._stringDeserializer.init(addr, pos + 6, flen));
                        flen += 4;
                        continue block16;
                    }
                    case 6: {
                        flen = IOBuffer.getInt((long)addr, (int)(pos + 2));
                        cb.handleDescription(this._stringDeserializer.init(addr, pos + 6, flen));
                        flen += 4;
                        continue block16;
                    }
                    default: {
                        switch (IOBuffer.getShort((long)addr, (int)pos) & 3) {
                            case 0: {
                                flen = 4 + IOBuffer.getInt((long)addr, (int)(pos + 2));
                                continue block16;
                            }
                            case 1: {
                                flen = 1;
                                continue block16;
                            }
                            case 2: {
                                flen = 2;
                                continue block16;
                            }
                            case 3: {
                                flen = 4;
                                continue block16;
                            }
                            case 4: {
                                flen = 8;
                                continue block16;
                            }
                        }
                        throw new IllegalStateException("corrupt field - #" + ((IOBuffer.getShort((long)addr, (int)pos) & 0xFFFF) >>> 3));
                    }
                }
            }
        }

        public final void stop() {
            this._stopped = true;
        }

        public final Deserializer init() {
            return this;
        }

        public final Deserializer setPool(UtlPool<Deserializer> pool) {
            this._pool = pool;
            return this;
        }

        public final UtlPool<Deserializer> getPool() {
            return this._pool;
        }

        final void dispose() {
            this.clearCreated();
            if (this._pool != null) {
                this.setPooled();
                this._pool.put((UtlPool.Item)this);
                if (!this.isPrivate()) {
                    _memstats.onEntityDeserializerDisposed(InstanceSize.class, MemoryStats.EntityType.EmbeddedEntity, true);
                }
            }
        }

        public static abstract class AbstractCallbackImpl
        implements Callback {
            @Override
            public void handleCpuCores(int val) {
            }

            @Override
            public void handleRamInMb(int val) {
            }

            @Override
            public void handleDiskInGb(int val) {
            }

            @Override
            public void handleSelectable(boolean val) {
            }

            @Override
            public void handleName(XStringDeserializer val) {
            }

            @Override
            public void handleNiceName(XStringDeserializer val) {
            }

            @Override
            public void handleDescription(XStringDeserializer val) {
            }
        }

        public static interface Callback {
            public void handleCpuCores(int var1);

            public void handleRamInMb(int var1);

            public void handleDiskInGb(int var1);

            public void handleSelectable(boolean var1);

            public void handleName(XStringDeserializer var1);

            public void handleNiceName(XStringDeserializer var1);

            public void handleDescription(XStringDeserializer var1);
        }
    }

    public static final class Serializer
    implements IQuarkChildSerializationCompletionCallback,
    UtlPool.Item<Serializer>,
    AdmRuntime.BufferSizer {
        private static final byte FLG_CREATED = 1;
        private static final byte FLG_POOLED = 2;
        private static final byte FLG_PRIVATE = 4;
        private static final MemoryStats _memstats = MemoryStats.getInstance();
        private InstanceSize _entity;
        private IQuarkChildSerializationCompletionCallback _parent;
        private int _mark;
        private int _len;
        private long _addr;
        private AdmRuntime.BufferSizer _sizer;
        private UtlPool<Serializer> _pool;
        private byte _flags;

        Serializer() {
            this.setCreated();
        }

        public static final Serializer create(boolean pvt) {
            Serializer serializer = (Serializer)_entitySerializerPool.get(null);
            if (pvt) {
                serializer.setPrivate();
            } else {
                serializer.clearPrivate();
                _memstats.onEntitySerializerAllocated(InstanceSize.class, MemoryStats.EntityType.EmbeddedEntity, !serializer.isCreated());
            }
            return serializer.clearPooled();
        }

        public static final Serializer create() {
            return Serializer.create(false);
        }

        private final Serializer setCreated() {
            this._flags = (byte)(this._flags | 1);
            return this;
        }

        private final boolean isCreated() {
            return (this._flags & 1) != 0;
        }

        private final Serializer clearCreated() {
            this._flags = (byte)(this._flags & 0xFFFFFFFE);
            return this;
        }

        private final Serializer setPooled() {
            this._flags = (byte)(this._flags | 2);
            return this;
        }

        private final boolean isPooled() {
            return (this._flags & 2) != 0;
        }

        private final Serializer clearPooled() {
            this._flags = (byte)(this._flags & 0xFFFFFFFD);
            return this;
        }

        private final Serializer setPrivate() {
            this._flags = (byte)(this._flags | 4);
            return this;
        }

        private final boolean isPrivate() {
            return (this._flags & 4) != 0;
        }

        private final Serializer clearPrivate() {
            this._flags = (byte)(this._flags & 0xFFFFFFFB);
            return this;
        }

        private final void ensureCapacity(int val) {
            if (this._sizer != null) {
                this._addr = this._sizer.ensureCapacity(this._addr, val);
            }
        }

        public final Serializer init(long addr, int len, IQuarkChildSerializationCompletionCallback parent) {
            this._entity = null;
            this._parent = parent;
            this._mark = -1;
            this._len = len;
            this._addr = addr;
            return this;
        }

        public final Serializer init(IOBuffer buffer, int len, IQuarkChildSerializationCompletionCallback parent) {
            return this.init(buffer.getNativeAddress(), len, parent);
        }

        public final Serializer init(IOBuffer buffer, IQuarkChildSerializationCompletionCallback parent) {
            return this.init(buffer.getNativeAddress(), 0, parent);
        }

        final Serializer init(InstanceSize entity) {
            this.init(entity.getSerializedBuffer(), 0, null);
            this._entity = entity;
            return this;
        }

        public final Serializer setSizer(AdmRuntime.BufferSizer sizer) {
            this._sizer = sizer;
            return this;
        }

        public final boolean hasSizer() {
            return this._sizer != null;
        }

        public final boolean isInitialized() {
            return this._addr != 0L;
        }

        public final int getSerializedLength() {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            return this._len;
        }

        public final void getTo(IOBuffer buffer, int offset) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            if (buffer.getLength() - offset < this._len) {
                throw new IllegalArgumentException("not enough space in supplied buffer");
            }
            buffer.putFrom(offset, this._addr, 0, this._len);
        }

        public final int getTo(long addr, int offset) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            IOBuffer.copy((long)this._addr, (int)0, (long)addr, (int)offset, (int)this._len);
            return this._len;
        }

        public final void putFrom(IOBuffer buffer, int offset, int len) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            if (this.hasSizer()) {
                this.ensureCapacity(this._len + len);
            }
            buffer.getTo(offset, this._addr, this._len, len);
            this._len += len;
        }

        public final void putFrom(long addr, int offset, int len) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            if (this.hasSizer()) {
                this.ensureCapacity(this._len + len);
            }
            IOBuffer.copy((long)addr, (int)offset, (long)this._addr, (int)this._len, (int)len);
            this._len += len;
        }

        public final Serializer cpuCores(int val) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            if (this._mark >= 0) {
                throw new IllegalStateException("child object serialization in progress");
            }
            if (this.hasSizer()) {
                this.ensureCapacity(this._len + 6);
            }
            IOBuffer.putShort((long)this._addr, (int)this._len, (short)27);
            this._len += 2;
            IOBuffer.putInt((long)this._addr, (int)this._len, (int)val);
            this._len += 4;
            return this;
        }

        public final Serializer ramInMb(int val) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            if (this._mark >= 0) {
                throw new IllegalStateException("child object serialization in progress");
            }
            if (this.hasSizer()) {
                this.ensureCapacity(this._len + 6);
            }
            IOBuffer.putShort((long)this._addr, (int)this._len, (short)35);
            this._len += 2;
            IOBuffer.putInt((long)this._addr, (int)this._len, (int)val);
            this._len += 4;
            return this;
        }

        public final Serializer diskInGb(int val) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            if (this._mark >= 0) {
                throw new IllegalStateException("child object serialization in progress");
            }
            if (this.hasSizer()) {
                this.ensureCapacity(this._len + 6);
            }
            IOBuffer.putShort((long)this._addr, (int)this._len, (short)43);
            this._len += 2;
            IOBuffer.putInt((long)this._addr, (int)this._len, (int)val);
            this._len += 4;
            return this;
        }

        public final Serializer selectable(boolean val) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            if (this._mark >= 0) {
                throw new IllegalStateException("child object serialization in progress");
            }
            if (this.hasSizer()) {
                this.ensureCapacity(this._len + 3);
            }
            IOBuffer.putShort((long)this._addr, (int)this._len, (short)57);
            this._len += 2;
            IOBuffer.putByte((long)this._addr, (int)this._len, (byte)((byte)(val ? 1 : 0)));
            ++this._len;
            return this;
        }

        public final Serializer name(String val) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            if (this._mark >= 0) {
                throw new IllegalStateException("child object serialization in progress");
            }
            if (val == null) {
                return this;
            }
            if (this.hasSizer()) {
                this.ensureCapacity(this._len + 6 + val.length());
            }
            IOBuffer.putShort((long)this._addr, (int)this._len, (short)8);
            this._len += 2;
            IOBuffer.putInt((long)this._addr, (int)this._len, (int)val.length());
            this._len += 4;
            IOBuffer.putASCIICharSequence((long)this._addr, (int)this._len, (CharSequence)val);
            this._len += val.length();
            return this;
        }

        public final Serializer name(XString val) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            if (this._mark >= 0) {
                throw new IllegalStateException("child object serialization in progress");
            }
            if (val == null || val.isNull()) {
                return this;
            }
            if (this.hasSizer()) {
                this.ensureCapacity(this._len + 6 + val.serializedLength());
            }
            IOBuffer.putShort((long)this._addr, (int)this._len, (short)8);
            this._len += 2;
            IOBuffer.putInt((long)this._addr, (int)this._len, (int)val.serializedLength());
            this._len += 4;
            this._len += val.getTo(this._addr, this._len);
            return this;
        }

        public final Serializer name(byte[] val, int offset, int len) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            if (this._mark >= 0) {
                throw new IllegalStateException("child object serialization in progress");
            }
            if (val == null) {
                return this;
            }
            if (this.hasSizer()) {
                this.ensureCapacity(this._len + 6 + len);
            }
            IOBuffer.putShort((long)this._addr, (int)this._len, (short)8);
            this._len += 2;
            IOBuffer.putInt((long)this._addr, (int)this._len, (int)len);
            this._len += 4;
            IOBuffer.putFrom((long)this._addr, (int)this._len, (byte[])val, (int)offset, (int)len);
            this._len += len;
            return this;
        }

        public final Serializer name(byte[] val) {
            return this.name(val, 0, val.length);
        }

        public final Serializer name(XStringDeserializer val) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            if (this._mark >= 0) {
                throw new IllegalStateException("child object serialization in progress");
            }
            if (val == null) {
                return this;
            }
            if (this.hasSizer()) {
                this.ensureCapacity(this._len + 6 + val.serializedLength());
            }
            IOBuffer.putShort((long)this._addr, (int)this._len, (short)8);
            this._len += 2;
            IOBuffer.putInt((long)this._addr, (int)this._len, (int)val.serializedLength());
            this._len += 4;
            this._len += val.getTo(this._addr, this._len);
            return this;
        }

        public final Serializer name(IOBuffer val, int offset, int len) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            if (this._mark >= 0) {
                throw new IllegalStateException("child object serialization in progress");
            }
            if (val == null) {
                return this;
            }
            if (this.hasSizer()) {
                this.ensureCapacity(this._len + 6 + len);
            }
            IOBuffer.putShort((long)this._addr, (int)this._len, (short)8);
            this._len += 2;
            IOBuffer.putInt((long)this._addr, (int)this._len, (int)len);
            this._len += 4;
            val.getTo(offset, this._addr, this._len, len);
            this._len += len;
            return this;
        }

        public final Serializer niceName(String val) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            if (this._mark >= 0) {
                throw new IllegalStateException("child object serialization in progress");
            }
            if (val == null) {
                return this;
            }
            if (this.hasSizer()) {
                this.ensureCapacity(this._len + 6 + val.length());
            }
            IOBuffer.putShort((long)this._addr, (int)this._len, (short)16);
            this._len += 2;
            IOBuffer.putInt((long)this._addr, (int)this._len, (int)val.length());
            this._len += 4;
            IOBuffer.putASCIICharSequence((long)this._addr, (int)this._len, (CharSequence)val);
            this._len += val.length();
            return this;
        }

        public final Serializer niceName(XString val) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            if (this._mark >= 0) {
                throw new IllegalStateException("child object serialization in progress");
            }
            if (val == null || val.isNull()) {
                return this;
            }
            if (this.hasSizer()) {
                this.ensureCapacity(this._len + 6 + val.serializedLength());
            }
            IOBuffer.putShort((long)this._addr, (int)this._len, (short)16);
            this._len += 2;
            IOBuffer.putInt((long)this._addr, (int)this._len, (int)val.serializedLength());
            this._len += 4;
            this._len += val.getTo(this._addr, this._len);
            return this;
        }

        public final Serializer niceName(byte[] val, int offset, int len) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            if (this._mark >= 0) {
                throw new IllegalStateException("child object serialization in progress");
            }
            if (val == null) {
                return this;
            }
            if (this.hasSizer()) {
                this.ensureCapacity(this._len + 6 + len);
            }
            IOBuffer.putShort((long)this._addr, (int)this._len, (short)16);
            this._len += 2;
            IOBuffer.putInt((long)this._addr, (int)this._len, (int)len);
            this._len += 4;
            IOBuffer.putFrom((long)this._addr, (int)this._len, (byte[])val, (int)offset, (int)len);
            this._len += len;
            return this;
        }

        public final Serializer niceName(byte[] val) {
            return this.niceName(val, 0, val.length);
        }

        public final Serializer niceName(XStringDeserializer val) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            if (this._mark >= 0) {
                throw new IllegalStateException("child object serialization in progress");
            }
            if (val == null) {
                return this;
            }
            if (this.hasSizer()) {
                this.ensureCapacity(this._len + 6 + val.serializedLength());
            }
            IOBuffer.putShort((long)this._addr, (int)this._len, (short)16);
            this._len += 2;
            IOBuffer.putInt((long)this._addr, (int)this._len, (int)val.serializedLength());
            this._len += 4;
            this._len += val.getTo(this._addr, this._len);
            return this;
        }

        public final Serializer niceName(IOBuffer val, int offset, int len) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            if (this._mark >= 0) {
                throw new IllegalStateException("child object serialization in progress");
            }
            if (val == null) {
                return this;
            }
            if (this.hasSizer()) {
                this.ensureCapacity(this._len + 6 + len);
            }
            IOBuffer.putShort((long)this._addr, (int)this._len, (short)16);
            this._len += 2;
            IOBuffer.putInt((long)this._addr, (int)this._len, (int)len);
            this._len += 4;
            val.getTo(offset, this._addr, this._len, len);
            this._len += len;
            return this;
        }

        public final Serializer description(String val) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            if (this._mark >= 0) {
                throw new IllegalStateException("child object serialization in progress");
            }
            if (val == null) {
                return this;
            }
            if (this.hasSizer()) {
                this.ensureCapacity(this._len + 6 + val.length());
            }
            IOBuffer.putShort((long)this._addr, (int)this._len, (short)48);
            this._len += 2;
            IOBuffer.putInt((long)this._addr, (int)this._len, (int)val.length());
            this._len += 4;
            IOBuffer.putASCIICharSequence((long)this._addr, (int)this._len, (CharSequence)val);
            this._len += val.length();
            return this;
        }

        public final Serializer description(XString val) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            if (this._mark >= 0) {
                throw new IllegalStateException("child object serialization in progress");
            }
            if (val == null || val.isNull()) {
                return this;
            }
            if (this.hasSizer()) {
                this.ensureCapacity(this._len + 6 + val.serializedLength());
            }
            IOBuffer.putShort((long)this._addr, (int)this._len, (short)48);
            this._len += 2;
            IOBuffer.putInt((long)this._addr, (int)this._len, (int)val.serializedLength());
            this._len += 4;
            this._len += val.getTo(this._addr, this._len);
            return this;
        }

        public final Serializer description(byte[] val, int offset, int len) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            if (this._mark >= 0) {
                throw new IllegalStateException("child object serialization in progress");
            }
            if (val == null) {
                return this;
            }
            if (this.hasSizer()) {
                this.ensureCapacity(this._len + 6 + len);
            }
            IOBuffer.putShort((long)this._addr, (int)this._len, (short)48);
            this._len += 2;
            IOBuffer.putInt((long)this._addr, (int)this._len, (int)len);
            this._len += 4;
            IOBuffer.putFrom((long)this._addr, (int)this._len, (byte[])val, (int)offset, (int)len);
            this._len += len;
            return this;
        }

        public final Serializer description(byte[] val) {
            return this.description(val, 0, val.length);
        }

        public final Serializer description(XStringDeserializer val) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            if (this._mark >= 0) {
                throw new IllegalStateException("child object serialization in progress");
            }
            if (val == null) {
                return this;
            }
            if (this.hasSizer()) {
                this.ensureCapacity(this._len + 6 + val.serializedLength());
            }
            IOBuffer.putShort((long)this._addr, (int)this._len, (short)48);
            this._len += 2;
            IOBuffer.putInt((long)this._addr, (int)this._len, (int)val.serializedLength());
            this._len += 4;
            this._len += val.getTo(this._addr, this._len);
            return this;
        }

        public final Serializer description(IOBuffer val, int offset, int len) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            if (this._mark >= 0) {
                throw new IllegalStateException("child object serialization in progress");
            }
            if (val == null) {
                return this;
            }
            if (this.hasSizer()) {
                this.ensureCapacity(this._len + 6 + len);
            }
            IOBuffer.putShort((long)this._addr, (int)this._len, (short)48);
            this._len += 2;
            IOBuffer.putInt((long)this._addr, (int)this._len, (int)len);
            this._len += 4;
            val.getTo(offset, this._addr, this._len, len);
            this._len += len;
            return this;
        }

        public final int done() {
            if (this._entity != null) {
                this._entity.setSerializedBufferLength(this._len);
            }
            if (this._parent != null) {
                this._parent.childSerializeComplete(this._len);
                this._parent = null;
            }
            this._mark = -1;
            return this._len;
        }

        public final Serializer init() {
            return this;
        }

        public final Serializer setPool(UtlPool<Serializer> pool) {
            this._pool = pool;
            return this;
        }

        public final UtlPool<Serializer> getPool() {
            return this._pool;
        }

        final void dispose() {
            this.clearCreated();
            if (this._pool != null) {
                this.setPooled();
                this._pool.put((UtlPool.Item)this);
                if (!this.isPrivate()) {
                    _memstats.onEntitySerializerDisposed(InstanceSize.class, MemoryStats.EntityType.EmbeddedEntity, true);
                }
            }
        }

        public final void childSerializeComplete(int len) {
            if (this._mark < 0) {
                throw new IllegalStateException("child object serialization in not in progress");
            }
            IOBuffer.putInt((long)this._addr, (int)this._mark, (int)(len - this._len));
            this._len = len;
            this._mark = -1;
        }

        public final long ensureCapacity(long addr, int capacity) {
            this._addr = this._sizer.ensureCapacity(addr, capacity);
            return this._addr;
        }
    }

    private static final class InstanceSizeDeserializerPoolEvictedItemReceiver
    implements UtlPool.EvictedItemReceiver<Deserializer> {
        private InstanceSizeDeserializerPoolEvictedItemReceiver() {
        }

        public final void process(Deserializer evictedItem) {
            _memstats.onEntityDeserializerLeaked(InstanceSize.class, MemoryStats.EntityType.EmbeddedEntity);
        }
    }

    private static final class InstanceSizeDeserializerPoolFactory
    implements UtlPool.Factory<Deserializer> {
        private InstanceSizeDeserializerPoolFactory() {
        }

        public final Deserializer createItem(Object object) {
            return new Deserializer();
        }

        public final Deserializer[] createItemArray(int size) {
            return new Deserializer[size];
        }
    }

    private static final class InstanceSizeSerializerPoolEvictedItemReceiver
    implements UtlPool.EvictedItemReceiver<Serializer> {
        private InstanceSizeSerializerPoolEvictedItemReceiver() {
        }

        public final void process(Serializer evictedItem) {
            _memstats.onEntitySerializerLeaked(InstanceSize.class, MemoryStats.EntityType.EmbeddedEntity);
        }
    }

    private static final class InstanceSizeSerializerPoolFactory
    implements UtlPool.Factory<Serializer> {
        private InstanceSizeSerializerPoolFactory() {
        }

        public final Serializer createItem(Object object) {
            return new Serializer();
        }

        public final Serializer[] createItemArray(int size) {
            return new Serializer[size];
        }
    }

    private static final class InstanceSizePojoPoolEvictedItemReceiver
    implements UtlPool.EvictedItemReceiver<Pojo> {
        private InstanceSizePojoPoolEvictedItemReceiver() {
        }

        public final void process(Pojo evictedItem) {
            evictedItem.clear(true);
            _memstats.onEntityPojoLeaked(InstanceSize.class, MemoryStats.EntityType.EmbeddedEntity);
        }
    }

    private static final class InstanceSizePojoPoolFactory
    implements UtlPool.Factory<Pojo> {
        private InstanceSizePojoPoolFactory() {
        }

        public final Pojo createItem(Object object) {
            return new Pojo();
        }

        public final Pojo[] createItemArray(int size) {
            return new Pojo[size];
        }
    }

    private static final class InstanceSizePoolEvictedItemReceiver
    implements UtlPool.EvictedItemReceiver<InstanceSize> {
        private InstanceSizePoolEvictedItemReceiver() {
        }

        public final void process(InstanceSize evictedItem) {
            evictedItem.clear(false, true);
            _memstats.onEntityLeaked(InstanceSize.class, MemoryStats.EntityType.EmbeddedEntity);
        }
    }

    private static final class InstanceSizePoolFactory
    implements UtlPool.Factory<InstanceSize> {
        private InstanceSizePoolFactory() {
        }

        public final InstanceSize createItem(Object object) {
            return new InstanceSize();
        }

        public final InstanceSize[] createItemArray(int size) {
            return new InstanceSize[size];
        }
    }

    static final class InstanceSizePoolFactoryItemCreateArgument {
        UUID id;
        boolean wasCreated;

        InstanceSizePoolFactoryItemCreateArgument() {
        }

        InstanceSizePoolFactoryItemCreateArgument init(UUID id) {
            this.id = id;
            this.wasCreated = false;
            return this;
        }
    }
}

