/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.tools;

import com.neeve.controller.Controller;
import com.neeve.deploy.App;
import com.neeve.deploy.Host;
import com.neeve.deploy.HostCollection;
import com.neeve.deploy.Server;
import com.neeve.server.mon.SrvMonHeartbeatMessage;
import com.neeve.server.mon.cnc.SrvMonTraceRecord;
import com.neeve.tools.interactive.InteractiveTool;
import java.util.concurrent.ConcurrentHashMap;

final class ControllerToolHostCollectionHandler
implements HostCollection.EventHandler {
    private final Controller controller;
    private final ConcurrentHashMap<String, HostHandler> hostHandlers = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, ServerHandler> serverHandlers = new ConcurrentHashMap();

    public ControllerToolHostCollectionHandler(InteractiveTool tool, Controller controller) {
        this.controller = controller;
    }

    void open() throws Exception {
        this.controller.getModel().getHostCollection().setEventHandler((HostCollection.EventHandler)this);
        for (Host h : this.controller.getModel().getHostCollection().getHosts()) {
            this.onHostUp(h);
        }
    }

    final ServerHandler getServerHandler(String serverName) {
        for (ServerHandler handler : this.serverHandlers.values()) {
            if (!handler.server.getName().equals(serverName)) continue;
            return handler;
        }
        return null;
    }

    void close() throws Exception {
        this.controller.getModel().getHostCollection().setEventHandler(null);
        this.hostHandlers.clear();
        this.serverHandlers.clear();
    }

    public void onHostUp(Host host) {
        HostHandler handler = this.hostHandlers.get(host.getAddress().getCanonicalHostName());
        if (handler != null) {
            if (handler.host == host) {
                return;
            }
            handler.close();
        }
        new HostHandler(host);
    }

    final class ServerHandler
    implements Server.EventHandler {
        private final Server server;
        private final String serverKey;
        private final ConcurrentHashMap<Server.EventHandler, Server.EventHandler> delegates = new ConcurrentHashMap();

        ServerHandler(Server server) {
            this.server = server;
            this.serverKey = server.getHost().getAddress().getHostName() + "/" + server.getName();
            ControllerToolHostCollectionHandler.this.serverHandlers.put(this.serverKey, this);
            server.setEventHandler((Server.EventHandler)this);
        }

        void addDelegate(Server.EventHandler handler) {
            this.delegates.put(handler, handler);
        }

        void removeDelegate(Server.EventHandler handler) {
            this.delegates.remove(handler);
        }

        public final void onStateChange(Server.State state) {
            for (Server.EventHandler d : this.delegates.values()) {
                d.onStateChange(state);
            }
        }

        public final void onAppUp(App app) {
            for (Server.EventHandler d : this.delegates.values()) {
                d.onAppUp(app);
            }
        }

        public final void onAppDown(App app) {
            for (Server.EventHandler d : this.delegates.values()) {
                d.onAppDown(app);
            }
        }

        public final void onHeartbeat(SrvMonHeartbeatMessage heartbeat) {
            for (Server.EventHandler d : this.delegates.values()) {
                d.onHeartbeat(heartbeat);
            }
        }

        public final void onTraceRecord(SrvMonTraceRecord traceRecord) {
            for (Server.EventHandler d : this.delegates.values()) {
                d.onTraceRecord(traceRecord);
            }
        }

        public final Server getServer() {
            return this.server;
        }
    }

    final class HostHandler
    implements Host.EventHandler {
        private final Host host;

        public HostHandler(Host host) {
            this.host = host;
            ControllerToolHostCollectionHandler.this.hostHandlers.put(host.getAddress().getCanonicalHostName(), this);
            host.setEventHandler((Host.EventHandler)this);
            for (Server server : host.getServers()) {
                this.onServerUp(server);
            }
        }

        public void onServerUp(Server server) {
            new ServerHandler(server);
        }

        public void onServerDown(Server server) {
        }

        public final Host getHost() {
            return this.host;
        }

        public void close() {
        }
    }
}

