/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.hstr;

import com.neeve.hstr.EHstrFormatException;
import com.neeve.hstr.Hstr;
import com.neeve.trace.Tracer;
import com.neeve.util.UtlLinkedHashMap;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.ListIterator;
import java.util.Map;

public class HstrTable<E> {
    private final Tracer tracer;
    private int size;
    private Node root;
    private UtlLinkedHashMap<String, Node> map;
    private UtlLinkedHashMap<String, Node> denormalizedMap;
    private final int TRACE_FLAG_CREATE = 1;
    private final int TRACE_FLAG_SET_NODE_OBJECT = 2;

    public HstrTable(Tracer tracer, int size) {
        this.size = size;
        this.tracer = tracer != null ? tracer : Tracer.get("nv.hstr");
        this.init();
    }

    public HstrTable(int size) {
        this(null, size);
    }

    public HstrTable() {
        this(null, 0);
    }

    private final void init() {
        this.root = new Node(null, null);
        this.map = this.size > 0 ? new UtlLinkedHashMap(this.size) : new UtlLinkedHashMap();
        this.denormalizedMap = this.size > 0 ? new UtlLinkedHashMap(this.size) : new UtlLinkedHashMap();
    }

    private final void dump(Node node, PrintStream out, String leadingString) {
        if (node.wildcardChildren != null) {
            for (Node iteratorNode : node.wildcardChildren.values()) {
                out.println(" |" + leadingString + " " + iteratorNode);
                this.dump(iteratorNode, out, leadingString + "--");
            }
        }
        if (node.nonWildcardChildren != null) {
            for (Node iteratorNode : node.nonWildcardChildren.values()) {
                out.println(" |" + leadingString + " " + iteratorNode);
                this.dump(iteratorNode, out, leadingString + "--");
            }
        }
        if (node.levelWildcardChild != null) {
            out.println(" |" + leadingString + " " + node.levelWildcardChild);
        }
    }

    private final ArrayList<Node> matchNodes(Node node, Node parentNode, ArrayList<Node> inMatchingNodes) {
        ArrayList<Node> outMatchingNodes = inMatchingNodes;
        if (this.tracer.debug) {
            this.tracer.log("HstrTable [" + this.hashCode() + "] Finding matches to " + node.getName() + " from '" + parentNode.getName() + "' wildcard children...", Tracer.Level.DEBUG);
        }
        if (parentNode.wildcardChildren != null) {
            for (Node iteratorNode : parentNode.wildcardChildren.values()) {
                if (this.tracer.debug) {
                    this.tracer.log("HstrTable [" + this.hashCode() + "] ...matching against " + iteratorNode.getName() + "...", Tracer.Level.DEBUG);
                }
                if (iteratorNode != node && Hstr.isElementMatch(iteratorNode.element, node.element)) {
                    if (outMatchingNodes == null) {
                        outMatchingNodes = new ArrayList();
                    }
                    if (this.tracer.debug) {
                        this.tracer.log("HstrTable [" + this.hashCode() + "] ......match", Tracer.Level.DEBUG);
                    }
                    outMatchingNodes.add(iteratorNode);
                    continue;
                }
                if (!this.tracer.debug) continue;
                this.tracer.log("HstrTable [" + this.hashCode() + "] ......not a match", Tracer.Level.DEBUG);
            }
        } else if (this.tracer.debug) {
            this.tracer.log("HstrTable [" + this.hashCode() + "] ...no wildcard children.", Tracer.Level.DEBUG);
        }
        if (this.tracer.debug) {
            this.tracer.log("HstrTable [" + this.hashCode() + "] Finding matches to " + node.getName() + " from '" + parentNode.getName() + "' non-wildcard children...", Tracer.Level.DEBUG);
        }
        if (parentNode.nonWildcardChildren != null) {
            if (node.isWildcard()) {
                for (Node iteratorNode : parentNode.nonWildcardChildren.values()) {
                    if (this.tracer.debug) {
                        this.tracer.log("HstrTable [" + this.hashCode() + "] ...matching against " + iteratorNode.getName() + "...", Tracer.Level.DEBUG);
                    }
                    if (iteratorNode != node && Hstr.isElementMatch(iteratorNode.element, node.element)) {
                        if (outMatchingNodes == null) {
                            outMatchingNodes = new ArrayList();
                        }
                        if (this.tracer.debug) {
                            this.tracer.log("HstrTable [" + this.hashCode() + "] ......match", Tracer.Level.DEBUG);
                        }
                        outMatchingNodes.add(iteratorNode);
                        continue;
                    }
                    if (!this.tracer.debug) continue;
                    this.tracer.log("HstrTable [" + this.hashCode() + "] ......not a match", Tracer.Level.DEBUG);
                }
            } else if (parentNode != node.parent) {
                Node childNode;
                if (this.tracer.debug) {
                    this.tracer.log("HstrTable [" + this.hashCode() + "] ...finding exact match in parent's non-wildcard table...", Tracer.Level.DEBUG);
                }
                if ((childNode = parentNode.getNonWildcardChild(node.element)) != null && node != childNode) {
                    if (outMatchingNodes == null) {
                        outMatchingNodes = new ArrayList();
                    }
                    if (this.tracer.debug) {
                        this.tracer.log("HstrTable [" + this.hashCode() + "] ......match ('" + childNode.getName() + "')", Tracer.Level.DEBUG);
                    }
                    outMatchingNodes.add(childNode);
                } else if (this.tracer.debug) {
                    this.tracer.log("HstrTable [" + this.hashCode() + "] ......no match", Tracer.Level.DEBUG);
                }
            }
        } else if (this.tracer.debug) {
            this.tracer.log("HstrTable [" + this.hashCode() + "] ...no non-wildcard children.", Tracer.Level.DEBUG);
        }
        return outMatchingNodes;
    }

    private final Node getChildNode(Node node, String element, int flags) {
        Node childNode = null;
        if (this.tracer.debug) {
            this.tracer.log("HstrTable [" + this.hashCode() + "] Finding child node '" + element + "' (parent='" + node.getName() + "')", Tracer.Level.DEBUG);
        }
        if (!Hstr.isWildcard(element)) {
            childNode = node.getNonWildcardChild(element);
            if (childNode == null) {
                if (this.tracer.debug) {
                    this.tracer.log("HstrTable [" + this.hashCode() + "] ...child not found.", Tracer.Level.DEBUG);
                }
                if ((flags & 1) == 1) {
                    childNode = new Node(node, element);
                    node.addNonWildcardChild(element, childNode);
                    if (this.tracer.debug) {
                        this.tracer.log("HstrTable [" + this.hashCode() + "] ...created child node (non-wildcard node) " + childNode + ".", Tracer.Level.DEBUG);
                    }
                } else if (this.tracer.debug) {
                    this.tracer.log("HstrTable [" + this.hashCode() + "] ...not creating child node (create flag not set).", Tracer.Level.DEBUG);
                }
            } else if (this.tracer.debug) {
                this.tracer.log("HstrTable [" + this.hashCode() + "] ...found node " + childNode, Tracer.Level.DEBUG);
            }
        } else if (element.compareTo(Hstr.getLevelWildcard()) == 0) {
            childNode = node.levelWildcardChild;
            if (childNode == null) {
                if (this.tracer.debug) {
                    this.tracer.log("HstrTable [" + this.hashCode() + "] ...child not found.", Tracer.Level.DEBUG);
                }
                if ((flags & 1) == 1) {
                    childNode = node.levelWildcardChild = new Node(node, element);
                    if (this.tracer.debug) {
                        this.tracer.log("HstrTable [" + this.hashCode() + "] ...created child node (level-wildcard node) " + childNode + ".", Tracer.Level.DEBUG);
                    }
                } else if (this.tracer.debug) {
                    this.tracer.log("HstrTable [" + this.hashCode() + "] ...not creating child node (create flag not set).", Tracer.Level.DEBUG);
                }
            } else if (this.tracer.debug) {
                this.tracer.log("HstrTable [" + this.hashCode() + "] ...found node " + childNode, Tracer.Level.DEBUG);
            }
        } else {
            childNode = node.getWildcardChild(element);
            if (childNode == null) {
                if (this.tracer.debug) {
                    this.tracer.log("HstrTable [" + this.hashCode() + "] ...child not found.", Tracer.Level.DEBUG);
                }
                if ((flags & 1) == 1) {
                    childNode = new Node(node, element);
                    node.addWildcardChild(element, childNode);
                    if (this.tracer.debug) {
                        this.tracer.log("HstrTable [" + this.hashCode() + "] ...created child node (non-level-wildcard node) " + childNode + ".", Tracer.Level.DEBUG);
                    }
                } else if (this.tracer.debug) {
                    this.tracer.log("HstrTable [" + this.hashCode() + "] ...not creating child node (create flag not set).", Tracer.Level.DEBUG);
                }
            } else if (this.tracer.debug) {
                this.tracer.log("HstrTable [" + this.hashCode() + "] ...found node " + childNode, Tracer.Level.DEBUG);
            }
        }
        return childNode;
    }

    private final ArrayList<Node> prepareSiblingMatchingNodes(Node node, Node parentNode, ArrayList<Node> parentMatchingNodes) {
        if (this.tracer.debug) {
            this.tracer.log("HstrTable [" + this.hashCode() + "] Finding sibling matches to node '" + node.getName() + "' (parent=" + parentNode.getName() + ")...", Tracer.Level.DEBUG);
        }
        ArrayList<Node> matchingNodes = this.matchNodes(node, parentNode, null);
        if (parentMatchingNodes != null) {
            for (Node iteratorNode : parentMatchingNodes) {
                if (this.tracer.debug) {
                    this.tracer.log("HstrTable [" + this.hashCode() + "] Finding cousin matches to node '" + node.getName() + "' (parent sibling=" + iteratorNode.getName() + ")...", Tracer.Level.DEBUG);
                }
                matchingNodes = this.matchNodes(node, iteratorNode, matchingNodes);
            }
        } else if (this.tracer.debug) {
            this.tracer.log("HstrTable [" + this.hashCode() + "] Parent has no siblings i.e. node has no cousin matches", Tracer.Level.DEBUG);
        }
        return matchingNodes;
    }

    private final void matchNodeToChildrenOfANode(Node node, Node parentNode) {
        if (parentNode.wildcardChildren != null) {
            for (Node iteratorNode : parentNode.wildcardChildren.values()) {
                if (iteratorNode != node && iteratorNode.object != null) {
                    node.addMatchingNode(iteratorNode);
                    iteratorNode.addMatchingNode(node);
                }
                this.matchNodeToChildrenOfANode(node, iteratorNode);
            }
        }
        if (parentNode.nonWildcardChildren != null) {
            for (Node iteratorNode : parentNode.nonWildcardChildren.values()) {
                if (iteratorNode != node && iteratorNode.object != null) {
                    node.addMatchingNode(iteratorNode);
                    iteratorNode.addMatchingNode(node);
                }
                this.matchNodeToChildrenOfANode(node, iteratorNode);
            }
        }
        if (parentNode.levelWildcardChild != null && parentNode.levelWildcardChild != node) {
            node.addMatchingNode(parentNode.levelWildcardChild);
            parentNode.levelWildcardChild.addMatchingNode(node);
        }
    }

    private final void matchNodeToLevelWildcard(Node foundNode, Node ancestorNode, ArrayList<Node> ancestorMatchingNodes) {
        block7: {
            block6: {
                if (ancestorNode.levelWildcardChild == foundNode) break block6;
                if (ancestorNode.levelWildcardChild != null) {
                    if (foundNode.object != null) {
                        ancestorNode.levelWildcardChild.addMatchingNode(foundNode);
                    }
                    foundNode.addMatchingNode(ancestorNode.levelWildcardChild);
                }
                if (ancestorMatchingNodes == null) break block7;
                for (Node iteratorNode : ancestorMatchingNodes) {
                    if (iteratorNode.levelWildcardChild == null) continue;
                    if (foundNode.object != null) {
                        iteratorNode.levelWildcardChild.addMatchingNode(foundNode);
                    }
                    foundNode.addMatchingNode(iteratorNode.levelWildcardChild);
                }
                break block7;
            }
            this.matchNodeToChildrenOfANode(foundNode, ancestorNode);
            if (ancestorMatchingNodes != null) {
                for (Node iteratorNode : ancestorMatchingNodes) {
                    this.matchNodeToChildrenOfANode(foundNode, iteratorNode);
                }
            }
        }
    }

    private final void checkNPruneChildNode(Node parentNode, Node childNode) {
        if (childNode.isEmpty()) {
            if (!parentNode.removeNonWildcardChild(childNode.element) && !parentNode.removeWildcardChild(childNode.element)) {
                parentNode.levelWildcardChild = null;
            }
            childNode.parent = null;
            if (childNode.matchingNodes != null) {
                for (Node iteratorNode : childNode.matchingNodes) {
                    iteratorNode.removeMatchingNode(childNode);
                }
            }
        }
    }

    private final void setMatchingNodes(Node node, ArrayList<Node> matchingNodes) {
        if (matchingNodes != null) {
            for (Node iteratorNode : matchingNodes) {
                if (iteratorNode.object == null) continue;
                iteratorNode.addMatchingNode(node);
                node.addMatchingNode(iteratorNode);
            }
        }
    }

    private final Node checkNCleanFoundNodeMatchList(Node node) {
        Node clonedNode = node;
        if (node.object == null && node.matchingNodes != null) {
            clonedNode = (Node)node.clone();
            for (Node iteratorNode : node.matchingNodes) {
                iteratorNode.removeMatchingNode(node);
            }
            node.matchingNodes.clear();
        }
        return clonedNode;
    }

    private final Node trace(String[] hstr, int currentElement, Node node, ArrayList<Node> matchingNodes, E object, int flags) {
        String element = null;
        if (currentElement < hstr.length && (element = hstr[currentElement].trim().toLowerCase()).length() > 0) {
            ArrayList<Node> childMatchingNodes = null;
            Node childNode = this.getChildNode(node, element, flags);
            if (childNode != null) {
                Node foundNode;
                if (!childNode.isLevelWildcard() && (flags & 1) == 1) {
                    childMatchingNodes = this.prepareSiblingMatchingNodes(childNode, node, matchingNodes);
                }
                if ((foundNode = this.trace(hstr, currentElement + 1, childNode, childMatchingNodes, object, flags)) != null) {
                    if ((flags & 1) == 1) {
                        this.matchNodeToLevelWildcard(foundNode, node, matchingNodes);
                    }
                    this.checkNPruneChildNode(node, childNode);
                    if (node == this.root) {
                        foundNode = this.checkNCleanFoundNodeMatchList(foundNode);
                    }
                }
                return foundNode;
            }
            return null;
        }
        if ((flags & 2) == 2) {
            node.object = object;
        }
        if ((flags & 1) == 1) {
            this.setMatchingNodes(node, matchingNodes);
        }
        return node;
    }

    public final Node put(String hstr, E object) throws EHstrFormatException {
        if (object == null) {
            throw new IllegalArgumentException("object cannot be null");
        }
        hstr = Hstr.normalize(hstr, true);
        if (this.tracer.debug) {
            this.tracer.log("HstrTable [" + this.hashCode() + "] Putting object " + object + " with name '" + hstr + "'...", Tracer.Level.DEBUG);
        }
        Node node = this.trace(Hstr.split(hstr), 0, this.root, null, object, 3);
        this.map.put(hstr, node);
        this.denormalizedMap.put(Hstr.denormalize(hstr, false), node);
        return node;
    }

    public final int size() {
        return this.map.size();
    }

    public final Node get(String hstr) {
        Node node;
        if (!hstr.startsWith(Hstr.getElementSeparator()) && (node = this.denormalizedMap.get(hstr)) != null) {
            return node;
        }
        try {
            hstr = Hstr.normalize(hstr, false);
        }
        catch (EHstrFormatException e) {
            throw new InternalError("hstr normalizer threw format exception with validate set to false!");
        }
        return this.map.get(hstr);
    }

    public final LinkedHashMap<String, Node> matches(String hstr) throws EHstrFormatException {
        Node node;
        hstr = Hstr.normalize(hstr, true);
        LinkedHashMap<String, Node> map = new LinkedHashMap<String, Node>();
        if (this.tracer.debug) {
            this.tracer.log("HstrTable [" + this.hashCode() + "] Finding matches to '" + hstr + "...", Tracer.Level.DEBUG);
        }
        if ((node = this.trace(Hstr.split(hstr), 0, this.root, null, null, 0)) == null || node.object == null) {
            if (this.tracer.debug) {
                this.tracer.log("HstrTable [" + this.hashCode() + "] Node not found. Creating...", Tracer.Level.DEBUG);
            }
            node = this.trace(Hstr.split(hstr), 0, this.root, null, null, 1);
        }
        if (node.matchingNodes != null) {
            if (this.tracer.debug) {
                this.tracer.log("HstrTable [" + this.hashCode() + "] " + node.matchingNodes.size() + " matching nodes found.", Tracer.Level.DEBUG);
            }
            for (Node iteratorNode : node.matchingNodes) {
                if (iteratorNode.object == null) {
                    throw new InternalError("Node with null object present in matching node list!");
                }
                map.put(iteratorNode.getName(), iteratorNode);
            }
        } else if (this.tracer.debug) {
            this.tracer.log("HstrTable [" + this.hashCode() + "] No matching nodes found.", Tracer.Level.DEBUG);
        }
        return map;
    }

    public final void dump(PrintStream out) {
        out.println("");
        this.dump(this.root, out, "");
        out.println("");
    }

    public final Node remove(String hstr) throws EHstrFormatException {
        Node node = this.map.remove(hstr = Hstr.normalize(hstr, true));
        if (node != null) {
            this.trace(Hstr.split(hstr), 0, this.root, null, null, 2);
            this.denormalizedMap.remove(Hstr.denormalize(hstr, false));
        }
        return node;
    }

    public final Collection<Node> values() {
        return this.map.values();
    }

    public final ListIterator<Map.Entry<String, Node>> fastValueIterator() {
        return this.map.fastIterator().toFirst();
    }

    public final void clear() {
        this.init();
    }

    public final class Node {
        Node parent;
        String element;
        LinkedHashSet<Node> matchingNodes;
        LinkedHashMap<String, Node> nonWildcardChildren;
        LinkedHashMap<String, Node> wildcardChildren;
        Node levelWildcardChild;
        byte flags;
        E object;
        static final byte FLAG_WILDCARD_ELEMENT = 1;
        static final byte FLAG_LEVEL_WILDCARD_ELEMENT = 2;

        Node(Node parent, String element) {
            this.parent = parent;
            this.element = element;
            if (this.element != null && Hstr.isWildcard(element)) {
                this.flags = 1;
                if (this.element.compareTo(Hstr.getLevelWildcard()) == 0) {
                    this.flags = (byte)(this.flags | 2);
                }
            }
        }

        final boolean isEmpty() {
            return !(this.nonWildcardChildren != null && !this.nonWildcardChildren.isEmpty() || this.wildcardChildren != null && !this.wildcardChildren.isEmpty() || this.levelWildcardChild != null || this.object != null);
        }

        final boolean isWildcard() {
            return (this.flags & 1) == 1;
        }

        final boolean isLevelWildcard() {
            return (this.flags & 2) == 2;
        }

        final void addWildcardChild(String element, Node node) {
            if (this.wildcardChildren == null) {
                this.wildcardChildren = new LinkedHashMap();
            }
            this.wildcardChildren.put(element, node);
        }

        final Node getWildcardChild(String element) {
            if (this.wildcardChildren != null) {
                return this.wildcardChildren.get(element);
            }
            return null;
        }

        final boolean removeWildcardChild(String element) {
            if (this.wildcardChildren == null || this.wildcardChildren.remove(element) == null) {
                return false;
            }
            if (this.wildcardChildren.isEmpty()) {
                this.wildcardChildren = null;
            }
            return true;
        }

        final void addNonWildcardChild(String element, Node node) {
            if (this.nonWildcardChildren == null) {
                this.nonWildcardChildren = new LinkedHashMap();
            }
            this.nonWildcardChildren.put(element, node);
        }

        final Node getNonWildcardChild(String element) {
            if (this.nonWildcardChildren != null) {
                return this.nonWildcardChildren.get(element);
            }
            return null;
        }

        final boolean removeNonWildcardChild(String element) {
            if (this.nonWildcardChildren == null || this.nonWildcardChildren.remove(element) == null) {
                return false;
            }
            if (this.nonWildcardChildren.isEmpty()) {
                this.nonWildcardChildren = null;
            }
            return true;
        }

        final void addMatchingNode(Node node) {
            if (this.matchingNodes == null) {
                this.matchingNodes = new LinkedHashSet();
            }
            this.matchingNodes.add(node);
        }

        final boolean removeMatchingNode(Node node) {
            if (this.matchingNodes == null || !this.matchingNodes.remove(node)) {
                return false;
            }
            if (this.matchingNodes.isEmpty()) {
                this.matchingNodes = null;
            }
            return true;
        }

        protected final Object clone() {
            Node node = new Node(this.parent, this.element);
            node.matchingNodes = this.matchingNodes == null ? null : (LinkedHashSet)this.matchingNodes.clone();
            node.nonWildcardChildren = this.nonWildcardChildren;
            node.wildcardChildren = this.wildcardChildren;
            node.levelWildcardChild = this.levelWildcardChild;
            node.flags = this.flags;
            node.object = this.object;
            return node;
        }

        public final String getName() {
            return this.parent == null ? "" : this.parent.getName() + Hstr.getElementSeparator() + this.element;
        }

        public final E getObject() {
            return this.object;
        }

        public final LinkedHashSet<Node> getMatchingNodes() {
            return this.matchingNodes;
        }

        public final String toString() {
            String str = this.element;
            str = str + " {" + (this.object == null ? "null" : this.object.toString());
            str = str + ", ";
            str = str + "matches=(";
            if (this.matchingNodes != null) {
                Iterator iterator = this.matchingNodes.iterator();
                while (iterator.hasNext()) {
                    Node iteratorNode = (Node)iterator.next();
                    str = str + iteratorNode.getName();
                    if (!iterator.hasNext()) continue;
                    str = str + ", ";
                }
            }
            str = str + ")";
            str = str + "}";
            return str;
        }
    }
}

