/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.link;

import cern.colt.list.ObjectArrayList;
import com.neeve.config.Config;
import com.neeve.link.ELnkAlreadyPresentException;
import com.neeve.link.LnkContainer;
import com.neeve.link.LnkObject;
import com.neeve.trace.Tracer;
import java.util.HashMap;
import java.util.Iterator;

public final class LnkRegistry
extends LnkObject {
    private final HashMap<String, LnkContainer> containers;
    private static final LnkRegistry instance = new LnkRegistry();

    private LnkRegistry() {
        super(null);
        Config.setTraceLevel((Tracer)this.tracer, (String)"nv.link.registry.trace");
        this.containers = new HashMap();
    }

    public static LnkRegistry getInstance() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addContainer(LnkContainer container) throws ELnkAlreadyPresentException {
        HashMap<String, LnkContainer> hashMap = this.containers;
        synchronized (hashMap) {
            if (this.tracer.debug) {
                this.tracer.log("Adding container " + (Object)((Object)container) + " to link registry.", Tracer.Level.DEBUG);
            }
            if (this.containers.containsKey(container.getName())) {
                throw new ELnkAlreadyPresentException();
            }
            this.containers.put(container.getName(), container);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final LnkContainer getContainer(String name) {
        HashMap<String, LnkContainer> hashMap = this.containers;
        synchronized (hashMap) {
            return this.containers.get(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ObjectArrayList getContainers() {
        HashMap<String, LnkContainer> hashMap = this.containers;
        synchronized (hashMap) {
            ObjectArrayList list = new ObjectArrayList();
            Iterator<LnkContainer> iterator = this.containers.values().iterator();
            while (iterator.hasNext()) {
                list.add((Object)iterator.next());
            }
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final LnkContainer removeContainer(String name) {
        HashMap<String, LnkContainer> hashMap = this.containers;
        synchronized (hashMap) {
            LnkContainer container = this.containers.remove(name);
            if (this.tracer.debug) {
                this.tracer.log("Removing container " + (Object)((Object)container) + " from link registry.", Tracer.Level.DEBUG);
            }
            return container;
        }
    }
}

