/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.emx.nio;

import com.neeve.emx.IEmxDispatcher;
import com.neeve.emx.IEmxEvent;
import com.neeve.emx.IEmxEventHandler;
import com.neeve.util.UtlListElement;

abstract class EmxNioEvent
extends UtlListElement
implements IEmxEvent {
    private IEmxEvent.EventType type;
    private int priority;
    private IEmxEventHandler handler;
    private IEmxDispatcher dispatcher;
    private Object tag;
    private Object attachment;
    private long scheduleTs;
    private long dispatchTs;

    protected EmxNioEvent(IEmxEvent.EventType type, IEmxEventHandler handler) {
        this.setType(type);
        this.setPriority(15);
        this.setHandler(handler);
    }

    private final void setType(IEmxEvent.EventType type) {
        this.type = type;
    }

    final void setScheduleTime(long ts) {
        this.dispatchTs = this.scheduleTs = ts;
    }

    final void setDispatchTime(long ts) {
        this.dispatchTs = ts;
    }

    final void setTag(Object tag) {
        this.tag = tag;
    }

    final Object getTag() {
        return this.tag;
    }

    @Override
    public final IEmxEvent.EventType getType() {
        return this.type;
    }

    @Override
    public final IEmxEvent setPriority(int priority) {
        if (priority < 0 || priority > 31) {
            throw new IllegalArgumentException("Invalid event priority [" + priority + "]. Must be between IEmxEvent.MINIMUM_EVENT_PRIORITY and IEmxEvent.MAXIMUM_EVENT_PRIORITY");
        }
        if (this.dispatcher != null) {
            throw new IllegalStateException("Event priority cannot be changed while being scheduled by a dispatcher");
        }
        this.priority = priority;
        return this;
    }

    @Override
    public final int getPriority() {
        return this.priority;
    }

    @Override
    public final IEmxEvent setHandler(IEmxEventHandler handler) {
        if (this.dispatcher != null) {
            throw new IllegalStateException("Event handler cannot be changed while being scheduled by a dispatcher");
        }
        this.handler = handler;
        return this;
    }

    @Override
    public final IEmxEventHandler getHandler() {
        return this.handler;
    }

    final IEmxEvent setDispatcher(IEmxDispatcher dispatcher) {
        this.dispatcher = dispatcher;
        return this;
    }

    @Override
    public final IEmxDispatcher getDispatcher() {
        return this.dispatcher;
    }

    @Override
    public final long getLatency() {
        return this.dispatchTs - this.scheduleTs;
    }

    @Override
    public final IEmxEvent setAttachment(Object attachment) {
        this.attachment = attachment;
        return this;
    }

    @Override
    public final Object getAttachment() {
        return this.attachment;
    }

    public String toString() {
        return "type=" + (Object)((Object)this.getType()) + " prio=" + this.getPriority() + " handler=" + (this.getHandler() != null) + " dispatcher=" + (this.getDispatcher() != null) + " latency=" + this.getLatency();
    }
}

