/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.emx;

import com.neeve.emx.EEmxException;
import com.neeve.emx.EEmxTimeoutException;
import com.neeve.emx.EmxObject;
import com.neeve.emx.IEmxNwLnkPeerEndpoint;
import com.neeve.emx.IEmxNwReadReadyEvent;
import com.neeve.emx.IEmxNwWriteReadyEvent;
import com.neeve.io.IOBuffer;

public final class EmxNwLnk
extends EmxObject {
    private final IEmxNwLnkPeerEndpoint writePep;
    private final IEmxNwWriteReadyEvent writeReadyEvent;
    private final IEmxNwLnkPeerEndpoint readPep;
    private final IEmxNwReadReadyEvent readReadyEvent;
    private final boolean readUsingDataReceiver;
    private final DataReceiver dataReceiver;
    private IOBuffer readBuffer;
    private int readPos;
    private boolean reading;
    private boolean writing;
    private boolean closing;
    private boolean closed;

    EmxNwLnk(IEmxNwLnkPeerEndpoint writePep, IEmxNwLnkPeerEndpoint readPep) {
        if (writePep == null) {
            throw new IllegalArgumentException("write link cannot be null");
        }
        if (readPep == null) {
            throw new IllegalArgumentException("read link cannot be null");
        }
        this.writePep = writePep;
        this.writeReadyEvent = writePep.getWriteReadyEvent();
        if (this.writeReadyEvent != null) {
            this.writeReadyEvent.setAttachment((Object)this);
        }
        this.readPep = readPep;
        this.readReadyEvent = readPep.getReadReadyEvent();
        if (this.readReadyEvent != null) {
            this.readReadyEvent.setAttachment((Object)this);
        }
        this.dataReceiver = (this.readUsingDataReceiver = this.readPep.supportReadUsingDataReceiver()) ? new DataReceiver() : null;
    }

    public final void setReadBuffer(IOBuffer buffer, int pos) {
        this.readBuffer = buffer;
        this.readPos = pos;
    }

    public final IOBuffer getReadBuffer() {
        return this.readBuffer;
    }

    public final int getReadPos() {
        return this.readPos;
    }

    public final void configureBlockingRead(boolean val) throws EEmxException {
        if (this.closing || this.closed) {
            throw new IllegalStateException("link is " + (this.closing ? "closing" : "closed"));
        }
        this.readPep.configureBlocking(val);
    }

    public final int read() throws EEmxException {
        if (this.closing || this.closed) {
            throw new IllegalStateException("link is " + (this.closing ? "closing" : "closed"));
        }
        this.reading = true;
        try {
            if (this.readUsingDataReceiver) {
                this.readPep.read(this.dataReceiver.reset());
                int n = this.dataReceiver.lengthLastRead;
                return n;
            }
            int n = this.readPep.read(this.readBuffer, this.readPos);
            return n;
        }
        finally {
            this.reading = false;
        }
    }

    public final IEmxNwReadReadyEvent getReadReadyEvent() {
        return this.readReadyEvent;
    }

    public final void configureBlockingWrite(boolean val) throws EEmxException {
        if (this.closing || this.closed) {
            throw new IllegalStateException("link is " + (this.closing ? "closing" : "closed"));
        }
        this.writePep.configureBlocking(val);
    }

    public final boolean usingNativeIOForWrite() {
        return this.writePep.usingNativeIO();
    }

    public final boolean usingNativeIOForRead() {
        return this.readPep.usingNativeIO();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final long write(IOBuffer buffer, int offset, int len) throws EEmxException {
        if (this.closing || this.closed) {
            throw new IllegalStateException("link is " + (this.closing ? "closing" : "closed"));
        }
        this.writing = true;
        try {
            long l = this.writePep.write(buffer, offset, len);
            return l;
        }
        finally {
            this.writing = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final long write(IOBuffer[] buffers, int[] offsets, int[] lens, int count) throws EEmxException {
        if (this.closing || this.closed) {
            throw new IllegalStateException("link is " + (this.closing ? "closing" : "closed"));
        }
        this.writing = true;
        try {
            long l = this.writePep.write(buffers, offsets, lens, count);
            return l;
        }
        finally {
            this.writing = false;
        }
    }

    public final IEmxNwWriteReadyEvent getWriteReadyEvent() {
        return this.writeReadyEvent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void close() throws EEmxException {
        if (this.closing || this.closed) {
            return;
        }
        this.closing = true;
        try {
            this.readPep.close();
            this.writePep.close();
            long ts = System.currentTimeMillis();
            while ((this.reading || this.writing) && System.currentTimeMillis() - ts < 5000L) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {}
            }
            if (this.reading | this.writing) {
                throw new EEmxTimeoutException("timed out waiting for underlying read/write to terminate");
            }
            if (this.readBuffer != null) {
                this.readBuffer.dispose();
            }
            this.closed = true;
        }
        finally {
            this.closing = false;
        }
    }

    private final class DataReceiver
    implements IEmxNwLnkPeerEndpoint.IDataReceiver {
        int lengthLastRead;

        private DataReceiver() {
        }

        final DataReceiver reset() {
            this.lengthLastRead = 0;
            return this;
        }

        @Override
        public final void onData(long buffer, int offset, int length) {
            (EmxNwLnk.this.readBuffer = IOBuffer.ensureCapacity((IOBuffer)EmxNwLnk.this.readBuffer, (int)(EmxNwLnk.this.readPos + length), (boolean)true)).putFrom(EmxNwLnk.this.readPos, buffer, offset, length);
            this.lengthLastRead = length;
        }
    }
}

