/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.query.impl.mem;

import com.google.common.collect.Lists;
import com.neeve.query.QueryException;
import com.neeve.query.impl.QueryConfig;
import com.neeve.query.impl.QueryRepositoryBase;
import java.util.List;

public class ListRepository<REC>
extends QueryRepositoryBase<Integer, REC> {
    private final List<REC> elements;

    public ListRepository(String name, List<REC> elements) {
        super(null, name, QueryConfig.getConfig());
        this.elements = elements;
    }

    @Override
    public boolean isLiveIndexingUpToDate() {
        return true;
    }

    @Override
    public REC retrieve(Integer key) throws QueryException {
        return this.elements.get(key);
    }

    @Override
    public void flushIndexing() throws QueryException {
    }

    @Override
    public Integer getRecordId(REC record) {
        return this.elements.indexOf(record);
    }

    @Override
    public long getCommitSequence(REC record) {
        return this.elements.indexOf(record);
    }

    @Override
    public Iterable<REC> retrieve(long startCommitSeqNo, long endCommitSeqNo) throws QueryException {
        return Lists.newArrayList(this.elements.subList((int)startCommitSeqNo, (int)endCommitSeqNo + 1));
    }

    @Override
    protected void stopIndexing() throws QueryException, InterruptedException {
    }

    @Override
    protected void startIndexing(long fromPos) throws QueryException {
        int size = this.elements.size();
        for (int i = (int)fromPos; i < size; ++i) {
            REC element = this.elements.get(i);
            try {
                this.index(element);
                if (i % 1000 != 0) continue;
                this.commit(i);
                continue;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new QueryException("Interrupted during reindex");
            }
        }
        try {
            this.commit(size - 1);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new QueryException("Interrupted during reindex");
        }
    }

    @Override
    protected boolean isOrderedRepository() {
        return true;
    }
}

