/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.ods.impl;

import com.neeve.ods.IStoreReplicatorStats;
import com.neeve.ods.impl.StoreReplicator;
import com.neeve.stats.IStats;
import com.neeve.stats.Stats;
import java.text.NumberFormat;

final class StoreReplicatorStats
extends Stats
implements IStoreReplicatorStats {
    private NumberFormat format;
    private long startTime;
    private long deltaStartTime;
    private StoreReplicator replicator;
    private long numCommitsReceivedLast;
    private long numPacketsReceivedLast;
    private long numCommitsSentLast;
    private long numPacketsSentLast;
    private long numCommitAcksReceivedLast;
    private long numCommitAcksSentLast;
    volatile long numCommitsReceived;
    volatile long numPacketsReceived;
    volatile long numCommitsSent;
    volatile long numPacketsSent;
    volatile long numCommitAcksReceived;
    volatile long numCommitAcksSent;
    final Stats.LatencyManager dso2p = new Stats.LatencyManager("o2p");
    final Stats.LatencyManager ddo2p = new Stats.LatencyManager("o2p");

    StoreReplicatorStats(StoreReplicator replicator, String name, String startProp) {
        super("nv.ods.replicator", name, "nv.ods.replicator.stats", startProp);
        this.format = NumberFormat.getInstance();
        this.format.setMaximumFractionDigits(2);
        this.replicator = replicator;
        this.startPeriodicOutputIfConfigured();
    }

    private void stamp() {
        this.deltaStartTime = System.currentTimeMillis();
        this.numCommitsReceivedLast = this.numCommitsReceived;
        this.numPacketsReceivedLast = this.numPacketsReceived;
        this.numCommitsSentLast = this.numCommitsSent;
        this.numPacketsSentLast = this.numPacketsSent;
        this.numCommitAcksReceivedLast = this.numCommitAcksReceived;
        this.numCommitAcksSentLast = this.numCommitAcksSent;
    }

    protected final void init() {
        this.startTime = System.currentTimeMillis();
        this.stamp();
    }

    public final synchronized void get(StringBuilder sb) {
        long currentTime = System.currentTimeMillis();
        long deltaTime = currentTime - this.deltaStartTime;
        long deltaTotalTime = currentTime - this.startTime;
        long numCommitsReceivedCurrent = this.numCommitsReceived;
        long numPacketsReceivedCurrent = this.numPacketsReceived;
        long numCommitsSentCurrent = this.numCommitsSent;
        long numPacketsSentCurrent = this.numPacketsSent;
        long numCommitAcksReceivedCurrent = this.numCommitAcksReceived;
        long numCommitAcksSentCurrent = this.numCommitAcksSent;
        String commitsReceivedStr = this.format.format(numCommitsReceivedCurrent);
        String commitReceiptRateStr = this.format.format(numCommitsReceivedCurrent * 1000L / deltaTotalTime);
        String deltaCommitReceiptRateStr = this.format.format((numCommitsReceivedCurrent - this.numCommitsReceivedLast) * 1000L / deltaTime);
        String packetsReceivedStr = this.format.format(numPacketsReceivedCurrent);
        String packetReceiptStr = this.format.format(numPacketsReceivedCurrent * 1000L / deltaTotalTime);
        String deltaPacketReceiptStr = this.format.format((numPacketsReceivedCurrent - this.numPacketsReceivedLast) * 1000L / deltaTime);
        String commitsSentStr = this.format.format(numCommitsSentCurrent);
        String commitSendRateStr = this.format.format(numCommitsSentCurrent * 1000L / deltaTotalTime);
        String deltaCommitSendRateStr = this.format.format((numCommitsSentCurrent - this.numCommitsSentLast) * 1000L / deltaTime);
        String packetsSentStr = this.format.format(numPacketsSentCurrent);
        String packetSendRateStr = this.format.format(numPacketsSentCurrent * 1000L / deltaTotalTime);
        String deltaPacketSendRateStr = this.format.format((numPacketsSentCurrent - this.numPacketsSentLast) * 1000L / deltaTime);
        String commitAcksReceivedStr = this.format.format(numCommitAcksReceivedCurrent);
        String commitAckReceiveRateStr = this.format.format(numCommitAcksReceivedCurrent * 1000L / deltaTotalTime);
        String deltaCommitAckReceiveRateStr = this.format.format((numCommitAcksReceivedCurrent - this.numCommitAcksReceivedLast) * 1000L / deltaTime);
        String commitAcksSentStr = this.format.format(numCommitAcksSentCurrent);
        String commitAckSendRateStr = this.format.format(numCommitAcksSentCurrent * 1000L / deltaTotalTime);
        String deltaCommitAckSendRateStr = this.format.format((numCommitAcksSentCurrent - this.numCommitAcksSentLast) * 1000L / deltaTime);
        int detachedSendDisruptorCapacityCurrent = this.getDetachedSendDisruptorCapacity();
        int detachedSendDisruptorRemainingCurrent = this.getDetachedSendDisruptorRemaining();
        int detachedSendDisruptorUsedCurrent = detachedSendDisruptorCapacityCurrent - detachedSendDisruptorRemainingCurrent;
        int detachedSendDisruptorUsagePctCurrent = detachedSendDisruptorCapacityCurrent > 0 ? detachedSendDisruptorUsedCurrent * 100 / detachedSendDisruptorCapacityCurrent : 0;
        String detachedSendDisruptorCapacityStr = this.format.format(detachedSendDisruptorCapacityCurrent);
        String detachedSendDisruptorUsedStr = this.format.format(detachedSendDisruptorUsedCurrent);
        String detachedSendDisruptorUsagePctStr = this.format.format(detachedSendDisruptorUsagePctCurrent);
        String detachedSendClaimStrategyStr = this.getDetachedSendDisruptorClaimStrategy();
        String detachedSendWaitStrategyStr = this.getDetachedSendDisruptorWaitStrategy();
        this.dso2p.compute();
        int detachedDispatchDisruptorCapacityCurrent = this.getDetachedDispatchDisruptorCapacity();
        int detachedDispatchDisruptorRemainingCurrent = this.getDetachedDispatchDisruptorRemaining();
        int detachedDispatchDisruptorUsedCurrent = detachedDispatchDisruptorCapacityCurrent - detachedDispatchDisruptorRemainingCurrent;
        int detachedDispatchDisruptorUsagePctCurrent = detachedDispatchDisruptorCapacityCurrent > 0 ? detachedDispatchDisruptorUsedCurrent * 100 / detachedDispatchDisruptorCapacityCurrent : 0;
        String detachedDispatchDisruptorCapacityStr = this.format.format(detachedDispatchDisruptorCapacityCurrent);
        String detachedDispatchDisruptorUsedStr = this.format.format(detachedDispatchDisruptorUsedCurrent);
        String detachedDispatchDisruptorUsagePctStr = this.format.format(detachedDispatchDisruptorUsagePctCurrent);
        String detachedDispatchClaimStrategyStr = this.getDetachedDispatchDisruptorClaimStrategy();
        String detachedDispatchWaitStrategyStr = this.getDetachedDispatchDisruptorWaitStrategy();
        this.ddo2p.compute();
        sb.append("{");
        sb.append("role=").append((Object)this.replicator.getRole()).append(" ");
        sb.append("state=").append((Object)this.replicator.getState()).append(" ");
        sb.append("primary=").append(this.replicator.getPrimary());
        sb.append("}").append("\n");
        sb.append("...In{");
        sb.append(commitsReceivedStr).append("(").append(commitReceiptRateStr).append(" ").append(deltaCommitReceiptRateStr).append(") ");
        sb.append(packetsReceivedStr).append("(").append(packetReceiptStr).append(" ").append(deltaPacketReceiptStr).append(")");
        sb.append("}").append("\n");
        sb.append("...Out{");
        sb.append(commitsSentStr).append("(").append(commitSendRateStr).append(" ").append(deltaCommitSendRateStr).append(") ");
        sb.append(packetsSentStr).append("(").append(packetSendRateStr).append(" ").append(deltaPacketSendRateStr).append(")");
        sb.append("}").append("\n");
        sb.append("...Ack{");
        sb.append(commitAcksReceivedStr).append("(").append(commitAckReceiveRateStr).append(" ").append(deltaCommitAckReceiveRateStr).append(") ");
        sb.append(commitAcksSentStr).append("(").append(commitAckSendRateStr).append(" ").append(deltaCommitAckSendRateStr).append(")");
        sb.append("}").append("\n");
        sb.append("Send Disruptor (").append(detachedSendClaimStrategyStr).append(", ").append(detachedSendWaitStrategyStr).append(") {");
        sb.append("[").append(detachedSendDisruptorUsedStr).append(" of ").append(detachedSendDisruptorCapacityStr).append("] ").append(detachedSendDisruptorUsagePctStr).append("%");
        sb.append("}").append("\n");
        this.dso2p.get(sb);
        sb.append("Dispatch Disruptor (").append(detachedDispatchClaimStrategyStr).append(", ").append(detachedDispatchWaitStrategyStr).append(") {");
        sb.append("[").append(detachedDispatchDisruptorUsedStr).append(" of ").append(detachedDispatchDisruptorCapacityStr).append("] ").append(detachedDispatchDisruptorUsagePctStr).append("%");
        sb.append("}").append("\n");
        this.ddo2p.get(sb);
        this.stamp();
    }

    @Override
    public final long getNumCommitsReceived() {
        return this.numCommitsReceived;
    }

    @Override
    public final long getNumCommitEntriesReceived() {
        return this.numPacketsReceived;
    }

    @Override
    public final long getNumCommitsSent() {
        return this.numCommitsSent;
    }

    @Override
    public final long getNumCommitEntriesSent() {
        return this.numPacketsSent;
    }

    @Override
    public final long getNumCommitAcksReceived() {
        return this.numCommitAcksReceived;
    }

    @Override
    public final long getNumCommitAcksSent() {
        return this.numCommitAcksSent;
    }

    @Override
    public final boolean isDetachedSend() {
        return this.replicator.getEventSequencer().isDetachedSend();
    }

    @Override
    public final int getDetachedSendDisruptorCapacity() {
        return this.replicator.getEventSequencer().getDetachedSendDisruptorCapacity();
    }

    @Override
    public final int getDetachedSendDisruptorRemaining() {
        return this.replicator.getEventSequencer().getDetachedSendDisruptorRemaining();
    }

    @Override
    public final String getDetachedSendDisruptorClaimStrategy() {
        return this.replicator.getEventSequencer().getDetachedSendDisruptorClaimStrategy();
    }

    @Override
    public final String getDetachedSendDisruptorWaitStrategy() {
        return this.replicator.getEventSequencer().getDetachedSendDisruptorWaitStrategy();
    }

    @Override
    public final IStats.Latencies getDetachedSendOfferToPollLatencies() {
        return null;
    }

    @Override
    public final boolean isDetachedDispatch() {
        return this.replicator.getEventSequencer().isDetachedDispatch();
    }

    @Override
    public final int getDetachedDispatchDisruptorCapacity() {
        return this.replicator.getEventSequencer().getDetachedDispatchDisruptorCapacity();
    }

    @Override
    public final int getDetachedDispatchDisruptorRemaining() {
        return this.replicator.getEventSequencer().getDetachedDispatchDisruptorRemaining();
    }

    @Override
    public final String getDetachedDispatchDisruptorClaimStrategy() {
        return this.replicator.getEventSequencer().getDetachedDispatchDisruptorClaimStrategy();
    }

    @Override
    public final String getDetachedDispatchDisruptorWaitStrategy() {
        return this.replicator.getEventSequencer().getDetachedDispatchDisruptorWaitStrategy();
    }

    @Override
    public final IStats.Latencies getDetachedDispatchOfferToPollLatencies() {
        return null;
    }
}

