/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.blog;

import com.eaio.uuid.UUID;
import com.neeve.ods.IStoreBinding;
import com.neeve.ods.IStoreCheckpointingController;
import com.neeve.ods.IStoreEvent;
import com.neeve.ods.IStoreEventHandler;
import com.neeve.ods.IStoreObjectFactory;
import com.neeve.ods.IStorePersister;
import com.neeve.ods.StoreBindingFactory;
import com.neeve.ods.StoreDescriptor;
import com.neeve.ods.StoreObjectFactoryRegistry;
import com.neeve.ods.StorePersisterDescriptor;
import com.neeve.rog.IRogChangeDataCaptureHandler;
import com.neeve.rog.IRogNode;
import com.neeve.rog.log.RogLog;
import com.neeve.rog.log.RogLogCdcProcessor;
import java.util.List;

public final class Blogger {
    private final String _name;
    private String _location;
    private int _maxLogSize;
    private boolean _isOpen;
    private IStoreBinding _store;
    private TailListener _tailListener;
    private RogLogCdcProcessor _cdcProcessor;
    private CdcHandler _cdcHandler;

    private Blogger(String name) {
        this._name = name;
        this._maxLogSize = 1024;
    }

    public static final Blogger create(String name) {
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        return new Blogger(name);
    }

    public final String getName() {
        return this._name;
    }

    public final Blogger registerFactory(IStoreObjectFactory factory) {
        if (this._isOpen) {
            throw new IllegalStateException("blogger is open (factory can only be registered on a closed blogger)");
        }
        if (factory == null) {
            throw new IllegalArgumentException("factory cannot be null");
        }
        StoreObjectFactoryRegistry.getInstance().registerObjectFactory(factory);
        return this;
    }

    public final Blogger setMaxLogSize(int val) {
        if (this._isOpen) {
            throw new IllegalStateException("blogger is open (close, set property and reopen blogger)");
        }
        if (this._maxLogSize < 1) {
            throw new IllegalArgumentException("max size must be >= 1Mb");
        }
        this._maxLogSize = val;
        return this;
    }

    public final int getMaxLogSize() {
        return this._maxLogSize;
    }

    public final Blogger setLocation(String val) {
        if (this._isOpen) {
            throw new IllegalStateException("blogger is open (close, set property and reopen blogger)");
        }
        this._location = val;
        return this;
    }

    public final String getLocation() {
        return this._location;
    }

    public final Blogger open() throws Exception {
        if (this._isOpen) {
            throw new IllegalStateException("already open");
        }
        StorePersisterDescriptor persisterDescriptor = StorePersisterDescriptor.create(this._name, RogLog.class.getName());
        persisterDescriptor.setProperty("storeRoot", this._location);
        persisterDescriptor.setProperty("cdcEnabled", "true");
        persisterDescriptor.setProperty("autoRepair", "true");
        persisterDescriptor.setProperty("compaction.compactionThreshold", String.valueOf(this._maxLogSize));
        persisterDescriptor.setProperty("initialLogLength", "0");
        persisterDescriptor.setProperty("detachedWrite", "true");
        persisterDescriptor.setProperty("flushOnCommit", "true");
        persisterDescriptor.save();
        StoreDescriptor storeDescriptor = StoreDescriptor.create(this._name);
        storeDescriptor.setPersister(this._name);
        storeDescriptor.setPersistenceQuorum(1);
        storeDescriptor.setMaxPersistSyncBacklog(0);
        storeDescriptor.setCheckpointingType(IStoreCheckpointingController.Type.Default);
        storeDescriptor.setCheckpointThreshold(1);
        storeDescriptor.save();
        this._store = StoreBindingFactory.getInstance().createBinding(null, this._name, (IStoreEventHandler)new StoreEventHandler());
        this._store.open();
        this._isOpen = true;
        return this;
    }

    public final boolean isOpen() {
        return this._isOpen;
    }

    public final void log(IRogNode object) throws Exception {
        if (!this._isOpen) {
            throw new IllegalStateException("not open");
        }
        this._store.send(object);
        this._store.commit(null);
    }

    public final void tail(TailListener tailListener) throws Exception {
        if (!this._isOpen) {
            throw new IllegalStateException("not open");
        }
        if (this._cdcProcessor != null) {
            throw new IllegalStateException("tailing already in progress");
        }
        this._cdcHandler = new CdcHandler();
        this._cdcProcessor = ((RogLog)this._store.getPersister()).createCdcProcessor(this._cdcHandler);
        this._tailListener = tailListener;
        try {
            this._cdcProcessor.run();
            Throwable e = this._cdcHandler.getErrorCause();
            if (e != null) {
                if (e instanceof Error) {
                    throw (Error)e;
                }
                throw (Exception)e;
            }
        }
        finally {
            this._tailListener = null;
            this._cdcProcessor = null;
            this._cdcHandler = null;
        }
    }

    public final void setLogCompactionThreshold(int val) throws Exception {
        if (!this._isOpen) {
            throw new IllegalStateException("not open");
        }
        IStorePersister persister = this._store.getPersister();
        if (!(persister instanceof RogLog)) {
            throw new UnsupportedOperationException("compaction threshold can only be set on the native X logger");
        }
        ((RogLog)persister).setCompactionThreshold(val);
    }

    public final void scheduleLogCompactionOnNextWrite() throws Exception {
        if (!this._isOpen) {
            throw new IllegalStateException("not open");
        }
        IStorePersister persister = this._store.getPersister();
        if (!(persister instanceof RogLog)) {
            throw new UnsupportedOperationException("compaction threshold can only be set on the native X logger");
        }
        ((RogLog)persister).scheduleCompactionOnNextWrite();
    }

    public final void close() {
        if (this._isOpen) {
            this._store.close(0);
            if (this._cdcProcessor != null) {
                this._cdcProcessor.close();
            }
            this._isOpen = false;
        }
    }

    public static interface TailListener {
        public void onObject(IRogNode var1);
    }

    private final class CdcHandler
    implements IRogChangeDataCaptureHandler {
        private Throwable errorCause;

        final Throwable getErrorCause() {
            return this.errorCause;
        }

        @Override
        public final void onLogStart(int logNumber) {
        }

        @Override
        public final void onCheckpointStart(long version) {
        }

        @Override
        public final boolean handleChange(UUID id, IRogChangeDataCaptureHandler.ChangeType ct, List<IRogNode> list) {
            IRogNode object = list.get(list.size() - 1);
            if (Blogger.this._tailListener != null) {
                Blogger.this._tailListener.onObject(object);
            }
            return true;
        }

        @Override
        public final boolean onCheckpointComplete(long version) {
            return true;
        }

        @Override
        public final void onWait() {
        }

        @Override
        public final void onLogComplete(int logNumber, IRogChangeDataCaptureHandler.LogCompletionReason reason, Throwable errorCause) {
            this.errorCause = errorCause;
        }
    }

    private final class StoreEventHandler
    implements IStoreEventHandler {
        private StoreEventHandler() {
        }

        @Override
        public final void onEvent(IStoreEvent event) {
        }
    }
}

