/*
 * Decompiled with CFR 0.152.
 */
package com.akiban.sql.parser;

import com.akiban.sql.StandardException;
import com.akiban.sql.parser.QueryTreeNodeList;
import com.akiban.sql.parser.ResultColumn;

public class ResultColumnList
extends QueryTreeNodeList<ResultColumn> {
    int orderBySelect = 0;
    protected boolean forUpdate;
    private int initialListSize = 0;

    public void addResultColumn(ResultColumn resultColumn) {
        resultColumn.setVirtualColumnId(this.size() + 1);
        this.add(resultColumn);
    }

    public void appendResultColumns(ResultColumnList resultColumns, boolean destructiveCopy) {
        int oldSize = this.size();
        int newID = oldSize + 1;
        int otherSize = resultColumns.size();
        for (int index = 0; index < otherSize; ++index) {
            ((ResultColumn)resultColumns.get(index)).setVirtualColumnId(newID);
            ++newID;
        }
        if (destructiveCopy) {
            this.destructiveAddAll(resultColumns);
        } else {
            this.addAll(resultColumns);
        }
    }

    public ResultColumn getResultColumn(int position) {
        ResultColumn rc;
        if (position <= this.size() && (rc = (ResultColumn)this.get(position - 1)).getColumnPosition() == position) {
            return rc;
        }
        int size = this.size();
        for (int index = 0; index < size; ++index) {
            ResultColumn rc2 = (ResultColumn)this.get(index);
            if (rc2.getColumnPosition() != position) continue;
            return rc2;
        }
        return null;
    }

    public ResultColumn getOrderByColumn(int position) {
        if (position == 0) {
            return null;
        }
        return this.getResultColumn(position);
    }

    public ResultColumn getResultColumn(String columnName) {
        int size = this.size();
        for (int index = 0; index < size; ++index) {
            ResultColumn resultColumn = (ResultColumn)this.get(index);
            if (!columnName.equalsIgnoreCase(resultColumn.getName())) continue;
            return resultColumn;
        }
        return null;
    }

    public String[] getColumnNames() {
        String[] strings = new String[this.size()];
        int size = this.size();
        for (int index = 0; index < size; ++index) {
            ResultColumn resultColumn = (ResultColumn)this.get(index);
            strings[index] = resultColumn.getName();
        }
        return strings;
    }

    public void removeJoinColumns(ResultColumnList joinColumns) {
        for (ResultColumn joinRC : joinColumns) {
            String columnName = joinRC.getName();
            ResultColumn rightRC = this.getResultColumn(columnName);
            if (rightRC == null) continue;
            this.remove(rightRC);
        }
    }

    public ResultColumnList getJoinColumns(ResultColumnList joinColumns) throws StandardException {
        ResultColumnList newRCL = new ResultColumnList();
        for (ResultColumn joinRC : joinColumns) {
            String columnName = joinRC.getName();
            ResultColumn xferRC = this.getResultColumn(columnName);
            if (xferRC == null) {
                throw new StandardException("Column not found: " + columnName);
            }
            newRCL.add(xferRC);
        }
        return newRCL;
    }

    protected void markInitialSize() {
        this.initialListSize = this.size();
    }

    @Override
    public String toString() {
        return super.toString();
    }
}

